<?php
//ob_end_clean();

include("prog_init.inc");
$GLOBALS['GAT_DUMP_HELPER']=true;
if (!defined("IS_WIN")) define("IS_WIN", (stristr(php_uname('s'), 'windows')==FALSE)?false:true);

include("hexutil.inc");
include("util.inl");

$args=proc_args();
include($args['config']);

$glob['program_arguments']=$args;

include("ext_cmd.inl");
include("httpr.inl");
include("helios.inl");
include("session.inl");
include("pocket.inl");
include("dev.inl");
include("gat.inl");
include("term.inl");
include("sphinx.inl");
include("ucs.inl");
include("txp.inl");
include("jsp.inl");
include("dev_jsp.inl");
include("conn.inl");
include("handler.inl");
include("proxy.inl");
include("crt.inl");
include("memreg.inl");
include("memreg_dev.inl");

define('NL', get_nl());

$phrases_fixes=array(
    from_utf8('Извините;клиент не идентифицирован;')=>from_utf8('Извините;Клиент не;идентифицирован'),
    from_utf8('Извините;Клиент уже в клубе;')=>from_utf8('Извините;Клиент;уже в клубе'),
    from_utf8('Извините;контракт не активен/нет доступа в зону;')=>from_utf8('Извините;Контракт;  не активен /;нет доступа;в зону'),
);

//print(var_d($glob['program_arguments'])."\n\n\n");


include("csv.inc");

$glob['csv_keys']=array(
  'session_time'=>false,
  'term_id'=>false,
  'term_addr'=>false,
  'term_role'=>false,
  'uid'=>false,
  'kpo_result'=>false,
  'kpo_msg'=>false,
  'cam_result'=>false,
  'cam_cid'=>false,
  'final_result'=>false,
  'final_msg'=>false,
);

function proc_args() {
  $src_arr=$_SERVER['argv'];
  array_shift($src_arr);
  $args=array();
  foreach ($src_arr as $astr) {
    $ipa=explode('=', $astr, 2);
    if (count($ipa)==0) continue;
    $ipa[0]=strtolower(trim($ipa[0]));
    if (count($ipa)==1) {
      $args[$ipa[0]]=true;
    } else {
      $args[$ipa[0]]=trim($ipa[1]);
    }
  }
  
  if (!is_string(@$args['config'])) $args['config']='';
  $args['config']=trim(@$args['config']);
  if ($args['config']=='') $args['config']='config.inc';

  return $args;
}

function csv_log_fname($keys, $suffix='') {
  global $glob;
  if (!is_string(@$glob['csv_log_dir']) || strlen($glob['csv_log_dir'])==0) return '';
  if (!file_exists($glob['csv_log_dir'])) @mkdir($glob['csv_log_dir'], 0777, true);
  $tmv=time();
  $dir_name=date("m_Y", $tmv);
  $file_path=$glob['csv_log_dir'].$dir_name.$suffix.'.csv';
/*
  $dir_path=$glob['csv_log_dir'].$dir_name.'/';
  if (!file_exists($dir_path)) @mkdir($dir_path, 0777, true);
  if (!file_exists($dir_path)) return '';
  $file_name='gat_'.sprintf('%08X_', day_from_unix_time($tmv)).'_'.date("d_m_Y", $tmv).'.txt';
  $file_path=$dir_path.$file_name;
*/
  if (!file_exists($file_path)) {
    $gdata_str=csv_arr2line($keys);
    log_print($file_path, $gdata_str, false, true, "\r\n");
  }
  if (!file_exists($file_path)) return '';
  return $file_path;
}

function register_csv_event($data, $fn_suffix='', $keys=false) {
  global $glob;
//  plogs(var_export($data, true));
  $gdata=array();
  $flags=array();
  if (!is_array($keys)) $keys=array_keys($glob['csv_keys']);
  foreach ($keys as $key) {
    $val='';
    if (array_key_exists($key, $data)) $val=nl2comma($data[$key]);
    $gdata[]=$val;
    $flags[]=(@$glob['csv_keys'][$key])?true:false;
  }
  $gdata_str=csv_arr2line(array_values($gdata), $flags);
//  plogs($gdata_str);
  $fname=csv_log_fname($keys, $fn_suffix);
//  plogs($fname);
  if (strlen($fname)>0) {
    log_print($fname, $gdata_str, false, true, "\r\n");
  }
}

/*

       if ($ttype==GAT_TTYPE_TIME) {
         $csv_reg_arr = array(
           'timestamp'=>date("d.m.y H:i:s"),
           'id'=>$id,
           'addres'=>$ip.':'.$port,
           'type'=>gat_avok($GLOBALS['GAT_Terminals'], $ttype, 'Unknown'),
           'uid'=>$uid_hex,
         );
         foreach ($aparams as $k=>$v) $csv_reg_arr[$k]=$v;
         register_csv_event($gtime_reg_arr);
       }

*/




function _on_raw_print(&$pool, $key, &$ra, &$ret) {
   $ret=proto_pack_decode_arr_ex($ret);
   return true;
}

function _on_startup() {
  global $dmn_main_conn, $glob;
  if (is_callable('sphinx_init')) sphinx_init();
  if (is_callable('ucs_init')) if (!ucs_init()) return;
  if (is_callable('txp_init')) if (!txp_init()) return;
  if (is_callable('jsp_init')) if (!jsp_init()) return;
  if (is_callable('crt_init')) if (!crt_init()) return;
  if (is_callable('memreg_init')) if (!memreg_init()) return;

  
  // free pass locks array uppercase transform
  if (!is_array(@$glob['free_pass_locks'])) $glob['free_pass_locks']=array();
  foreach ($glob['free_pass_locks'] as &$li) $li=strtoupper(trim($li));


  
//  logp($glob['log_file'],"\n\nmemreg obj:\n".var_export(memreg_data(), true)."\n", true);exit(0);
    
//  req_db_termlist();
  
//  $res=helios_new($dmn_main_conn['pool'], false, REQ_TAG_TLIST, dmnh_hcfg_cam(), $glob['cam_service_ident_path']);

//  $pk=array('lockers_data'=>'23,13:25,A:2, M:334');dev_jsp_transform_lockers_data($pk);print(var_d($pk)."\n\n\n");exit(0);

}

function _on_idle() {
  global $dmn_main_conn, $glob;
  $res=idle_proc($dmn_main_conn['pool']);
//   usleep(1000);
  return $res;
}

function fmt_llist($ldata) {
  if (!is_array($ldata)) return '0';
  $lda=array();
	foreach ($ldata as $lstr) $lda[]=preg_replace('/[^\d]/', '', $lstr);
  $llist=trim(implode(',', $lda));
  if (strlen($llist)==0) $llist='0';
  return $llist;
}

function fmt_llist_craft($ldata) {
  if (!is_array($ldata)) return '';
  $lda=array();
  foreach ($ldata as $ld) {
    $lda[]=implode(':', $ld);
  }
//  foreach ($ldata as $ld) if (is_array($ld) && (int)@$ld['auth_err']==0 && (int)@$ld['read_err']==0 && @$ld['locked'] && (int)@$ld['cab_no']>0) {
//    $lda[]=((@$ld['is_passtech'])?(string)@$ld['litera']:(int)@$ld['block_no']).':'.(int)@$ld['cab_no'];  
//  }
  return trim(implode(',', $lda));
}

function fmt_llist_1c_m_($ldata) {
  if (!is_array($ldata)) return '0';
  if (count($ldata)==0) return '0';
  $lda=array();
  foreach ($ldata as $ld) {
    $lda[]=implode(':', $ld);
  }
  return trim(implode(',', $lda));
}

function virtualgym_fmt_uid($uid_raw) {
  $len=strlen($uid_raw);
  $arr=array();
  for ($i=0;$i<$len;$i++) {
    $arr[]=sprintf("%02X", ord($uid_raw{$i}));
  }
  $arr[]='90';
  while (count($arr)<16) $arr[]='00';
  return implode('-', $arr);
}

function dmnh_hurl_http($params=false) {
  global $glob;
  if (!is_array($params) || count($params)<4) return false;
  $req_tag=$params[0];
  $sobj=&$params[1];
  $conn=&$params[2];    
  $http_cfg=&$params[2];
  
  $dtype='';
  if (@$sobj['data']['faceid']) $dtype='faceid';
  if (@$sobj['data']['barcode']) $dtype='qr';
  if (@$sobj['data']['rfid']) $dtype='rfid';
  
  if (@$glob['http_service_url_fmt_suff']=='wc1c') {
    if ($req_tag==REQ_TAG_QRY) return $glob['http_service_ident_path'].'/'.@$conn['id'].'/'.$sobj['uid'].'/0/0/0/'.fmt_llist(@$sobj['data']['rfid']['lockers_data_f']).'/0';
    if ($req_tag==REQ_TAG_REG) return $glob['http_service_ident_path'].'/'.@$conn['id'].'/'.$sobj['uid'].'/1/0/0/0/0';
  } else if (@$glob['http_service_url_fmt_suff']=='a&a') { 
    if ($req_tag==REQ_TAG_QRY) return $glob['http_service_ident_path'].'/verify/'.@$conn['id'].'/'.$sobj['uid'];
    if ($req_tag==REQ_TAG_REG) return $glob['http_service_ident_path'].'/check/'.@$conn['id'].'/'.$sobj['uid'];
  } else if (@$glob['http_service_url_fmt_suff']=='1c_m') { 
    if ($req_tag==REQ_TAG_QRY) return $glob['http_service_ident_path'].'/checkaccess?id='.@$conn['id'].'&uid='.$sobj['uid'].'&tagtype='.$dtype;
    if ($req_tag==REQ_TAG_REG) return $glob['http_service_ident_path'].'/event?id='.@$conn['id'].'&uid='.$sobj['uid'].'&tagtype='.$dtype;
  } else if (@$glob['http_service_url_fmt_suff']=='1c_m_') {
    if ($req_tag==REQ_TAG_QRY) return $glob['http_service_ident_path'].'/checkaccess?id='.@$conn['id'].'&uid='.$sobj['uid'].'&cells='.fmt_llist_1c_m_(@$sobj['data']['rfid']['lockers_data']);
    if ($req_tag==REQ_TAG_REG) return $glob['http_service_ident_path'].'/event?id='.@$conn['id'].'&uid='.$sobj['uid'];
  } else if (@$glob['http_service_url_fmt_suff']=='craft') { 
    if ($req_tag==REQ_TAG_QRY) return '/pass_request?id='.@$conn['id'].'&uid='.$sobj['uid'].'&role='.@$conn['role'].'&locks='.fmt_llist_craft(@$sobj['data']['rfid']['lockers_data']);
    if ($req_tag==REQ_TAG_REG) return '/pass_register?id='.@$conn['id'].'&uid='.$sobj['uid'].'&role='.@$conn['role'];
  } else if (@$glob['http_service_url_fmt_suff']=='virtualgym') {
    if (($uid_raw=session_get_raw_uid($sobj))==false) return false;
    $uid=virtualgym_fmt_uid($uid_raw);
    if ($req_tag==REQ_TAG_QRY) return $glob['http_service_ident_path'].'/checking.php?id='.@$conn['id'].'&uid='.$uid;
    if ($req_tag==REQ_TAG_REG) return false;
  } else {
    if ($req_tag==REQ_TAG_QRY) return $glob['http_service_ident_path'].'/checking.php?id='.@$conn['id'].'&uid='.$sobj['uid'].'&lockers='.fmt_llist(@$sobj['data']['rfid']['lockers_data_f']);
    if ($req_tag==REQ_TAG_REG) return $glob['http_service_ident_path'].'/checking.php?id='.@$conn['id'].'&uid='.$sobj['uid'].'&reg=1';
  }
  return false;
}

function dmnh_hcfg_http($params=false) {
  global $glob;
  $ret=array(
    'ip'=>$glob['http_service_ip'],
    'port'=>$glob['http_service_port'],
    'host'=>@$glob['http_service_name'],
    'connect_timeout'=>((float)@$glob['kpo_request_expire_time']>0)?(float)@$glob['kpo_request_expire_time']:HTTPR_DEF_CONNECT_TIMEOUT,
    'expire_time'=>((float)@$glob['http_service_expire_time']>0)?(float)@$glob['http_service_expire_time']:HTTPR_DEF_EXPIRE_TIME,
    'extra_headers'=>array(),
  );
  if (is_array(@$glob['http_service_request_extra_headers'])) foreach ($glob['http_service_request_extra_headers'] as $hd) if (is_string($hd)) $ret['extra_headers'][]=$hd;
  return $ret;
}

function dmnh_hcfg_cam($params=false) {
  global $glob;
  $ret=array(
    'ip'=>$glob['cam_service_ip'],
    'port'=>$glob['cam_service_port'],
    'host'=>@$glob['cam_service_name'],
    'connect_timeout'=>((float)@$glob['kpo_request_expire_time']>0)?(float)@$glob['kpo_request_expire_time']:HTTPR_DEF_CONNECT_TIMEOUT,
    'expire_time'=>1.0+((float)@$glob['cam_service_expire_time']>0)?(float)@$glob['cam_service_expire_time']:HTTPR_DEF_EXPIRE_TIME,
    'extra_headers'=>array(),
  );
  if (is_array(@$glob['cam_service_request_extra_headers'])) foreach ($glob['cam_service_request_extra_headers'] as $hd) if (is_string($hd)) $ret['extra_headers'][]=$hd;
  if ($glob['cam_service_proto']=='recx') {
//    $ret['extra_headers'][]='Content-Type: application/x-www-form-urlencoded';
    $ret['extra_headers'][]='Content-Type: application/json';
    $ret['extra_headers'][]='Accept: application/json';
    $ret['post_body']=json_encode(array(@$glob['cam_service_cam_field']=>@$params['cam_pid'], @$glob['cam_service_person_field']=>@$params['person_id']));
//    '{"cameraId": "00001130-0001-1001-0002-000100000030","personId": "887d4255-d11d-45c0-50f8-a7ea3535adc9"}';
    $ret['extra_headers'][]='Content-Length: '.sprintf('%d', strlen($ret['post_body']));

  }
  return $ret;
}

function dmnh_httpr_del($params) {
  global $dmn_main_conn, $glob;
  if (!is_array($params) || count($params)<3) return false;
  $request=&$params[0];
  $pool=&$params[1];
  $key=$params[2];

  $ec=0;
  $sobj=&session_obj_get($request['params']);
  if (@$request['tag']===REQ_TAG_CRT) {
    $cct=(float)@$glob['crt_check_time'];
    if ($cct<0.0) $glob['crt_check_time']=-$cct;
  } else if (!$request['processed']) {
    $time=get_mtf();
    $et=sprintf('%.3f', $time-$request['time']);
    $ec='db request expired('.$et.' sec)';
    if (array_key_exists('drop_info', $request)) {
      $time=$request['drop_info']['time'];
      $ec=$request['drop_info']['reason'];
    }
    if (@$request['tag']===REQ_TAG_TLIST) {
      if (count($glob[GLOB_KEY_CONNECTIONS])==0 && array_key_exists('def_terminals', $glob) && is_array($glob['def_terminals'])) {
        ecmdh_termlist(array('check', $glob['def_terminals']), false);
      }
      tlogs_add(false, array('type'=>'DB_REQUEST_INCOMPLETE', 'time'=>$time, 'reason'=>$ec, 'autofixed'=>(@$glob['service_autofix_expired'])?'YES':'NO'));
    } else if (@$request['tag']===REQ_TAG_QRY) {
      if ($sobj && @$sobj['data']['kpo']['rkey']==$request['rkey']) {
        if (@$glob['service_autofix_expired']) {
          session_set_kpo_result($sobj, KPO_RES_YES, $glob['service_fixed_msg'], array('kpo_answer_data'=>'autofix'));
        } else {
          session_set_kpo_result($sobj, KPO_RES_NO, $glob['service_link_err_msg'], array('kpo_answer_data'=>'link error'));
        }
        session_check_done($sobj);
      }
      tlogs_add(false, array('type'=>'DB_REQUEST_INCOMPLETE', 'time'=>$time, 'reason'=>$ec, 'autofixed'=>(@$glob['service_autofix_expired'])?'YES':'NO'));
    } else if (@$request['tag']===REQ_TAG_CAM) {
      if ($sobj && @$sobj['data']['cam']['rkey']==$request['rkey']) {
		$tmo=$time-$request['time'];
		if ($tmo>$glob['cam_service_expire_time']) {
          session_set_cam_result($sobj, CAM_RES_NO, array('cam_answer_data'=>'idle_timeout'));
		} else {
          session_set_cam_result($sobj, CAM_RES_FAIL, array('cam_answer_data'=>'http_timeout'));
          tlogs_add(false, array('type'=>'DB_REQUEST_INCOMPLETE', 'time'=>$time, 'reason'=>$ec, 'autofixed'=>(@$glob['service_autofix_expired'])?'YES':'NO'));
		}			
        session_check_done($sobj);
      }
    }
  }  
  return $ec;
}

function dmnh_helios_event($params=false) {
  global $dmn_main_conn, $glob;
  if (!is_array($params) || count($params)<3) return false;
  $request=&$params[0];
  $pool=&$params[1];
  $key=$params[2];
  $json=$params[3];
  $evt=$params[4];

  $sobj=&session_obj_get($request['params']);
  
//  logp($glob['log_file'], "helios event:\n".var_d(array('key'=>$key, 'sobj'=>$sobj, 'request'=>$request, 'json'=>$json, 'evt'=>$evt), true)."\n", true);  
  
  if (!$sobj || @$sobj['data']['cam']['rkey']!=$request['rkey']) return false;
  if ($evt=='YES') {
    plogs('helios person VERIFIED', true);
//    plogs(var_d($json), true);
    session_set_cam_result($sobj, CAM_RES_YES, array('cam_answer_data'=>$json));
    session_check_done($sobj);
  } else if ($evt=='NO') {
    plogs('helios person NOT RECOGNIZED', true);
    session_set_cam_result($sobj, CAM_RES_NO, array('cam_answer_data'=>$json));
    session_check_done($sobj);
  } else if ($evt=='NF') {
    plogs('helios person NOT FOUND', true);
    session_set_cam_result($sobj, CAM_RES_NF, array('cam_answer_data'=>$json));
    session_check_done($sobj);
  } else if ($evt=='COR') {
    if ((int)@$sobj['data']['cam']['result']!=CAM_RES_UNDEF) return false;
    $cor_keys=@array_keys(@$json['correlations']);
    $matches=@$json['correlations'][@$cor_keys[0]]['matches'];
    if (is_array($matches) && count($matches)>0) {
      $koef=0;
      foreach ($matches as $m) {
         $k=(int)round(((float)@$m['correlation'])*100);
         if ($k>$koef) $koef=$k;
      }
      $pk=eproto_packet(eproto_cmd_Interactive);
      $pk['flags']=(int)@$sobj['data']['rfid']['reader_type'];
      $pk['payload']=pocket_interactive(from_utf8("Посмотрите\nв камеру\n\n".$koef.'% / '.(int)@$sobj['max_correlation'].'%'), session_cam_max_time_ms(), 0, false);
      $pool->send($sobj['key'], $pk);
      if ((int)@$sobj['max_correlation']<$koef) $sobj['max_correlation']=$koef;
    }
  } else if ($evt=='FAIL') {
    plogs('helios request FAIL', true);
    session_set_cam_result($sobj, CAM_RES_FAIL, array('cam_answer_data'=>$json));
    session_check_done($sobj);
  } else if ($evt=='DEL') {
    plogs('helios request deleted ['.@$json.']', true);
    $ec=0;
    if (!$request['processed']) {
      $time=get_mtf();
      $et=sprintf('%.3f', $time-$request['time']);
      $ec='cam request expired('.$et.' sec)';
      if (array_key_exists('drop_info', $request)) {
        $time=$request['drop_info']['time'];
        $ec=$request['drop_info']['reason'];
      }
      if (@$request['close_reason']) $ec=$request['close_reason'];
      
      tlogs_add(false, array('type'=>'CAM_REQUEST_INCOMPLETE', 'time'=>$time, 'reason'=>$ec, 'autofixed'=>(@$glob['service_autofix_expired'])?'YES':'NO'));
    }
    return true;
  }
  
  return true;
}

function dmnh_jsp_event($params=false) {
  global $dmn_main_conn, $glob;
  if (!is_array($params) || count($params)<6) return false;
  $request=&$params[0];
  $pool=&$params[1];
  $key=$params[2];
  $evt=strtolower(trim($params[3]));
  $pk=$params[4];
  $pk_raw=$params[5];

 
  $s="jsp event:\n".var_d(array('key'=>$key, 'request'=>$request, 'pk'=>$pk, 'evt'=>$evt), true)."\n";
  logp($glob['log_file'], $s, true);  
  plogs(w2d($s));
  
  $pk['tid']='12';

  $tid=agov($pk, 'tid', NULL);
  $uid=agov($pk, 'uid', '');
  $rid=agov($pk, 'rid', false);

  $conn=&conn_get_settings_by_id($tid);
  
  if ($evt=='answer') {
    if (!($sobj=&session_obj_get(@$request['rparams']['s_id']))) return false;
    if (@$sobj['data']['kpo']['rkey']==$request['rkey']) {
      $result=agov($pk, array('result', 'allow', 'grant_access'), NULL);
      $message=(string)agov($pk, array('message', 'text', 'string'), '');
      $cid=(string)agov($pk, array('cid', 'bioid', 'client_id'), '');
      
      $cid=trim((string)$cid); if (strlen($cid)>0) $sobj['cid']=$cid;
      if (is_null($result)) {
        session_set_kpo_result($sobj, KPO_RES_NO, $glob['service_link_err_msg'], array('kpo_answer_data'=>'link error'));
      } else {
        $kres=($result)?KPO_RES_YES:KPO_RES_NO;
        $message=($result)?session_fix_allow_message($message):session_fix_denied_message($message);
        session_set_kpo_result($sobj, $kres, $message, array('kpo_answer_data'=>array('request'=>$request, 'pk'=>$pk)));
      }      
      session_check_done($sobj);
    }
  } else if ($evt=='command') {
    if (@$pk['cmd']=='allow_pass' || @$pk['cmd']=='relay_open') {
      if (!$conn) return true;
      if (!($sobj=&dev_session_auto_renew($pool, $uid, @$conn['key'], @$conn['apkey']))) return true;
      if (is_string($rid) && strlen($rid)>0) $sobj['jsp_rid']=$rid;
      $pk['auth']=true;
      session_set_rfid_data($sobj, $pk);
      $sobj['uid_raw']=$uid;
      session_wait($sobj, SESSION_PROC_KPO, 'kpo_result');
      session_lp_update($sobj);
      session_set_kpo_result($sobj, KPO_RES_YES, session_fix_allow_message(@$pk['caption']), array('kpo_answer_data'=>'Manual open'));
      session_check_done($sobj);
    } else if (@$pk['cmd']=='relay_close') {
      if (!$conn) return true;
      if ($conn['type']==TTYPE_POCKET) {
        $pool->send($conn['key'], eproto_packet(eproto_cmd_RelayControlEx, 0, relay_on_ex(0x1FFFFFFF)));
      } else if ($conn['type']==TTYPE_JSP) {
        jsp_send($conn['key'], array('cmd'=>'relay_close'));
      }      
    } else if (@$pk['cmd']=='message') {
      if (!$conn) return true;
      if ($conn['type']==TTYPE_POCKET) {
        $pool->send($conn['key'], eproto_packet(eproto_cmd_Interactive, 0, pocket_interactive(colon2nl(@$pk['text']), (int)@$pk['time'], 0, true)));
      } else if ($conn['type']==TTYPE_JSP) {
        jsp_send($conn['key'], $pk);
      }      
    } else {
      if (is_string(@$pk['rid']) && strlen($pk['rid'])>0) jsp_answer_request($key, $pk['rid'], $pk);
    }
  } else if ($evt=='timeout1') {
    if (!($sobj=&session_obj_get(@$request['rparams']['s_id']))) return false;
    if (@$sobj['data']['kpo']['rkey']==$request['rkey']) {
      if (@$glob['service_autofix_expired']) {
        session_set_kpo_result($sobj, KPO_RES_YES, $glob['service_fixed_msg'], array('kpo_answer_data'=>'autofix'));
      } else {
        session_set_kpo_result($sobj, KPO_RES_NO, $glob['service_link_err_msg'], array('kpo_answer_data'=>'link error'));
      }
      session_check_done($sobj);
    }
  }
  
  return false;
}
  
function dmnh_tag_read_try_deny($params=false) {
  global $dmn_main_conn, $glob;
  if (!is_array($params) || count($params)<1) return false;
  $slink=&$params[0];

  if (!($sobj=&session_obj_get($slink))) return false;
  
  if (!($conn=&conn_get_settings($sobj['key'], $sobj['apkey'], true))) return false;

  $data=@$sobj['data']['rfid'];
  if (!is_array($data)) return false;
  
  if (!@$data['auth']) {
    $sobj['data']['error_message']=from_utf8(';Метка;не прочитана;');
    return true;
  }

  if (@$conn['deny_lockers'] && is_array(@$data['lockers_data_f']) && count($data['lockers_data_f'])>0) {
    $msg='Сдайте шкафы:';
    $chs=array_chunk($data['lockers_data_f'], 3);
    if (count($chs)>3) $chs=array_slice($chs, 0, 3);
    foreach ($chs as $cha) {
      $msg.=';'.implode(', ', $cha);
    }
    $sobj['data']['error_message']=from_utf8($msg);
    return true;
  }
  
  if (@$data['temp_card'] && @$conn['deny_ct']) {
    $msg="Это карта\nдля\nкартоприемника";
    $sobj['data']['error_message']=from_utf8($msg);
    return true;
  }
  
  $mda=@$conn['memreg_deny'];
  if (is_string($mda)) $mda=array($mda); 
  if (is_array($mda)) {
    foreach ($mda as $mdkey) {
      if (memreg_key($mdkey, $mdkey)) {
        if (memreg_key($data['uid'], $uid_key)) {
          if (!is_null(memreg_get($mdkey, $uid_key))) {
            $sobj['data']['error_message']=memreg_message(MEMREG_MSG_DENIED, $mdkey);
            return true;
          }
        }    
      }
    }
  }
  
    
  return false;
}

function dmnh_barcode_read_try_deny($params=false) {
  global $dmn_main_conn, $glob;
  return false;
  if (!is_array($params) || count($params)<1) return false;
  $slink=&$params[0];

  if (!($sobj=&session_obj_get($slink))) return false;
  
  if (!($conn=&conn_get_settings($sobj['key'], $sobj['apkey'], true))) return false;

  $data=@$sobj['data']['barcode'];
  if (!is_array($data)) return false;
  
  if (!preg_match('/^([\d]{4,32})$/', $data['data'])) {
    $sobj['data']['error_message']=from_utf8(';Штрих-код;не прочитан;');
    return true;
  }
  if (@$conn['proxy']) $data=str_pad(substr($data, 3), 14, '0', STR_PAD_LEFT);

  return false;
}

function dmnh_faceid_read_try_deny($params=false) {
  global $dmn_main_conn, $glob;
  return false;
  if (!is_array($params) || count($params)<1) return false;
  $slink=&$params[0];

  if (!($sobj=&session_obj_get($slink))) return false;
  
  if (!($conn=&conn_get_settings($sobj['key'], $sobj['apkey'], true))) return false;

  $data=@$sobj['data']['faceid'];
  if (!is_array($data)) return false;
  
  if (!preg_match('/^([\d]{3,15})$/', $data['data'])) {
    $sobj['data']['error_message']=from_utf8(';Лицо;не распознано;');
    return true;
  }
  
  return false;
}

function dmnh_session_cde($params=false) {
  global $dmn_main_conn, $glob;
  if (!is_array($params) || count($params)<1) return false;
  $slink=&$params[0];
  $call_reason=false;
  if (count($params)>1) $call_reason=$params[1];

  if (!($sobj=&session_obj_get($slink))) return false;
  
  if (@$sobj['processed'] || @$sobj['completed']) return;
  $pool=$dmn_main_conn['pool'];
  
  $mtf=get_mtf();  

  if (!($conn=&conn_get_settings($sobj['key'], $sobj['apkey'], true))) return true;
  $tid=$conn['con_key'];
  $gpkey=cgate_get_op_conn($conn);

  $lp=&session_get_lp($sobj);

//  logp($glob['log_file'], "session sobj:\n".var_d($sobj)."\n");
//  logp($glob['log_file'], "session conn:\n".var_d($conn)."\n");
//  logp($glob['log_file'], "session connection:\n".var_d($glob[GLOB_KEY_CONNECTIONS][$sobj['key']], true));

  $rce_flags=POCKET_RELAY_FLAG_DOWNCOUNT | POCKET_RELAY_FLAG_ZSECOND;// | POCKET_RELAY_FLAG_GATE_TRANSFER;

  if (!@$sobj['stage']) {
    if (@$sobj['data']['rfid']) {
      if (!session_try_tag_read_deny($sobj)) {
        if ($gpkey) session_dev_lock($sobj, $gpkey);
    
        if (!session_kpo_send_request($sobj)) return true;
        session_wait($sobj, SESSION_PROC_KPO, 'kpo_result');
        session_lp_update($sobj);
      }
    } else if (@$sobj['data']['barcode']) {
      if (!session_try_barcode_read_deny($sobj)) {
        if ($gpkey) session_dev_lock($sobj, $gpkey);
    
        if (!session_kpo_send_request($sobj)) return true;
        session_wait($sobj, SESSION_PROC_KPO, 'kpo_result');
        session_lp_update($sobj);
      }
    } else if (@$sobj['data']['faceid']) {
      if (!session_try_faceid_read_deny($sobj)) {
        if ($gpkey) session_dev_lock($sobj, $gpkey);
    
        if (!session_kpo_send_request($sobj)) return true;
        session_wait($sobj, SESSION_PROC_KPO, 'kpo_result');
        session_lp_update($sobj);
      }
    }
  }

  if (@$sobj['data']['error_message']) {
    session_set_result($sobj, 0, session_fix_error_message((string)$sobj['data']['error_message']));
    $sobj['stage']='last_answer';
  }
  
  if (@$sobj['stage']=='kpo_result') {
    session_set_result($sobj, 1, session_fix_allow_message((string)@$sobj['data']['kpo']['message']));
    if ($_cid=session_uid2cid(@$sobj['uid'])) $sobj['cid']=$_cid;
    if ($sobj['data']['kpo']['result']!==KPO_RES_YES) {
      session_set_result($sobj, 0, session_fix_denied_message((string)@$sobj['data']['kpo']['message']));
      $sobj['stage']='kpo_direct';
    } else if ($gpkey) {
      $sobj['stage']='open_first';
    } else if (@$glob['cam_service_active'] && !@$sobj['data']['cam']['result'] && @$sobj['cid'] && @$glob['cam_links'][$tid]) {
      if (!session_cam_send_request($sobj)) return true;
      session_wait($sobj, SESSION_PROC_CAM, 'cam_result');
    } else {
      $sobj['stage']='kpo_direct';
    }
    session_lp_update($sobj);
  }

  if (@$sobj['stage']=='open_first') {
    if (!session_dev_send_pass_request($sobj, (string)@$sobj['data']['kpo']['message'])) return session_done($sobj);
    session_wait($sobj, SESSION_PROC_PASS, 'first_passed', array('key'=>$sobj['key']));
    session_lp_update($sobj);
  }
  
  if (@$sobj['stage']=='first_passed') {
    if (!@$sobj['passed']) return true;
    $sobj['data']['passed_first']=session_passed2val(@$sobj['passed']);
    session_set_passed_data($sobj, NULL);

    if (!@$sobj['data']['passed_first']) {
      session_done($sobj);
    } else {
        session_dev_lock($sobj, $sobj['key'], from_utf8("Ожидание \nраспознавания..."));
//      logp($glob['log_file'], "passed:\n".var_d($sobj['data']['passed_first'], true)."\n", true);
      
      if ($_cid=session_uid2cid(@$sobj['uid'])) $sobj['cid']=$_cid;

      if (@$glob['cam_service_active'] && !@$sobj['data']['cam']['result'] && @$sobj['cid'] && @$glob['cam_links'][$tid]) {
        if (!session_cam_send_request($sobj)) return true;
        session_wait($sobj, SESSION_PROC_CAM, 'cam_result');
      } else {
        $sobj['stage']='open_second';
      }
    }
    session_lp_update($sobj);
  }

  if (@$sobj['stage']=='cam_result') {
    if (!is_array(@$sobj['data']['cam']) || !array_key_exists('result', $sobj['data']['cam'])) session_set_cam_result($sobj, CAM_RES_FAIL);
    if (@$glob['cam_always_pass'] || @$sobj['data']['cam']['result']==CAM_RES_YES) {
      session_set_result($sobj);
      $sobj['stage']=($gpkey)?'open_second':'kpo_direct';
    } else if (@$sobj['data']['cam']['result']==CAM_RES_NO) {
      session_set_result($sobj, 0, @$glob['cam_service_result_msg_no']);
      $sobj['stage']='last_answer';
    } else if (@$sobj['data']['cam']['result']==CAM_RES_NF) {
      session_set_result($sobj, 0, @$glob['cam_service_result_msg_nf']);
      $sobj['stage']='last_answer';
    } else if (@$sobj['data']['cam']['result']==CAM_RES_FAIL) {
      session_set_result($sobj, 0, @$glob['cam_service_result_msg_fail']);
      $sobj['stage']='last_answer';
    } else {
      session_set_result($sobj);
      session_done($sobj);
    }
    
    logp($glob['log_file'], "cam data:\n".var_d(@$sobj['data']['cam'], true)."\n", true);
    session_lp_update($sobj);
  }
  
  if (@$sobj['stage']=='open_second') {
    session_dev_unlock($sobj, $gpkey);
    session_dev_lock($sobj, $sobj['key']);
    if (!session_dev_send_pass_request($sobj, from_utf8('Ожидание прохода'), false, $gpkey)) return session_done($sobj);
    session_wait($sobj, SESSION_PROC_PASS, 'second_passed', array('key'=>$gpkey));
    session_lp_update($sobj);
  }

  if (@$sobj['stage']=='second_passed') {
    if (@$sobj['passed']) $sobj['data']['passed_second']=session_passed2val(@$sobj['passed']);
//    session_dev_unlock($sobj, $sobj['key']);
    $sobj['stage']='passed';
  }
  
  if (@$sobj['stage']=='kpo_direct') {
    if ($sobj['data']['kpo']['result']===KPO_RES_UNDEF) return true;
    if ($sobj['data']['kpo']['result']==KPO_RES_NO) {
      session_set_result($sobj, 0, session_fix_denied_message((string)@$sobj['data']['kpo']['message']));
    } else if ($sobj['data']['kpo']['result']==KPO_RES_YES) {
      session_set_result($sobj, 1, session_fix_allow_message((string)@$sobj['data']['kpo']['message']));
    } else {
      session_set_result($sobj, 0, session_fix_error_message((string)@$sobj['data']['kpo']['message']));
    }
    $sobj['stage']='last_answer';
    session_lp_update($sobj);
  }
  
  if (@$sobj['stage']=='last_answer') {
    $msg=(string)@$sobj['data']['message'];
    if (!is_int(@$sobj['data']['result'])) {
      session_dev_send_cancel_text($sobj, session_fix_error_message($msg));
    } else if ($sobj['data']['result']>0) {
      if (!session_dev_send_pass_request($sobj, session_fix_allow_message($msg), $rce_flags)) return session_done($sobj);
      session_wait($sobj, SESSION_PROC_PASS, 'passed', array('key'=>$gpkey));
    } else {
      session_dev_send_cancel_text($sobj, session_fix_denied_message($msg));
      session_done($sobj);
    }
    session_lp_update($sobj);
  }

  if (@$sobj['stage']=='passed') {
    $sobj['data']['passed']=session_passed2val(@$sobj['passed']);
    if (!@$sobj['report_sent'] && (int)@$sobj['data']['result']>0 && ($conn['type']!=TTYPE_JSP || (@$sobj['passed'] && !@$sobj['passed']['tmo']))) {
      session_kpo_send_report($sobj);
      $sobj['report_sent']=true;
    }
    session_done($sobj);
  }

  if (@$sobj['stage']=='done') {
    if (!@$sobj['report_sent'] && (int)@$sobj['data']['result']>0 && ($conn['type']!=TTYPE_JSP || (@$sobj['passed'] && !@$sobj['passed']['tmo']))) {
      session_kpo_send_report($sobj);
      $sobj['report_sent']=true;
    }
    session_dev_unlock($sobj);
    session_lp_update($sobj);
    $sobj['processed']=true;
    reg_session_csv_event($sobj);
//    logp($glob['log_file'], "dmnh_session_processed\n", true);  
  }
  
  return true;
}

function dmnh_session_done($params=false) {
  global $dmn_main_conn, $glob;
  if (!is_array($params) || count($params)<1) return false;
  $slink=&$params[0];
  $prev_stage=false;
  if (count($params)>1) $prev_stage=$params[1];

  if (is_callable('crt_session_done')) crt_session_done($slink, $prev_stage);


//  if (!($sobj=&session_obj_get($slink))) return false;

  
}

function ga($key, $result, $message, $uid, $c, $d=false, $rce_flags=false) {
  global $dmn_main_conn, $glob;
  
  if (!array_key_exists($key, $glob[GLOB_KEY_CONNECTIONS])) return false;
  
  $glob['llock']=$d;
//  plogs(var_d(array($key, $result, $message, $uid, $c), true)."\n");
//  plogs(var_d($glob[GLOB_KEY_CONNECTIONS][$key], true)."\n");
//  plogs(var_d($message, true)."\n");
  if ($glob[GLOB_KEY_CONNECTIONS][$key]['settings']['utf']) $message=to_utf8($message);
//  plogs(var_d($message, true)."\n");
  $skey = session_key($uid, $key);
//  $sobj=@$glob[GLOB_KEY_SESSIONS][$skey];
  $sobj=&session_obj_get($skey);
  $pass_time=(int)(session_pass_time($sobj)*1000);
  if ($glob[GLOB_KEY_CONNECTIONS][$key]['settings']['type']==TTYPE_POCKET) {
    $message=colon2nl($message);
    if ($result>0) {
      if (!is_int($rce_flags)) $rce_flags=POCKET_RELAY_FLAG_DOWNCOUNT | POCKET_RELAY_FLAG_ZSECOND;
      if (is_array($sobj)) {
//        logp($glob['log_file'], "session[".$skey."]:\n".var_d($sobj, true));
        if (@$sobj['data']['rfid']['temp_card'] && @$glob[GLOB_KEY_CONNECTIONS][$key]['settings']['ctrole']=='card_taker') $rce_flags|=POCKET_RELAY_FLAG_TAKE_CARD;
      }

//      logp($glob['log_file'], "rce_flags[".$skey."]:\n".var_d($rce_flags, true));
      if (!($rce_flags & POCKET_RELAY_FLAG_DOWNCOUNT)) {
        $pk=eproto_packet(eproto_cmd_Interactive);
        $pk['flags']=(int)@$sobj['data']['rfid']['reader_type'];
        $pk['payload']=pocket_interactive($message, $pass_time, 0, true);
        $dmn_main_conn['pool']->send($key, $pk);
      }
      $pk=eproto_packet(eproto_cmd_RelayControlEx);
      $pk['flags']=(int)@$sobj['data']['rfid']['reader_type'];
      $pk['payload']=relay_on_ex($pass_time, $rce_flags, $message, $sobj['s_id']);
//      $pk['payload']=relay_on_ex($pass_time, $rce_flags, $message, $uid);
      $dmn_main_conn['pool']->send($key, $pk);
//      $dmn_main_conn['pool']->send($key, eproto_packet(eproto_cmd_Beep));
      $dmn_main_conn['pool']->send($key, eproto_packet(eproto_cmd_Enquire));
      if (is_array($sobj)) $sobj['relay_open_sent']=true;
    } else {
      $dmn_main_conn['pool']->send($sobj['key'], eproto_packet(eproto_cmd_RelayControlEx, (int)@$sobj['data']['rfid']['reader_type'], relay_on_ex(0x1FFFFFFF)));
      $pk=eproto_packet(eproto_cmd_Interactive);
      $pk['flags']=(int)@$sobj['data']['rfid']['reader_type'];
      $pk['payload']=pocket_interactive($message, 1500, 4, true);
      $dmn_main_conn['pool']->send($key, $pk);
    }
  } else if ($glob[GLOB_KEY_CONNECTIONS][$key]['settings']['type']==TTYPE_SPHINX) {
    sphinx_send($key, 'DELEGATION_REPLY', $uid, 'NORMAL', ($result>0)?'255':'0', '0', '0', '0', '0');    
  } else if ($glob[GLOB_KEY_CONNECTIONS][$key]['settings']['type']==TTYPE_GAT) {
    $pk=gat_packet($uid, $c, ($result>0)?0:1, $message);
    $dmn_main_conn['pool']->send($key, $pk);
  } else if ($glob[GLOB_KEY_CONNECTIONS][$key]['settings']['type']==TTYPE_JSP) {
    if (is_string(@$sobj['jsp_rid'])) {
      jsp_answer_request($key, $sobj['jsp_rid'], array('result'=>$result, 'uid'=>$sobj['s_id'], 'cid'=>@$sobj['cid'], 'message'=>$message, 'time'=>$pass_time));
    } else if ($result>0) {
      jsp_send_request($key, 'relay_open', array('uid'=>$sobj['s_id'], 'caption'=>$message, 'time'=>$pass_time));
    } else {
      jsp_send_request($key, 'relay_close');
      jsp_send_request($key, 'message', array('uid'=>$sobj['uid'], 'text'=>$message, 'time'=>1500));
    }
  }
  
  if (!$result && $glob['ucs_child_key'] && ($cset=&conn_get_settings($sobj['key'], $sobj['apkey']))) {
    if (is_array(@$cset[UCS_SENT_REQUEST_KEY])) {
      $pa=$cset[UCS_SENT_REQUEST_KEY];
      ucs_send_transaction($dmn_main_conn['pool'], $pa[0], $pa[1], UCS_CANCEL_SYMBOL);
    }
  }

  $glob['llock']=false;
  return true;
}

function ga_a($params) {
  if (!is_array($params) || count($params)<5) return false;
  $key=array_shift($params);
  $result=array_shift($params);
  $message=array_shift($params);
  $uid=array_shift($params);
  $c=array_shift($params);
  $d=(count($params)>0)?array_shift($params):false;
  $rce_flags=(count($params)>0)?array_shift($params):false;
  return ga($key, $result, $message, $uid, $c, $d, $rce_flags);
}

function dmnh_httpr_on_data($params) { //Функция парсит список терминалов.
  global $dmn_main_conn, $glob;
  if (!is_array($params) || count($params)<5) return false;
  $data=$params[0];
  $raw_data=$params[1];
  $request=&$params[2];
  $pool=&$params[3];
  $key=$params[4];
//  logp($glob['log_file'], "http_data handler:\n".var_d(array($raw_data, $data), true)."\n", true);
  
     $status=@$data[0];
     $headers=@$data[1];
//     plogs("data:\n".var_d(@$data[3], true)."\n");
     $data=json_as_rows(@$data[3]);
//     plogs("status:\n".var_d($status, true)."\n");
//     plogs("headers:\n".var_d($headers, true)."\n");
//     plogs("data:\n".var_d($data, true)."\n");
     if (@$request['tag']===REQ_TAG_TLIST) {
       if (array_key_exists('DEVICES', $data)) $data=@$data['DEVICES'];
       if (is_array($data)) {
         $terminals=array();
         foreach ($data as $d) {
           $terminals[]=trim(@$d['ID']).':'.trim(@$d['IP']).':'.trim(@$d['PORT']).':'.trim(@$d['CONFIG_STRING']);
         }
//         logp($glob['log_file'], "terminals ip list #1 [".$key."]:\n".var_d($terminals, true)."\n", true);
         if (array_key_exists('def_terminals', $glob) && is_array($glob['def_terminals'])) $terminals=$glob['def_terminals'];
//         logp($glob['log_file'], "terminals ip list #2 [".$key."]:\n".var_d($terminals, true)."\n", true);
         if ($request['completed']) return true;
//         logp($glob['log_file'], "terminals ip list #3 [".$key."]:\n".var_d($terminals, true)."\n", true);
         $terminals=term_filter_list($terminals);
//         logp($glob['log_file'], "terminals ip list #4 [".$key."]:\n".var_d($terminals, true)."\n", true);
         ecmdh_termlist(array('check', $terminals), false);
       }
     } else if (@$request['tag']===REQ_TAG_QRY) {
       
//       logp($glob['log_file'], "answer [".$key."]:\n".var_d($data, true)."\n", true);
       $was_err=true;
       $allow=0;
       $msg=$glob['service_link_err_msg'].'2';
       $cid='';
       if (is_array($data)) {
         if (array_key_exists('CID', $data)) {
            $cid=@$data['CID'];
         } else if (array_key_exists('CLIENT_ID', $data)) {
            $cid=@$data['CLIENT_ID'];
         } else if (array_key_exists('BIOID', $data)) {
            $cid=@$data['BIOID'];
         }
         if (is_array($data) && array_key_exists('RESULTVAL', $data) && array_key_exists('MSGSTR', $data)) {
           $allow=(int)@$data['RESULTVAL'];
           $msg=(string)@$data['MSGSTR'];
           $was_err=false;
         } else if (is_array($data) && array_key_exists('RESULT', $data) && array_key_exists('MESSAGE', $data)) {
           $allow=(int)@$data['RESULT'];
           $msg=(string)@$data['MESSAGE'];
           $was_err=false;
         } else if (is_array($data) && array_key_exists('RESULT', $data) && array_key_exists('DENYREASON', $data)) {
           $allow=(int)@$data['RESULT'];
           $msg=(string)@$data['DENYREASON'];
           $was_err=false;
         } else if (is_array($data) && array_key_exists('GRANT_ACCESS', $data) && array_key_exists('TEXT', $data)) {
           $allow=(int)@$data['GRANT_ACCESS'];
           $msg=(string)@$data['TEXT'];
           $was_err=false;
         } else if (is_array($status) && (int)@$status[1]==500) {
           $allow=0;
           $msg=$glob['service_denied_msg'];
           $was_err=false;
         } else {
           $allow=0;
           $msg=$glob['service_link_err_msg'].'1';
         }
         if ($msg=='') {
           $msg=($allow)?$glob['service_fixed_msg']:$glob['service_denied_msg'];
         }
       } else if (is_array($status) && (int)@$status[1]==500) {
           $allow=0;
           $msg=$glob['service_denied_msg'];
           $was_err=false;
       }
       if (!($sobj=&session_obj_get($request['params']))) return httpr_fin_rt($key);
       if (@$sobj['data']['kpo']['rkey']!=$request['rkey']) return httpr_fin_rt($key);
       $cid=trim((string)$cid); if (strlen($cid)>0) $sobj['cid']=$cid;
       
//       if (is_array(@$conn['lp'])) $conn['lp']['result']=array('allow'=>($allow>0), 'msg'=>$msg, 'dbrtime'=>(get_mtf()-$request['time']));
//       if ($request['completed']) return true;
       
       if ($was_err) {
         if (@$glob['service_autofix_expired']) {
           $allow=1;
           $msg=$glob['service_fixed_msg'];
           tlogs_add(false, array('type'=>'DB_REQUEST_INCOMPLETE', 'time'=>get_mtf(), 'reason'=>$msg, 'autofixed'=>'YES'));
//           session_set_kpo_result($sobj, KPO_RES_YES, $glob['service_fixed_msg']);
           $sobj['ap_mode']=true;
         } else {
           $allow=0;
           $msg=$glob['service_link_err_msg'];
//           session_set_kpo_result($sobj, KPO_RES_NO, $glob['service_link_err_msg']);
         }
       }
       
       $kres=($allow>0)?KPO_RES_YES:KPO_RES_NO;
       session_set_kpo_result($sobj, $kres, $msg, array('kpo_answer_data'=>$data));
       session_check_done($sobj);
     } else if (@$request['tag']===REQ_TAG_CAM) {
       if (!($sobj=&session_obj_get($request['params']))) return httpr_fin_rt($key);
       if (@$sobj['data']['cam']['rkey']!=$request['rkey']) return httpr_fin_rt($key);
       if ((int)@$sobj['data']['cam']['result']==CAM_RES_UNDEF) {
         if ($glob['cam_service_proto']=='recx') {
           $emes=strtolower(trim(@$data['ERROR']['MESSAGE']));
           $st=strtolower(trim(@$data['STATUS']));
           if (strpos($emes, 'profile not found')!==false) {
             session_set_cam_result($sobj, CAM_RES_NF, array('cam_answer_data'=>$data));
           } else if (strpos($emes, 'no active portraits in profile')!==false) {
             session_set_cam_result($sobj, CAM_RES_NF, array('cam_answer_data'=>$data));
           } else if ($st=='success') {
             session_set_cam_result($sobj, CAM_RES_YES, array('cam_answer_data'=>$data));
           } else {
             session_set_cam_result($sobj, CAM_RES_FAIL, array('cam_answer_data'=>$data));
           }
         } else {
           $cpkey = false;
           $cpid = false;
           $cpres = false;
           if (is_array($data)) {
             $cpkey = array_key_exists('PERSON KEY', $data);
             $cpid = array_key_exists('PERSON ID', $data);
             $cpres = array_key_exists('RESULT', $data);
           }
           if ($cpkey==false) {
             session_set_cam_result($sobj, CAM_RES_FAIL, array('cam_answer_data'=>$data));
           } else if ($cpid==false) {
             session_set_cam_result($sobj, CAM_RES_NF, array('cam_answer_data'=>$data));
           } else if ($cpres==false) {
             session_set_cam_result($sobj, CAM_RES_NO, array('cam_answer_data'=>$data));
           } else {
             session_set_cam_result($sobj, CAM_RES_YES, array('cam_answer_data'=>$data));
           }
         }
       }
       session_check_done($sobj);
     } else if (@$request['tag']===REQ_TAG_CRT) {
       if (is_callable('crt_process_items')) crt_process_items($key, $request, $data);
     }
     httpr_fin($key);
     return true;
}

function net_card_check_proc(&$pool) {
  global $dmn_main_conn, $glob;
  
  $glob['terminal_connect_timeout']=1.0;
  $glob['reconnection_wait_time_step']=0.2;
  $glob['reconnection_wait_time_max']=1.0;
  $glob['term_autoping_interval']=2.0;
  $glob['term_autoping_timeout']=5.0;

  if (!array_key_exists('net_test_last_check', $glob)) $glob['net_test_last_check']=get_mtf();
  if (!array_key_exists('net_test_check_time', $glob)) $glob['net_test_check_time']=0.5;
  if (!array_key_exists('net_test_counter', $glob)) $glob['net_test_counter']=0;
  
    $min_mtf=get_mtf()-((float)$glob['net_test_check_time']);
    if ((float)$glob['net_test_last_check']<$min_mtf) {
      foreach ($glob[GLOB_KEY_CONNECTIONS] as &$conn) {
        $pk=eproto_packet(eproto_cmd_Interactive);
        $pk['flags']=EPROTO_PK_FLAGS_RT_MAIN;
        $pk['payload']=pocket_interactive(from_utf8("Net Check\n\nAttempt\n#".$glob['net_test_counter']), 1500, 0, false);
        $pool->send($conn['key'], $pk);
        $pool->send($conn['key'], eproto_packet(eproto_cmd_BeepShort));
        
 /*       
        $pk=eproto_packet(eproto_cmd_Signal);
        $pk['flags']=EPROTO_PK_FLAGS_RT_USART;
        $pk['payload']=(($glob['net_test_counter']/5)%2)?"\x01":"\x02";
        $pool->send($conn['key'], $pk);
 */       
      }
      $glob['net_test_last_check']=get_mtf();
      $glob['net_test_counter']++;
    }
}

function idle_proc(&$pool) {
  global $dmn_main_conn, $glob;
  
  $mtf=get_mtf();
  
  if (is_callable('session_idle_proc')) session_idle_proc($pool, $mtf);
  if (is_callable('httpr_idle_proc')) httpr_idle_proc($pool, $mtf);
  if (is_callable('helios_idle_proc')) helios_idle_proc($pool, $mtf);
  if (is_callable('conn_idle_proc')) conn_idle_proc($pool, $mtf);
  
//  net_card_check_proc($pool);

  if ($glob['term_list_check_time']>0.0) {
    $min_mtf=$mtf-((float)$glob['term_list_check_time']);
    if ((float)@$glob['term_list_last_check']<$min_mtf) req_db_termlist();
  }

  if (is_callable('crt_idle_proc')) crt_idle_proc($pool, $mtf);
  if (is_callable('proxy_idle_proc')) proxy_idle_proc($pool, $mtf);
  if (is_callable('sphinx_idle_proc')) sphinx_idle_proc($pool, $mtf);
  if (is_callable('ucs_idle_proc')) ucs_idle_proc($pool, $mtf);
  if (is_callable('txp_idle_proc')) txp_idle_proc($pool, $mtf);
  if (is_callable('jsp_idle_proc')) jsp_idle_proc($pool, $mtf);
  if (is_callable('memreg_idle_proc')) memreg_idle_proc($pool, $mtf);
//  print(".");
  return true;
}

function req_db_termlist() {
  global $dmn_main_conn, $glob;

  $res=false;
  if (array_key_exists('def_terminals', $glob) && is_array($glob['def_terminals'])) {  
    if (count($glob['def_terminals'])>0) ecmdh_termlist(array('check', term_filter_list($glob['def_terminals'])), false);
    $res=true;
  } else if ($glob['http_service_active']) {
    $res=httpr_new($dmn_main_conn['pool'], false, REQ_TAG_TLIST, dmnh_hcfg_http(), $glob['http_service_termlist_path']);
  }
  if ($res) $glob['term_list_last_check']=get_mtf();
  return $res;
}

handler_init('dmnh_');
dmn_main_start();

?>