<?php

if (!defined("INC_BIT_H")){
   define("INC_BIT_H", TRUE);

    $GLOBALS['BIT_MAX_LEN'] = 32;
    
    function bit_set($map, $n) {
      if ($n<1 || $n>$GLOBALS['BIT_MAX_LEN']) return $map;
      return (int) ($map | (1 << ($n-1)));
    }
    
    function bit_clear($map, $n) {
      if ($n<1 || $n>$GLOBALS['BIT_MAX_LEN']) return $map;
      return (int) ($map & (~(1 << ($n-1))));
    }
    
    function bit_flip($map, $n) {
      if ($n<1 || $n>$GLOBALS['BIT_MAX_LEN']) return $map;
      return (int) ($map ^ (1 << ($n-1)));
    }
    
    function bit_invert($map, $n) { return bit_flip($map, $n); }
    
    function bit_test($map, $n) {
      if ($n<1 || $n>$GLOBALS['BIT_MAX_LEN']) return false;
      return (($map & (1 << ($n-1)))?true:false);
    }

    function bit_set_($map, $n) { $map=bit_set($map, $n); return $map; }
    
    function bit_clear_($map, $n) { $map=bit_clear($map, $n); return $map; }
    
    function bit_flip_($map, $n) { $map=bit_flip($map, $n); return $map; }
    
    function bit_invert_($map, $n) { $map=bit_invert($map, $n); return $map; }

}
?>
