<?php

if (!defined("INC_CRYPT_H")){
   define("INC_CRYPT_H", TRUE);

  include("crc8.inc");

  function crypt_get_secret_key() {
      $res=&$GLOBALS["SECRET_KEY"];
      if (!$res || strlen($res)<1) $res="SecretKeyOfDSD";
      return $res;
  }

  function crypt_gen_uni_id() {
      srand ((double) microtime() * 1000000);
      return hexdec(substr(md5(uniqid(rand(0xFFFF, 0xFFFFFFFF),1)),0,8));
  }

  function crypt_gen_uni_id_16() {
      srand ((double) microtime() * 1000000);
      return hexdec(substr(md5(uniqid(rand(0xFFFF, 0xFFFFFFFF),1)),0,8));
  }

  function crypt_oid2hash($oid) {
    $trcode=crypt_gen_trans_code($oid);
    return crypt_gen_public_code($oid, $trcode);
  }
  
  function crypt_hash2oid($hash) {
    return crypt_get_id_from_public($hash);
  }

  function crypt_gen_trans_code($product_id, $nick='DSD', $email='dsd@host.com', $rnd=0) {
      if (!$rnd) $rnd = crypt_gen_uni_id();
      return strtoupper(md5($nick.sprintf("%08X",$rnd).sprintf("%08X",$product_id).$email));
  }

  function crypt_idhash_random_data($length) {
    $mod=$length%4;
    $len=floor($length/4);
    $result='';
    for ($i = 0 ; $i < $len; $i++ ) $result.=crypt_encode_num_r(crypt_gen_uni_id(), 4);
    if ($mod>0) $result.=crypt_encode_num_r(crypt_gen_uni_id(), $mod);
    return $result;
  }

  function crypt_idhash_number2block($var, $vsize, $length, $key) {
    if ($vsize<1) $vsize=1;
    if ($vsize>4) $vsize=4;
    if ($vsize+1>$length) return false;

    $data=chr($vsize & 0xFF);
    $data.=crypt_encode_num_r($var, $vsize);
    $vsize++;
    $data.=crypt_idhash_random_data($length-$vsize);

    if ($length>9) $key.=substr($data, 9);
    $rdata=crypt_rc4_encrypt_str($data, $key);
    return strtoupper(crypt_str_to_hex(substr($rdata, 0, $vsize).substr($data, $vsize)));
  }

  function crypt_idhash_block2number($cdata, $key) {
    $cdlen=strlen($cdata);
    $cdata=crypt_hex_to_str($cdata);
//     return $cdata;
    if (strlen($cdata)*2!==$cdlen) return false;
    $length=strlen($cdata);
    if ($length>9) $key.=substr($cdata, 9);
    $data=crypt_rc4_encrypt_str($cdata, $key);
    $vsize=ord($data[0]);
    if ($vsize<1 || $vsize>4 || $vsize+1>$length) return false;
    
    return crypt_decode_num_r($data, $vsize, 1);
  }

  function crypt_gen_public_code($trans_id, $trans_code, $uni=0) {
      if (!preg_match('/^[\dA-Fa-f]{32,}$/', $trans_code)) return '';
      $trans_code=substr($trans_code, 0, 16);
      if (!$uni) $uni = crypt_gen_uni_id();
      $trans_num = hexdec(substr($trans_code, 4, 8));
      $res_num = $trans_id ^ $uni ^ $trans_num;
      $crc=CRC8_BlockChecksum(sprintf("%08X",$trans_id).sprintf("%08X",$uni).sprintf("%08X",$trans_num));
      $crc=sprintf("%02X",$crc);
      $trans_code{0}=$crc{0};
      $trans_code{1}=$crc{1};
      $res = sprintf("%08X",$uni).sprintf("%08X",$res_num).$trans_code;
      return $res;
  }

  function crypt_get_id_from_public($pub_code) {
      if (!preg_match('/^[\dA-Fa-f]{32,}$/', $pub_code)) return -1;
      $trans_code=substr($pub_code, 16);
      $uni = hexdec(substr($pub_code, 0, 8));
      $tid = hexdec(substr($pub_code, 8, 8));
      $trans_num=hexdec(substr($pub_code, 20, 8));
      $trans_id = $tid ^ $trans_num ^ $uni;

      $crc=CRC8_BlockChecksum(sprintf("%08X",$trans_id).sprintf("%08X",$uni).sprintf("%08X",$trans_num));
      $tcrc=hexdec(substr($trans_code, 0, 2));
      if ($crc!=$tcrc) return false;
      return $trans_id;
  }

  function crypt_check_public_trans_code($pub_code, $trans_code) {
      if (
          !preg_match('/^[\dA-Fa-f]{32,}$/', $pub_code) ||
          !preg_match('/^[\dA-Fa-f]{16,}$/', $trans_code)
          ) return false;
      if ( substr($trans_code, 0, 16)!=substr($pub_code, 16, 16) ) return false;
      return true;
  }

  function crypt_str_to_codes($str='') {
     $arr = array();
     $len = strlen($str);
     for ($i=0;$i<$len;$i++) $arr[]=ord($str{$i});
     return $arr;
  }
               
  function crypt_codes_to_str($codes, $zero_break=false) {
     array_walk($codes, create_function('&$item, $key, &$udata',($zero_break)?'if ($udata) { $item = ""; } else if ($item==0) { $item = ""; $udata=true; } else { $item=chr($item); }':'$item = chr($item);'), false);
     return implode('',$codes);
  }

  function crypt_hex_to_codes($hex_str='') {
      $len = floor(strlen($hex_str)/2);
      if ($len<=0 || !preg_match('/^[\dA-Fa-f]+$/', $hex_str)) return array();
//      if (strlen($hex_str)>$len*2) $hex_str = substr($hex_str, 0, $len*2);
      $arr = array();
//      $arr = explode(':',chunk_split($hex_str,2,':'));
//      if (count($arr)!=$len) return false;
      for ($i=0;$i<$len;$i++) $arr[]=hexdec($hex_str{$i*2}.$hex_str{($i*2)+1});
      return $arr;
  }

  function crypt_codes_to_hex($codes, $prefix='', $postfix='') {
     $fmtstr=$prefix.'%02X'.$postfix;
     array_walk($codes, create_function('&$item,&$key,&$fmtstr','$item = sprintf($fmtstr,$item);'), $fmtstr);
     return implode('',$codes);
  }

  function crypt_str_to_hex($str='', $prefix='', $postfix='') {
     if (!$prefix && !$postfix) return bin2hex($str);
     return crypt_codes_to_hex(crypt_str_to_codes($str), $prefix, $postfix);
  }

  function crypt_hex_to_str($hex_str='', $upcase=false) {
    $sl=strlen($hex_str);
    $l=floor($sl/2);
    if ($l==0) return '';
    if ($l*2!==$sl) $hex_str=substr($hex_str, 0, $l*2);
    return pack("H*" , $hex_str);
//    if ($upcase) $ret=strtoupper($ret);
  }

  function crypt_xor_codes($codes1, $codes2) {
     $len = count($codes1);
     if ($len>count($codes2)) return array();
     $arr = array();
     for ($i=0;$i<$len;$i++) $arr[]= $codes1[$i] ^ $codes2[$i];
     return $arr;
  }
   
  function crypt_encrypt_str($str='', $pass='') {
      $result = array();
      $sid = crypt_gen_uni_id();
      $trans_code = crypt_gen_trans_code($sid, $pass, $pass, $sid);
      $pub_code = crypt_gen_public_code($sid, $trans_code);
      $trans_codes = crypt_hex_to_codes($trans_code);
      array_push($result, $pub_code);

      $clen = count($trans_codes);
      $codes = array_chunk(crypt_str_to_codes($str), $clen);
      if (count($codes)==0) $codes = array(array());
      $len = count($codes);
      foreach ($codes as $chunk) {
            if (count($chunk)<$clen) $chunk=array_pad($chunk, $clen, 0);
            array_push($result, crypt_codes_to_hex(crypt_xor_codes($chunk, $trans_codes)));
      }
      return implode('',$result);
  }                                     
   
  function crypt_decrypt_str($str='', $pass='') {
      $result = array();
      $pub_code = substr($str, 0, 32);
      $str = substr($str, 32);
      $sid = crypt_get_id_from_public($pub_code);
      $trans_code = crypt_gen_trans_code($sid, $pass, $pass, $sid);
       
      if ( !($trans_codes=crypt_hex_to_codes($trans_code)) ) return '';

      $clen = count($trans_codes);
      $codes = crypt_hex_to_codes($str);
      $codes = array_chunk($codes, $clen);
      $len = count($codes);
//      print("5\n");
      foreach ($codes as $chunk) {      
            if (count($chunk)<$clen) $chunk=array_pad($chunk, $clen, 0);
            array_push($result, crypt_codes_to_str(crypt_xor_codes($chunk, $trans_codes), true));
      }
      return implode('',$result);
  }

  function crypt_rc4_setup_key($key_text, &$key) {
      $len=strlen($key_text);
      if (!is_array($key)) $key=array();
      $key['table']=array();
      $key['index']=array();
      //   
      for ($i=0;$i<256;$i++) $key['table'][$i] = $i;
      //  
      $key['index'][0] = 0;
      $key['index'][1] = 0;
    
      //   
      $e=0;
      for ($i=0;$i<256;$i++) {
         //   $e
         $ch =ord($key_text{$i%$len});
         $e  = ($e+$ch+$key['table'][$i])%256;
    
         //  
         $temp = $key['table'][$i];
         $key['table'][$i] = $key['table'][$e];
         $key['table'][$e] = $temp;
      }
  }

  function crypt_rc4_encrypt($text, &$key) {
      $len=strlen($text);
      $ciphertext='';
      for ($i=0;$i<$len;$i++) {
         //  
         $key['index'][0]=($key['index'][0]+1)%256;
         $key['index'][1]=($key['index'][1]+$key['table'][$key['index'][0]])%256;
    
         //   
         $temp = $key['table'][$key['index'][0]];
         $key['table'][$key['index'][0]] = $key['table'][$key['index'][1]];
         $key['table'][$key['index'][1]] = $temp;
    
         //   
         $ch_t=ord($text{$i});
         $ch_c= $ch_t ^ $key['table'][($key['table'][$key['index'][0]]+$key['table'][$key['index'][1]])%256];
         $ciphertext .= chr($ch_c);
      }
      return $ciphertext;
  }

  function crypt_rc4_encrypt_str($text, $pass) {
     $key=array();
     crypt_rc4_setup_key($pass, $key);
     return crypt_rc4_encrypt($text, $key);
  }

  function crypt_encode_num($val, $bytes_count=4) {
      $result = '';
      if ($bytes_count>3) $result .= chr(($val >> 24) & 0xFF);
      if ($bytes_count>2) $result .= chr(($val >> 16) & 0xFF);
      if ($bytes_count>1) $result .= chr(($val >> 8) & 0xFF);
      if ($bytes_count>0) $result .= chr($val);
      return $result;
  }

  function crypt_decode_num($str, $bytes_count=4, $offset=0) {
      $len = strlen($str);
      if ($len<0) return 0;
      if ($len<4 && $bytes_count>$len) $bytes_count=$len;
      $i=$offset;
      $result = 0;
      if ($bytes_count>3) $result |= (ord($str{$i++}) << 24);
      if ($bytes_count>2) $result |= (ord($str{$i++}) << 16);
      if ($bytes_count>1) $result |= (ord($str{$i++}) << 8);
      if ($bytes_count>0) $result |= ord($str{$i++});
      return $result;
  }

  function crypt_encode_num_r($val, $bytes_count=4) {
      $result = '';
      if ($bytes_count>0) $result .= chr($val & 0xFF);
      if ($bytes_count>1) $result .= chr(($val >> 8) & 0xFF);
      if ($bytes_count>2) $result .= chr(($val >> 16) & 0xFF);
      if ($bytes_count>3) $result .= chr(($val >> 24) & 0xFF);
      return $result;
  }

  function crypt_decode_num_r($str, $bytes_count=4, $offset=0) {
      $len = strlen($str);
      if ($len<0) return 0;
      if ($len<4 && $bytes_count>$len) $bytes_count=$len;
      $i=$offset;
      $result = 0;
      if ($bytes_count>0) $result |= ord($str{$i++});
      if ($bytes_count>1) $result |= (ord($str{$i++}) << 8);
      if ($bytes_count>2) $result |= (ord($str{$i++}) << 16);
      if ($bytes_count>3) $result |= (ord($str{$i++}) << 24);
      return $result;
  }

  function crypt_dump_packet($data, $line_prefix='') {
     $res=array();
     $l=strlen($data);
     $ind=0;
     while ($ind<$l) {
        $str=sprintf("0x%08X ",$ind);
        $ml=$l-$ind; if ($ml>16) $ml=16;
        $str1='';
        for ($i=0;$i<$ml;$i++) {
            $chc=ord($data{$ind+$i});
            $str.=sprintf(" %02X",$chc);
            if ($chc>32) {
              $str1.=chr($chc);
            } else {
              $str1.='.';
            }
        }
        $str.=str_pad('', (16-$ml)*3);
        $str.='  '.$str1;
        array_push($res, $line_prefix.$str);
        $ind+=$ml;
     }
      
     return implode("\n",$res);
  }

}
?>
