<?php
if (!defined("INC_CSV_H")) {
     define("INC_CSV_H", TRUE);

$csv_delimiter_symbol=',';
     
     
function csv_from_array($data, $flags=false) {
  if (!is_array($data) || count($data)==0) return '';
  $ret=array();
  $fields=array_keys($data[0]);
  $ret[]=csv_arr2line($fields);
  foreach($data as $larr) {
    $ret[]=csv_arr2line(array_values($larr), $flags);
  }
  return implode("\r\n", $ret);
}

function csv_arr2line($data, $flags=false) {
  global $csv_delimiter_symbol;
  if (!is_array($data) || count($data)==0) return false;
  if (!is_array($flags)) $flags=array();
  $l=count($data);
  while (count($flags)<$l) $flags[]=false;
  $ret=array();
  for ($i=0;$i<$l;$i++) {
    $val=(string)$data[$i];
    if (preg_match('/[\n\r\"\\'.$csv_delimiter_symbol.']/', $val) || @$flags[$i]) $val='"'.preg_replace('/\"/', '""', $val).'"';
    if (@$flags[$i]) $val='='.$val;
    $ret[]=$val;
  }
  return implode($csv_delimiter_symbol, $ret);
}

} // end incl_h
?>
