<?php

if (!defined("INC_DAEMON_H")){
   define("INC_DAEMON_H", TRUE);

include("udp_server.inc");
include("udp_client.inc");

if (!defined("IS_WIN")) define("IS_WIN", (stristr(php_uname('s'), 'windows')==FALSE)?false:true);

define("DAEMON_MAXFD", 64);

function d_pr($pid) {
  if (IS_WIN) {
    exec('tasklist /FI "PID eq '.$pid.'" /NH /FO CSV /V', $tls);
    $tls=(is_array($tls))?implode("\n", $tls):$tls;
    return preg_match('/php\.exe/i', $tls)?true:false;
  }
  return posix_kill($pid, 0);
}

class daemon_parent {
  var $main_pid;
  var $main_dir;
  var $children;
  var $pid_file;
  var $log_file;
  var $log_dir;
  var $module_dir;
  var $term_func;
  var $server;
  var $server_host;
  var $server_port;
  var $server_password;
  var $on_server_data;
  var $need_exit;
  
  function daemon_parent() {
     $this->main_pid = 0;
     $this->main_dir='./';
     $this->children = array();
     $this->pid_file="./pids/daemon.pid";
     $this->log_file="./pids/daemon.log";
     $this->log_dir="./pids/";
     $this->module_dir="./modules/";
     $this->term_func=null;
     $this->server = null;
     $this->server_host='127.0.0.1';
     $this->server_port=3060;
     $this->server_password='';
     $this->on_server_data = null;
     $this->need_exit = false;
  }

  function print_log($str) {
    $fp = @fopen ($this->log_file, "ab");
    if (!$fp) return false;
    if (flock($fp, LOCK_EX)) {
      if ($str!='') $str=date("[m-d-y H:i:s] ").$str;
      fputs ($fp, $str."\n");
      flock($fp, LOCK_UN);
    } else {
      fclose ($fp);
      return false;
    }
    fclose ($fp);
    return true;
  }

  function start($main_func, $main_data=null, $term_func=null) {
    chdir($this->main_dir);
    if ($this->check()) return false;
  
    pcntl_signal(SIGCHLD, SIG_IGN);
  
    $pid = pcntl_fork();
    if ($pid<0) {
       print("first fork error\n");
       exit(1);
    } else if ($pid>0) {
       exit(0);      /* parent terminates */
    }                  
  
    if (!posix_setsid()) {
       print("could not detach from terminal\n");
       exit(1);
    }
  
    $this->term_func=$term_func;
  //  for ($i=1;$i<=SIGTERM;$i++) @pcntl_signal($i, "daemon_sig_handler");
    for ($i=1;$i<=SIGTERM;$i++) @pcntl_signal($i, SIG_IGN);
    $pid = pcntl_fork();
    if ($pid<0) {
       print("second fork error\n");
       exit(1);
    } else if ($pid>0) {
       exit(0);      /* 1st child terminates */
    }
  
    for ($i=0; $i<DAEMON_MAXFD; $i++) @fclose($i);
    @fclose((int)STDIN);
    @fclose((int)STDOUT);
    @fclose((int)STDERR);
  
    if (!$this->write_pid(getmypid())) return false;
                        
    umask(0);        /* clear our file mode creation mask */
  //  chdir("/");        /* change working directory */
  
    $this->server = new udp_server();
    $this->server->_daemon_data = &$this;
    $this->server->on_command='daemon_proc_server_data';
    $this->server->start($this->server_host, $this->server_port, $this->server_password);
  
    $main_func($this, $main_data);
     
    chdir($this->main_dir);
    $this->server->stop();
    $this->del_all_children();
    $this->del_pid();
  
    return true;
  }

  function new_child($main_func, $main_data=null, $term_func=null) {
    pcntl_signal(SIGCHLD, SIG_IGN);
    
    $pid = pcntl_fork();
    if ($pid<0) {
       print("child fork error\n");
       exit(1);
    } else if ($pid>0) {
       $this->children[$pid]=array();
       return $pid; /* parent returns to main */
    }
    
    for ($i=1;$i<SIGTERM;$i++) @pcntl_signal($i, SIG_IGN);
    @pcntl_signal(SIGTERM, SIG_DFL);
    @pcntl_signal(SIGKILL, SIG_DFL);
    
    for ($i=0; $i<DAEMON_MAXFD; $i++) @fclose($i);
    @fclose((int)STDIN);
    @fclose((int)STDOUT);
    @fclose((int)STDERR);
    
    chdir($this->main_dir);

    $this->server->stop();

    $child = new daemon_child();
    $child->main_pid=$this->main_pid;
    $child->pid=getmypid();
    $child->main_dir='./';
    $child->pid_file="./pids/daemon.pid";
    $child->log_dir=$this->log_dir;
    $child->main_func=$main_func;
    $child->main_data=$main_data;
    $child->term_func=$term_func;
    $child->server_host=$this->server_host;
    $child->server_port=$this->server_port;
    $child->start();
                                 
    exit(0);
  }

  function start_child($module, $main_data=null, $prefix='proc', $term_func=null) {
    $mpath=realpath($this->module_dir.$module.'.module');
    if (!file_exists($mpath)) return false;
    pcntl_signal(SIGCHLD, SIG_IGN);
    
    $pid = pcntl_fork();
    if ($pid<0) {
       print("child fork error\n");
       exit(1);
    } else if ($pid>0) {
        $res = array();
        $res['pid']=$pid;
        $res['main_data']=$main_data;
        $res['prefix']=$prefix;
        $this->set_child($pid, $res);
        return $pid; /* parent returns to main */
    }
    
    for ($i=1;$i<SIGTERM;$i++) @pcntl_signal($i, SIG_IGN);
    @pcntl_signal(SIGTERM, SIG_DFL);
    @pcntl_signal(SIGKILL, SIG_DFL);
    
//    for ($i=0; $i<DAEMON_MAXFD; $i++) @fclose($i);
//    @fclose((int)STDIN);
//    @fclose((int)STDOUT);
//    @fclose((int)STDERR);
    
    chdir($this->main_dir);

    $this->server->stop();

    $prog = '/usr/local/bin/php';
    $args=array();
    array_push($args, '-f');
    array_push($args, $mpath);
    array_push($args, $prefix);

//    print($prog.' '.implode(' ', $args)."\n");
    
    pcntl_exec($prog, $args);
    exit(0);
  }

  function start_child1($module, $main_data=null, $prefix='proc', $term_func=null) {
      $mpath=realpath($this->module_dir.$module.'.svc');
      if (!file_exists($mpath)) return false;
      $descriptorspec = array(
         0 => array("pipe", "r"),  // stdin is a pipe that the child will read from
         1 => array("pipe", "w"),  // stdout is a pipe that the child will write to
         2 => array("file", $this->log_dir.$prefix."_err.log", "a") // stderr is a file to write to
      );
      $process = proc_open("php -f ".$mpath, $descriptorspec, $pipes);
      if (is_resource($process)) {
          fwrite($pipes[0], serialize($main_data));
          fclose($pipes[0]);
          $pid=(int)fgets($pipes[1], 1024);
          fclose($pipes[1]);

          $res = array();
          $res['handle']=$process;
          $res['pid']=$pid;
          $res['command']=$st['command'];
          $res['pipes']=$pipes;
          $this->set_child($pid, $res);
          return $pid;
      }
      return false;
  }

  function term_child($pid) {
     $child=&$this->children[$pid];
     $l=count($child['pipes']);
     for ($i=0;$i<$l;$i++) fclose($child['pipes'][$i]);
     proc_terminate($child['handle'], SIGKILL);
     $this->del_child($pid);
  }

  function do_server_data(&$srv, $data, $addr , $port, $bindata) {
     $func=$this->on_server_data;
     if ($func) $func($this, $data, $addr , $port);
     $this->need_exit=$data=='exit';
  }

  function sig_handler($signo) {
       $func=$this->term_func;
       switch ($signo) {                   
           case SIGTERM:
               // handle shutdown tasks
               $this->daemon_del_pid();
               exit;
               break;
           case SIGHUP:
               // handle restart tasks
               break;
           default:
               // handle all other signals
       }
       if ($func) $func($signo);
  }

  function del_pid() {
    if (file_exists($this->pid_file)) {
       unlink($this->pid_file);
    }
  }

  function read_pid() {
    if (!file_exists($this->pid_file)) return 0;
    $fp = fopen ($this->pid_file, "r");
    $s = fgets($fp);
    fclose ($fp);
    return (int)$s;
  }
  
  function write_pid($size) {
    $fp = @fopen ($this->pid_file, "w");
    if (!$fp) return false;
    fputs ($fp, "$size\n");
    fclose ($fp);
    return true;
  }
  
  function check() {
     $pid = $this->read_pid();
     if ($pid>0 && d_pr($pid)) return true;
     return false;
  }

  function get_child($pid) {
     return $this->children[$pid];
  }

  function set_child($pid, $data) {
     $this->children[$pid]=$data;
     return $this->children[$pid];
  }

  function del_child($pid) {
//      $r=posix_kill($pid, SIGTERM);
//      $r=posix_kill($pid, SIGKILL);
//      $this->server->send('exit', $this->children[$pid]['addr'] , $this->children[$pid]['port']);
//     print("kill [$pid] [$r]\n");
//      system('kill -9 '. $pid, $k);
//      if(!$k) $killed = 1;
      unset($this->children[$pid]);
  }

  function del_all_children() {
     $keys=array_keys($this->children);
     foreach ($keys as $k) {
//        $this->term_child($k);
        $this->del_child($k);
     }
  }

  function check_children() {
     $pids=array_keys($this->children);
     $l=count($pids);
     for ($i=0;$i<$l;$i++) {
         $pid=(int)$pids[$i];
         if ($pid<=0 || !d_pr($pid)) $this->del_child($pid);
     }
     return true;
  }

  function process() {
     $this->check_children();
     $this->server->process();
     if (!file_exists($this->pid_file)) $this->need_exit=true;
  }

}

class daemon_child {
  var $main_pid;
  var $pid;
  var $main_dir;
  var $pid_file;
  var $log_file;
  var $main_func;
  var $main_data;
  var $term_func;
  var $client;
  var $server_host;
  var $server_port;
  var $server_password;
  var $need_exit;
  var $commands;
  
  function daemon_child() {
     $this->main_pid = 0;
     $this->pid = 0;
     $this->main_dir='./';
     $this->pid_file=$this->pid_file;
     $this->log_file='';
     $this->log_dir="./";
     $this->main_func=null;
     $this->main_data=null;
     $this->term_func=null;
     $this->client=null;
     $this->server_host='127.0.0.1';
     $this->server_port=3060;
     $this->server_password='';
     $this->need_exit = false;
     $this->commands = array();
  }

  function print_log($str) {
    $fp = @fopen ($this->log_file, "ab");
    if (!$fp) return false;
    if (flock($fp, LOCK_EX)) {
      if ($str!='') $str=date("[m-d-y H:i:s] ").$str;
      fputs ($fp, $str."\n");
      flock($fp, LOCK_UN);
    } else {
      fclose ($fp);
      return false;
    }
    fclose ($fp);
    return true;
  }

  function start() {
     $error = '';
     $this->client = new udp_client();
     if (!$this->client->start($this->server_host, $this->server_port, $this->server_password)) {
        $error="Cannot create socket to talk [".$this->client->err_code."] [".$this->client->err_str."].";
        return false;
     }

     $this->need_exit = false;
     $func = $this->main_func;
     if ($func) $func($this, $this->main_data);
     
     return true;
  }

  function process() {
     $cmd = $this->get_command();
     if ($cmd[0]!==false) {
       array_push($this->commands, $cmd[0]);
       $this->need_exit=($cmd[0]=='exit');
     }
//     if (!file_exists($this->pid_file)) $this->need_exit=true;
  }

  function send_status($str) {
     $this->client->send($str);
  }

  function get_command() {
     return $this->client->recv();
  }

}

function daemon_proc_server_data(&$srv, $data, $addr, $port, $bindata) {
     $daemon = &$srv->_daemon_data;
     $daemon->do_server_data($srv, $data, $addr, $port, $bindata);
}

} // end incl_h
?>
