<?php

if (!defined("INC_DAEMON_H")){
   define("INC_DAEMON_H", TRUE);

define("DAEMON_MAXFD", 255);

if (!defined("IS_WIN")) define("IS_WIN", (stristr(php_uname('s'), 'windows')==FALSE)?false:true);


function d1_pr($pid) {
  if (IS_WIN) {
    exec('tasklist /FI "PID eq '.$pid.'" /NH /FO CSV /V', $tls);
    $tls=(is_array($tls))?implode("\n", $tls):$tls;
    return preg_match('/php\.exe/i', $tls)?true:false;
  }
  return posix_kill($pid, 0);
}

class daemon_parent {
  var $main_pid;
  var $main_dir;
  var $children;
  var $pid_file;
  var $log_file;
  var $log_dir;
  var $log_subdir;
  var $log_add;
  var $term_func;
  var $log_print_func;
  var $need_exit;
  var $_stdin;
  var $_stdout;
  var $_stderr;
  var $_stderr1;
  var $_stderr2;
  var $_stderr3;
  
  function daemon_parent() {
     $this->main_pid = 0;
     $this->main_dir='./';
     $this->children = array();
     $this->log_dir="./pids/";
     $this->log_subdir='';
     $this->log_add='';
     $this->pid_file=$this->log_dir."daemon.pid";
     $this->log_file=$this->log_dir."daemon.log";
     $this->term_func=null;
     $this->log_print_func=null;
     $this->need_exit = false;
  }

  function gen_log_subdir() {
     $tmv=time();
     return sprintf('%08X_', $tmv).date("dmY_His", $tmv);
  }

  function check_log_subdir($tsize=100000000) {
     $root=$this->log_dir.$this->log_subdir;
     $res=0;
     if ($dir = @opendir($root)) {
        while (($file = readdir($dir)) !== false) {
           $fn=$root.$file;
           if (is_file($fn)) {
               $res+=filesize($fn);
               if ($res>$tsize) break;
           }
        }
        closedir($dir);
     }
     $this->log_add=sprintf('%10u', $res);
     return ($res<$tsize);
  }

  function get_log_subdir() {
     $suf=($this->log_subdir=='')?'_':'';
     while ($this->log_subdir=='' || !$this->check_log_subdir()) {
        $this->log_subdir=$this->gen_log_subdir().$suf.'/';
     }
     $lsd=$this->log_dir.$this->log_subdir;
     if (!file_exists($lsd)) mkdir($lsd, 0777, true);
     return $this->log_subdir;
  }

  function log_subdir() {
     return $this->log_dir.$this->get_log_subdir();
  }

  function print_log($str) {
    $this->log_file=$this->log_subdir()."daemon.log";
//    $log_file1=$this->log_dir.$this->get_log_subdir()."daemon.log";
    $fp = @fopen ($this->log_file, "ab");
    if (!$fp) return false;
    if (flock($fp, LOCK_EX)) {
//      if ($str!='') $str=date("[d-m-y H:i:s] ").$str;
      if ($str!='') $str=date("[d-m-y H:i:s] ").'['.$this->log_add.']'.$str;
      fputs ($fp, $str."\n");
      flock($fp, LOCK_UN);
    } else {
      fclose ($fp);
      return false;
    }
    fclose ($fp);
    return true;
  }

  function remap_console_streams($stdout_file, $stderr_file) {
//    $this->print_log(var_export(array('STDIN'=>STDIN, 'STDOUT'=>STDOUT, 'STDERR'=>STDERR), true));
  
    for ($i=DAEMON_MAXFD; $i>0; $i--) @fclose($i);
    @fclose(STDIN);
    @fclose(STDOUT);
    @fclose(STDERR);
    $this->_stdin = fopen('/dev/null', 'r');
//    $this->_stdin = fopen($this->log_dir."daemon_stdin.log", 'ab');
    $this->_stdout = fopen($stdout_file, 'ab');
//    $this->_stderr = fopen($stderr_file, 'ab');
//    $this->_stderr1 = fopen($stderr_file.'1', 'ab');
//    $this->_stderr2 = fopen($stderr_file.'2', 'ab');
//    $this->_stderr3 = fopen($stderr_file.'3', 'ab');
//    $this->print_log(var_export(array('STDIN'=>$STDIN, 'STDOUT'=>$STDOUT, 'STDERR'=>$STDERR), true));//    define(STDIN, $STDIN);
//    define(STDOUT, $STDOUT);
//    define(STDERR, $STDERR);
  }

  function start($main_func, $main_data=null, $term_func=null) {
    chdir($this->main_dir);
    if ($this->check()) return false;
  
    pcntl_signal(SIGCHLD, SIG_IGN);
  
    $pid = pcntl_fork();
    if ($pid<0) {
       $this->print_log("error: first fork error");
       exit(1);
    } else if ($pid>0) {
       exit(0);      /* parent terminates */
    }                  
  
    if (!posix_setsid()) {
       $this->print_log("error: could not detach from terminal");
       exit(1);
    }
  
    $this->term_func=$term_func;
  //  for ($i=1;$i<=SIGTERM;$i++) @pcntl_signal($i, "daemon_sig_handler");
    for ($i=1;$i<=SIGTERM;$i++) @pcntl_signal($i, SIG_IGN);
    $pid = pcntl_fork();
    if ($pid<0) {
       $this->print_log("error: second fork error");
       exit(1);
    } else if ($pid>0) {
       exit(0);      /* 1st child terminates */
    }
    chdir($this->main_dir);

    if (!posix_setsid()) {
       $this->print_log("error: could not detach from terminal");
       exit(1);
    }
  
//    @fclose(STDERR);
//    @fclose(STDOUT);
//    @fclose(STDIN);
//    for ($i=DAEMON_MAXFD; $i>=0; $i--) @fclose($i);

    $this->remap_console_streams($this->log_dir."daemon_stdout.log", $this->log_dir."daemon_stderr.log");
//    $this->print_log(var_export(array('STDIN'=>STDIN, 'STDOUT'=>STDOUT, 'STDERR'=>STDERR), true));
//    $this->print_log(var_export(array('STDIN'=>$STDIN, 'STDOUT'=>$STDOUT, 'STDERR'=>$sSTDERR), true));
//    @fclose((int)STDIN);
//    @fclose((int)STDOUT);
//    @fclose((int)STDERR);
  
    if (!$this->write_pid(getmypid())) return false;
                        
    umask(0);        /* clear our file mode creation mask */
  
    $main_func($this, $main_data);
     
    $this->del_all_children();
    $this->del_pid();
  
    return true;
  }

  function new_child($main_func, $main_data=null, $term_func=null) {
    pcntl_signal(SIGCHLD, SIG_IGN);
    
    $pid = pcntl_fork();
    if ($pid<0) {
       print("child fork error\n");
       exit(1);
    } else if ($pid>0) {
       $this->children[$pid]=array();
       return $pid; /* parent returns to main */
    }
    $pid=getmypid();
    chdir($this->main_dir);
    
    for ($i=1;$i<SIGTERM;$i++) @pcntl_signal($i, SIG_IGN);
    @pcntl_signal(SIGTERM, SIG_DFL);
    @pcntl_signal(SIGKILL, SIG_DFL);
    
    for ($i=0; $i<DAEMON_MAXFD; $i++) @fclose($i);
    @fclose(STDIN);
    @fclose(STDOUT);
    @fclose(STDERR);
    $STDIN = fopen('/dev/null', 'r');
    $STDOUT = fopen($this->log_subdir()."daemon_child_".$pid."_stdout.log", 'wb');
    $STDERR = fopen($this->log_subdir()."daemon_child_".$pid."_stderr.log", 'wb');
//    @fclose((int)STDIN);
//    @fclose((int)STDOUT);
//    @fclose((int)STDERR);
    

    $child = new daemon_child();
    $child->main_pid=$this->main_pid;
    $child->pid=getmypid();
    $child->main_dir='./';
    $child->log_dir=$this->log_dir;
    $child->pid_file=$this->pid_file;
    $child->log_file=$this->log_file; //$child->log_dir."child_".sprintf("%08X",$child->pid).".log";
    $child->log_prefix='child_'.sprintf("%08X",$child->pid).' ';
    $child->main_func=$main_func;
    $child->main_data=$main_data;
    $child->term_func=$term_func;
    $child->parent=$this;
    $child->start();
                                 
    exit(0);
  }

  function term_child($pid) {
     $child=&$this->children[$pid];
     $l=count($child['pipes']);
     for ($i=0;$i<$l;$i++) fclose($child['pipes'][$i]);
     proc_terminate($child['handle'], SIGKILL);
     $this->del_child($pid);
  }

  function do_server_data(&$srv, $data, $addr , $port, $bindata) {
     $func=$this->on_server_data;
     if ($func) $func($this, $data, $addr , $port);
     $this->need_exit=$data=='exit';
  }

  function sig_handler($signo) {
       $func=$this->term_func;
       switch ($signo) {                   
           case SIGTERM:
               // handle shutdown tasks
               $this->daemon_del_pid();
               exit;
               break;
           case SIGHUP:
               // handle restart tasks
               break;
           default:
               // handle all other signals
       }
       if ($func) $func($signo);
  }

  function del_pid() {
    if (file_exists($this->pid_file)) {
       unlink($this->pid_file);
    }
  }

  function read_pid() {
    if (!file_exists($this->pid_file)) return 0;
    $fp = fopen ($this->pid_file, "r");
    $s = fgets($fp);
    fclose ($fp);
    return (int)$s;
  }
  
  function write_pid($size) {
    $fp = @fopen ($this->pid_file, "w");
    if (!$fp) return false;
    fputs ($fp, "$size\n");
    fclose ($fp);
    return true;
  }
  
  function check() {
     $pid = $this->read_pid();
     if ($pid>0 && d1_pr($pid)) return true;
     return false;
  }

  function get_child($pid) {
     return $this->children[$pid];
  }

  function set_child($pid, $data) {
     $this->children[$pid]=$data;
     return $this->children[$pid];
  }

  function del_child($pid) {
//      $r=posix_kill($pid, SIGTERM);
//      $r=posix_kill($pid, SIGKILL);
//      $this->server->send('exit', $this->children[$pid]['addr'] , $this->children[$pid]['port']);
//     print("kill [$pid] [$r]\n");
//      system('kill -9 '. $pid, $k);
//      if(!$k) $killed = 1;
      unset($this->children[$pid]);
  }

  function del_all_children() {
     $keys=array_keys($this->children);
     foreach ($keys as $k) {
//        $this->term_child($k);
        $this->del_child($k);
     }
  }

  function check_children() {
     $pids=array_keys($this->children);
     $l=count($pids);
     for ($i=0;$i<$l;$i++) {
         $pid=(int)$pids[$i];
         if ($pid<=0 || !d1_pr($pid, 0)) $this->del_child($pid);
     }
     return true;
  }

  function process() {
     $this->check_children();
     $this->server->process();
     if (!file_exists($this->pid_file)) $this->need_exit=true;
  }

}

class daemon_child {
  var $main_pid;
  var $pid;
  var $main_dir;
  var $pid_file;
  var $log_file;
  var $log_prefix;
  var $main_func;
  var $main_data;
  var $term_func;
  var $need_exit;
  var $commands;
  var $parent;
  
  function daemon_child() {
     $this->main_pid = 0;
     $this->pid = 0;
     $this->main_dir='./';
     $this->log_dir="./";
     $this->pid_file=$this->pid_file;
     $this->log_file='';
     $this->log_prefix='';
     $this->main_func=null;
     $this->main_data=null;
     $this->term_func=null;
     $this->need_exit = false;
     $this->parent = false;
  }

  function print_log($str) {
    $fp = @fopen ($this->log_file, "ab");
    if (!$fp) return false;
    if (flock($fp, LOCK_EX)) {
      if ($str!='') $str=date("[d-m-y H:i:s] ").$this->log_prefix.$str;
      fputs ($fp, $str."\n");
      flock($fp, LOCK_UN);
    } else {
      fclose ($fp);
      return false;
    }
    fclose ($fp);
    return true;
  }

  function start() {
     $this->need_exit = false;
     $func = $this->main_func;
     if ($func) $func($this, $this->main_data);
     return true;
  }

}

} // end incl_h
?>
