<?php
if (!defined("INC_DB_FILE_H")){
   define("INC_DB_FILE_H", TRUE);

define("DB_FILE_HEADER_MAGIC", 12345);
define("DB_FILE_HEADER_LEN", 16);

define("DB_FILE_FTYPE_INT", 1);
define("DB_FILE_FTYPE_STR", 2);

class db_file {
  var $fname;
  var $fd;
  var $header;
  var $current_record_no;
  var $fcntr;
  
  function error($str) {
//     print("Error: [$str]\n");
     return false;
  }

  function db_file($fname) {
     $this->fname=$fname;
     $this->fcntr=0;
     $this->current_record_no=0;
     $this->header=array();
     $this->header['FIELDS']=array();

     $this->fd=@fopen($this->fname, 'a+b'); $this->destroy();
     @chmod($this->fname, 0777);
     $this->fd=@fopen($this->fname, 'rw+b');
     if ($this->fd) {
         $this->read_header();
     } else {
       $this->error("Cannot open file {".$this->fname."}");
     }
     
  }

  function destroy() {
     @fclose($this->fd);
     $this->fd=false;
  }

  function encode_num($val, $bytes_count=4) {
      $result = '';
      if ($bytes_count>3) $result .= chr(($val >> 24) & 0xFF);
      if ($bytes_count>2) $result .= chr(($val >> 16) & 0xFF);
      if ($bytes_count>1) $result .= chr(($val >> 8) & 0xFF);
      if ($bytes_count>0) $result .= chr($val);
      return $result;
  }

  function decode_num($str, $bytes_count=4, $offset=0) {
      $len = strlen($str)-$offset;
      if ($len<0) return 0;
      if ($len<4 && $bytes_count>$len) $bytes_count=$len;
      $i=$offset;
      $result = 0;
      if ($bytes_count>3) $result |= (ord($str{$i++}) << 24);
      if ($bytes_count>2) $result |= (ord($str{$i++}) << 16);
      if ($bytes_count>1) $result |= (ord($str{$i++}) << 8);
      if ($bytes_count>0) $result |= ord($str{$i++});
      return $result;
  }

  function read_block($len, $offset=-1) {
     if (!$this->fd) return false;
     if ($offset>-1) {
        if (fseek($this->fd, $offset)!==0) return false;
     }
     return @fread($this->fd, $len);
  }

  function write_block($data, $len=0, $offset=-1) {
     if (!$this->fd) return false;
     if ($offset>-1) {
        if (fseek($this->fd, $offset)!==0) return false;
     }
     if ($len<=0) $len=strlen($data);
     $written=@fwrite($this->fd, $data, $len);
     return ($written && $written==$len);
  }

  function read_header() {
     if (!$this->fd) return $this->error("no fd");
     clearstatcache();
     $fstat = fstat($this->fd);
     $fsize=$fstat['size'];
     if ($fsize<DB_FILE_HEADER_LEN) return $this->error("fsize<DB_FILE_HEADER_LEN");
     $hdr_data=$this->read_block(DB_FILE_HEADER_LEN, 0);
     if (!$hdr_data || strlen($hdr_data)!=DB_FILE_HEADER_LEN) return $this->error("cannot read header");

     $this->header['MAGIC']=$this->decode_num($hdr_data, 4, 0);
     if ($this->header['MAGIC']!=DB_FILE_HEADER_MAGIC) return $this->error("Wrong MAGIC");

     $this->header['FIELDS_DSC_LEN']=$this->decode_num($hdr_data, 4, 4);
     if ($fsize<DB_FILE_HEADER_LEN+$this->header['FIELDS_DSC_LEN']) return $this->error("Wrong FDSC_LEN");

     $this->header['FIELD_COUNT']=$this->decode_num($hdr_data, 1, 8);
     $this->_read_header_fields();
  }

  function write_header() {
     if (!$this->fd) return $this->error("no fd");
     $this->_write_header_fields();

     $hdr_data=$this->encode_num(DB_FILE_HEADER_MAGIC, 4).
               $this->encode_num($this->header['FIELDS_DSC_LEN'], 4).
               $this->encode_num($this->header['FIELD_COUNT'], 1).$this->encode_num(0, 3).
               $this->encode_num(0, 4);
     return $this->write_block($hdr_data, 16, 0);
  }
   
  function _read_header_fields() {

     if ($this->header['FIELDS_DSC_LEN']%32!=0) return $this->error("Wrong FDSC_LEN (%32)");
     $field_count=(int)floor($this->header['FIELDS_DSC_LEN']/32);
     if ($field_count==0) return $this->error("Wrong fieldcount (0, ".$this->header['FIELDS_DSC_LEN'].")");
     if ($field_count!=$this->header['FIELD_COUNT']) return $this->error("Wrong fieldcount ($field_count)");

     $hdrf_data=$this->read_block($this->header['FIELDS_DSC_LEN'], DB_FILE_HEADER_LEN);
     if (!$hdrf_data || strlen($hdrf_data)!=$this->header['FIELDS_DSC_LEN']) return $this->error("Cannot read fdsc");

     $fcntr=0;
     $rl=0;

     for ($i=0;$i<$field_count;$i++) {
       $offset=$i*32;
       $field=array();

       $field['SIZE']=$this->decode_num($hdrf_data, 1, $offset+0);
       $field['TYPE']=$this->decode_num($hdrf_data, 1, $offset+1);
       $fnl=$this->decode_num($hdrf_data, 1, $offset+2);
       if ($fnl<1) {
           $field['NAME']='FIELD_'.(++$fcntr);
       } else {
          if ($fnl>28) $fnl=28;  
          $field['NAME']=substr($hdrf_data, $offset+4, $fnl);
       }
       $field['NAME'] = strtoupper(trim($field['NAME']));
       $fnl = strlen($field['NAME']);
       if ($fnl<1) $field['NAME']='FIELD_'.(++$fcntr);

       $rl+=$field['SIZE'];
       array_push($this->header['FIELDS'], $field);
     }

     return true;
  }

  function _write_header_fields() {

     $hdrf_arr=array();
     $field_count = count($this->header['FIELDS']);

     for ($i=0;$i<$field_count;$i++) {
          $field=$this->header['FIELDS'][$i];
            
          $field['NAME'] = strtoupper(trim($field['NAME']));
          $fnl = strlen($field['NAME']);
          if ($fnl<1) $field['NAME']='FIELD_'.(++$fcntr);
          if ($fnl>28) $fnl=28;
                             
          $fnl = strlen(trim($field['NAME']));
          $fdata=$this->encode_num($field['SIZE'], 1).
                 $this->encode_num($field['TYPE'], 1).
                 $this->encode_num($fnl, 1).
                 $this->encode_num(0, 1).
                 substr($field['NAME'], 0, $fnl);
          $fdl = strlen($fdata);
          if ($fdl<32) $fdata=str_pad($fdata, 32 , chr(0));
          array_push($hdrf_arr, $fdata);
     }

     $hdrf_data=implode('',$hdrf_arr);
     if (strlen($hdrf_data)!=$field_count*32) return $this->error("Wrong fieldcount (%32)");
     $this->header['FIELD_COUNT']=$field_count;
     $this->header['FIELDS_DSC_LEN']=$field_count*32;
     return $this->write_block($hdrf_data, $field_count*32, DB_FILE_HEADER_LEN);
  }


  function field_def_hash() {
     $fields=$this->header['FIELDS'];
     $fcount = count($fields);
     $result = array();
     for ($i=0;$i<$fcount;$i++) $result[$fields[$i]['NAME']] = array($i, $fields[$i]);
     return $result;
  }

  function field_def($name, $type, $size) {
      $field=array();
      $field['NAME'] = strtoupper(trim($name));
      $fnl = strlen($field['NAME']);
      if ($fnl<1) $field['NAME']='FIELD_'.(++$this->fcntr);
      if ($fnl>28) { $field['NAME']=substr($field['NAME'], 0, 28); }

//      if ($type!=DB_FILE_FTYPE_INT && $type!=DB_FILE_FTYPE_STR) return false;

      $field['SIZE']=$size;
      if ($field['SIZE']>0xFF) $field['SIZE']=0xFF;
            
      $field['TYPE']=$type;

      $fhash=$this->field_def_hash();

      if (array_key_exists($field['NAME'], $fhash)) {
         $ind=$fhash[$field['NAME']][0];
         $this->header['FIELDS'][$ind]=$field;                                          
      } else {
         array_push($this->header['FIELDS'], $field);
      }
      return true;
  }

  function enc_record($rec) {
     $res_arr=array();
     $field_count = count($this->header['FIELDS']);

     for ($i=0;$i<$field_count;$i++) {
          $field=$this->header['FIELDS'][$i];
          $fd='';

          if ($field['TYPE']==DB_FILE_FTYPE_INT) {
              if ($rec[$field['NAME']]) {
                  $fd=$this->encode_num((int)$rec[$field['NAME']], $field['SIZE']);
              }
          } else if ($field['TYPE']==DB_FILE_FTYPE_STR) {
              $fd=$rec[$field['NAME']];
          }

          $fnl = $field['SIZE'];
          if (strlen($fd)>$fnl) $fd=substr($fd, 0, $fnl);
          if (strlen($fd)<$fnl) $fd=str_pad($fd, $fnl, chr(0));
          array_push($res_arr, $fd);
     }
     $rd = implode('',$res_arr);

     $rl = $this->record_len();
     if (strlen($rd)>$rl) $rd=substr($rd, 0, $rl);
     if (strlen($rd)<$rl) $rd=str_pad($rd, $rl, chr(0));
     return $rd;
  }

  function put_record($rno, $rec) {
     $rd=$this->enc_record($rec);
     $offset = DB_FILE_HEADER_LEN+$this->header['FIELDS_DSC_LEN'];
     $offset += $this->record_len()*$rno;
     $res = $this->write_block($rd, $this->record_len(), $offset);
     if ($res) $this->current_record_no=$rno+1;
     return $res;
  }
   
  function append_record($rec) {
     $rcnt = $this->record_count();
     $this->put_record($rcnt, $rec);
  }

  function record_count() {
     if (!$this->fd) return $this->error("no fd");
     clearstatcache();
     $fstat = fstat($this->fd);
     $fsize=$fstat['size']-(DB_FILE_HEADER_LEN+$this->header['FIELDS_DSC_LEN']);
     if ($fsize<$this->record_len()) return 0;
     $rcount = (int)floor($fsize/$this->record_len());
     return $rcount;
  }

  function fetch_record($rno=false) {

     $offset = DB_FILE_HEADER_LEN+$this->header['FIELDS_DSC_LEN'];
     $rno = ($rno!==false)?$rno:$this->current_record_no;
     $offset += $this->record_len()*$rno;

     $rd=$this->read_block($this->record_len(), $offset);
     if (!$rd || strlen($rd)!=$this->record_len()) return false;

     $this->current_record_no=$rno+1;

     $res_arr=array();
     $field_count = count($this->header['FIELDS']);

     $offset=0;
     for ($i=0;$i<$field_count;$i++) {
          $field=$this->header['FIELDS'][$i];
          $res_arr['__NO__']=$rno;

          if ($field['TYPE']==DB_FILE_FTYPE_INT) {
              $res_arr[$field['NAME']]=$this->decode_num($rd, $field['SIZE'], $offset);
          } else if ($field['TYPE']==DB_FILE_FTYPE_STR) {
              $res_arr[$field['NAME']]=trim(substr($rd, $offset, $field['SIZE']));
          }
          $offset+=$field['SIZE'];
     }
     return $res_arr;
  }

  function record_len() {
     $field_count = count($this->header['FIELDS']);

     $res = 0;
     $offset=0;
     for ($i=0;$i<$field_count;$i++) {
          $field=$this->header['FIELDS'][$i];
          $res+=$field['SIZE'];
     }
     return $res;
  }

  function zap() {
     if (!$this->fd) return $this->error("no fd");
     return @ftruncate($this->fd, DB_FILE_HEADER_LEN+$this->header['FIELDS_DSC_LEN']);
  }
}           



} // end incl_h     
?>
