<?php
if (!defined("INC_DB_OBJ_H")){
   define("INC_DB_OBJ_H", TRUE);


function db_object_new($type, $connect_args=false) {
  $type=strtolower($type);
  if (!$connect_args || !is_array($connect_args)) return false;
  $connect_args=array_change_key_case($connect_args, CASE_LOWER);

  if (!@$connect_args['server'] ||
      !@$connect_args['database'] ||
      !@$connect_args['login'] ||
      !@$connect_args['password']) return false;

  if (!is_array(@$connect_args['cinfo'])) $connect_args['cinfo']=false;
//  print("cargs:".var_export($connect_args, true)."\n");

  if ($type=='interbase') {
    require_once('ib_obj.inc');
    return new ib_obj($connect_args['server'], $connect_args['database'], $connect_args['login'], $connect_args['password']);
  } else if ($type=='mssql_sqlsrv') {
    require_once('mssql_sqlsrv_obj.inc');
    return new mssql_sqlsrv_obj($connect_args['server'], $connect_args['database'], $connect_args['login'], $connect_args['password'], $connect_args['cinfo']);
  } else if ($type=='mssql_pdo') {
    require_once('mssql_pdo_obj.inc');
    return new mssql_pdo_obj($connect_args['server'], $connect_args['database'], $connect_args['login'], $connect_args['password']);
  }
  return false;
}

} // end incl_h
?>
