<?php
if (!defined("INC_DMN_MAIN_H")){
   define("INC_DMN_MAIN_H", TRUE);

ini_set("max_execution_time", "0");
ini_set("memory_limit", "-1");
ob_implicit_flush();
if (!defined("IS_WIN")) define("IS_WIN", (stristr(php_uname('s'), 'windows')==FALSE)?false:true);

include("prog_init.inc");
include("log.inc");

include("func.inc");
include("tcp_socket_pool.inc");
include('proto_pack.inc');
include("crypt.inc");
include("daemon1.inc");

$dmn_main_conn=array(
  'pool'=>false,
  'daemon'=>false,
  'srvaddr'=>'0.0.0.0',
  'srvport'=>3060,
  'need_exit'=>false,
  'need_halt'=>false,
  'pid_and_log_dir'=>'./pids/',
  'err_codes'=>array(
     200=>'Ok',
     500=>'Unknown command',
     501=>'Negative answer(cancel)',
     503=>'Unauthorized',
     504=>'Unauthorized request',
     505=>'General error',
  ),
  'system_pwd'=>'WCFCPWDWORD',
  'cmd_prefix'=>'cmd_',
  'lr_pool'=>array(),
  'cmd_array'=>array(),
  'ping_array'=>array(),
  'raw_log_fn'=>'raw_log.txt',
  'need_raw_dump'=>false,
  'raw_only_child'=>false,
  'raw_only_effective_child'=>false,
  'raw_separate_logs'=>false,
  'low_raw_enabled'=>false,
  'log_microdate'=>false,
  'on_idle'=>false,
  'on_startup'=>false,
  'on_stopup'=>false,
  'on_connect'=>false,
  'on_disconnect'=>false,
  'on_send'=>false,
  'on_recv'=>false,
  'on_data'=>false,
  'on_raw_print'=>false,
  'on_link_task_start'=>false,
  'on_link_task_stop'=>false,
);
if (IS_WIN) $dmn_main_conn['srvaddr']='localhost';


function dmn_main_gen_result() { // $code, $data=?
   global $dmn_main_conn;
   $args=func_get_args();
   $c=count($args);
   $code=505;
   $ret='Unknown error';
   if ($c>0) $code=(int)array_shift($args);
   if ($c>1) {
       $ret=array_shift($args);
   } else if (array_key_exists($code, $dmn_main_conn['err_codes'])) {
       $ret=$dmn_main_conn['err_codes'][$code];
   }
   return proto_pack_encode_val($code).proto_pack_encode_val($ret);
}



function dmn_main_start() {
  global $dmn_main_conn;

  $dmn_main_conn['cmd_array']=array_merge((array)$dmn_main_conn['cmd_array'], (array)dmn_main_parse_cmd_arr($dmn_main_conn['cmd_prefix']));
  $dmn_main_conn['daemon'] = new daemon_parent();
  $dmn_main_conn['daemon']->log_dir=$dmn_main_conn['pid_and_log_dir'];
  $dmn_main_conn['daemon']->pid_file=$dmn_main_conn['daemon']->log_dir."daemon.pid";
  $dmn_main_conn['daemon']->log_file=$dmn_main_conn['daemon']->log_dir."daemon.log";

  if (IS_WIN) {
    dmn_main_main($dmn_main_conn['daemon'], getcwd());
  } else {
    if (!$dmn_main_conn['daemon']->start('dmn_main_main', getcwd(), 'dmn_main_on_terminate')) {
       print("Failed to start or already running, exiting...\n");
    }
  }
}


function dmn_main_on_terminate($signo) {
   global $dmn_main_conn;
   $dmn_main_conn['daemon']->print_log("terminated: [$signo]");
}

function dmn_main_try_exec_handler($fname, &$var_0=NULL, &$var_1=NULL, &$var_2=NULL, &$var_3=NULL, &$var_4=NULL, &$var_5=NULL, &$var_6=NULL, &$var_7=NULL, &$var_8=NULL, &$var_9=NULL, &$var_10=NULL, &$var_11=NULL, &$var_12=NULL, &$var_13=NULL, &$var_14=NULL, &$var_15=NULL, &$var_16=NULL, &$var_17=NULL, &$var_18=NULL, &$var_19=NULL, &$var_20=NULL) {
  global $dmn_main_conn;
  $cnt=func_num_args()-1; if ($cnt<0) return false;
  $args=array(); for ($i=0;$i<$cnt;$i++) $args[$i]=&${'var_'.$i};
  if (!array_key_exists($fname, $dmn_main_conn)) return false;
  $callable_name=false; if (!is_callable($dmn_main_conn[$fname], false, $callable_name)) return false;
  $r=call_user_func_array($callable_name, $args);
  if (is_null($r)) return null;
  return array($r);
}

function dmn_main_main(&$daemon, $cwd) {
  global $dmn_main_conn;


  chdir($cwd);
  chdir($daemon->main_dir);

  // we are the daemon now
    $daemon->print_log('daemon started');
    $pool = new tcp_socket_pool();
    $dmn_main_conn['pool']=$pool;
    if (defined("INC_DBN_H")) dbn_set_pool($pool);
    if (defined("INC_SMS_H")) sms_set_pool($pool);
    if (defined("INC_ALPHABANK_H")) alphabank_set_pool($pool);
    if (defined("INC_PROXY_H")) proxy_set_pool($pool);
    if (defined("INC_SESSION_H")) session_set_pool($pool);
    $pool->on_data='dmn_main_on_command';
    $pool->on_connect='dmn_main_on_connect';
    $pool->on_disconnect='dmn_main_on_disconnect';
    $pool->on_debug='dmn_main_on_debug';
    $pool->on_send='dmn_main_on_send';
    $pool->on_recv='dmn_main_on_recv';
    $pool->on_low_send='dmn_main_on_low_send';
    $pool->on_low_recv='dmn_main_on_low_recv';
    $pool->on_link_task_start='dmn_main_on_link_task_start';
    $pool->on_link_task_stop='dmn_main_on_link_task_stop';

    $err_code=0;
    $err_str='';
    if (!$pool->start_server($dmn_main_conn['srvaddr'], $dmn_main_conn['srvport'], $err_code, $err_str)) {
       $daemon->print_log('server starting error: '.$err_code.':'.$err_str."\n");
       exit(0);
    }

    if (IS_WIN) $daemon->write_pid(1);

    dmn_main_try_exec_handler('on_startup');
    while (!$dmn_main_conn['need_exit']) {
       $pool->process();
//       usleep(100000);
       clearstatcache();
       if (!file_exists($daemon->pid_file)) $dmn_main_conn['need_exit']=true;
       dmn_main_on_idle();
    }
    dmn_main_try_exec_handler('on_stopup');

    if (!$dmn_main_conn['need_halt']) while ($pool->process(true)) usleep(1);
    $pool->do_close_all();

    $daemon->print_log('daemon terminated');

  return 0;
}

function dmn_main_try_raw_client_dump($prefix, &$pool, $key, $ra, $ret=false) {
   global $dmn_main_conn;

   if (defined("INC_DBN_H")) if (is_dbn_connection($key)) return false;
   if (defined("INC_SMS_H")) if (is_sms_connection($key)) return false;
   if (defined("INC_ALPHABANK_H")) if (is_alphabank_connection($key)) return false;
   if (defined("INC_PROXY_H")) if (is_proxy_connection($key)) return false;
   if (defined("INC_SESSION_H")) if (is_session_connection($key)) return false;
   
   
   $allow=(!$dmn_main_conn['raw_only_child'] || $pool->is_socket_type($key, TCP_SP_TYPE_CHILD));
   if ($dmn_main_conn['need_raw_dump'] && $allow) dmn_main_raw_client_dump_print_log($prefix, $key, $pool, $ra, $ret);
}

function dmn_main_try_raw_dump($prefix, &$pool, $key, $ra, $ret=false) {
   global $dmn_main_conn;
   $res=dmn_main_try_exec_handler('on_raw_print', $pool, $key, $ra, $ret);
//   if (is_array($res)) {
//      if (!$res[0]) return;
//   }
   
   $allow=(!$dmn_main_conn['raw_only_child'] || $pool->is_socket_type($key, TCP_SP_TYPE_CHILD));
   if ($dmn_main_conn['raw_only_child'] && $dmn_main_conn['raw_only_effective_child']) {
      if (defined("INC_DBN_H")) if (is_dbn_connection($key)) return false;
      if (defined("INC_SMS_H")) if (is_sms_connection($key)) return false;
      if (defined("INC_ALPHABANK_H")) if (is_alphabank_connection($key)) return false;
      if (defined("INC_PROXY_H")) if (is_proxy_connection($key)) return false;
      if (defined("INC_SESSION_H")) if (is_session_connection($key)) return false;
      if (is_array($ret) && $ret[0]=='session_listen') return false;
   }
   if ($dmn_main_conn['need_raw_dump'] && $allow) dmn_main_raw_dump_print_log($prefix, $key, $pool, $ra, $ret);
}

function dmn_main_try_low_raw_dump($prefix, &$pool, $key, $ra) {
   global $dmn_main_conn;
   if (!$dmn_main_conn['low_raw_enabled']) return;
   $allow=(!$dmn_main_conn['raw_only_child'] || $pool->is_socket_type($key, TCP_SP_TYPE_CHILD));
   if ($dmn_main_conn['raw_only_child'] && $dmn_main_conn['raw_only_effective_child']) {
      if (defined("INC_DBN_H")) if (is_dbn_connection($key)) return false;
      if (defined("INC_SMS_H")) if (is_sms_connection($key)) return false;
      if (defined("INC_PROXY_H")) if (is_proxy_connection($key)) return false;
      if (defined("INC_SESSION_H")) if (is_session_connection($key)) return false;
   }
   if ($dmn_main_conn['need_raw_dump'] && $allow) dmn_main_low_raw_dump_print_log($prefix, $key, $pool, $ra);
}

function dmn_main_on_recv(&$pool, $key, $buffer, &$readed=0, &$wait_len=0, &$seq_no=0) {
   global $dmn_main_conn;
   $ret=dmn_main_try_exec_handler('on_recv', $pool, $key, $buffer, $readed, $wait_len, $seq_no);
   if (!is_array($ret)) {
      $ret=proto_packet_dec($buffer);
      if ($ret!==false) {
         $readed=$ret['plen'];
         $wait_len=(int)$ret['next_len'];
         $seq_no=$ret['seq_no'];
         $ret=$ret['data'];
      }
   } else $ret=$ret[0];
   if ($readed==0) return $ret;
//   if ($wait_len!=0) return $ret;
//   $ra=array();
//   if (array_key_exists($seq_no, $pool->list[$key]['recv_raw_stack'])) $ra=$pool->list[$key]['recv_raw_stack'][$seq_no];
   $ra=(array)substr($buffer, 0, $readed);
//   $rds=$dmn_main_conn['lr_pool'][$key];
//   if ($readed>0) {
//     $rdl=strlen($buffer)-$readed;
//     $dmn_main_conn['lr_pool'][$key]=0;
//   } else {
//     $rdl=strlen($buffer)-$dmn_main_conn['lr_pool'][$key];
//   }
//   $ra=(array)substr($buffer, $rds, $rdl);
   dmn_main_try_raw_dump('received from', $pool, $key, $ra, $ret);
   return $ret;
}

function dmn_main_on_send(&$pool, $key, $data, $seq_no) {
   global $dmn_main_conn;
   $ret=dmn_main_try_exec_handler('on_send', $pool, $key, $data, $seq_no);
   if (!is_array($ret)) {
       $ret=proto_packet_enc($data, $seq_no);
   } else $ret=$ret[0];
   if ($ret===false) $ret=array();
   $ra=(array)$ret;
   dmn_main_try_raw_dump('sended to', $pool, $key, $ra, $data);
   return $ret;
}

function dmn_main_on_low_recv(&$pool, $key, $data) {
   global $dmn_main_conn;
   $ret=dmn_main_try_exec_handler('on_low_recv', $pool, $key, $data);
   if (!is_array($ret)) {
     $ret=true;
   } else $ret=$ret[0];
   $ra=(array)$data;
   dmn_main_try_low_raw_dump('received from', $pool, $key, $ra);
   return $ret;
}

function dmn_main_on_low_send(&$pool, $key, $data) {
   global $dmn_main_conn;
   $ret=dmn_main_try_exec_handler('on_low_send', $pool, $key, $data);
   if (!is_array($ret)) {
     $ret=true;
   } else $ret=$ret[0];
   $ra=(array)$data;
   dmn_main_try_low_raw_dump('sended to', $pool, $key, $ra);
   return $ret;
}

function dmn_main_on_debug(&$pool, $str) {
   global $dmn_main_conn;
   $dmn_main_conn['daemon']->print_log("debug [".$str."]");
}

function dmn_main_pk_full_dec($raw) {
   $pk=proto_packet_dec($raw);
   if (!$pk) return false;
   unset($pk['data']);
   return $pk;
}

function dmn_main_raw_multi_dump(&$pool, &$raw_data_arr) {
   $result=array();
   foreach ($raw_data_arr as $raw) {
      array_push($result, $pool->dump_packet($raw)); // ."\n".var_export(dmn_main_pk_full_dec($raw), true));
   }
   return implode("\n\n", $result);
}

function dmn_main_raw_client_dump_print_log($prefix, $key, &$pool, &$raw_data_arr, &$data=false) {
   global $dmn_main_conn;
   $addr=$pool->list[$key]['addr'];
   $port=$pool->list[$key]['port'];

   $s=$prefix.' '.$addr.':'.$port.' ['.$key."]:\n".dmn_main_raw_multi_dump($pool, $raw_data_arr)."\n\n";
   if ($data!==false) $s.="Data:\n".var_export($data, true)."\n\n";
//   if ($data!==false) $s.="Data:\n".var_export(proto_pack_decode_arr_ex($data), true)."\n\n";
   if ($dmn_main_conn['raw_separate_logs']) {
     log_print($dmn_main_conn['daemon']->log_subdir().'raw_client_'.$key.'.txt', $s, $dmn_main_conn['log_microdate']);
   } else {
     log_print($dmn_main_conn['daemon']->log_subdir().'raw_client_log.txt', $s, $dmn_main_conn['log_microdate']);
   }
}

function dmn_main_raw_dump_print_log($prefix, $key, &$pool, &$raw_data_arr, &$data=false) {
   global $dmn_main_conn;
   $addr=$pool->list[$key]['addr'];
   $port=$pool->list[$key]['port'];

   $s=$prefix.' '.$addr.':'.$port.' ['.$key."]:\n".dmn_main_raw_multi_dump($pool, $raw_data_arr)."\n\n";
   if ($data!==false) $s.="Data:\n".var_export($data, true)."\n\n";
//   if ($data!==false) $s.="Data:\n".var_export(proto_pack_decode_arr_ex($data), true)."\n\n";
   if ($dmn_main_conn['raw_separate_logs']) {
     log_print($dmn_main_conn['daemon']->log_subdir().'raw_'.$key.'.txt', $s, $dmn_main_conn['log_microdate']);
   } else {
     log_print($dmn_main_conn['daemon']->log_subdir().'raw_log.txt', $s, $dmn_main_conn['log_microdate']);
   }
}

function dmn_main_low_raw_dump_print_log($prefix, $key, &$pool, &$raw_data_arr) {
   global $dmn_main_conn;
   $addr=$pool->list[$key]['addr'];
   $port=$pool->list[$key]['port'];

   $s=$prefix.' '.$addr.':'.$port.' ['.$key."]:\n".dmn_main_raw_multi_dump($pool, $raw_data_arr)."\n\n";
   if ($dmn_main_conn['raw_separate_logs']) {
     log_print($dmn_main_conn['daemon']->log_subdir().'low_raw_'.$key.'.txt', $s, $dmn_main_conn['log_microdate']);
   } else {
     log_print($dmn_main_conn['daemon']->log_subdir().'low_raw_log.txt', $s, $dmn_main_conn['log_microdate']);
   }
}

function dmn_main_on_connect(&$pool, $cli_key) {
   global $dmn_main_conn;
   $addr=$pool->list[$cli_key]['addr'];
   $port=$pool->list[$cli_key]['port'];
   $dmn_main_conn['lr_pool'][$cli_key]=0;
   if (is_array(dmn_main_try_exec_handler('on_connect', $pool, $cli_key, $addr, $port))) return;
   $dmn_main_conn['daemon']->print_log("client ".$addr.':'.$port.':'.$cli_key." connected");
}

function dmn_main_on_disconnect(&$pool, $cli_key, $err_code=0) {
   global $dmn_main_conn;      
   if ($pool->is_socket_type($cli_key, TCP_SP_TYPE_SERVER)) return;

   $addr=$pool->list[$cli_key]['addr'];
   $port=$pool->list[$cli_key]['port'];
   $err=($err_code==0)?'':', error '.$err_code.':'.socket_strerror($err_code);
   if (is_array(dmn_main_try_exec_handler('on_disconnect', $pool, $cli_key, $addr, $port, $err_code))) return;
   $dmn_main_conn['daemon']->print_log("client ".$addr.':'.$port.':'.$cli_key." disconnected".$err);
}

function dmn_main_on_command(&$pool, $cli_key) {
   global $dmn_main_conn;
   $data=$pool->get_data($cli_key);
   if (defined("INC_DBN_H")) if (is_dbn_connection($cli_key)) return false;
   if (defined("INC_SMS_H")) if (is_sms_connection($cli_key)) return false;
   if (defined("INC_ALPHABANK_H")) if (is_alphabank_connection($cli_key)) return false;
   if (defined("INC_PROXY_H")) if (is_proxy_connection($cli_key)) return false;
   if (defined("INC_SESSION_H")) if (is_session_connection($cli_key)) return false;
   $addr=$pool->list[$cli_key]['addr'];
   $port=$pool->list[$cli_key]['port'];
   if ($data===false) return false;
   $raw_data=$data[2];
   $seq_no=$data[1];
   $data=$data[0];

   $ret=dmn_main_try_exec_handler('on_data', $pool, $cli_key, $data, $seq_no);
   if (is_array($ret)) return;


   $cmd_data=dmn_main_parse_command($data);
   if ($cmd_data===false) return false;
   if (is_int($cmd_data[0])) return;

   $cmd=strtolower(trim($cmd_data[0]));
   $params=$cmd_data[1];
//    $pool->do_debug(var_export($cmd_data, true));
    $result=dmn_main_process_command($cmd, $params, $cli_key, $seq_no, $data);
    if ($result!==false) $res=$pool->send($cli_key, $result, $seq_no);
    $dmn_main_conn['daemon']->print_log("[$cmd ".@implode('|',$params)."] ".':'.$cli_key);
}

function dmn_main_parse_command($data) {
   $result=proto_pack_decode_arr_ex($data);
   if (!$result) return false;
   $cmd=array_shift($result);
//   $cmd=strtolower(trim(array_shift($result)));
   return array($cmd, $result);
}

function dmn_main_process_command($cmd, $params, $cli_key, $seq_no=0, $data='') {
   global $dmn_main_conn;
//   $result=dmn_main_gen_result(500, implode('|',$params));
   $result=dmn_main_gen_result(500);
//   $result=false;
   if (array_key_exists($cmd, $dmn_main_conn['cmd_array'])) {
      if ($cmd=='test') {
        $result=$dmn_main_conn['cmd_array'][$cmd]($params, $cli_key, $seq_no, $data);
      } else {
        $result=$dmn_main_conn['cmd_array'][$cmd]($params, $cli_key, $seq_no);
      }
   } else {
      $ret=dmn_main_try_exec_handler('on_unknown_command', $cmd, $params, $cli_key, $seq_no);
//      if (is_array($ret) && $ret[0]!==false) $result=$ret[0];
      if (is_array($ret)) $result=$ret[0];
   }
   return $result;
}

function dmn_main_on_idle() {
   global $dmn_main_conn;
   if (defined("INC_SESSION_H")) session_check_idle();
   if (defined("INC_DB_DAEMON_H")) db_check_idle();
   if (defined("INC_DBN_H")) dbn_check_idle();
   if (defined("INC_SMS_H")) sms_check_idle();
   if (defined("INC_ALPHABANK_H")) alphabank_check_idle();
   if (defined("INC_PROXY_H")) proxy_check_idle();
   dmn_main_try_exec_handler('on_idle');
   return true;
}

function dmn_main_on_link_task_start(&$pool, &$task, &$data) {
   $key=$task['key'];
//   if (defined("INC_DBN_H")) if (is_dbn_connection($key)) return on_dbn_busy($pool, $task);
//   if (defined("INC_SMS_H")) if (is_sms_connection($key)) return on_sms_busy($pool, $task);
   if (defined("INC_DBN_H")) if (is_dbn_connection($key)) return dbn_task_start($pool, $task, $data);
   if (defined("INC_SMS_H")) if (is_sms_connection($key)) return sms_task_start($pool, $task, $data);
   if (defined("INC_ALPHABANK_H")) if (is_alphabank_connection($key)) return alphabank_task_start($pool, $task, $data);
   if (defined("INC_PROXY_H")) if (is_proxy_connection($key)) return proxy_task_start($pool, $task, $data);
   return dmn_main_try_exec_handler('on_link_task_start', $pool, $task, $data);
}                              

function dmn_main_on_link_task_stop(&$pool, &$task, &$data) {
   $key=$task['key'];
//   if (defined("INC_DBN_H")) if (is_dbn_connection($key)) return on_dbn_free($pool, $task);
//   if (defined("INC_SMS_H")) if (is_sms_connection($key)) return on_sms_free($pool, $task);
   if (defined("INC_DBN_H")) if (is_dbn_connection($key)) return dbn_task_stop($pool, $task, $data);
   if (defined("INC_SMS_H")) if (is_sms_connection($key)) return sms_task_stop($pool, $task, $data);
   if (defined("INC_ALPHABANK_H")) if (is_alphabank_connection($key)) return alphabank_task_stop($pool, $task, $data);
   if (defined("INC_PROXY_H")) if (is_proxy_connection($key)) return proxy_task_stop($pool, $task, $data);
   return dmn_main_try_exec_handler('on_link_task_stop', $pool, $task, $data);
}

function dmn_main_parse_cmd_arr($prefix='cmd_') {
   $flist=get_defined_functions();
   $flist=$flist['user'];
   $pl=strlen($prefix);
   $ret=array();
   foreach ($flist as $fname) if (stripos($fname,$prefix)===0) $ret[substr($fname, $pl)]=$fname;
   return $ret;
}

function cmd_test($params, $cli_key, $seq_no=0, $data='') {
   global $dmn_main_conn;
   $test_array=array(
     'Hello world!',
     0xFEFEFE,
     -0xFEFEFE,
     253.999999996,
     -253.999999996,               
     $dmn_main_conn['cmd_array'],
     $dmn_main_conn['err_codes'],
   );
   if ($params && is_array($params) && count($params)>0) return dmn_main_gen_result(200, array('PARAMETERS'=>$params, 'DATA_DUMP'=>$dmn_main_conn['pool']->dump_packet($data)));
   return dmn_main_gen_result(200, $test_array);
}

function cmd_ping($params, $cli_key, $seq_no=0) {
   global $dmn_main_conn;
   $retval=time();
   if ($params && is_array($params) && count($params)>0) return dmn_main_gen_result(200, $params);
   return dmn_main_gen_result(200, $retval);
}

function cmd_terminate($params, $cli_key, $seq_no=0) {
   global $dmn_main_conn;
   if (count($params)<1 || $params[0]!=$dmn_main_conn['system_pwd']) return dmn_main_gen_result(503);
   $dmn_main_conn['need_exit']=true;
   return dmn_main_gen_result(200);
}

function cmd_halt($params, $cli_key, $seq_no=0) {
   global $dmn_main_conn;
   if (count($params)<1 || $params[0]!=$dmn_main_conn['system_pwd']) return dmn_main_gen_result(503);
   $dmn_main_conn['need_exit']=true;
   $dmn_main_conn['need_halt']=true;
   return dmn_main_gen_result(200);
}

} // end incl_h
?>
