<?php
if (!defined("INC_EPROTO_H")) {
     define("INC_EPROTO_H", TRUE);

include("numcoder.inc");
include("crc8.inc");
     
$GLOBALS['EPROTO_DUMP_HELPER']=true;

define('EPROTO_SALTLEN', 0x03);
define('EPROTO_SALTXLEN', EPROTO_SALTLEN*2);
define('EPROTO_CRYPTCRC_LEN', 2);
define('EPROTO_CRYPTHEAD_LEN', EPROTO_SALTXLEN+EPROTO_CRYPTCRC_LEN);

define('EPROTO_HEAD_LEN', 0x08);

define('EPROTO_MARKER', 0x2A); // [*]
define('EPROTO_BODY_MAX_LEN', 0x7F);
define('EPROTO_PAYLOAD_MAX_LEN', EPROTO_BODY_MAX_LEN+EPROTO_CRYPTHEAD_LEN);
define('EPROTO_PACKET_MAX_LEN', EPROTO_HEAD_LEN+EPROTO_PAYLOAD_MAX_LEN);

define('EPROTO_CFG_TAG_MAC', 0x01);

define('EPROTO_CFG_TAG_IP', 0x02);
define('EPROTO_CFG_TAG_MASK', 0x03);
define('EPROTO_CFG_TAG_GATEWAY', 0x04);
define('EPROTO_CFG_TAG_UDP_PORT', 0x05);
define('EPROTO_CFG_TAG_TCP_PORT', 0x06);
define('EPROTO_CFG_TAG_DEBUG_PORT', 0x07);
define('EPROTO_CFG_TAG_PING_CONTROL', 0x09);

define('EPROTO_CFG_TAG_NET', 0x08);


define('EPROTO_CFG_TAG_BEHAVIOR', 0x10);
define('EPROTO_CFG_TAG_LANG', 0x11);
define('EPROTO_CFG_TAG_PROGRESS_MODE', 0x12);
define('EPROTO_CFG_TAG_WAIT_TMO', 0x13);
define('EPROTO_CFG_TAG_BLOCK_CAB', 0x14);
define('EPROTO_CFG_TAG_BLOCK_CELL', 0x15);
define('EPROTO_CFG_TAG_NO_FINGER', 0x16);
define('EPROTO_CFG_TAG_NO_FINGER_HW_TEST', 0x17);
define('EPROTO_CFG_TAG_BUZZER_DUTY', 0x18);
define('EPROTO_CFG_TAG_LED_BRIGHTNESS', 0x19);

define('EPROTO_CFG_TAG_SECTOR_KEYS', 0x20);
define('EPROTO_CFG_TAG_LOCKERS_LIST', 0x21);

define('EPROTO_INTERACTIVE_TAG_DELAY', 0x00);
define('EPROTO_INTERACTIVE_TAG_SOUND', 0x01);
define('EPROTO_INTERACTIVE_TAG_LIGHT', 0x02);
define('EPROTO_INTERACTIVE_TAG_TEXT', 0x03);
define('EPROTO_INTERACTIVE_TAG_WAITING', 0x04);

define('EPROTO_INTERACTIVE_SOUND_BEEP', 0x00);
define('EPROTO_INTERACTIVE_SOUND_QUACK', 0x01);

define('EPROTO_RRT_CONFIG', 0x00);
define('EPROTO_RRT_FINGER', 0x01);
define('EPROTO_RRT_ENROLL_CTRL', 0x02);

define('EPROTO_SIGNAL_LOCKED', 0x01);
define('EPROTO_SIGNAL_UNLOCKED', 0x02);
define('EPROTO_SIGNAL_NFC_LOCK', 0x03);
define('EPROTO_SIGNAL_NFC_UNLOCK', 0x04);



define('eproto_cmd_Busy'              ,   0x00);
define('eproto_cmd_RemoveTag'         ,   0x01); define('eproto_resp_RemoveTag'         , eproto_cmd_RemoveTag        |0x80);
define('eproto_cmd_ReadTag'           ,   0x02); define('eproto_resp_ReadTag'           , eproto_cmd_ReadTag          |0x80);
define('eproto_cmd_ReadTagExtended'   ,   0x03); define('eproto_resp_ReadTagExtended'   , eproto_cmd_ReadTagExtended  |0x80);
define('eproto_cmd_WriteTagBlock'     ,   0x04); define('eproto_resp_WriteTagBlock'     , eproto_cmd_WriteTagBlock    |0x80);
define('eproto_cmd_Authenticate'      ,   0x05); define('eproto_resp_Authenticate'      , eproto_cmd_Authenticate     |0x80);
define('eproto_cmd_Enquire'           ,   0x06); define('eproto_resp_Enquire'           , eproto_cmd_Enquire          |0x80);
define('eproto_cmd_EHLO'              ,   0x07); define('eproto_resp_EHLO'              , eproto_cmd_EHLO             |0x80);
define('eproto_cmd_GetConfig'         ,   0x08); define('eproto_resp_GetConfig'         , eproto_cmd_GetConfig        |0x80);
define('eproto_cmd_SetConfig'         ,   0x09); define('eproto_resp_SetConfig'         , eproto_cmd_SetConfig        |0x80);
define('eproto_cmd_DisplayText'       ,   0x0A); define('eproto_resp_DisplayText'       , eproto_cmd_DisplayText      |0x80);
define('eproto_cmd_Beep'              ,   0x0B); define('eproto_resp_Beep'              , eproto_cmd_Beep             |0x80);
define('eproto_cmd_BeepShort'         ,   0x0C); define('eproto_resp_BeepShort'         , eproto_cmd_BeepShort        |0x80);
define('eproto_cmd_Quack'             ,   0x0D); define('eproto_resp_Quack'             , eproto_cmd_Quack            |0x80);
define('eproto_cmd_QuackQuack'        ,   0x0E); define('eproto_resp_QuackQuack'        , eproto_cmd_QuackQuack       |0x80);
define('eproto_cmd_EEPROMTest'        ,   0x0F); define('eproto_resp_EEPROMTest'        , eproto_cmd_EEPROMTest       |0x80);
define('eproto_cmd_NetCfgLoad'        ,   0x10); define('eproto_resp_NetCfgLoad'        , eproto_cmd_NetCfgLoad       |0x80);
define('eproto_cmd_EnrollFinger'      ,   0x11); define('eproto_resp_EnrollFinger'      , eproto_cmd_EnrollFinger     |0x80);
define('eproto_cmd_ClearFinger'       ,   0x12); define('eproto_resp_ClearFinger'       , eproto_cmd_ClearFinger      |0x80);
define('eproto_cmd_BehaviorCfgLoad'   ,   0x13); define('eproto_resp_BehaviorCfgLoad'   , eproto_cmd_BehaviorCfgLoad  |0x80);
define('eproto_cmd_ResetBehaviorCfg'  ,   0x14); define('eproto_resp_ResetBehaviorCfg'  , eproto_cmd_ResetBehaviorCfg |0x80);
define('eproto_cmd_RelayControl'      ,   0x15); define('eproto_resp_RelayControl'      , eproto_cmd_RelayControl     |0x80);
define('eproto_cmd_InputChanged'      ,   0x16); define('eproto_resp_InputChanged'      , eproto_cmd_InputChanged     |0x80);
define('eproto_cmd_Interactive'       ,   0x17); define('eproto_resp_Interactive'       , eproto_cmd_Interactive      |0x80);
define('eproto_cmd_FingerEnrolled'    ,   0x18); define('eproto_resp_FingerEnrolled'    , eproto_cmd_FingerEnrolled   |0x80);
define('eproto_cmd_FingerErased'      ,   0x19); define('eproto_resp_FingerErased'      , eproto_cmd_FingerErased     |0x80);
define('eproto_cmd_FingerShot'        ,   0x1A); define('eproto_resp_FingerShot'        , eproto_cmd_FingerShot       |0x80);
define('eproto_cmd_ResetNet'          ,   0x20); define('eproto_resp_ResetNet'          , eproto_cmd_ResetNet         |0x80);
define('eproto_cmd_WriteCabID'        ,   0x21); define('eproto_resp_WriteCabID'        , eproto_cmd_WriteCabID       |0x80);
define('eproto_cmd_SectorKeysCfgLoad' ,   0x22); define('eproto_resp_SectorKeysCfgLoad' , eproto_cmd_SectorKeysCfgLoad|0x80);
define('eproto_cmd_ResetSectorKeys'   ,   0x23); define('eproto_resp_ResetSectorKeys'   , eproto_cmd_ResetSectorKeys  |0x80);
define('eproto_cmd_LockerListCfgLoad' ,   0x24); define('eproto_resp_LockerListCfgLoad' , eproto_cmd_LockerListCfgLoad|0x80);
define('eproto_cmd_ResetLockerList'   ,   0x25); define('eproto_resp_ResetLockerList'   , eproto_cmd_ResetLockerList  |0x80);
define('eproto_cmd_RAW_Data'          ,   0x26); define('eproto_resp_RAW_Data'          , eproto_cmd_RAW_Data         |0x80);
define('eproto_cmd_USARTRaw'          ,   0x27); define('eproto_resp_USARTRaw'          , eproto_cmd_USARTRaw         |0x80);
define('eproto_cmd_RelayControlEx'    ,   0x28); define('eproto_resp_RelayControlEx'    , eproto_cmd_RelayControlEx   |0x80);
define('eproto_cmd_Reset'             ,   0x29); define('eproto_resp_Reset'             , eproto_cmd_Reset            |0x80);

define('eproto_cmd_Signal'            ,   0x30); define('eproto_resp_Signal'            , eproto_cmd_Signal           |0x80);


$GLOBALS['EPROTO_Interactive_Sound_Types']=array(
  EPROTO_INTERACTIVE_SOUND_BEEP=>'EPROTO_INTERACTIVE_SOUND_BEEP',
  EPROTO_INTERACTIVE_SOUND_QUACK=>'EPROTO_INTERACTIVE_SOUND_QUACK',
);

$GLOBALS['EPROTO_Interactive_Tags']=array(
  EPROTO_INTERACTIVE_TAG_DELAY=>'EPROTO_INTERACTIVE_TAG_DELAY',
  EPROTO_INTERACTIVE_TAG_SOUND=>'EPROTO_INTERACTIVE_TAG_SOUND',
  EPROTO_INTERACTIVE_TAG_LIGHT=>'EPROTO_INTERACTIVE_TAG_LIGHT',
  EPROTO_INTERACTIVE_TAG_TEXT=>'EPROTO_INTERACTIVE_TAG_TEXT',
  EPROTO_INTERACTIVE_TAG_WAITING=>'EPROTO_INTERACTIVE_TAG_WAITING',
);

$GLOBALS['EPROTO_Commands']=array(
  eproto_cmd_Busy=>'Busy',
  eproto_cmd_RemoveTag=>'RemoveTag',
  eproto_cmd_ReadTag=>'ReadTag',
  eproto_cmd_ReadTagExtended=>'ReadTagExtended',
  eproto_cmd_WriteTagBlock=>'WriteTagBlock',
  eproto_cmd_Authenticate=>'Authenticate',
  eproto_cmd_Enquire=>'Enquire',
  eproto_cmd_EHLO=>'EHLO',
  eproto_cmd_GetConfig=>'GetConfig',
  eproto_cmd_SetConfig=>'SetConfig',
  eproto_cmd_DisplayText=>'DisplayText',
  eproto_cmd_Beep=>'Beep',
  eproto_cmd_BeepShort=>'BeepShort',
  eproto_cmd_Quack=>'Quack',
  eproto_cmd_QuackQuack=>'QuackQuack',
  eproto_cmd_EEPROMTest=>'EEPROMTest',
  eproto_cmd_NetCfgLoad=>'NetCfgLoad',
  eproto_cmd_EnrollFinger=>'EnrollFinger',
  eproto_cmd_ClearFinger=>'ClearFinger',
  eproto_cmd_BehaviorCfgLoad=>'BehaviorCfgLoad',
  eproto_cmd_ResetBehaviorCfg=>'ResetBehaviorCfg',
  eproto_cmd_RelayControl=>'RelayControl',
  eproto_cmd_InputChanged=>'InputChanged',
  eproto_cmd_Interactive=>'Interactive',
  eproto_cmd_FingerEnrolled=>'FingerEnrolled',
  eproto_cmd_FingerErased=>'FingerErased',
  eproto_cmd_FingerShot=>'FingerShot',
  eproto_cmd_ResetNet=>'ResetNet',
  eproto_cmd_WriteCabID=>'WriteCabID',
  eproto_cmd_SectorKeysCfgLoad=>'SectorKeysCfgLoad',
  eproto_cmd_ResetSectorKeys=>'ResetSectorKeys',
  eproto_cmd_LockerListCfgLoad=>'LockerListCfgLoad',
  eproto_cmd_ResetLockerList=>'ResetLockerList',
  eproto_cmd_RAW_Data=>'RAW_Data',
  eproto_cmd_USARTRaw=>'USARTRaw',
  eproto_cmd_RelayControlEx=>'RelayControlEx',
  eproto_cmd_Reset=>'Reset',
  eproto_cmd_Signal=>'Signal',
);


function eproto_resp($cmd) {
  return ($cmd | 0x80) & 0xFF;
}

function eproto_avok(&$array, $key, $not_found_val=false) {
  if ((is_int($key) || is_string($key)) && array_key_exists($key, $array)) return $array[$key];
  return $not_found_val;
}

function eproto_cmd_name($cmd, $not_found_val=false) {
  $name=eproto_avok($GLOBALS['EPROTO_Commands'], $cmd & 0x7F);
  if ($name==false) return $not_found_val;
  return (($cmd & 0x80)?'eproto_resp_':'eproto_cmd_').$name;
}

function eproto_itag_name($tag, $not_found_val=false) {
  $name=eproto_avok($GLOBALS['EPROTO_Interactive_Tags'], $tag);
  if ($name==false) return $not_found_val;
  return $name;
}

function eproto_itag_stype_name($stype, $not_found_val=false) {
  $name=eproto_avok($GLOBALS['EPROTO_Interactive_Sound_Types'], $stype);
  if ($name==false) return $not_found_val;
  return $name;
}

function eproto_tlv_enc_empty($tag, $flags=0, $max=0) {
  $tag_size=($flags>>2)&0x03; $tag_size++;
  $len_size=($flags)&0x03; $len_size++;
  if ($max>0 && $tag_size+$len_size>$max) return false;
  return numcoder_encode_r($tag, $tag_size).
         numcoder_encode_r(0, $len_size);
}

function eproto_tlv_enc_num($tag, $val, $vsize, $flags=0, $max=0) {
  $tag_size=($flags>>2)&0x03; $tag_size++;
  $len_size=($flags)&0x03; $len_size++;
  if ($max>0 && $tag_size+$len_size+$vsize>$max) return false;
  return numcoder_encode_r($tag, $tag_size).
         numcoder_encode_r($vsize, $len_size).
         numcoder_encode_r($val, $vsize);
}

function eproto_tlv_enc_buf($tag, $buf, $flags=0, $max=0) {
  $tag_size=($flags>>2)&0x03; $tag_size++;
  $len_size=($flags)&0x03; $len_size++;
  $vsize=strlen($buf);
  if ($max>0 && $tag_size+$len_size+$vsize>$max) return false;
  return numcoder_encode_r($tag, $tag_size).
         numcoder_encode_r($vsize, $len_size).
         $buf;
}

function eproto_tlv_decode($data, $flags=0) {
  $tag_size=($flags>>2)&0x03; $tag_size++;
  $len_size=($flags)&0x03; $len_size++;
  $offset=0;
  $loffset=strlen($data);
  $result=array();
  while ($offset<$loffset) {
    if ($offset+$tag_size+$len_size>$loffset) return -1;
    $res=array();
    $res['tag']=numcoder_decode_r($data, $offset, $tag_size, $loffset);
    $res['len']=numcoder_decode_r($data, $offset, $len_size, $loffset);
    if ($offset+$res['len']>$loffset) return -2;
    $res['val']=numcoder_decode_buf($data, $offset, $res['len'], $loffset);
    array_push($result, $res);
  }
  return $result;
}

function eproto_skip2marker($buf, &$offset=0) {
  $loffset=strlen($buf);
  while ($offset<$loffset) {
    if (ord($buf{$offset})==EPROTO_MARKER) return true;
    $offset++;
  }    
  return false;
}

function eproto_packet($cmd, $flags=0, $data=false) {
  $pk=array();
  $pk['marker']=EPROTO_MARKER;
  $pk['cmd']=$cmd;
  if ($GLOBALS['EPROTO_DUMP_HELPER']) $pk['cmd_hex']=sprintf('0x%02X',$pk['cmd']);
  if ($GLOBALS['EPROTO_DUMP_HELPER']) $pk['cmd_name']=eproto_cmd_name($pk['cmd'], 'Unknown');
  if ($GLOBALS['EPROTO_DUMP_HELPER']) if ($pk['cmd'] & 0x80) $pk['responce']=true;
  $pk['payload_len']=0;
  $pk['flags']=$flags;
  $pk['code']=0;
  $pk['crc_h']=0;
  $pk['crc_b']=0;
  $pk['payload']=$data;
  if ($GLOBALS['EPROTO_DUMP_HELPER']) if (is_string($pk['payload']) && strlen($pk['payload'])>0) $pk['payload_hex']=numcoder_dump_simple($pk['payload']);
  return $pk;
}

function eproto_packet_try_read_header($buf, $offset=0, &$pk=false) {
  $loffset=strlen($buf);
  $soffset=$offset;
  $len=$loffset-$offset;
  if (EPROTO_HEAD_LEN>$len) return EPROTO_HEAD_LEN-$len;
  
  $pk['marker']=numcoder_decode_r($buf, $offset, 1, $loffset); if ($pk['marker']!=EPROTO_MARKER) return -1;
  $pk['cmd']=numcoder_decode_r($buf, $offset, 1, $loffset);
  if ($GLOBALS['EPROTO_DUMP_HELPER']) $pk['cmd_hex']=sprintf('0x%02X',$pk['cmd']);
  if ($GLOBALS['EPROTO_DUMP_HELPER']) $pk['cmd_name']=eproto_cmd_name($pk['cmd'], 'Unknown');
  if ($GLOBALS['EPROTO_DUMP_HELPER']) if ($pk['cmd'] & 0x80) $pk['responce']=true;
  $pk['payload_len']=numcoder_decode_r($buf, $offset, 2, $loffset); if ($pk['payload_len']>EPROTO_PAYLOAD_MAX_LEN) return -2;
  $pk['flags']=numcoder_decode_r($buf, $offset, 1, $loffset);
  $pk['code']=numcoder_decode_r($buf, $offset, 1, $loffset);
  $pk['crc_h']=numcoder_decode_r($buf, $offset, 1, $loffset); if (CRC8_BlockChecksum($buf, $soffset, EPROTO_HEAD_LEN-2)!=$pk['crc_h']) return -3;
  $pk['crc_b']=numcoder_decode_r($buf, $offset, 1, $loffset);
  return 0;
}
  
function eproto_packet_decode($buf, &$offset=0, &$pk=false) {
  $pk=array();
//  if (!eproto_skip2marker($buf, $offset)) return EPROTO_HEAD_LEN;
  $hd_len=eproto_packet_try_read_header($buf, $offset, $pk);
  if ($hd_len!=0) return $hd_len;

  $pk_len=EPROTO_HEAD_LEN+$pk['payload_len'];

  $loffset=strlen($buf);
  if ($pk_len>$loffset-$offset) return $pk_len-($loffset-$offset);
  $pk['payload']=substr($buf, $offset+EPROTO_HEAD_LEN, $pk['payload_len']);
  if ($GLOBALS['EPROTO_DUMP_HELPER']) if (array_key_exists('payload', $pk) && is_string($pk['payload']) && strlen($pk['payload'])>0) $pk['payload_hex']=numcoder_dump_simple($pk['payload']);

  if (CRC8_BlockChecksum($pk['payload'])!=$pk['crc_b']) return -4;

  $offset+=$pk_len;

  return $pk;
}
  
function eproto_packet_encode(&$pk) {
  if (array_key_exists('payload', $pk) && is_string($pk['payload']) && strlen($pk['payload'])>0) {
    $pk['payload_len']=strlen($pk['payload']);
  }  
  $pk['len']=EPROTO_HEAD_LEN+$pk['payload_len'];
  $pk['marker']=EPROTO_MARKER;
  $ret=numcoder_encode_r($pk['marker'], 1);
  $ret.=numcoder_encode_r($pk['cmd'], 1);
  $ret.=numcoder_encode_r($pk['payload_len'], 2);
  $ret.=numcoder_encode_r($pk['flags'], 1);
  $ret.=numcoder_encode_r($pk['code'], 1);

  $pk['crc_h']=CRC8_BlockChecksum($ret);
  $ret.=numcoder_encode_r($pk['crc_h'], 1);

  $pk['crc_b']=CRC8_BlockChecksum($pk['payload']);
  $ret.=numcoder_encode_r($pk['crc_b'], 1);

  if ($pk['payload_len']>0) $ret.=$pk['payload'];

  if ($GLOBALS['EPROTO_DUMP_HELPER']) $pk['cmd_hex']=sprintf('0x%02X',$pk['cmd']);
  if ($GLOBALS['EPROTO_DUMP_HELPER']) $pk['cmd_name']=eproto_cmd_name($pk['cmd'], 'Unknown');
  if ($GLOBALS['EPROTO_DUMP_HELPER']) if ($pk['cmd'] & 0x80) $pk['responce']=true;
  if ($GLOBALS['EPROTO_DUMP_HELPER']) if (is_string($pk['payload']) && strlen($pk['payload'])>0) $pk['payload_hex']=numcoder_dump_simple($pk['payload']);

  return $ret;
}
  
function eproto_RelayControl_packet($rno=0, $tmo=200) {
  $tmo=(int)($tmo/50);
  $rno&=0x03;
  $tmo&=0x3F;
  $pk=eproto_packet(eproto_cmd_RelayControl);
  $pk['code']=($rno << 6) | $tmo;  
  return $pk;
}  
  
  
} // end incl_h
?>
