<?php

if (!defined("INC_FS_H")){
   define("INC_FS_H", TRUE);

  define("FS_DL_DIRS", 0x00000001);
  define("FS_DL_FILES", 0x00000002);
  
  function fs_dir_list($root, $wich=FS_DL_DIRS, $filter=false) {
     $wich = (int) $wich;
     $res = array();
     if ($dir = @opendir($root)) {
        while (($file = readdir($dir)) !== false) {
           if (($wich & FS_DL_DIRS) && is_dir($root.$file) && preg_match('/[^\.]/', $file)) {
               if (!$filter || stristr($filter, $file)) array_push($res, $file);
           }
           if (($wich & FS_DL_FILES) && is_file($root.$file)) {
               $pi = pathinfo($file);
               if (!$filter || stristr($filter, $pi["extension"])) array_push($res, $file);
           }
        }
        closedir($dir);
     }
     return $res;
  }

}
?>
