<?php

if (!defined("INC_FUNC_H")){
   define("INC_FUNC_H", TRUE);

  function func_init_request() {
    array_walk($_REQUEST, create_function('&$item, $key','$item = trim(stripslashes($item));'));
    $_REQUEST=array_change_key_case($_REQUEST, CASE_UPPER);
  }

  function func_print_log($fname, $str) {
    $fp = fopen ($fname, "ab");
    fputs ($fp, $str);
    fclose ($fp);
  }

  function func_clear_log($fname, $del=false) {
    if ($del) {
       if (file_exists($fname)) return unlink($fname);
       return false;
    }
    $fp = fopen ($fname, "w");
//    $fp = fopen ($fname, "ab");
//    ftruncate($fp, 0);
    fclose ($fp);
  }
  

  function func_price_from_int($int_price, $hard=false) {
     $f_price=((int)$int_price)/100;
     if ($hard) return $f_price;
     $pa = preg_split("/[\.\,]/", "$f_price", 2);
     if (preg_match("/(\d{0,3})([\d]{3})+/", $pa[0], $ma)) $pa[0]= implode(' ',array_slice($ma,1));
     $pa[1]=str_pad($pa[1], 2, "0");
     return trim(implode('.',$pa));
  }


  function func_kpad($input) {
      return str_pad($input, 2, "0", STR_PAD_LEFT);
  }

  function func_get_file_contents($filename) {
    if (!file_exists($filename)) return '';
    return @file_get_contents($filename);
    $fp = @fopen($filename, "rb");
    $temp = "";
    if (!($fp)) return 0;
    while (!feof($fp)) $temp .= fread($fp, 4096);
    fclose ($fp);
    return $temp;
  }

  function func_put_file_contents($filename, $contents='') {
     if (file_exists($filename)) unlink($filename);
//     return file_put_contents($filename, $contents);
     if (!($fp = fopen ($filename, "wb"))) return '[error: failed open file!]';
     fwrite ($fp, $contents);
     fclose ($fp);
     chmod ($filename, 0664);
  }                                   

  function func_str_to_codes($str='') {
     $arr = array();
     $len = strlen($str);
     for ($i=0;$i<$len;$i++) $arr[]=ord($str{$i});
     return $arr;
  }

  function func_reset_page($_parameter='') {
    global $script_name;
    $arr = array();
    $show = trim($_REQUEST['SHOW']); if (strlen($show)>0) array_push($arr, "show=$show");
    $order = trim($_REQUEST['ORDER']); if (strlen($order)>0) array_push($arr, "order=$order");
    $by_firm = trim($_REQUEST['BY_FIRM']); if (strlen($by_firm)>0) array_push($arr, "by_firm=$by_firm");
    if (strlen(trim($_parameter))>0) array_push($arr, trim($_parameter));
    $param = implode("&",$arr);
    if (strlen($param)>0) $param = "?".$param;

//    print("\n\n[$PHP_SELF$param]\n\n");
    print("\n\n<script LANGUAGE=\"JavaScript\">location.replace(\"$PHP_SELF$param\");</script>\n\n");
    exit();
  }

  function func_make_str($r=0, $ch=' ') {
     return str_pad("", $r*strlen($ch), $ch, STR_PAD_LEFT);
  }
  
  function func_bit_set($value, $no) {
     if ($no<1 || $no>32) return (int) $value;
     return (int) $value | (1 << ($no-1));
  }
  
  function func_bit_clear($value, $no) {
     if ($no<1 || $no>32) return (int) $value;
     return (int) $value & (~(1 << ($no-1)));
  }
  
  function func_bit_flip($value, $no) {
     if ($no<1 || $no>32) return (int) $value;
     return (int) $value ^ (1 << ($no-1));
  }
  
  function func_bit_test($value, $no) {
     if ($no<1 || $no>32) return (int) $value;
     return (int) (($value & (1 << ($no-1)))?1:0);
  }
  
  function func_bit_to_str($value, $length=32) {
     if ($length<1) return '';
     if ($length>32) $length=32;
     $buffer='';
     for ($i=1;$i<=$length;$i++) $buffer .= (bit_test($value, $i))?'1':'0';
     return $buffer;
  }
   
}
?>
