<?php
if (!defined("INC_GAT_H")) {
     define("INC_GAT_H", TRUE);

include("numcoder.inc");

$GLOBALS['GAT_DUMP_HELPER']=false;


define('GAT_CMD_SET_PROTO_TYPE', 0x85);
define('GAT_CMD_SET_ADDRESS', 0xE2);
define('GAT_CMD_SET_DATE', 0xE7);
define('GAT_CMD_IDENT_READ_DATE', 0xE1);
define('GAT_CMD_TEST_CONNECTION', 0x06);
define('GAT_CMD_CLEAR_BAPTISM_DATA', 0x25);
define('GAT_CMD_ENABLE_BAPTISM', 0x26);
define('GAT_CMD_READ_BAPTISM_DATA', 0x27);
define('GAT_CMD_READ_EVENT', 0x62);
define('GAT_CMD_REPEAT_EVENT', 0x63);
define('GAT_CMD_DELETE_EVENTS', 0x64);
define('GAT_CMD_PASS_MASTER', 0x60);
define('GAT_CMD_TRIG_MASTER', 0xCE);
define('GAT_CMD_RESET', 0xA0);
define('GAT_CMD_SET_ADR_EXTENDED', 0xA2);

define('GAT_CMD_CARD_IDENT', 0x80);
define('GAT_CMD_REQ_MASTER', 0xE5);
define('GAT_CMD_CANCEL', 0xC0);
define('GAT_CMD_ACTION_STARTED', 0xA1);
define('GAT_CMD_BUTTON_EVENT', 0x86);
define('GAT_CMD_HOST_CONTROL', 0xCA);
define('GAT_CMD_HOST_CONTROL_RESP', 0xCB);
define('GAT_CMD_ALARM_MSG', 0xA4);
define('GAT_CMD_CASH_VALUE', 0xA5);
define('GAT_CMD_CASH_COLLECT', 0xA8);

$GLOBALS['GAT_Commands']=array(
  GAT_CMD_SET_PROTO_TYPE=>'GAT_CMD_SET_PROTO_TYPE',
  GAT_CMD_SET_ADDRESS=>'GAT_CMD_SET_ADDRESS',
  GAT_CMD_SET_DATE=>'GAT_CMD_SET_DATE',
  GAT_CMD_IDENT_READ_DATE=>'GAT_CMD_IDENT_READ_DATE',
  GAT_CMD_TEST_CONNECTION=>'GAT_CMD_TEST_CONNECTION',
  GAT_CMD_CLEAR_BAPTISM_DATA=>'GAT_CMD_CLEAR_BAPTISM_DATA',
  GAT_CMD_ENABLE_BAPTISM=>'GAT_CMD_ENABLE_BAPTISM',
  GAT_CMD_READ_BAPTISM_DATA=>'GAT_CMD_READ_BAPTISM_DATA',
  GAT_CMD_READ_EVENT=>'GAT_CMD_READ_EVENT',
  GAT_CMD_REPEAT_EVENT=>'GAT_CMD_REPEAT_EVENT',
  GAT_CMD_DELETE_EVENTS=>'GAT_CMD_DELETE_EVENTS',
  GAT_CMD_PASS_MASTER=>'GAT_CMD_PASS_MASTER',
  GAT_CMD_TRIG_MASTER=>'GAT_CMD_TRIG_MASTER',
  GAT_CMD_RESET=>'GAT_CMD_RESET',
  GAT_CMD_SET_ADR_EXTENDED=>'GAT_CMD_SET_ADR_EXTENDED',
  GAT_CMD_CARD_IDENT=>'GAT_CMD_CARD_IDENT',
  GAT_CMD_REQ_MASTER=>'GAT_CMD_REQ_MASTER',
  GAT_CMD_CANCEL=>'GAT_CMD_CANCEL',
  GAT_CMD_ACTION_STARTED=>'GAT_CMD_ACTION_STARTED',
  GAT_CMD_BUTTON_EVENT=>'GAT_CMD_BUTTON_EVENT',
  GAT_CMD_HOST_CONTROL=>'GAT_CMD_HOST_CONTROL',
  GAT_CMD_HOST_CONTROL_RESP=>'GAT_CMD_HOST_CONTROL_RESP',
  GAT_CMD_ALARM_MSG=>'GAT_CMD_ALARM_MSG',
  GAT_CMD_CASH_VALUE=>'GAT_CMD_CASH_VALUE',
  GAT_CMD_CASH_COLLECT=>'GAT_CMD_CASH_COLLECT',
);

$GLOBALS['GAT_Commands_Descriptions']=array(
  GAT_CMD_SET_PROTO_TYPE=>'Set the host communication protocol',
  GAT_CMD_SET_ADDRESS=>'Set new address for the terminal',
  GAT_CMD_SET_DATE=>'Set date and time',
  GAT_CMD_IDENT_READ_DATE=>'Read terminal identification and date/time',
  GAT_CMD_TEST_CONNECTION=>'Cable connection test',
  GAT_CMD_CLEAR_BAPTISM_DATA=>'Clear authorisation data',
  GAT_CMD_ENABLE_BAPTISM=>'Enable authorisation',
  GAT_CMD_READ_BAPTISM_DATA=>'Read authorisation data',
  GAT_CMD_READ_EVENT=>'Read last event',
  GAT_CMD_REPEAT_EVENT=>'Repeat reading last event',
  GAT_CMD_DELETE_EVENTS=>'Delete all events',
  GAT_CMD_PASS_MASTER=>'Pass master mode to terminal',
  GAT_CMD_TRIG_MASTER=>'Force terminal to change to online active mode',
  GAT_CMD_RESET=>'Force terminal to reset',
  GAT_CMD_SET_ADR_EXTENDED=>'Set new address',
  GAT_CMD_CARD_IDENT=>'Identification by Card (Data Carrier)',
  GAT_CMD_REQ_MASTER=>'Request to Transfer to Master Mode',
  GAT_CMD_CANCEL=>'Process Cancellation',
  GAT_CMD_ACTION_STARTED=>'Message that the Device is Beeing Used',
  GAT_CMD_BUTTON_EVENT=>'Button was Pressed Event',
  GAT_CMD_HOST_CONTROL=>'Direct Access Control by Host',
  GAT_CMD_HOST_CONTROL_RESP=>'Direct Access Control by Host Responce',
  GAT_CMD_ALARM_MSG=>'Alarm Message to the Host',
  GAT_CMD_CASH_VALUE=>'Message with the Value of the Bill',
  GAT_CMD_CASH_COLLECT=>'The Bill is Collected',
);


define('GAT_TTYPE_INFO', 0x00);
define('GAT_TTYPE_ACCESS', 0x01);
define('GAT_TTYPE_TIME', 0x02);
define('GAT_TTYPE_RETURN', 0x03);
define('GAT_TTYPE_CASH', 0x04);
     
$GLOBALS['GAT_Terminals']=array(
  GAT_TTYPE_INFO=>'GAT_TTYPE_INFO',
  GAT_TTYPE_ACCESS=>'GAT_TTYPE_ACCESS',
  GAT_TTYPE_TIME=>'GAT_TTYPE_TIME',
  GAT_TTYPE_RETURN=>'GAT_TTYPE_RETURN',
  GAT_TTYPE_CASH=>'GAT_TTYPE_CASH',
);

$GLOBALS['GAT_Terminals_Descriptions']=array(
  GAT_TTYPE_INFO=>'GAT Info 6xxx',
  GAT_TTYPE_ACCESS=>'GAT Access 6xxx',
  GAT_TTYPE_TIME=>'GAT Time 6xxx',
  GAT_TTYPE_RETURN=>'GAT Return 6xxx',
  GAT_TTYPE_CASH=>'GAT Cash 6xxx',
);

define('GAT_RTYPE_LEGIC', 0x01);
define('GAT_RTYPE_BARCODE', 0x04);
define('GAT_RTYPE_OMRON', 0x10);
define('GAT_RTYPE_ISO15693', 0x11);
define('GAT_RTYPE_MIFARE', 0x12);
define('GAT_RTYPE_PINPAD', 0x20);
     
$GLOBALS['GAT_Readers']=array(
  GAT_RTYPE_LEGIC=>'GAT_RTYPE_LEGIC',
  GAT_RTYPE_BARCODE=>'GAT_RTYPE_BARCODE',
  GAT_RTYPE_OMRON=>'GAT_RTYPE_OMRON',
  GAT_RTYPE_ISO15693=>'GAT_RTYPE_ISO15693',
  GAT_RTYPE_MIFARE=>'GAT_RTYPE_MIFARE',
  GAT_RTYPE_PINPAD=>'GAT_RTYPE_PINPAD',
);

define('GAT_ARES_USED', 0x00);
define('GAT_ARES_FIU_ERROR', 0x10);
define('GAT_ARES_NOT_USED', 0x55);
     
$GLOBALS['GAT_ActionResults']=array(
  GAT_ARES_USED=>'GAT_ARES_USED',
  GAT_ARES_FIU_ERROR=>'GAT_ARES_FIU_ERROR',
  GAT_ARES_NOT_USED=>'GAT_ARES_NOT_USED',
);

$GLOBALS['_gat_stc']='0400000c646d6e7372765f636c69737407000089'.
                     '040000036164640700007e0400000e3034354436'.
                     '3930413337334338300400000833453838413344'.
                     '440400000e303441344543304133373343383004'.
                     '00000e3034374543383041333733433830040000'.
                     '0830314444393943390400000841373538424346'.
                     '4304000008453130453941333204000008423138'.
                     '3743324434040000083631423543334434010000'.
                     '0100';

function gat_resp($cmd) {
  return ($cmd | 0x10) & 0xFF;
}

function gat_avok(&$array, $key, $not_found_val=false) {
  if ((is_int($key) || is_string($key)) && array_key_exists($key, $array)) return $array[$key];
  return $not_found_val;
}

function gat_encode_hca($hca) {
  $hca&=0xFFFF;
//  $hca=(($hca>>14)&0x03) | (($hca<<2) & 0xFFFC);
  $hca=(($hca<<14)&0xC000) | (($hca>>2) & 0x3FFF);
  $hca^=0x69A3;
  return $hca;
}

function gat_calc_lrc($buf, $offset, $len) {
  $lrc=0;
  for ($i=$offset;$i<$len;$i++) $lrc^=ord($buf{$i})&0xFF;
  return $lrc;
}

function gat_packet($adr, $cmd, $te_status=0, $data=false) {
  $pk=array();
  $pk['adr']=$adr;
  $pk['cmd']=$cmd;
  if ($GLOBALS['GAT_DUMP_HELPER']) $pk['cmd_hex']=sprintf('0x%02X',$pk['cmd']);
  if ($pk['cmd'] & 0x10) $pk['te_status']=$te_status;
  $pk['data']=$data;
  if ($GLOBALS['GAT_DUMP_HELPER']) if (is_string($pk['data']) && strlen($pk['data'])>0) $pk['data_hex']=numcoder_dump_simple($pk['data']);
  return $pk;
}

function gat_decode_packet($buf, &$offset=0, &$pk=false) {
  $pk=array();
  $soffset=$offset;
  $loffset=strlen($buf);
  if ($loffset<4) return 4-$loffset;
  $pk['len']=numcoder_decode($buf, $offset, 1, $loffset); if ($pk['len']===false) return false;
  if ($loffset-$offset<$pk['len']) return $pk['len']-($loffset-$offset);
  $pk['adr']=numcoder_decode($buf, $offset, 1, $loffset); if ($pk['adr']===false) return false;
  $pk['cmd']=numcoder_decode($buf, $offset, 1, $loffset); if ($pk['cmd']===false) return false;
  if ($GLOBALS['GAT_DUMP_HELPER']) $pk['cmd_hex']=sprintf('0x%02X',$pk['cmd']);
  if ($pk['cmd'] & 0x10) {
    if ($pk['len']<4) return false;
    $pk['te_status']=numcoder_decode($buf, $offset, 1, $loffset); if ($pk['te_status']===false) return false;
  } else {
    if ($pk['len']<3) return false;
    $pk['te_status']=false;
  }  
  if ($offset<$pk['len']) {
    $data=substr($buf, $offset, $pk['len']-$offset);
    $offset+=strlen($data);
  } else $data=false;
  $pk['clrc']=gat_calc_lrc($buf, $soffset, $offset-$soffset);
  $pk['lrc']=numcoder_decode($buf, $offset, 1, $loffset); if ($pk['lrc']===false) return false;
  $pk['data']=$data;
  if ($GLOBALS['GAT_DUMP_HELPER']) $pk['data_hex']=numcoder_dump_simple($pk['data']);
  return $pk;
}

function gat_encode_packet(&$pk) {
  $pk['len']=strlen($pk['data'])+3;
  if ($pk['cmd'] & 0x10) $pk['len']++;
  if ($pk['len']>0xFF) return false;
  $ret=numcoder_encode($pk['len']&0xFF, 1);
  $ret.=numcoder_encode($pk['adr']&0xFF, 1);
  $ret.=numcoder_encode($pk['cmd']&0xFF, 1);
  if ($pk['cmd'] & 0x10) $ret.=numcoder_encode($pk['te_status']&0xFF, 1);
  if (is_string($pk['data']) && strlen($pk['data'])>0) $ret.=$pk['data'];
  $ret.=chr(gat_calc_lrc($ret, 0, strlen($ret)));
  return $ret;
}

} // end incl_h
?>
