<?php

if (!defined("INC_GRAPH_H")){
   define("INC_GRAPH_H", TRUE);

   define("IMG_TYPE_JPEG", 1);
   define("IMG_TYPE_GIF", 2);
   define("IMG_TYPE_PNG", 3);

  function graph_thumb_image($src_file, $dest_file, $thumb_w, $thumb_h, $quality=75, $no_strip_borders=false, $overlay=false, $debug=false) {
     $s_pi = pathinfo($src_file);
     $d_pi = pathinfo($dest_file);
     $st=IMG_TYPE_JPEG;
     $dt=IMG_TYPE_JPEG;
     if ( preg_match("/^(jpg|jpeg)$/i",$s_pi["extension"]) ) $st=IMG_TYPE_JPEG;
       if ( preg_match("/^(jpg|jpeg)$/i",$d_pi["extension"]) ) $dt=IMG_TYPE_JPEG;
     if ( preg_match("/^(gif)$/i",$s_pi["extension"]) ) $st=IMG_TYPE_GIF;
       if ( preg_match("/^(gif)$/i",$d_pi["extension"]) ) $dt=IMG_TYPE_GIF;
     if ( preg_match("/^(png)$/i",$s_pi["extension"]) ) $st=IMG_TYPE_PNG;
       if ( preg_match("/^(png)$/i",$d_pi["extension"]) ) $dt=IMG_TYPE_PNG;
     if (!$st || !$dt) return false;

     $src_img = false;
     if ($st==IMG_TYPE_JPEG) $src_img = imagecreatefromjpeg($src_file);
     if ($st==IMG_TYPE_GIF) $src_img = imagecreatefromgif($src_file);
     if ($st==IMG_TYPE_PNG) $src_img = imagecreatefrompng($src_file);
     if (!$src_img) return false;

     if ($overlay) {
       $timg = imagecreatefrompng($overlay);
       $td = array(imagesx($timg), imagesy($timg));
     }
     $sd = array(imagesx($src_img), imagesy($src_img));
     $dd = array($thumb_w, $thumb_h);
     $s_delta = $sd[0]/$sd[1];
     $d_delta = $thumb_w/$thumb_h;
     if ($debug) print("delta[".$s_delta.",".$d_delta."]<br>\n");
     $dc = array(0,0);
     $no_resize=($sd[0]<$dd[0] && $sd[1]<$dd[1]);
     if ($s_delta>=$d_delta) {
       $dd[0]=($no_resize)?$sd[0]:$thumb_w;
       $dd[1]=($no_resize)?$sd[1]:(int)($thumb_w/$s_delta);
       $dc[1]= (int)(($thumb_h-$dd[1])/2);
       if ($debug) print("calc h<br>\n");
     } else {
       $dd[0]=($no_resize)?$sd[0]:(int)($thumb_h*$s_delta);
       $dd[1]=($no_resize)?$sd[1]:$thumb_h;
       $dc[0]= (int)(($thumb_w-$dd[0])/2);
       if ($debug) print("calc w<br>\n");           
     }
     if ($no_resize) {
       $dc[0]= (int)(($thumb_w-$dd[0])/2);
       $dc[1]= (int)(($thumb_h-$dd[1])/2);
     }
     if ($overlay) {
       $trans = imagecolorallocate($timg, 0, 255, 255);
       $trans = imagecolortransparent($timg, $trans);
     }                                               
   if ($no_strip_borders) {
     $dst_img = imagecreatetruecolor($thumb_w, $thumb_h);
     $bg = imagecolorallocate($dst_img, 210, 216, 226);
     imagefilledrectangle($dst_img, 0, 0, $thumb_w, $thumb_h, $bg);

     imagecopyresampled($dst_img, $src_img, $dc[0], $dc[1], 0, 0, $dd[0], $dd[1], $sd[0], $sd[1]);
     if ($overlay) ImageCopyMerge($dst_img, $timg, $dc[0]+$dd[0]-$td[0]-3, $dc[1]+$dd[1]-$td[1]-3, 0, 0, $td[0], $td[1], 90);
   } else {
     $dst_img = imagecreatetruecolor($dd[0], $dd[1]);
     $bg = imagecolorallocate($dst_img, 128, 128, 128);
     imagefilledrectangle($dst_img, 0, 0, $dd[0], $dd[1], $bg);

     imagecopyresampled($dst_img, $src_img, 0, 0, 0, 0, $dd[0], $dd[1], $sd[0], $sd[1]);
     if ($overlay) ImageCopyMerge($dst_img, $timg, $dd[0]-$td[0]-3, $dd[1]-$td[1]-3, 0, 0, $td[0], $td[1], 90);
   }
     if ($debug) print("sd[".$sd[0].",".$sd[1]."]<br>\n");
     if ($debug) print("dd[".$dd[0].",".$dd[1]."]<br>\n");
     imagejpeg($dst_img, $dest_file, 75);
     imagedestroy($src_img);
     imagedestroy($dst_img);
     return true;
  }

   
}
?>
