<?php

if (!defined("INC_HEXUTIL_H")){
   define("INC_HEXUTIL_H", TRUE);

$hexutil_hex_table = '0123456789ABCDEF';

$hexutil_hex_table_r = array(
  0xFF     , 0xFF     , 0xFF     , 0xFF     , 0xFF     , 0xFF     , 0xFF     , 0xFF     ,
  0xFF     , 0xFF     , 0xFF     , 0xFF     , 0xFF     , 0xFF     , 0xFF     , 0xFF     ,
  0xFF     , 0xFF     , 0xFF     , 0xFF     , 0xFF     , 0xFF     , 0xFF     , 0xFF     ,
  0xFF     , 0xFF     , 0xFF     , 0xFF     , 0xFF     , 0xFF     , 0xFF     , 0xFF     ,
  0xFF     , 0xFF     , 0xFF     , 0xFF     , 0xFF     , 0xFF     , 0xFF     , 0xFF     ,
  0xFF     , 0xFF     , 0xFF     , 0xFF     , 0xFF     , 0xFF     , 0xFF     , 0xFF     ,
  0x00/*0*/, 0x01/*1*/, 0x02/*2*/, 0x03/*3*/, 0x04/*4*/, 0x05/*5*/, 0x06/*6*/, 0x07/*7*/,
  0x08/*8*/, 0x09/*9*/, 0xFF     , 0xFF     , 0xFF     , 0xFF     , 0xFF     , 0xFF     ,
  0xFF     , 0x0A/*A*/, 0x0B/*B*/, 0x0C/*C*/, 0x0D/*D*/, 0x0E/*E*/, 0x0F/*F*/, 0xFF     ,
  0xFF     , 0xFF     , 0xFF     , 0xFF     , 0xFF     , 0xFF     , 0xFF     , 0xFF     ,
  0xFF     , 0xFF     , 0xFF     , 0xFF     , 0xFF     , 0xFF     , 0xFF     , 0xFF     ,
  0xFF     , 0xFF     , 0xFF     , 0xFF     , 0xFF     , 0xFF     , 0xFF     , 0xFF     ,
  0xFF     , 0x0A/*a*/, 0x0B/*b*/, 0x0C/*c*/, 0x0D/*d*/, 0x0E/*e*/, 0x0F/*f*/, 0xFF     ,
  0xFF     , 0xFF     , 0xFF     , 0xFF     , 0xFF     , 0xFF     , 0xFF     , 0xFF     ,
  0xFF     , 0xFF     , 0xFF     , 0xFF     , 0xFF     , 0xFF     , 0xFF     , 0xFF     ,
  0xFF     , 0xFF     , 0xFF     , 0xFF     , 0xFF     , 0xFF     , 0xFF     , 0xFF     ,
  0xFF     , 0xFF     , 0xFF     , 0xFF     , 0xFF     , 0xFF     , 0xFF     , 0xFF     ,
  0xFF     , 0xFF     , 0xFF     , 0xFF     , 0xFF     , 0xFF     , 0xFF     , 0xFF     ,
  0xFF     , 0xFF     , 0xFF     , 0xFF     , 0xFF     , 0xFF     , 0xFF     , 0xFF     ,
  0xFF     , 0xFF     , 0xFF     , 0xFF     , 0xFF     , 0xFF     , 0xFF     , 0xFF     ,
  0xFF     , 0xFF     , 0xFF     , 0xFF     , 0xFF     , 0xFF     , 0xFF     , 0xFF     ,
  0xFF     , 0xFF     , 0xFF     , 0xFF     , 0xFF     , 0xFF     , 0xFF     , 0xFF     ,
  0xFF     , 0xFF     , 0xFF     , 0xFF     , 0xFF     , 0xFF     , 0xFF     , 0xFF     ,
  0xFF     , 0xFF     , 0xFF     , 0xFF     , 0xFF     , 0xFF     , 0xFF     , 0xFF     ,
  0xFF     , 0xFF     , 0xFF     , 0xFF     , 0xFF     , 0xFF     , 0xFF     , 0xFF     ,
  0xFF     , 0xFF     , 0xFF     , 0xFF     , 0xFF     , 0xFF     , 0xFF     , 0xFF     ,
  0xFF     , 0xFF     , 0xFF     , 0xFF     , 0xFF     , 0xFF     , 0xFF     , 0xFF     ,
  0xFF     , 0xFF     , 0xFF     , 0xFF     , 0xFF     , 0xFF     , 0xFF     , 0xFF     ,
  0xFF     , 0xFF     , 0xFF     , 0xFF     , 0xFF     , 0xFF     , 0xFF     , 0xFF     ,
  0xFF     , 0xFF     , 0xFF     , 0xFF     , 0xFF     , 0xFF     , 0xFF     , 0xFF     ,
  0xFF     , 0xFF     , 0xFF     , 0xFF     , 0xFF     , 0xFF     , 0xFF     , 0xFF     ,
  0xFF     , 0xFF     , 0xFF     , 0xFF     , 0xFF     , 0xFF     , 0xFF     , 0xFF     
);
   
   
function hexutil_buf2hex($buf) {
  global $hexutil_hex_table;
  $result='';
  $len=strlen($buf);
  for ($i=0;$i<$len;$i++) {
    $val=ord($buf{$i});
    $result.=$hexutil_hex_table{($val>>4)&0xF};
    $result.=$hexutil_hex_table{($val)&0xF};
  }
  return $result;
}
   
function hexutil_hex2buf($hex_str) {
  global $hexutil_hex_table_r;
  $len=strlen($hex_str);
  $l=(int)($len/2);
  if ($len!=$l*2) return false;
  $result='';
  for ($i=0;$i<$l;$i++) {
    $v1=$hexutil_hex_table_r[ord($hex_str{$i*2})];
    $v2=$hexutil_hex_table_r[ord($hex_str{($i*2)+1})];
    if ($v1>0xF || $v2>0xF) return false;
    $result.=chr(($v1<<4 | $v2) & 0xFF);
  }
  return $result;
}   
   
  function hexutil_dump($data, $line_prefix='') {
     $res=array();
     $l=strlen($data);
     $ind=0;
     while ($ind<$l) {
        $str=sprintf("0x%08X ",$ind);
        $ml=$l-$ind; if ($ml>16) $ml=16;
        $str1='';
        for ($i=0;$i<$ml;$i++) {
            $chc=ord($data{$ind+$i});
            $str.=sprintf(" %02X",$chc);
            if ($chc>32) {
              $str1.=chr($chc);
            } else {
              $str1.='.';
            }
        }
        $str.=str_pad('', (16-$ml)*3);
        $str.='  '.$str1;
        array_push($res, $line_prefix.$str);
        $ind+=$ml;
     }
      
     return implode("\n",$res);
  }

}
?>
