<?php
if (!defined("INC_IB_H")){
   define("INC_IB_H", TRUE);
   $GLOBALS['TEST_MODE']=false;

function ib_connection($ibc_arr) {
  $res=@ibase_connect($ibc_arr[0], $ibc_arr[1], $ibc_arr[2], $ibc_arr[3], $ibc_arr[4], $ibc_arr[5]);
  check_ib_err(true);
  return $res;
}

function ib_execute_arr(&$query, $vlist) {
    $fvlist = array();
    $l=count($vlist);
    for ($i=0;$i<$l;$i++) {
      array_push($fvlist, "\$in_arr[".$i."]");
    }
    $fcode = 'return @ibase_execute($query,'.implode(", ",$fvlist).');';
    $newfunc = @create_function('&$query, $in_arr', $fcode);
    if ($GLOBALS['TEST_MODE']) {
      $pi_str='';
      $l=ibase_num_params($query);
      for ($i=0;$i<$l;$i++) {
        $pi=ibase_param_info($query, $i);
        $pi_str.="\n".var_export($pi, true);
      }

//      print($fcode.":\n".var_export($vlist, true)."\n");
//      ib_print_log($l.":\n".$pi_str.":\n".$fcode.":\n".var_export($vlist, true));
      ib_print_log(var_export($vlist, true));
      return true;
    } else {
//      ib_print_log(var_export($vlist, true));
      return @$newfunc($query, $vlist);
    }
}

function ib_get_result_row(&$dbh, $sql) {
//  print("[$sql]\n");
  $sth = @ibase_query($dbh, $sql);
  if (!($row = @ibase_fetch_assoc($sth))) return false;
  $row=array_change_key_case($row, CASE_UPPER);
  @ibase_free_result($sth);
  return $row;
}

function ib_get_result_id(&$dbh, $sql) {
  $sth = @ibase_query($dbh, $sql);
  if (!($row = @ibase_fetch_assoc($sth))) return false;
  $row=array_change_key_case($row, CASE_UPPER);
  $res=(int)$row['ID'];
  @ibase_free_result($sth);
  unset($row);
  return $res;
}

function ib_get_ex_result_id(&$query, $vlist) {
  $sth = @ib_execute_arr($query, $vlist);
  if ($sth===FALSE) return false;
  if ($sth===TRUE) return 0;
  if (!($row = @ibase_fetch_assoc($sth))) return 0;
  $row=array_change_key_case($row, CASE_UPPER);
  $res=(int)$row['ID'];
  @ibase_free_result($sth);
  unset($row);
  unset($sth);
  return $res;
}

function ib_get_blob_field_names(&$sth, $is_upper=false) {
  $fil = ibase_num_fields($sth);
  $result=array();
  for ($i = 0; $i < $fil; $i++) {
      $fi = ibase_field_info($sth, $i);
      if ($fi['type']=='BLOB') array_push($result, ($is_upper)?strtoupper($fi['name']):$fi['name']);
  }
  return $result;
}

function ib_create_blob($value, &$lnk = NULL) {
   $blob = @ibase_blob_create($lnk);
   if ($blob===false) return false;
   @ibase_blob_add($blob, $value);
   $blob_id = @ibase_blob_close($blob);
   return $blob_id;
}

function ib_get_blob($blob_id, &$lnk = NULL) {
   $blob_data = ($lnk!==NULL)?@ibase_blob_info($lnk, $blob_id):@ibase_blob_info($blob_id);
   $blob_hndl = ($lnk!==NULL)?@ibase_blob_open($lnk, $blob_id):@ibase_blob_open($blob_id);;
   if ($blob_hndl===false) return false;
   $value = @ibase_blob_get($blob_hndl, $blob_data[0]);
   @ibase_blob_close($blob_hndl);
   return $value;
}

function ib_prepare_blob_params(&$query, &$params, &$lnk = NULL) {
  $pil=ibase_num_params($query);
  $result=false;
  for ($i=0;$i<$pil;$i++) {
    $pi=ibase_param_info($query, $i);
    if ($pi['type']=='BLOB') {
       if (!is_null($params[$i]) && $params[$i]!='') {
          $params[$i]=ib_create_blob($params[$i], $lnk);
       } else {
          $params[$i]=NULL;
       }
       $result=true;
    }
  }
  return $result;
}

function ib_get_row_blobs(&$row, &$fn_blobs, &$lnk = NULL) {
  foreach ($fn_blobs as $bfn) if (!is_null($row[$bfn])) $row[$bfn] = ib_get_blob($row[$bfn], $lnk);
}

function ib_prepare_params(&$query, &$params, &$lnk = NULL) {
  $pil=ibase_num_params($query);
  $result=false;
  for ($i=0;$i<$pil;$i++) {
    $pi=ibase_param_info($query, $i);
    if ($pi['type']=='BLOB') {
       if (!is_null($params[$i]) && $params[$i]!='') {
          $params[$i]=ib_create_blob($params[$i], $lnk);
       } else {
          $params[$i]=NULL;
       }
       $result=true;
    } else if ($pi['type']=='CHAR' || $pi['type']=='VARCHAR') {
       if (strlen($params[$i])>$pi['length']) $params[$i]=substr($params[$i], 0, $pi['length']);
    } else if ($pi['type']=='INTEGER') {
       $params[$i]=(int)$params[$i];
    } else if ($pi['type']=='NUMERIC') {
       $params[$i]=(float)$params[$i];
    }
  }
  return $result;
}

function ib_get_ex_result_array(&$query, $vlist, &$lnk = NULL) {
//    global $dmn_main_conn; $daemon=$dmn_main_conn['daemon'];
//  ib_print_log(var_export($vlist, true));
  ib_prepare_params($query, $vlist, $lnk);
  $sth = @ib_execute_arr($query, $vlist);
  if ($sth===FALSE) return false;
  if (!is_resource($sth)) return $sth;
  $res = array();
//  ib_print_log(var_export(array($sth, $vlist), true));
//    $daemon->print_log("*check_link_task ".var_export(array($key, $int_seq),true));
  $blob_names=ib_get_blob_field_names($sth, true);
  while ($row = @ibase_fetch_assoc($sth)) {
//      ib_print_log(var_export($row, true));
      $row=array_change_key_case($row, CASE_UPPER);
      ib_get_row_blobs($row, $blob_names, $lnk);
      array_push($res, $row);
  }
//  ib_print_log('-----------------');
  @ibase_free_result($sth);
  return $res;
}

function ib_get_result_array(&$dbh, $sql) {
  $sth = @ibase_query($dbh, $sql);
  $res = array();

/*
    $coln = ibase_num_fields($sth);
    for ($i = 0; $i < $coln; $i++) {
        $col_info = ibase_field_info($sth, $i);
        print_r($col_info);
    }
*/
  while ($row = @ibase_fetch_assoc($sth)) {
      $row=array_change_key_case($row, CASE_UPPER);
      array_push($res, $row);
  }
  @ibase_free_result($sth);
  return $res;
}

function get_ib_err() {
  $err_code=ibase_errcode();
  if ($err_code==false) return false;
  $s=ibase_errmsg();
  return array($err_code, $s);
}

function check_ib_err($need_exit=false) {
  $err_code=ibase_errcode();
  if ($err_code==false) return false;
  $s=ibase_errmsg();
  $ret="IB error: [$err_code]: ".$s;
  ib_print_log($ret);
  if ($need_exit) exit();
  return true;
}

  function ib_print_log($str) {
    $fp = fopen ('ib.txt', "ab");
    fputs ($fp, $str."\r\n");
    fclose ($fp);
  }

} // end incl_h
?>
