<?php
if (!defined("INC_IB_OBJ_H")){
   define("INC_IB_OBJ_H", TRUE);
   $GLOBALS['TEST_MODE']=false;
   $GLOBALS['DB_OBJ_ERR_LOG_PREFIX']='';
   $GLOBALS['DB_OBJ_ERR_CRITICAL_EXIT']=true;

  $dtf='%d.%m.%Y %H:%M:%S';
//  ini_set('ibase.timestampformat', $dtf);
//  ini_set('ibase.dateformat', $dtf);
//  ini_set('ibase.timeformat', $dtf);

  $GLOBALS['IB_OBJ_TYPES_SIMPLE']=array (
     'INT64'=>'INTEGER',
     'BIT'=>'INTEGER',
     'INTEGER'=>'INTEGER',
     'SMALLINT'=>'INTEGER',
     'CHAR'=>'VARCHAR',
     'VARCHAR'=>'VARCHAR',
     'BLOB'=>'VARCHAR',
     'DATE'=>'DATETIME',
     'TIMESTAMP'=>'DATETIME',
     'FLOAT'=>'FLOAT',
     'DOUBLE'=>'FLOAT',
     'NUMERIC(18,2)'=>'FLOAT',
  );

class ib_obj_request {
  var $dbobj;
  var $handle;
  var $sql;
  var $tr_handle;
  var $result_handle;
  var $func;
  var $fetch_flags;
  var $meta;

  // constructor
  function ib_obj_request($dbobj, $sql) {
    $this->dbobj=$dbobj;
    $this->sql=$sql;
    $this->handle=false;
    $this->tr_handle=false;
    $this->func=false;
    $this->result_handle=false;
    $this->meta=false;
    $this->fetch_flags=IBASE_FETCH_BLOBS;// | IBASE_UNIXTIME;
  }

  function int_exec($pnum=0, $vlist, &$func=false) {
    if (!function_exists($func)) {
      $fvlist = '';
      if ($pnum && $pnum>0) {
        $fvlist = array();
        for ($i=0;$i<$pnum;$i++) array_push($fvlist, '$in_arr['.$i.']');
        $fvlist=','.implode(',',$fvlist);
      }
      $func = @create_function('&$query, $in_arr', 'return @ibase_execute($query'.$fvlist.');');
    }
    return @$func($this->handle, $vlist);
  }

  function prepare() {
    if (!$this->handle || $this->dbobj->transaction()!=$this->tr_handle) {
      $this->close();
      $this->func=false;
      $this->tr_handle=$this->dbobj->transaction();
      $this->handle=ibase_prepare($this->tr_handle, $this->sql);
      if ($this->handle===false) $this->dbobj->check_err($GLOBALS['DB_OBJ_ERR_CRITICAL_EXIT']);
    }
    return $this->handle;
  }

  function meta() {
    return $this->meta;
  }

  function int_prepare_params(&$vlist=false) {
    if (!$this->prepare()) $this->dbobj->check_err($GLOBALS['DB_OBJ_ERR_CRITICAL_EXIT']);
    if ($vlist===false) return false;
    $pil=ibase_num_params($this->handle);
    $result=false;
    for ($i=0;$i<$pil;$i++) {
      $pi=ibase_param_info($this->handle, $i);
      if (is_null($vlist[$i])) {
         $vlist[$i]=NULL;
      } else if ($pi['type']=='BLOB') {
  //       if (!is_null($vlist[$i]) && $vlist[$i]!='') {
//         $vlist[$i]=ib_create_blob($vlist[$i], $lnk);
  //       } else {
  //          $vlist[$i]=NULL;
  //       }
         $result=true;
      } else if ($pi['type']=='CHAR' || $pi['type']=='VARCHAR') {
         if (strlen($vlist[$i])>$pi['length']) $vlist[$i]=substr($vlist[$i], 0, $pi['length']);
      } else if ($pi['type']=='DATE') {
        if (preg_match('/(\d{4}\-\d{2}\-\d{2})\s\d{2}\:\d{2}\:\d{2}/', $vlist[$i], $m)) $vlist[$i]=$m[1];
      } else if ($pi['type']=='INTEGER') {
         $vlist[$i]=(int)$vlist[$i];
      } else if ($pi['type']=='NUMERIC') {
         $vlist[$i]=round((float)$vlist[$i], 5);
      }
    }
    return $pil;
  }            

  function execute($vlist=false) {
    $pn=$this->int_prepare_params($vlist);
    $this->result_handle=$this->int_exec($pn, $vlist, $this->func);
//    if (strpos($this->sql, 'update')!==false || strpos($this->sql, 'insert')!==false) $this->dbobj->print_log($this->sql."\n".var_export($this->result_handle,true)."\n".var_export($vlist,true));
    if ($this->result_handle===false) $this->dbobj->check_err($GLOBALS['DB_OBJ_ERR_CRITICAL_EXIT'], $this->sql."\n".$pn."\n".var_export($vlist,true));
    $this->meta=array();
    if (is_resource($this->result_handle)) {
      $nf=ibase_num_fields($this->result_handle);
      for ($i = 0; $i < $nf; $i++) {
        $fld = ibase_field_info($this->result_handle, $i);
        $fld=array_change_key_case($fld, CASE_UPPER);
        if (array_key_exists('TYPE', $fld)) $fld['TYPE_SIMPLE']=$this->dbobj->int_get_type_simple($fld['TYPE']);
        $this->meta[$fld['ALIAS']]=$fld;
      }
    }
    return $this->result_handle;
  }

  function fetch() {
    if (!$this->result_handle) return false;
    $row=ibase_fetch_assoc($this->result_handle, $this->fetch_flags);
    $this->dbobj->check_err($GLOBALS['DB_OBJ_ERR_CRITICAL_EXIT']);
    if (!$row) return false;
    $row=array_change_key_case($row, CASE_UPPER);
    foreach ($row as $key=>&$val) {
      if (is_null($val)) {
      } else if ($this->meta[$key]['TYPE_SIMPLE']=='FLOAT') {
        $val=sprintf('%.2f', round($val, 2));
      } else if ($this->meta[$key]['TYPE_SIMPLE']=='INTEGER') {
        $val=(int)$val;
      }
    }
    return $row;
  }

  function get_row($vlist=false) {
    if ($this->execute($vlist)===false) return false;
    return $this->fetch();
  }

  function close() {
    if ($this->handle) ibase_free_query($this->handle);
    $this->handle=false;
  }

}

class ib_obj {
  var $server;
  var $dbname;
  var $user;
  var $pass;
  var $link;
  var $transaction;
  var $trans_args;

  // constructor
  function ib_obj($server, $dbname, $user, $pass) {
    $this->server=$server;
    $this->dbname=$dbname;
    $this->user=$user;
    $this->pass=$pass;
    $this->link=false;
    $this->trans_args=IBASE_DEFAULT;
    $this->transaction=false;
    $this->connect();
  }            

  function link() {
    return $this->link;
  }

  function transaction() {
    if ($this->transaction===false) $this->start_transaction();
    return $this->transaction;
  }

  function prepare($sql) {
    $request=new ib_obj_request($this, $sql);
    if ($request->prepare()===false) return false;
    return $request;
  }

  function connect() {
    $this->link=@ibase_connect($this->server.':'.$this->dbname, $this->user, $this->pass, 'WIN1251', 0, 3);
    $this->check_err($GLOBALS['DB_OBJ_ERR_CRITICAL_EXIT']);
    return $this->link;
  }

  function connect_short() {
    $this->link=@ibase_connect($this->server.':'.$this->dbname, $this->user, $this->pass, 'WIN1251');
    $this->check_err($GLOBALS['DB_OBJ_ERR_CRITICAL_EXIT']);
    return $this->link;
  }

  function set_transaction_mode($trans_args=0) {
    if ($trans_args!=0) $this->trans_args=$trans_args;
  }

  function rollback() {
    if ($this->transaction!==false) {
      $res=ibase_rollback($this->transaction);
      if (!$res) $this->check_err($GLOBALS['DB_OBJ_ERR_CRITICAL_EXIT']);
    }
    $this->transaction=false;
  }

  function commit() {
    if ($this->transaction!==false) {
      $res=ibase_commit($this->transaction);
      if (!$res) $this->check_err($GLOBALS['DB_OBJ_ERR_CRITICAL_EXIT']);
    }
    $this->transaction=false;
  }

  function start_transaction($trans_args=0) {
    $this->set_transaction_mode($trans_args);
    $this->transaction=ibase_trans($this->trans_args, $this->link);
    if ($this->transaction===false) $this->check_err($GLOBALS['DB_OBJ_ERR_CRITICAL_EXIT']);
    return $this->transaction;
  }

  function close() {
    return ibase_close($this->link);
  }

  function get_err() {
    $err_code=ibase_errcode();
    if ($err_code==false) return false;
    $s=ibase_errmsg();
    return array($err_code, $s);
  }
  
  function check_err($need_exit=false, $add_text=false) {
    $err=$this->get_err();
    if ($err===false) return false;
    $ret="IB error: [".$err[0]."]: ".$err[1];
    if ($add_text!=false) $ret.="\n".$add_text;
     //."\n".var_export(debug_backtrace(),true);
    $this->print_log($ret);
    if ($need_exit) exit();
    return true;
  }
  
  function print_log($str) {
    $fn='ib.txt';
    $ts=strftime ("[%d.%m.%Y %H:%M:%S]");
    if (@fileperms($fn)!=0777) @chmod($fn, 0777);
    $fp = fopen ($fn, "ab");
    fwrite($fp, $ts." ".$GLOBALS['DB_OBJ_ERR_LOG_PREFIX'].' '.$str."\r\n");
    fclose ($fp);
  }

  function int_get_type_simple($in_type) {
    $in_type=strtoupper($in_type);
    if (array_key_exists($in_type, $GLOBALS['IB_OBJ_TYPES_SIMPLE'])) return $GLOBALS['IB_OBJ_TYPES_SIMPLE'][$in_type];
    return false;
  }

  function get_result_array($sql, $vlist=false) {
    $request=$this->prepare($sql);
    if (!$request) return false;
    if ($request->execute($vlist)===false) return false;
    $result=array();
    while ($row=$request->fetch()) $result[]=$row;
    $request->close();                        
    unset($request);
    return $result;
  }

  function get_result_row($sql, $vlist=false) {
    $request=$this->prepare($sql);
    if (!$request) return false;
    if ($request->execute($vlist)===false) return false;
    $row=$request->fetch();
    $request->close();                        
    unset($request);
    return $row;
  }

  function get_result_id($sql, $vlist=false) {
    $row=$this->get_result_row($sql, $vlist);
    if (array_key_exists('ID', $row)) return $row['ID'];
    return false;
  }

} // end class


} // end incl_h
?>
