<?php

if (!defined("INC_LOG_H")){
   define("INC_LOG_H", TRUE);

   define('GLOB_KEY_LOG_CNF', 'log_inc_cnf');
   $glob[GLOB_KEY_LOG_CNF]=array(
     'logs_enabled'=>true,
     'cache_enabled'=>false,
     'cache_purge_min_time'=>5.0,
     'cache_purge_max_time'=>30.0,
     'cache_write_threshold'=>4096,
   );

   define('GLOB_KEY_LOG_CACHE', 'log_inc_cache');
   $glob[GLOB_KEY_LOG_CACHE]=array();

   function log_get_mta() {
     $mta=explode(" ", microtime());
     $mta[0]=(float)$mta[0];
     $mta[1]=(float)$mta[1];
     return $mta;
   }  

   function log_get_mtf() {
     $mta=log_get_mta();
     return ((float)$mta[1] + (float)$mta[0]);
   }
   
   define('GLOB_KEY_LOG_VARS', 'log_inc_vars');
   $glob[GLOB_KEY_LOG_VARS]=array(
     'last_call_time'=>log_get_mtf(),
     'last_purge_time'=>log_get_mtf(),
   );

  function log_cache_write($fname, $data) {
    global $glob;
    if (!array_key_exists($fname, $glob[GLOB_KEY_LOG_CACHE]) || !is_array($glob[GLOB_KEY_LOG_CACHE][$fname])) {
      $glob[GLOB_KEY_LOG_CACHE][$fname]=array();
    }
    array_push($glob[GLOB_KEY_LOG_CACHE][$fname], $data);
  }
   
  function log_micro_date($format) {
    list($usec, $sec) = explode(" ",microtime());
    $sec=(int)$sec;
    $usec=(float)$usec;
    $usec=round($usec*1000000);
    $usec=sprintf('%06d', $usec);
    $format=str_replace('u', (string)$usec, $format);
    return date($format, $sec);
  }
//log_micro_date('[d.m.Y H:i:s.u] ')

  function log_clear($fname, $del=false, $no_create=false) {
    if ($del) {
       if (file_exists($fname)) return unlink($fname);
       return false;
    }
    if (!$no_create) {
      $fp = fopen ($fname, "w");
//      $fp = fopen ($fname, "ab");
//      ftruncate($fp, 0);
      fclose ($fp);
    }
  }

  function log_print($fname, $str, $microdate=false, $nodate=false, $nl="\n") {
    global $glob;
    if (!$glob[GLOB_KEY_LOG_CNF]['logs_enabled']) return false;
    if (!$nodate && $str!='') {
      if ($microdate) {
        $str=log_micro_date("[d-m-y H:i:s.u] ").$str;
      } else {
        $str=date("[d-m-y H:i:s] ").$str;
      }
    }
    $str.=$nl;
    if (strlen($str)>0) {
      if ($glob[GLOB_KEY_LOG_CNF]['cache_enabled']) {
        log_cache_write($fname, $str);
      } else {
        log_print_($fname, $str);
      }
    }
    
    $glob[GLOB_KEY_LOG_VARS]['last_call_time']=log_get_mtf();
    return true;
  }
  
  function log_print_($file_name, $data) {
    global $glob;
    if (!$glob[GLOB_KEY_LOG_CNF]['logs_enabled']) return false;
    $fp = @fopen ($file_name, "ab");
    if (!$fp) return false;
    if (flock($fp, LOCK_EX)) {
      if (!is_array($data)) $data=array($data);
      $th=$glob[GLOB_KEY_LOG_CNF]['cache_write_threshold'];
      $out_data='';
      while (count($data)>0) {
        $chunk=array_shift($data);
        if (!is_string($chunk)) $chunk=(string)$chunk;
        $out_data.=$chunk;
        $l=strlen($out_data);
        if ($l>$th) {
//          print('log_flush['.$file_name.'] ('.$l.')'."\n" );
          fwrite($fp, $out_data, $l);
          $out_data='';            
        }
      }
      $l=strlen($out_data);
      if ($l>0) fwrite($fp, $out_data, $l);
      flock($fp, LOCK_UN);
    } else {
      fclose ($fp);
      return false;
    }
    fclose ($fp);
    return true;
  }

  function log_purge() {
    global $glob;
    if (!$glob[GLOB_KEY_LOG_CNF]['logs_enabled']) return false;
    $fnlist=array_keys($glob[GLOB_KEY_LOG_CACHE]);
    foreach ($fnlist as $fname) {
//      print('log_purge['.$fname.']'."\n" );
      if (log_print_($fname, $glob[GLOB_KEY_LOG_CACHE][$fname]) || true) unset($glob[GLOB_KEY_LOG_CACHE][$fname]);
    }
    $glob[GLOB_KEY_LOG_VARS]['last_purge_time']=log_get_mtf();
  }
  
  function log_auto_purge() {
    global $glob;
    if (!$glob[GLOB_KEY_LOG_CNF]['logs_enabled']) return false;
    $mtf=log_get_mtf();
    if ( count(array_keys($glob[GLOB_KEY_LOG_CACHE]))>0 &&
        (
        $glob[GLOB_KEY_LOG_VARS]['last_call_time']<$mtf-((float)$glob[GLOB_KEY_LOG_CNF]['cache_purge_min_time']) ||
        $glob[GLOB_KEY_LOG_VARS]['last_purge_time']<$mtf-((float)$glob[GLOB_KEY_LOG_CNF]['cache_purge_max_time'])
        )
        ) {
      log_purge();
    }
  }
  
} // end incl_h
?>
