<?php
/***
*    
* 
* @author DSD
* @version 20040209 by DSD
*
*/

if (!defined("INC_MAIL_H")){
   define("INC_MAIL_H", TRUE);

//include("debug.inc");
include("crypt.inc");
define("PATH_MAIL_TEMP", "logs/mail.tmp");
define("PATH_MAIL_SLOG", "logs/mail.log");
define("PATH_MAIL_LOG", "logs/mail_blob.log");
define("MAIL_SMTP_DEFAULT_SERVER", "mail.911.ru");
define("MAIL_SENDMAIL_PATH", "/usr/sbin/sendmail -i -t");


define("MAIL_ANSWER_REGEXP", "/(\\d+)\\s+(.*)/im");
define("MAIL_POP_ANSWER_REGEXP", "/([^\\s]+)\\s+(.*)/im");
define("MAIL_CHECKING_REGEXP_UNAME", "[a-z\\d]([a-z\\d\\_\\-]*)?");
define("MAIL_CHECKING_REGEXP_HNAME", "[a-z\\d]([a-z\\d\\_\\-]*[a-z\\d])?");
define("MAIL_CHECKING_REGEXP_USER_NAME", "(".MAIL_CHECKING_REGEXP_UNAME."([\\.]".MAIL_CHECKING_REGEXP_UNAME.")*)");
define("MAIL_CHECKING_REGEXP_HOST_NAME", "(".MAIL_CHECKING_REGEXP_HNAME."([\\.]".MAIL_CHECKING_REGEXP_HNAME.")*[\\.][a-z]{2,4})");
define("MAIL_CHECKING_REGEXP", "/^".MAIL_CHECKING_REGEXP_USER_NAME."(\\@)".MAIL_CHECKING_REGEXP_HOST_NAME."$/i");
//define("MAIL_MACRO_REGEXP", '/([^^]*?)(\{\%mail\_([a-z\d\_]+)\%\})([^^]*)/im');
define("MAIL_MACRO_REGEXP", '/([^\x00]*?)(\{\%mail\_([^\s]+)\%\})([^\x00]*)/im');

define("IS_WIN_NT", (PHP_OS=='WINNT')?1:0);
define("MAIL_SMTP_PORT", 25);
define("MAIL_SMTP_TIMEOUT", 10);
define("MAIL_NL", "\r\n");

define("MAIL_LOG_TO_FILE", 1);
define("MAIL_LOG_TO_SCREEN", 2);
define("MAIL_LOG_TO_ARRAY", 3);

  $GLOBALS['MAIL_GEN_UNSENDED'] = false;
  $GLOBALS['MAIL_BOUNDARY_COUNTER'] = 1;
  $GLOBALS['MAIL_LOG_ARRAY'] = array();
  $GLOBALS['MAIL_SLOG_ARRAY'] = array();
  $GLOBALS['MAIL_LOG_TO'] = MAIL_LOG_TO_ARRAY;

  $GLOBALS['PATH_MAIL_TEMPLATES'] = "templates/";

  $mail_scramble_strings = array (
                              0 => '&',
                              1 => '#',
                              2 => '"',
                              3 => '\'',
                              4 => '\\',
                              5 => '/',
                              6 => '<',
                              7 => '>',
                              8 => "\n"
                              );
  $mail_scramble_entities = array (
                              0 => '&amp;',
                              1 => '&#35;',
                              2 => '&quot;',
                              3 => '&#39;',
                              4 => '&#92;',
                              5 => '&#47;',
                              6 => '&lt;',
                              7 => '&gt;',
                              8 => '<br>'
                              );

  function mail_html_scramble($str, $no_spaces=FALSE) {
       global $mail_scramble_strings,$mail_scramble_entities;
       if (!$no_spaces) return str_replace(array("\r", ' '),array('', '&nbsp;'),str_replace($mail_scramble_strings,$mail_scramble_entities,$str));
       return str_replace("\r",'',str_replace($mail_scramble_strings,$mail_scramble_entities,$str));
  }

  function mail_html_unscramble($str) {
     global $mail_scramble_strings, $mail_scramble_entities;
     return str_replace('&nbsp;',' ',str_replace($mail_scramble_entities,$mail_scramble_strings,$str));
  }


function mail_debug_handler($errno, $errstr, $errfile, $errline) {
      $err_const='';
      $exit=1;
      switch ($errno) {
        case E_ERROR:          $err_const='Fatal error'; $exit=0; break;
        case E_WARNING:        $err_const='Warning'; $exit=0; break;
        case E_PARSE:          $err_const='Parse error'; $exit=0; break;
//        case E_NOTICE:         $err_const='Notice'; $exit=0; break;
        case E_USER_ERROR:     $err_const='Fatal error(user-generated)'; $exit=0; break;
        case E_USER_WARNING:   $err_const='Warning(user-generated)'; $exit=0; break;
        case E_USER_NOTICE:    $err_const='Notice(user-generated)'; $exit=0; break;
      }
      if ($exit) return;
//      $dbg = debug_get_backtrace();
//      if (count($dbg)) array_pop($dbg);
      array_push($GLOBALS['MAIL_ERRORS'], array($errno, $errstr, $errfile, $errline));
//      array_push($GLOBALS['MAIL_ERRORS'], array($errno, $errstr, $errfile, $errline, $dbg));
      return;
}

function mail_check_email($email) {
  if (preg_match(MAIL_CHECKING_REGEXP, $email, $matches) && strlen($matches[1])<=32) return array($matches[1], $matches[6]);
  return FALSE;                      
}

function mail_get_smtp_server($hostname) {
  $hosts=mail_getmxrr($hostname);
  if (!$hosts || !is_array($hosts) || count($hosts)<1) return false;
  return $hosts[0];
}

function mail_get_smtp_servers($hostname) {
  $hosts=mail_getmxrr($hostname);
  if (!$hosts || !is_array($hosts) || count($hosts)<1) return false;
  return $hosts;
}

function mail_getmxrr($hostname) {
  if (function_exists('getmxrr')) {
      if (!getmxrr($hostname, $hosts)) return FALSE;
  } else if (IS_WIN_NT) {
      if (!mail_getmxrr_winNT($hostname, $hosts)) return FALSE;
  } else {
      if (!mail_getmxrr_win98($hostname, $hosts)) return FALSE;
  }
  if (count($hosts)<1) return FALSE;
  return $hosts;
}

function mail_myexec($cmd, &$output) {
    $descrspec = array(
      0 => array("pipe", "r"),
      1 => array("pipe", "w"),
      2 => array("pipe", "w")
    );
    if (!is_array($output)) $output = array();
    $process = proc_open($cmd, $descrspec, $pipes);
    if (is_resource($process)) {
       fclose($pipes[0]);
       fclose($pipes[2]);
       while(!feof($pipes[1])) array_push($output, preg_replace('/[\\r\\n]/im', "", fgets($pipes[1], 1024)));
       fclose($pipes[1]);
       return proc_close($process);
    }
    return FALSE;
}                   

function mail_getmxrr_win98($hostname, &$mxhosts){
    $descrspec = array(
      0 => array("pipe", "r"),
      1 => array("pipe", "w"),
      2 => array("pipe", "w")
    );
    $output = array();
    if (!is_array($mxhosts)) $mxhosts = array();
    $process = proc_open("nslkup.exe", $descrspec, $pipes);
    if (is_resource($process)) {
       fclose($pipes[2]);
       fputs($pipes[0], "set type=MX\n");
       fputs($pipes[0], "set server=195.209.49.52\n");
       fputs($pipes[0], "$hostname\n");
       fputs($pipes[0], "bye\r\n");
       fclose($pipes[0]);
       while(!feof($pipes[1])) {
           array_push($output, preg_replace('/[\\r\\n]/im', "", fgets($pipes[1], 1024)));
       }
       fclose($pipes[1]);
       proc_close($process);
       $ocnt = count($output);
       for ($i=0;$i<$ocnt;$i++) {
           if (preg_match("/^[\s]+10\\,\\x20(.*)\\.$/im", $output[$i], $matches)) {
               array_push($mxhosts, $matches[1]);
           }
       }
//       _print_log("lkup.txt", join("\n",$mxhosts));
       return $mxhosts;
    }
    return FALSE;
}

function mail_checkdnsrr_winNT($host, $type='') {
   if(!empty( $host )) {
       # Set Default Type:
       if( $type == '' ) $type = "MX";
       @mail_myexec( "nslookup -type=$type $host", $output);
       while(list($k, $line) = each($output)) {
           # Valid records begin with host name:
           if(eregi("^$host", $line)) {
               # record found:
               return true;
           }
       }
       return false;
   }
}

function mail_getmxrr_winNT($hostname, &$mxhosts){
   if (!is_array($mxhosts)) $mxhosts = array();
   if (!empty($hostname)) {
       $ret = @mail_myexec("nslookup -type=MX $hostname", $output);
       while (list($k, $line)=each($output)) {
           # Valid records begin with hostname:
           if (ereg("^$hostname\tMX preference = ([0-9]+), mail exchanger = (.*)$", $line, $parts)) {
               $mxhosts[ $parts[1] ] = $parts[2];
           }
       }
       if (count($mxhosts)) {
           reset($mxhosts);
           ksort($mxhosts);
           $i = 0;
           while (list($pref, $host)=each($mxhosts)) {
               $mxhosts2[$i] = $host;
               $i++;
           }
           $mxhosts = $mxhosts2;
           return true;
       } else {
           return false;
       }
   }         
}

function mail_get_file_contents($filename) {
  return @file_get_contents($filename);

  $fp = @fopen($filename, "rb");
//  $fp = fopen($filename, "rb");
  $temp = "";
  if (!($fp)) return false;
  while (!feof($fp)) $temp .= fread($fp, 4096);
  fclose ($fp);
  return $temp;
}

function mail_put_file_contents($filename, $contents='') {
   if (file_exists($filename)) unlink($filename);
   if (!($fp = @fopen ($filename, "wb"))) return false;
   fwrite ($fp, $contents);
   fclose ($fp);
   return true;
}

function mail_recv_answer($fp, $numb) {
  $wrstr = '';
  if (!feof($fp)) {
      $wrstr = fgets($fp, 1024);
      if (!$wrstr) $wrstr = "Error!\n";
      mail_print_log("<- ".$wrstr, TRUE);
      if (preg_match(MAIL_ANSWER_REGEXP, $wrstr, $matches) &&
          $matches[1]==$numb) return array($matches[1], trim($matches[2]));
  }
  return FALSE;
}

function mail_recv_pop_answer($fp, $res) {
  $wrstr = '';
  if (!feof($fp)) {
      $wrstr = fgets($fp, 1024);
      if (!$wrstr) $wrstr = "Error!\n";
      mail_print_log("<- ".$wrstr, TRUE);
      if (preg_match(MAIL_POP_ANSWER_REGEXP, $wrstr, $matches) &&
          strtoupper(trim($matches[1]))==strtoupper(trim($res))) return array($matches[1], trim($matches[2]));
  }
  return FALSE;
}

function mail_recv_pop_answer_ex($fp) {
  $r = array();
  $term = false;
  while (!$term) {
     $line=mail_recv_pop_line($fp);
     if ($line===false) {
         $term = true;
     } else if (strlen($line)>0 && $line{0}=='.') {
         if (strlen($line)>1 && $line{1}=='.') {
           $line=substr($line, 1);
         } else {
           $term = true;
         }
     }
     if (!$term) $r[]=$line;
  }
  return $r;
}

function mail_recv_pop_line($fp) {
  $wrstr = '';
  if (!feof($fp)) {
      $wrstr = fgets($fp, 1024);
      if (!$wrstr) $wrstr = "Error!\n";
      mail_print_log("<- ".$wrstr, TRUE);
      return $wrstr;
  }
  return FALSE;
}

function mail_send_str($fp, $str, $no_log=false) {
      $str = preg_replace('/([^\\r]|^)(\\n)/im', "\\1\r\\2", $str);
      $r = fwrite($fp, $str, strlen($str));
      if ($r<1) $str = "Error!: ".$str;
//      mail_print_log(sprintf("-> [%04d]",$r).$str, TRUE);
      if ($no_log) {
         mail_print_log(sprintf("-> ",$r)."*********\r\n", TRUE);
      } else {
         mail_print_log(sprintf("-> ",$r).$str, TRUE);
      }
}

function mail_parse_macros($line, $rec) {
  $text = $line;
  $res = array();
  while (preg_match(MAIL_MACRO_REGEXP, $text, $matches)) {
     $fnd = $matches[2];
     $farr = explode('_',strtoupper($matches[3]));
     $_rec = $rec;
//     print("\n\n\n".var_export($farr, true)."\n\n\n");
     foreach ($farr as $item) {
        if (!is_array($_rec) || !array_key_exists($item, $_rec)) { $_rec=NULL; break; }
        $_rec = $_rec[$item];
     }
     if (!is_null($_rec)) $fnd = $_rec;
     array_push($res, $matches[1]);
     array_push($res, $fnd);
     $text=$matches[4];
  }
  array_push($res, $text);
  $line = join('',$res);
//  debug_sys_handler(E_WARNING, var_export($line, true), 'mail_parse_macros', 1);
  return $line;
}

function mail_send($rec) {
   if ($rec['ERROR']) return false;
   $GLOBALS['MAIL_ERRORS']=array();
   $GLOBALS['MAIL_LOG_ARRAY'] = array();
   $GLOBALS['MAIL_SLOG_ARRAY'] = array();
   $_mail_old_ehandler = set_error_handler('mail_debug_handler');
   $res = false;
   $hosts = $rec['TO']['SMTP'];
   if ($hosts && is_array($hosts) && count($hosts)>0) {
       foreach ($hosts as $host) {
          $res = _mail_send($rec, $host);
          if ($res) break;
       }
   } else if (is_string($hosts)) {
       $res = _mail_send($rec, $hosts);
   }
//   if (!$res) $res = __mail_send(0, $rec);
//   if (!$res) _mail_by_sendmail2($rec);
   restore_error_handler();
//   debug_sys_mess(E_WARNING, var_export($GLOBALS['MAIL_ERRORS'], true), 'aa', 1);
//   exit;
   return $res; 
}

function _mail_send($rec, $smtp) {
  if (!($rec && $rec['FROM'] && $rec['TO'])) return FALSE;

  mail_print_log("Session to [".$rec['TO']['EMAIL']."]-[".$smtp.":".MAIL_SMTP_PORT."]: ");
  mail_print_log("\n\n", TRUE);

  $r = false;
  $fp = fsockopen ($smtp, MAIL_SMTP_PORT, $errno, $errstr, MAIL_SMTP_TIMEOUT);
//  if (!$fp) $fp = fsockopen(MAIL_SMTP_DEFAULT_SERVER, MAIL_SMTP_PORT, $errno, $errstr, MAIL_SMTP_TIMEOUT);
  if ($fp) {
     $r = __mail_send($fp, $rec);
     fclose ($fp);
  }
  mail_print_log("\nSession ", TRUE);
  mail_print_log(($r)?"success":"fail[$fp, $errno, $errstr]");
  mail_print_log("\n");
  mail_print_log("\n".str_repeat("-", 80)."\n\n", TRUE);
  return $r;
}

function mail_get_sendmail_path() {
   return ini_get("sendmail_path");
}

function mail_set_sendmail_path() {
   return ini_set("sendmail_path", MAIL_SENDMAIL_PATH);
}

function _mail_by_sendmail($rec) {
    $fp = popen(mail_get_sendmail_path(), "w");
    if ($fp===false) return false;
    __mail_send($fp, $rec, true);
    pclose($fp);
    return true;
}

function _mail_by_sendmail1($rec) {
    $descrspec = array(
      0 => array("pipe", "r"),
      1 => array("pipe", "w"),
      2 => array("pipe", "w")
    );
    mail_print_log("\n".mail_get_sendmail_path(), TRUE);
    $process = proc_open(mail_get_sendmail_path(), $descrspec, $pipes);
    if (is_resource($process)) {
       mail_print_log("\npipe opened ok ", TRUE);
       __mail_send($pipes[0], $rec, true);
       while(!feof($pipes[1])) mail_print_log("\nout1: ".fgets($pipes[1], 1024));
       while(!feof($pipes[2])) mail_print_log("\nout2: ".fgets($pipes[2], 1024));
       fclose($pipes[0]);
       fclose($pipes[1]);
       fclose($pipes[2]);
       proc_close($process);
       return true;             
    }
    mail_print_log("\npipe opened fail ", TRUE);
    return false;
}

function _mail_by_sendmail2($rec) {
    $fp = fopen (PATH_MAIL_TEMP, "a");
    if ($fp===false) return false;
    __mail_send($fp, $rec, true);
    fclose ($fp);
    exec(mail_get_sendmail_path()." < ".PATH_MAIL_TEMP);
    return true;
}                                     
                                      
function __mail_send($fp, $rec, $noadd=false) {
      $wrstr = '';
      if ($fp<=0) {
          $ncount = count($rec['BODY_LINES']);
          $headers = "";
          $body = "";
          $hs = false;
          for ($i=0;$i<$ncount;$i++) {
            if ($hs) {
               $body .= mail_parse_macros($rec['BODY_LINES'][$i], $rec)."\n";
            } else {
               if (strlen(trim($rec['BODY_LINES'][$i]))<1) {
                 $hs = true;
               } else {
                 if (!preg_match("/^To:(.*)/im", $rec['BODY_LINES'][$i])) $headers .= mail_parse_macros($rec['BODY_LINES'][$i], $rec)."\n";
               }                                    
            }
          };

           $_to = "\"".$rec['TO']['NAMEF']."\" <".$rec['TO']['EMAIL'].">";
           $_subj = $rec[SUBJECT][F];
          mail_set_sendmail_path();
          mail($_to, $_subj, $body, $headers);
          return TRUE;
      }

      if (!$noadd) {
          if (!mail_recv_answer($fp, 220)) return FALSE;
          mail_send_str($fp, "HELO ".$rec['FROM']['HOST']."\n");
          if (!mail_recv_answer($fp, 250)) return FALSE;

          if ($rec['AUTH']) {
              mail_send_str($fp, "AUTH LOGIN\n");
              if (!$r=mail_recv_answer($fp, 334)) return FALSE;
                   if (trim(strtoupper(base64_decode($r[1])))!='USERNAME:') return FALSE;
                   mail_send_str($fp, base64_encode($rec['AUTH']['LOGIN'])."\n"); 
              if (!$r=mail_recv_answer($fp, 334, $r)) return FALSE;
                   if (trim(strtoupper(base64_decode($r[1])))!='PASSWORD:') return FALSE;
                   mail_send_str($fp, base64_encode($rec['AUTH']['PASSWORD'])."\n", true);
              if (!mail_recv_answer($fp, 235)) return FALSE;
          }

//SMTP: 05:44:26 [tx] AUTH LOGIN
//SMTP: 05:44:26 [rx] 334 VXNlcm5hbWU6
//SMTP: 05:44:26 [tx] YW5kcmV3
//SMTP: 05:44:26 [rx] 334 UGFzc3dvcmQ6
//SMTP: 05:44:26 [tx] Y2VsZXJvbg==
//SMTP: 05:44:26 [rx] 235 Authentication successful

          mail_send_str($fp, "MAIL FROM: <".$rec['FROM']['EMAIL'].">\n");
          if (!mail_recv_answer($fp, 250)) return FALSE;
          mail_send_str($fp, "RCPT TO: <".$rec['TO']['EMAIL'].">\n");
          if (!mail_recv_answer($fp, 250)) return FALSE;
          mail_send_str($fp, "DATA\n");
          if (!mail_recv_answer($fp, 354)) return FALSE;
      }

      $ncount = count($rec['BODY_LINES']);
      $body = "";
      for ($i=0;$i<$ncount;$i++) {
         $cln=mail_parse_macros($rec['BODY_LINES'][$i], $rec)."\r\n";
         if (strlen($cln)>0 && $cln{0}=='.') $cln='.'.$cln;
         mail_send_str($fp, $cln);
      }

      mail_send_str($fp, "\n");
      mail_send_str($fp, ".\n");
      if (!$noadd) {
        if (!mail_recv_answer($fp, 250)) return FALSE;
        mail_send_str($fp, "QUIT\n");
        if (!mail_recv_answer($fp, 221)) return TRUE;
      }
      return TRUE; 
}

function mail_rec($adr, $no_resolve=false) {
  $rec = array();
  $adr = preg_replace('/[\\r\\n]/im', "", $adr);
  $arr = preg_split("/[\s]+/", $adr, 2);
  if ($amail = mail_check_email($arr[0])) {
      $rec['EMAIL'] = trim($arr[0]);    
      $rec['NAME'] = trim(($arr[1])?$arr[1]:$amail[0]);
      $rec['NAMEF'] = mail_str_b64_enc($rec['NAME']);
      $rec['HOST'] = trim($amail[1]);
      if (!$no_resolve) $rec['SMTP'] = mail_get_smtp_servers($rec['HOST']);
      return $rec;
  }
  return FALSE;
}
                                         
function mail_print_log($str, $blob=false) {
   if ($GLOBALS['MAIL_LOG_TO']==MAIL_LOG_TO_FILE) {
     _print_log(PATH_MAIL_LOG, $str);
     if (!$blob) _print_log(PATH_MAIL_SLOG, $str);
     return true;
   } else if ($GLOBALS['MAIL_LOG_TO']==MAIL_LOG_TO_SCREEN) {
//     if (!$blob)
     print($str);
     return true;
   } else if ($GLOBALS['MAIL_LOG_TO']==MAIL_LOG_TO_ARRAY) {
     array_push($GLOBALS['MAIL_LOG_ARRAY'], $str);
     if (!$blob) array_push($GLOBALS['MAIL_SLOG_ARRAY'], $str);
     return true;
   }
   return false;
}

function _print_log($fname, $str) {
  $fp = fopen ($fname, "a");
  fputs ($fp, $str);
  fclose ($fp);
}

function mail_str_b64_enc($str) {
  return "=?windows-1251?B?".base64_encode($str)."?=";
}

function mail_send_auto($email_to="", $email_from='dsd@sharikoff.ru ', $subject="", $head="", $text="", $tmpl="mail.tmpl") {
   if (!$email_to || !$email_from || !$text) return false;
   if (!$subject) $subject="";
   if (!$head) $head="";
   if (!$tmpl) $tmpl="mail.tmpl";
   $record = mail_new_rec($email_from, $email_to, mail_get_file_contents($GLOBALS['PATH_MAIL_TEMPLATES'].$tmpl));
//   debug_sys_handler(E_WARNING, html_scramble(var_export($record, true))."[".IS_WIN_NT."]", 'mail_parse_macros', 1);
   if (!$record['TO']['SMTP']) $record['TO']['SMTP']=MAIL_SMTP_DEFAULT_SERVER;
//   if (!$record['TO']['SMTP']) return false;
   $record['MESSAGEID'] = mail_new_message_id($record['FROM']['HOST']);
   $record['SUBJECT'] = array("P"=>$subject, "F"=>mail_str_b64_enc($subject));
   $record['DATE'] = array("F"=>date ("D, d M Y H:i:s O"));
   $record['HEAD'] = $head;
   $record['BODYTEXT'] = $text;
   $record['BODYHTML'] = mail_html_scramble($text);
   return mail_send($record);
}

function mail_send_terr($email_to="", $subject="", $text="") {
    $arr_body = preg_split("/\n(\r)?/", $text);
    return mail_send_auto($email_to,
                   'paladin@911.ru Hamochka',
                   $subject,
                   array_shift($arr_body),
                   implode("\n",$arr_body),
                   "mail.tmpl");
}



















                 





function mail_open_template(&$rec, $tmpl) {
//   print("\n\n\n".var_export($rec, true)."\n\n\n");
   if ($rec['ERROR']) return $rec;
   if ($tmpl=='' || !file_exists($GLOBALS['PATH_MAIL_TEMPLATES'].$tmpl)) {
      $rec['ERROR']="Cannot open mail template [".$GLOBALS['PATH_MAIL_TEMPLATES'].$tmpl."]";
      trigger_error($rec['ERROR'], E_USER_WARNING);
      return $rec;
   }
   $rec['TEMPLATE']=array();
   $rec['TEMPLATE']['CONTENTS'] = mail_get_file_contents($GLOBALS['PATH_MAIL_TEMPLATES'].$tmpl);
   $rec['TEMPLATE']['INCLUDES'] = array();

   $pi=$rec["PARSE_IMAGES"];
   $rec["PARSE_IMAGES"]=true;
   $rec['TEMPLATE']['CONTENTS'] = mail_tmpl_parse_attachs($rec, $rec['TEMPLATE']['CONTENTS']);
   $rec["PARSE_IMAGES"]=$pi;

   $rec['HEADER'] = mail_tmpl_parse_attachs($rec, $rec['HEADER']);
   $rec['TEXT'] = mail_tmpl_parse_attachs($rec, $rec['TEXT']);

   $rec['HEADER'] = mail_tmpl_parse_params($rec, $rec['HEADER']);
   $rec['TEXT'] = mail_tmpl_parse_params($rec, $rec['TEXT']);
   $rec['SUBJECT'] = mail_tmpl_parse_params($rec, $rec['SUBJECT']);

   $rec['TEMPLATE']['CONTENTS'] = mail_tmpl_parse_params($rec, $rec['TEMPLATE']['CONTENTS']);

   return $rec;
}

function mail_tmpl_parse_attachs(&$rec, $c) {
   $rarr=array();
   while (preg_match ('/([^\x00]*?)(<[^\<\>]+>)([^\x00]*)/m', $c, $m)) {
      array_push($rarr, $m[1]);
      array_push($rarr, mail_template_p($m[2], $rec));
      $c = $m[3];
   }
   array_push($rarr, $c);
   return implode('', $rarr);
}

function mail_tmpl_parse_params(&$rec, $c) {
   return  mail_tmpl_replace_params(&$rec, $c);
}                     

function mail_tmpl_replace_params(&$rec, $c) {
   $rarr=array();
   while (preg_match('/([^\x00]*?)\{\%([^\%\}\s]+?)\%\}([^\x00]*)/m', $c, $m)) {
      array_push($rarr, $m[1]);
      array_push($rarr, mail_get_tmpl_tag($m[2], $rec));
      $c = $m[3];
   }
   array_push($rarr, $c);
   return implode('', $rarr);
}                     

function mail_template_p($tag, &$rec) {
  if (preg_match('/^\<\//', $tag)) return $tag;
    if (preg_match('/^\<attach\_file\s/i', $tag)) {
        if (preg_match('/([^\x00]*?[\s]+)(href=)([^\s\>]+)([^\x00]*)/m', $tag, $m)) {
            $s=mail_get_include_tag($m[3], $rec, true);
            return '';
            return $m[1].$m[2].$s.$m[4];
        }
    }
    if ($rec["PARSE_IMAGES"] && preg_match('/^\<img\s/i', $tag)) {
        if (preg_match('/([^\x00]*?[\s]+)(src=)([^\s\>]+)([^\x00]*)/m', $tag, $m)) {
            $s=mail_get_include_tag($m[3], $rec);
            return $m[1].$m[2].$s.$m[4];
        }
    }
    if ($rec["PARSE_LINKS"] && preg_match('/^\<a\s/i', $tag)) {
        if (preg_match('/([^\x00]*?[\s]+)(href=)([^\s\>]+)([^\x00]*)/m', $tag, $m)) {
            $s=mail_get_include_ref($m[3], $rec, true);
            return $m[1].$m[2].$s.$m[4];
        }
    }
    if ($rec["PARSE_IMAGES"] && preg_match('/([^\x00]*?[\s]+)(background=)([^\s\>]+)([^\x00]*)/m', $tag, $m)) {
            $s=mail_get_include_tag($m[3], $rec);
            return $m[1].$m[2].$s.$m[4];
    }
  return $tag;
}

function mail_strip_fname($fn) {
  if (preg_match('/^([\s\"\\\']+)([^\s]+)([\s\"\\\']+)$/m', $fn, $m)) {
     return $m[2];
  }
  return $fn;
}                             

function mail_get_file_ext($fname) {
   $pi=pathinfo($fname);
   return $pi["extension"];
}

function mail_extract_fname($fpath) {
   $pi=pathinfo($fpath);
   return $pi["basename"];
}

function mail_put_include($fname, &$rec, $create_attachments=false) {
   if (!$rec['TEMPLATE']['INCLUDES'][$fname]) {
      $fn=($rec['DEBUG_SHORT_NAMES'])?mail_extract_fname($fname):$fname;
      if ($rec['CALLBACK']) $rec['CALLBACK']("downloading \"".$fn."\" ... ");
      $fc=mail_check_file($fname);
      if ($fc) {
         if ($rec['CALLBACK']) $rec['CALLBACK']("OK (".strlen($fc)." bytes), packing... ");
         $cid=mail_gen_cid($rec);
         $rec['TEMPLATE']['INCLUDES'][$fname]=array($cid, base64_encode($fc), $create_attachments, !$create_attachments);
         if ($rec['CALLBACK']) $rec['CALLBACK']("OK [".$cid."]\n");
      } else {
         if ($rec['CALLBACK']) $rec['CALLBACK']("FAIL ".$fn."\n");
      }
   } else if (!$create_attachments) $rec['TEMPLATE']['INCLUDES'][$fname][3]=true;
}

function mail_get_include_ref($_fname, &$rec, $create_attachments=false) {
   $fname=mail_strip_fname($_fname);
   $ext=strtolower(mail_get_file_ext($fname));
   if ($ext!='jpg' &&
       $ext!='png' &&
       $ext!='gif') return $_fname;
   mail_put_include($fname, $rec, $create_attachments);
   return $_fname;
   if ($rec['TEMPLATE']['INCLUDES'][$fname]) return '"cid:'.$rec['TEMPLATE']['INCLUDES'][$fname][0].'"';
   if ($create_attachments && !$rec['TEMPLATE']['INCLUDES'][$fname][2]) $rec['TEMPLATE']['INCLUDES'][$fname][2]=$create_attachments;
   return '"cid:ERROR"';
}


function mail_get_include_tag($fname, &$rec, $create_attachments=false) {
   $fname=mail_strip_fname($fname); 
   mail_put_include($fname, $rec, $create_attachments);
   if ($rec['TEMPLATE']['INCLUDES'][$fname]) return '"cid:'.$rec['TEMPLATE']['INCLUDES'][$fname][0].'"';
   if ($create_attachments && !$rec['TEMPLATE']['INCLUDES'][$fname][2]) $rec['TEMPLATE']['INCLUDES'][$fname][2]=$create_attachments;
   return '"cid:ERROR"';
}

function mail_get_tmpl_tag($pname, &$rec) {
   return mail_parse_macros('{%'.$pname.'%}', $rec);
}

function mail_gen_cid(&$rec) {
   return sprintf("%08X",$rec['CID_NUM']++).'$'.sprintf("%08X",crypt_gen_uni_id()).'$'.mail_get_message_id($rec['MESSAGEID']);
}

function mail_check_file($fname) {
   $cwd=getcwd();
   $fc=false;
   if (chdir($GLOBALS['PATH_MAIL_TEMPLATES'])) $fc=mail_get_file_contents($fname);
   chdir($cwd);
   return $fc;
}

function mail_format_date($tm) {
  return date ("D, d M Y H:i:s O", $tm);
}

function mail_get_message_id($mid) {
  return sprintf("%08X",$mid['RND']).'$'.sprintf("%08X",$mid['TIME']).'@'.$mid['DOMAIN'];
}

function mail_new_message_id($domain="SHARIKOFF") {
  $mid = array();
  $mid['DOMAIN']=$domain;
  $mid['RND']=crypt_gen_uni_id();
  $mid['TIME']=time();
  return $mid;
}

function mail_new_boundary($bid=0, $mid=0) {
   if ($mid==0) $mid=$GLOBALS['MAIL_BOUNDARY_COUNTER']++;
   return '----=_NextPart_'.sprintf("%08X",$bid).'_'.sprintf("%08X",$mid).'_'.sprintf("%08X",crypt_gen_uni_id()).'.'.sprintf("%08X",time());
}

function mail_new($in_rec) {
   if (!$in_rec['TO'] || !$in_rec['FROM'] || !$in_rec['BODY']) return false;
   if (!$in_rec['SUBJECT']) $in_rec['SUBJECT']="";
   if (!$in_rec['HEADER']) $in_rec['HEADER']="";

   $record = array();
   $record['TO']=mail_rec($in_rec['TO'], $in_rec['NO_RESOLVE_SMTP']);
   $record['FROM']=mail_rec($in_rec['FROM'], $in_rec['NO_RESOLVE_SMTP']);
  
   if (!$record['TO']['SMTP']) $record['TO']['SMTP']=MAIL_SMTP_DEFAULT_SERVER;

   $record['MESSAGEID'] = mail_new_message_id($record['FROM']['HOST']);
   $record['BOUNDARY'] = mail_new_boundary();

   if ($in_rec['AUTH'] && $in_rec['AUTH']['LOGIN'] && $in_rec['AUTH']['PASSWORD']) $record['AUTH'] = $in_rec['AUTH'];

   $record['SUBJECT'] = $in_rec['SUBJECT'];
   $record['DATE'] = time();
   $record['HEADER'] = $in_rec['HEADER'];
   $record['TEXT'] = $in_rec['BODY'];
   $record['CID_NUM'] = 1;
   return $record;
}
                                         
function mail_new_rec($from, $to, $text) {
  $rec = array();
  $rec['FROM']=mail_rec($from);
  $rec['TO']=mail_rec($to);
  $arr_text = preg_split("/[\n]/",preg_replace('/[\\r]/im', "", $text));

  $ncount = count($arr_text);
  for ($i=0;$i<$ncount;$i++) {
        if ($arr_text[$i][0]=='.') $arr_text[$i] = '.'.$arr_text[$i];
  }
  $rec['BODY_LINES']=$arr_text;
  $rec['BODY']=implode("\r\n",$arr_text);
  return $rec;
}

function mail_gen_headers($rec) {
    $arr = array();
    if ($rec['ERROR']) return $arr;
    $arr[]='Return-Path: <'.$rec['FROM']['EMAIL'].'>';
    $arr[]='Message-ID: <'.mail_get_message_id($rec['MESSAGEID']).'>';
    $arr[]='Reply-To: "'.$rec['FROM']['NAMEF'].'" <'.$rec['FROM']['EMAIL'].'>';
    $arr[]='From: "'.$rec['FROM']['NAMEF'].'" <'.$rec['FROM']['EMAIL'].'>';
    $arr[]='To: "'.$rec['TO']['NAMEF'].'" <'.$rec['TO']['EMAIL'].'>';
    $arr[]='Subject: '.mail_str_b64_enc($rec['SUBJECT']);
    $arr[]='Date: '.mail_format_date($rec['DATE']);
    $arr[]='Organization: '.$rec['ORGANIZATION'];
    $arr[]='MIME-Version: 1.0';
    $arr[]='Content-Type: multipart/related;';
    $arr[]="\ttype=\"multipart/alternative\";";
    $arr[]="\tboundary=\"".$rec['BOUNDARY']."\"";
    $arr[]='X-Priority: 3';
    $arr[]='X-MSMail-Priority: Normal';
    $arr[]='X-Mailer: Microsoft Outlook Express 6.00.2720.3000';
    $arr[]='X-MimeOLE: Produced By Microsoft MimeOLE V6.00.2600.0000';
    if ($GLOBALS['MAIL_GEN_UNSENDED']) $arr[]='X-Unsent: 1';
   return $arr;
}

function mail_compile(&$mail) {
    if ($mail['ERROR']) return $arr;
    $nl = "\r\n";
//    $b=mail_new_boundary();
    $b=$mail['BOUNDARY'];
    $b1=mail_new_boundary();
    $b2=mail_new_boundary();
                                
    if ($mail['CALLBACK']) $mail['CALLBACK']("compiling mail body ... ");

    $rarr=mail_gen_headers($mail);
    $rarr[]="";
    $rarr[]="";
    $rarr[]="This is a multi-part message in MIME format.";
    $rarr[]="";
    $rarr[]="";
    $rarr[]="";

    $rarr[]="--$b";
    $rarr[]="Content-Type: multipart/alternative;";
    $rarr[]="\tboundary=\"$b1\"";
    $rarr[]="";
    $rarr[]="";
    $rarr[]="";


  if (1) { // plaintext version
    $rarr[]="--$b1";
    $rarr[]="Content-Type: text/plain;";
    $rarr[]="\tcharset=\"windows-1251\"";

    $content = strip_tags($mail['HEADER']).$nl.$nl.strip_tags($mail['TEXT']);
    if (preg_match('/<body[^<>]*?\>([^\x00]*)<\/body[^<>]*?>/im', $mail['TEMPLATE']['CONTENTS'], $m)) {
        $content = mail_html_unscramble(strip_tags($m[1]));
//         preg_replace('/<br>/',"\n",);
    }
    $content = mail_strip_breaks($content);

    $rarr[]="Content-Transfer-Encoding: quoted-printable";
//    $rarr[]="Content-Transfer-Encoding: none";
    $rarr[]="";
    $rarr=array_merge($rarr, mail_qp_encode($content));
//    $rarr[]=$content;
    $rarr[]="";
    $rarr[]="";
    $rarr[]="";
  }
                                 

  if (1) { // HTML version
    $rarr[]="--$b1";
    $rarr[]="Content-Type: text/html;";
    $rarr[]="\tcharset=\"windows-1251\"";
//    $rarr[]="Content-Transfer-Encoding: base64";
//    $rarr[]="Content-Transfer-Encoding: none";
    $rarr[]="Content-Transfer-Encoding: quoted-printable";

    $rarr[]="";
//    $rarr[]=chunk_split(base64_encode($mail['TEMPLATE']['CONTENTS']));
    $rarr=array_merge($rarr, mail_qp_encode($mail['TEMPLATE']['CONTENTS']));
    $rarr[]="";                         
//    $rarr[]=$mail['TEMPLATE']['CONTENTS'];
    $rarr[]="";
    $rarr[]="";
    $rarr[]="";
  }

  $rarr[]="--$b1--";
  $rarr[]="";
  $rarr[]="";
  $rarr[]="";


  if ($mail['CALLBACK']) $mail['CALLBACK']("OK\n");
  if ($mail['CALLBACK']) $mail['CALLBACK']("compiling includes...\n");
    
  foreach (array_keys($mail['TEMPLATE']['INCLUDES']) as $fname) {
       $pi = pathinfo($fname);
       $fn=($rec['DEBUG_SHORT_NAMES'])?mail_extract_fname($fname):$fname;

       if ($mail['CALLBACK']) $mail['CALLBACK']("   \"$fn\" (".strlen($mail['TEMPLATE']['INCLUDES'][$fname][1])." bytes) ... ");

       if ($mail['TEMPLATE']['INCLUDES'][$fname][3]) {
           $rarr[]="--$b";
           $rarr[]="Content-Type: application/octet-stream;";
           $rarr[]="\tname=\"".$pi['basename']."\"";
           $rarr[]="Content-Name: ".$pi['basename'];
           $rarr[]="Content-Transfer-Encoding: base64";
           $rarr[]="Content-Location: ".$fname;
           $rarr[]="Content-ID: <".$mail['TEMPLATE']['INCLUDES'][$fname][0].">";

           $rarr[]="";
           $rarr=array_merge($rarr, explode("\r\n", chunk_split($mail['TEMPLATE']['INCLUDES'][$fname][1])));
           $rarr[]="";
           $rarr[]="";
       }

       if ($mail['TEMPLATE']['INCLUDES'][$fname][2]) {
           $rarr[]="--$b";
           $rarr[]="Content-Type: application/octet-stream;";
           $rarr[]="\tname=\"".$pi['basename']."\"";
           $rarr[]="Content-Name: ".$pi['basename'];
           $rarr[]="Content-Transfer-Encoding: base64";
           $rarr[]="Content-Location: ".$fname;
           $rarr[]="Content-Disposition: attachment;";
           $rarr[]="\tfilename=\"".$pi['basename']."\"";

           $rarr[]="";
           $rarr=array_merge($rarr, explode("\r\n", chunk_split($mail['TEMPLATE']['INCLUDES'][$fname][1])));
           $rarr[]="";
           $rarr[]="";
       }

       if ($mail['CALLBACK']) $mail['CALLBACK']("OK\n");
  }
  if ($mail['CALLBACK']) $mail['CALLBACK']("OK\n");

/*
Content-Type: image/jpeg;
  name="crazy_it_party.jpg"
Content-Transfer-Encoding: base64
Content-Disposition: attachment;
  filename="crazy_it_party.jpg"
*/

    $rarr[]="--$b--";
    $rarr[]="";




    if ($mail['CALLBACK']) $mail['CALLBACK']("compile finishing ... ");

    $mail['BODY_LINES']=$rarr;
    if ($mail['CALLBACK']) $mail['CALLBACK']("(".count($rarr)." lines) ... ");
    $mail['BODY']=implode("\r\n", $rarr);

    if ($mail['CALLBACK']) $mail['CALLBACK']("OK\n");
    return $mail['BODY'];
}

function mail_strip_breaks($text) {
   $text=preg_replace('/^[\s]+[\r\n]([\x20]*[^\s])/i', "\${1}", $text);
   $text=preg_replace('/([^\s][\x20]*)[\r\n][\s]+$/i', "\${1}", $text);
   $lines=explode("\n", $text);
   $l = count($lines);
   $c=0;
   $r=array();
   for ($i=0;$i<$l;$i++) {
       $line=trim($lines[$i]);
       if ($line=='') {
         if ($c++<2) $r[]='';
       } else {
         $c=0;
         $r[]=rtrim($lines[$i]);
       }
   }
   return implode("\r\n", $r);
}

function mail_qp_encode($text) {
   $l = strlen($text);
   $res = array();
   $curr_str='';
   for ($i=0;$i<$l;$i++) {
       $ch = $text{$i};
       $chv = ord($ch);
       $out = sprintf("=%02X",$chv);
       if (($chv>=33 && $chv<=60) || ($chv>=62 && $chv<=126)) {
          $out = $ch;
       }
       if ($chv==32) $out = $ch;

       if ($chv==13 && $i<$l-1 && ord($text{$i+1})==10) {
           $res[]=$curr_str;
           $curr_str='';
           $i++;
       } else if (strlen($curr_str)+strlen($out)<76) {
           $curr_str.=$out;
       } else {
           $res[]=$curr_str.'=';
           $curr_str=$out;
       }
   }
   $res[]=$curr_str;
   return $res;
}

function mail_split_headers($msg) {
    $r = array('HEADERS'=>array(), 'BODY'=>array());
    $arr = $msg;
    if (!is_array($msg)) $arr = explode("\r\n", $msg);
    $is_hd = true;
    while ( count($arr)>0 && ($line=array_shift($arr))!=NULL ) {
         $ln = trim($line);
         if ($is_hd && $ln=='') {
             $is_hd=false;
             continue;
         }
         if ($is_hd) {
            if (count($r['HEADERS'])>0 && strlen($line)>0 && preg_match('/^\s+/', $line)) {
               $r['HEADERS'][count($r['HEADERS'])-1].="\r\n".trim($line, "\r\n");
            } else {
               array_push($r['HEADERS'], trim($line, "\r\n"));
            }
         } else {
            array_push($r['BODY'], trim($line, "\r\n"));
         }
    }
    return $r;
}

}                                        
?>
