<?php
if (!defined("INC_MSSQL_PDO_OBJ_H")){
   define("INC_MSSQL_PDO_OBJ_H", TRUE);
   $GLOBALS['TEST_MODE']=false;
   $GLOBALS['DB_OBJ_ERR_LOG_PREFIX']='';
   $GLOBALS['DB_OBJ_ERR_CRITICAL_EXIT']=true;

  $dtf='%d.%m.%Y %H:%M:%S';
//  ini_set('ibase.timestampformat', $dtf);
//  ini_set('ibase.dateformat', $dtf);
//  ini_set('ibase.timeformat', $dtf);

  $GLOBALS['MSSQL_PDO_OBJ_TYPES_SIMPLE']=array (
     'INT64'=>'INTEGER',
     'BIT'=>'INTEGER',
     'INTEGER'=>'INTEGER',
     'SMALLINT'=>'INTEGER',
     'CHAR'=>'VARCHAR',
     'VARCHAR'=>'VARCHAR',
     'BLOB'=>'VARCHAR',
     'DATE'=>'DATETIME',
     'TIMESTAMP'=>'DATETIME',
     'FLOAT'=>'FLOAT',
     'DOUBLE'=>'FLOAT',
  );

  $GLOBALS['MSSQL_PDO_OBJ_TYPES']=array (
    -5 => 'INT64', // SQL_BIGINT
    -2 => 'BLOB', // SQL_BINARY
    -7 => 'BIT', // SQL_BIT
    1 => 'CHAR', // SQL_CHAR
    91 => 'DATE', // SQL_TYPE_DATE
    93 => 'DATE', // SQL_TYPE_TIMESTAMP
    -155 => 'INTEGER', // SQL_SS_TIMESTAMPOFFSET
    3 => 'DOUBLE', // SQL_DECIMAL
    6 => 'FLOAT', // SQL_FLOAT
    -4 => 'BLOB', // SQL_LONGVARBINARY
    4 => 'INTEGER', // SQL_INTEGER
    -8 => 'CHAR', // SQL_WCHAR
    -10 => 'VARCHAR', // SQL_WLONGVARCHAR
    2 => 'DOUBLE', // SQL_NUMERIC
    -9 => 'VARCHAR', // SQL_WVARCHAR
    7 => 'DOUBLE', // SQL_REAL
    5 => 'SMALLINT', // SQL_SMALLINT
    -1 => 'VARCHAR', // SQL_LONGVARCHAR
    -154 => 'FLOAT', // SQL_SS_TIME2
    -6 => 'SMALLINT', // SQL_TINYINT
    -151 => 'VARCHAR', // SQL_SS_UDT
    -11 => 'VARCHAR', // SQL_GUID
    -3 => 'BLOB', // SQL_VARBINARY
    12 => 'VARCHAR', // SQL_VARCHAR
    -152 => 'VARCHAR', // SQL_SS_XML
  );

class mssql_pdo_obj_request {
  var $dbobj;
  var $handle;
  var $sql;
  var $params;
  var $params_int;
  var $meta;

  // constructor
  function mssql_pdo_obj_request($dbobj, $sql) {
    $this->dbobj=$dbobj;
    $this->sql=$sql;
    $this->handle=false;
    $this->meta=false;
  }

  function prepare() {
    if (!$this->handle || !$this->dbobj->transaction()) {
      $this->close();
      if (!$this->dbobj->transaction()) $this->dbobj->start_transaction();
//      preg_match_all('/\?/', $this->sql, $this->params);
//      $this->params=$this->params[0];
//      $this->params_int=array();
//      foreach ($this->params as &$v) $this->params_int[]=&$v;
//      print_r($this->params_int);
      $this->handle=$this->dbobj->link()->prepare($this->sql);
      if ($this->handle===false) $this->dbobj->check_err($GLOBALS['DB_OBJ_ERR_CRITICAL_EXIT']);
    }
    return $this->handle;
  }
  
  function meta() {
    return $this->meta;
  }

  function execute($vlist=false) {
    $this->prepare();
//    if (is_array($this->params) && count($this->params)>0 && is_array($vlist) && count($vlist)>=count($this->params)) {
//       for($i=0;$i<count($this->params);$i++) $this->params[$i]=$vlist[$i];
//    }
    if ($vlist===false || !is_array($vlist)) {
       $res=$this->handle->execute();
    } else {
       $res=$this->handle->execute($vlist);
    }
    if (!$res) $this->check_err($GLOBALS['DB_OBJ_ERR_CRITICAL_EXIT']);
//    $meta=sqlsrv_field_metadata($this->handle);
//    $this->meta=array();
//    foreach ($meta as $fld) {
//      $fld=array_change_key_case($fld, CASE_UPPER);
//      if (array_key_exists('TYPE', $fld)) $fld['TYPE_SIMPLE']=$this->dbobj->int_get_type_simple($fld['TYPE']);
//      $this->meta[strtoupper($fld['NAME'])]=$fld;
//    }

    return $res;
  }

  function fetch() {
    if (!$this->handle) return false;
    $row=$this->handle->fetch(PDO::FETCH_ASSOC);
//    return $row;
    if ($row===false) $this->check_err($GLOBALS['DB_OBJ_ERR_CRITICAL_EXIT']);
    if (!$row) return false;
    $row=array_change_key_case($row, CASE_UPPER);
    if (is_array($this->meta) && count($this->meta)>0) foreach ($row as $key=>&$val) {
      if (is_null($val)) {
      } else if (is_object($val) && is_a($val, 'DateTime')) {
        if ($val->format('H:i:s')=='00:00:00') {
          $val=$val->format('Y-m-d');
        } else {
          $val=$val->format('Y-m-d H:i:s');
        }
      } else if ($this->meta[$key]['TYPE_SIMPLE']=='FLOAT') {
        $val=sprintf('%.2f', round($val, 2));
      } else if ($this->meta[$key]['TYPE_SIMPLE']=='INTEGER') {
        $val=(int)$val;
      }
    }
    return $row;
  }

  function get_row($vlist=false) {
    if ($this->execute($vlist)===false) return false;
    return $this->fetch();
  }

  function close() {
    if ($this->handle) $this->handle->closeCursor();
    $this->handle=false;
  }

  function get_err() {
    $errcode=$this->handle->errorCode();
    if (!$errcode || $errcode=='00000') return false;
    $err=$this->handle->errorInfo();
    return (!$err || count($err)==0)?false:$err;
  }
  
  function check_err($need_exit=false, $add_text=false, $forcenocheck=false) {
    $ret='';
    if (!$forcenocheck) {
      $errs=$this->get_err();
      if ($errs===false) return false;
//      foreach ($errs as $err) $ret.="MSSQL PDO error: [".$err[0]."](".$err[1]."): ".$err[2]."\r\n";
      $ret.="MSSQL PDO error: [\n".var_export($errs, true)."\r\n";
      $ret.="\n";
      $forcenocheck=true;
    }
    if ($add_text!=false) $ret.=$add_text;
    return $this->dbobj->check_err($need_exit, $ret, $forcenocheck);
  }
}

class mssql_pdo_obj {
  var $server;
  var $dbname;
  var $user;
  var $pass;
  var $link;
  var $transaction;
  var $mscondelim;
  var $transaction_name;
      
  // constructor
  function mssql_pdo_obj($server, $dbname, $user, $pass) {
    $this->mscondelim=(stristr(php_uname('s'), 'windows')==FALSE)?':':',';
    $a=preg_split('/[\:\,]/', $server, 2); if (count($a)<2) { $a[1]=1433; } else { $a[1]=(int)$a[1]; }
    $this->server=implode($this->mscondelim, $a);
    $this->dbname=$dbname;
    $this->user=$user;
    $this->pass=$pass;
    $this->link=false;
    $this->trans_args=IBASE_DEFAULT;
    $this->transaction=false;
    $this->transaction_name='trpdomssql'.uniqid();
    $this->connect();
  }            

  function link() {
    return $this->link;
  }

  function transaction() {
    return $this->transaction;
  }

  function prepare($sql) {
    $request=new mssql_pdo_obj_request($this, $sql);
    if ($request->prepare()===false) return false;
    return $request;
  }

  function connect() {
    $dsn = 'dblib:host='.$this->server.';dbname='.$this->dbname;
    try {
        $this->link=new PDO($dsn, $this->user, $this->pass);
        if (!$this->link) $this->check_err($GLOBALS['DB_OBJ_ERR_CRITICAL_EXIT'], 'Connection failed with unknown reason');
    } catch (PDOException $e) {
        $this->link=false;
        $this->check_err($GLOBALS['DB_OBJ_ERR_CRITICAL_EXIT'], "Connection failed: " . $e->getMessage(), true);
    }
    return $this->link;
  }

  function rollback() {
    if ($this->transaction!==false) {
      $res=$this->int_simple_exec('ROLLBACK TRANSACTION '.$this->transaction_name);
      if (!$res) $this->check_err($GLOBALS['DB_OBJ_ERR_CRITICAL_EXIT']);
    }
    $this->transaction=false;
  }

  function commit() {
    if ($this->transaction!==false) {
      $res=$this->int_simple_exec('COMMIT TRANSACTION '.$this->transaction_name);
      if (!$res) $this->check_err($GLOBALS['DB_OBJ_ERR_CRITICAL_EXIT']);
    }
    $this->transaction=false;
  }

  function start_transaction($trans_args=0) {
    if ($this->transaction) $this->rollback();
    $this->transaction=$this->int_simple_exec('BEGIN TRANSACTION '.$this->transaction_name);
    if (!$this->transaction) $this->check_err($GLOBALS['DB_OBJ_ERR_CRITICAL_EXIT']);
    return $this->transaction;
  }

  function close() {
    $this->link=null;
  }

  function get_err() {
    $errcode=$this->link->errorCode();
    if (!$errcode || $errcode=='00000') return false;
    $err=$this->link->errorInfo();
    return (!$err || count($err)==0)?false:$err;
  }
  
  function check_err($need_exit=false, $add_text=false, $forcenocheck=false) {
    $ret='';
    if (!$forcenocheck) {
      $errs=$this->get_err();
      if ($errs===false) return false;
//      foreach ($errs as $err) $ret.="MSSQL PDO error: [".$err[0]."](".$err[1]."): ".$err[2]."\r\n";
      $ret.="MSSQL PDO error: [\n".var_export($errs, true)."\r\n";
      $ret.="\n";
    }
    if ($add_text!=false) $ret.=$add_text;
     //."\n".var_export(debug_backtrace(),true);
    $this->print_log($ret);
    if ($need_exit) exit();
    return true;
  }
  
  function print_log($str) {
    $fn='mssql_pdo.txt';
    $ts=strftime ("[%d.%m.%Y %H:%M:%S]");
    if (@fileperms($fn)!=0777) @chmod($fn, 0777);
    $fp = fopen ($fn, "ab");
    fwrite($fp, $ts." ".$GLOBALS['DB_OBJ_ERR_LOG_PREFIX'].' '.$str."\r\n");
    fclose ($fp);
  }

  function int_get_type($in_type) {
    if (array_key_exists($in_type, $GLOBALS['MSSQL_PDO_OBJ_TYPES'])) return $GLOBALS['MSSQL_PDO_OBJ_TYPES'][$in_type];
    return false;
  }

  function int_get_type_simple($in_type) {
    $in_type=$this->int_get_type($in_type);
    if (!$in_type) return false;
    if (array_key_exists($in_type, $GLOBALS['MSSQL_PDO_OBJ_TYPES_SIMPLE'])) return $GLOBALS['MSSQL_PDO_OBJ_TYPES_SIMPLE'][$in_type];
    return false;
  }

  function int_simple_exec($sql) {
    $request=$this->link->prepare($sql);
    if (!$request) return false;
    if ($request->execute()===false) return false;
    $request->closeCursor();
    $request=null;
    return true;
  }

  function get_result_array($sql, $vlist=false) {
    $request=$this->prepare($sql);
    if (!$request) return false;
    if ($request->execute($vlist)===false) return false;
    $result=array();
    while ($row=$request->fetch()) $result[]=$row;
    $request->close();                        
    unset($request);
    return $result;
  }

  function get_result_row($sql, $vlist=false) {
    $request=$this->prepare($sql);
    if (!$request) return false;
    if ($request->execute($vlist)===false) return false;
    $row=$request->fetch();
    $request->close();                        
    unset($request);
    return $row;
  }

  function get_result_id($sql, $vlist=false) {
    $row=$this->get_result_row($sql, $vlist);
    if (array_key_exists('ID', $row)) return $row['ID'];
    return false;
  }

} // end class


} // end incl_h
?>
