<?php

if (!defined("INC_NUMCODER_H")) {
     define("INC_NUMCODER_H", TRUE);



  function numcoder_decode($buffer, &$offset=0, $vsize=4, $loffset=false) {
      if ($vsize<1) $vsize=1;
      if ($vsize>8) $vsize=8;
      if ($loffset===false) $loffset=strlen($buffer);
      $len = $loffset-$offset;
      if ($len<1 || $vsize>$len) return false;
      $result = 0;
      for ($i=$vsize-1; $i>=0; $i--) $result |= ord($buffer{$offset++}) << ($i*8);
      return $result;
  }

  function numcoder_decode_r($buffer, &$offset=0, $vsize=4, $loffset=false) {
      if ($vsize<1) $vsize=1;
      if ($vsize>8) $vsize=8;
      if ($loffset===false) $loffset=strlen($buffer);
      $len = $loffset-$offset;
      if ($len<1 || $vsize>$len) return false;
      $result = 0;
      for ($i=0; $i<$vsize; $i++) $result |= ord($buffer{$offset++}) << ($i*8);
      return $result;
  }

  function numcoder_decode_buf($buffer, &$offset=0, $blen=1, $loffset=false) {
    if ($loffset===false) $loffset=strlen($buffer);
    $len = $loffset-$offset;
    if ($len<1 || $blen>$len) return false;
    $data=substr($buffer, $offset, $blen);
    $offset+=strlen($data);
    return $data;
  }

  function numcoder_encode($val, $vsize=4) {
      if ($vsize<1) $vsize=1;
      if ($vsize>8) $vsize=8;
      $offset=0;
      $result = str_repeat("\0", $vsize);
      for ($i=$vsize-1; $i>=0; $i--) $result{$offset++} = chr(($val >> ($i*8)) & 0xFF);
      return $result;
  }

  function numcoder_encode_r($val, $vsize=4) {
      if ($vsize<1) $vsize=1;
      if ($vsize>8) $vsize=8;
      $offset=0;
      $result = str_repeat("\0", $vsize);
      for ($i=0; $i<$vsize; $i++) $result{$offset++} = chr(($val >> ($i*8)) & 0xFF);
      return $result;
  }

  function numcoder_dump($data, $line_prefix='') {
     $res=array();
     $l=strlen($data);
     $ind=0;
     while ($ind<$l) {
        $str=sprintf("0x%08X ",$ind);
        $ml=$l-$ind; if ($ml>16) $ml=16;
        $str1='';
        for ($i=0;$i<$ml;$i++) {
            $chc=ord($data{$ind+$i});
            $str.=sprintf(" %02X",$chc);
            if ($i==7) $str.=' ';
            if ($chc>32) {
              $str1.=chr($chc);
            } else {
              $str1.='.';
            }
        }
        $str.=str_pad('', (16-$ml)*3);
        $str.='  '.$str1;
        array_push($res, $line_prefix.$str);
        $ind+=$ml;
     }
      
     return implode("\n",$res);
  }

  function numcoder_dump_simple($data, $separator=' ', $prefix='0x') {
     $res=array();
     $l=strlen($data);
     $ind=-1;
     $fmt=$prefix.'%02X';
     while (++$ind<$l) array_push($res, sprintf($fmt,ord($data{$ind})));
     return implode($separator, $res);
  }


} // end incl_h
?>
