<?php
if (!defined("INC_POCKET_H")) {
     define("INC_POCKET_H", TRUE);

include("eproto.inc");
include("numcoder.inc");
include("crc8.inc");
     
$GLOBALS['POCKET_DUMP_HELPER']=true;

define('POCKET_CFG_TAG_MAC', 0x01);

define('POCKET_CFG_TAG_IP', 0x02);
define('POCKET_CFG_TAG_MASK', 0x03);
define('POCKET_CFG_TAG_GATEWAY', 0x04);
define('POCKET_CFG_TAG_UDP_PORT', 0x05);
define('POCKET_CFG_TAG_TCP_PORT', 0x06);
define('POCKET_CFG_TAG_DEBUG_PORT', 0x07);
define('POCKET_CFG_TAG_PING_CONTROL', 0x09);

define('POCKET_CFG_TAG_NET', 0x08);


define('POCKET_CFG_TAG_BEHAVIOR', 0x10);
define('POCKET_CFG_TAG_LANG', 0x11);
define('POCKET_CFG_TAG_PROGRESS_MODE', 0x12);
define('POCKET_CFG_TAG_WAIT_TMO', 0x13);
define('POCKET_CFG_TAG_BLOCK_CAB', 0x14);
define('POCKET_CFG_TAG_BLOCK_CELL', 0x15);
define('POCKET_CFG_TAG_NO_FINGER', 0x16);
define('POCKET_CFG_TAG_NO_FINGER_HW_TEST', 0x17);
define('POCKET_CFG_TAG_BUZZER_DUTY', 0x18);
define('POCKET_CFG_TAG_LED_BRIGHTNESS', 0x19);

define('POCKET_CFG_TAG_SECTOR_KEYS', 0x20);
define('POCKET_CFG_TAG_LOCKERS_LIST', 0x21);

define('POCKET_INTERACTIVE_TAG_DELAY', 0x00);
define('POCKET_INTERACTIVE_TAG_SOUND', 0x01);
define('POCKET_INTERACTIVE_TAG_LIGHT', 0x02);
define('POCKET_INTERACTIVE_TAG_TEXT', 0x03);
define('POCKET_INTERACTIVE_TAG_WAITING', 0x04);
define('POCKET_INTERACTIVE_TAG_HOURGLASS', 0x05);

define('POCKET_INTERACTIVE_TAG_SYS_IDLE', 0xE0);
define('POCKET_INTERACTIVE_TAG_SYS_LOCKS', 0xE1);
define('POCKET_INTERACTIVE_TAG_SYS_DCOUNT', 0xE2);

define('POCKET_INTERACTIVE_SOUND_BEEP', 0x00);
define('POCKET_INTERACTIVE_SOUND_QUACK', 0x01);

define('POCKET_RRT_CONFIG', 0x00);
define('POCKET_RRT_FINGER', 0x01);
define('POCKET_RRT_ENROLL_CTRL', 0x02);

define('POCKET_RELAY_FLAG_DOWNCOUNT', 0x01);
define('POCKET_RELAY_FLAG_ZSECOND', 0x02);
define('POCKET_RELAY_FLAG_TAKE_CARD', 0x04);
define('POCKET_RELAY_FLAG_GATE_TRANSFER', 0x08);

define('POCKET_SIGNAL_LOCKED', 0x01);
define('POCKET_SIGNAL_UNLOCKED', 0x02);
define('POCKET_SIGNAL_NFC_LOCK', 0x03);
define('POCKET_SIGNAL_NFC_UNLOCK', 0x04);

define('POCKET_RELAY_DCS_CONTRAST', 0x00);
define('POCKET_RELAY_DCS_FILLED', 0x01);
define('POCKET_RELAY_DCS_XFILLED', 0x02);

define('EPROTO_PK_FLAGS_RT_MAIN', 0x10);
define('EPROTO_PK_FLAGS_RT_CTAKER', 0x20);
define('EPROTO_PK_FLAGS_RT_USART', 0x30);
define('EPROTO_PK_FLAGS_RT_EXT', 0x40);

define('POCKET_RELAY_UID_MAX_LEN', 32);


function pocket_rt_string($rt) {
  if ($rt==EPROTO_PK_FLAGS_RT_CTAKER) {
    return 'CTAKER';
  } else if ($rt==EPROTO_PK_FLAGS_RT_USART) {
    return 'USART';
  } else if ($rt==EPROTO_PK_FLAGS_RT_EXT) {
    return 'EXT';
  }
  return 'MAIN';
}

function pocket_rt_code($rts) {
  $rts=strtoupper(trim($rts));
  if ($rts=='MAIN') return EPROTO_PK_FLAGS_RT_MAIN;
  if ($rts=='CTAKER') return EPROTO_PK_FLAGS_RT_CTAKER;
  if ($rts=='USART') return EPROTO_PK_FLAGS_RT_USART;
  if ($rts=='EXT') return EPROTO_PK_FLAGS_RT_EXT;
  return 0x00;
}

function pocket_interactive_delay($delay) {
  $delay=(int)$delay & 0xFFFF;
  return eproto_tlv_enc_num(POCKET_INTERACTIVE_TAG_DELAY, $delay, 2);
}

function pocket_interactive_waiting($delay, $display_hourglass=false, $wait_till_removed=false) {
  $delay=(int)$delay & 0xFFFF;
  $val=numcoder_encode_r($delay, 2);
  
  $dhg=(($display_hourglass))?1:0;
  $wtr=(($wait_till_removed))?1:0;
  if ($dhg>0 || $wtr>0) $val.=numcoder_encode_r($dhg, 1);
  if ($wtr>0) $val.=numcoder_encode_r($wtr, 1);
  
  return eproto_tlv_enc_buf(POCKET_INTERACTIVE_TAG_WAITING, $val);
}

function pocket_interactive_light($brightness) {
  $brightness=(int)$delay & 0xFF;
  return eproto_tlv_enc_num(POCKET_INTERACTIVE_TAG_LIGHT, $brightness, 1);
}

function pocket_interactive_hourglass($flags) {
  return eproto_tlv_enc_num(POCKET_INTERACTIVE_TAG_HOURGLASS, $flags, 1);
}

function pocket_interactive_sys_idle() {
  return eproto_tlv_enc_empty(SYS_IDLE);
}

function pocket_oled1325_fstrlen_max($text, $max=16) {
  $r=0;
  if (!is_string($text)) return $r;
  $tlen=strlen($text);
  if ($max>$tlen) $max=$tlen;
  if ($max>0) while ($r<$max && ord($text[$r])!=0x00 && ord($text[$r])!=0x0A && ord($text[$r])!=0x0D) $r++;
  return $r;
}

function pocket_interactive_sys_dcount($caption, $cur_val, $max_val) {
  $val=numcoder_encode($cur_val, 2).
       numcoder_encode($max_val, 2);
  $tlen=(!is_string($caption) || strlen($caption)==0)?0:pocket_oled1325_fstrlen_max($caption, 16);
  if ($tlen>0) $val.=substr($caption, 0, $tlen);
  $val=eproto_tlv_enc_buf(POCKET_INTERACTIVE_TAG_SYS_DCOUNT, $val);
  
  return $val;
}

function pocket_interactive_sound($s_type, $s_freq, $s_len, $s_vol, $end_delay=0) {
  $s_type=(int)$s_type & 0xFF;
  $s_freq=(int)$s_freq & 0xFFFF;
  $s_len=(int)$s_len & 0xFFFF;
  $s_vol=(int)$s_vol & 0xFF;
  $end_delay=(int)$end_delay & 0xFFFF;

  if ($end_delay>$s_len) $end_delay=0;
  if ($end_delay>0) $s_len=$s_len-$end_delay;

  $val=numcoder_encode_r($s_type, 1).
       numcoder_encode_r($s_freq, 2).
       numcoder_encode_r($s_len, 2).
       numcoder_encode_r($s_vol, 1);

  $val=eproto_tlv_enc_buf(POCKET_INTERACTIVE_TAG_SOUND, $val);
  if ($end_delay>0) $val.=pocket_interactive_delay($end_delay);

  return $val;
}

function pocket_interactive_text($text) {
  return eproto_tlv_enc_buf(POCKET_INTERACTIVE_TAG_TEXT, $text);
}

function pocket_interactive($text, $display_time, $sound, $till_removed=false) {
  $val=pocket_interactive_text($text);
  $vol=0xFF;
  if ($sound==1) { // Beep
    $val.=pocket_interactive_sound(POCKET_INTERACTIVE_SOUND_BEEP,  4000, 150, $vol, 50);
  } else if ($sound==2) { // Quack
    $val.=pocket_interactive_sound(POCKET_INTERACTIVE_SOUND_QUACK,  4000, 150, $vol, 50);
  } else if ($sound==3) { // BeepBeep
    $val.=pocket_interactive_sound(POCKET_INTERACTIVE_SOUND_BEEP,  4000, 100, $vol, 50);
    $val.=pocket_interactive_sound(POCKET_INTERACTIVE_SOUND_BEEP,  4000, 100, $vol, 50);
  } else if ($sound==4) { // QuackQuack
    $val.=pocket_interactive_sound(POCKET_INTERACTIVE_SOUND_QUACK,  4000, 100, $vol, 50);
    $val.=pocket_interactive_sound(POCKET_INTERACTIVE_SOUND_QUACK,  4000, 150, $vol, 50);
  }
  if (is_int($display_time) || $till_removed) $val.=pocket_interactive_waiting($display_time, false, $till_removed);
  return $val;
}

function relay_on_ex($on_time, $flags=0x00, $caption=false, $uid=false) {
  $val=($on_time>0x0FFFFFFF)?"\xFF\xFF\xFF\xFF":numcoder_encode_r($on_time, 4);
  $val.=numcoder_encode_r($flags, 1);
  $uid_len=(is_string($uid))?strlen($uid):0;
  if ($uid_len>32) $uid_len=32;
  $val.=numcoder_encode_r($uid_len, 1);
  if ($uid_len>0) $val.= substr($uid, 0, $uid_len);
  if (is_string($caption)) {
    $clen=strlen($caption);
	$mlen=($flags & POCKET_RELAY_FLAG_DOWNCOUNT)?16:96;
    if ($clen>$mlen) $clen=$mlen;
    if ($clen>0) $val.= substr($caption, 0, $clen);
  }
  return $val;
}  

function pocket_parse_packet(&$pk) {

  $pk['data']=array();
  $data=&$pk['data'];
  
  $rt=(int)$pk['flags'] & 0xF0;
  if ($rt==0) $rt=EPROTO_PK_FLAGS_RT_MAIN;
  $data['reader_type']=$rt;
  $data['reader_type_name']=pocket_rt_string($rt);
  $data['src_pk_code']=$pk['code'];
  $data['src_pk_flags']=$pk['flags'];
  
  
  if ($pk['cmd']==eproto_cmd_Enquire) {
    if (!@$pk['payload']) return false;
    $offset=0;
    $loffset=strlen($pk['payload']);
    if ($loffset<4) return false;
    $uid_len=$loffset;
    $data['ping_interval']=numcoder_decode_r($pk['payload'], $offset, 2, $loffset);
    $data['ping_timeout']=numcoder_decode_r($pk['payload'], $offset, 2, $loffset);
  } else if ($pk['cmd']==eproto_cmd_ReadTag) {
    if (!@$pk['payload']) return false;
    $offset=0;
    $loffset=strlen($pk['payload']);
    if ($loffset<4) return false;
    $uid_len=$loffset;
    $data['uid_raw']=numcoder_decode_buf($pk['payload'], $offset, $uid_len, $loffset);
    $data['uid']=numcoder_dump_simple($data['uid_raw'], '', '');
    if ($uid_len>2) {
      $off=0;
      $data['wiegand']=','.numcoder_decode_r($data['uid_raw'], $off, 2);
      $data['wiegand']=numcoder_decode_r($data['uid_raw'], $off, 1).$data['wiegand'];
    }
  } else if ($pk['cmd']==eproto_cmd_ReadTagExtended) {
    if (!@$pk['payload']) return false;
    $offset=0;
    $loffset=strlen($pk['payload']);
    if ($loffset<5) return false;
    $uid_len=numcoder_decode_r($pk['payload'], $offset, 1, $loffset);
    if ($uid_len>=$loffset) return false;
    $data['uid_raw']=numcoder_decode_buf($pk['payload'], $offset, $uid_len, $loffset);
    $data['uid']=numcoder_dump_simple($data['uid_raw'], '', '');
    if ($uid_len>2) {
      $off=0;
      $data['wiegand']=','.numcoder_decode_r($data['uid_raw'], $off, 2);
      $data['wiegand']=numcoder_decode_r($data['uid_raw'], $off, 1).$data['wiegand'];
    }
    if ($offset+2<=$loffset) {
      $data['finger_result']=numcoder_decode_r($pk['payload'], $offset, 2, $loffset);
      if ($data['finger_result'] & 0x8000) $data['finger_result']-=0x10000;
    }
    $lockers_data=array();
    while ($offset+4<=$loffset) {
      $linfo=array();
      $err=numcoder_decode($pk['payload'], $offset, 1, $loffset);
      $linfo['auth_err']=(($err >> 4) & 0x0F);
      $linfo['read_err']=($err & 0x0F);
      $bno=numcoder_decode($pk['payload'], $offset, 1, $loffset);
      $linfo['is_passtech']=($bno & 0x80)!=0;
      if ($linfo['is_passtech']) {
        $linfo['block_no']=$bno & 0x7F;
        $linfo['litera']='-';
        if ($linfo['block_no']>0 && $linfo['block_no']<27) $linfo['litera']=chr(ord('A')+$linfo['block_no']-1);
      } else {
        $linfo['block_no']=$bno;
      }
      $cab=numcoder_decode($pk['payload'], $offset, 2, $loffset); 
      $linfo['locked']=($cab & 0x8000)!=0;
      $linfo['cab_no']= $cab & 0x7FFF;
      $lockers_data[]=$linfo;
    }
    $data['auth']=false;
    if (count($lockers_data)>0) {
       $lauth=$lockers_data[0];
       if (is_array($lauth) && (int)@$lauth['auth_err']==0 && (int)@$lauth['read_err']==0) $data['auth']=true;
      $data['lockers_data']=$lockers_data;
    }
    if ($pk['code']!=0) {
	    $data['auth']=true;
	    if ($pk['code'] & 0x01) $data['last_sector_auth']=true;
	    if ($pk['code'] & 0x02) $data['passtech_auth']=true;
	    if ($pk['code'] & 0x04) $data['temp_card']=true;
	    if ($pk['code'] & 0x08) $data['fast_react']=true;
	  }
  } else if ($pk['cmd']==eproto_cmd_DisplayText) {
    if (!@$pk['payload']) return false;
    $offset=0;
    $loffset=strlen($pk['payload']);
    if ($loffset<2) return false;
    $data['delay']=numcoder_decode_r($pk['payload'], $offset, 2, $loffset);
    $capt_len=$loffset-$offset;
    if ($capt_len>128) $capt_len=12;
    if ($capt_len>0) $data['caption']=numcoder_decode_buf($pk['payload'], $offset, $capt_len, $loffset);
  } else if ($pk['cmd']==eproto_cmd_Interactive) {
    if (!@$pk['payload']) return false;
    $data['tlvs']=eproto_tlv_decode($pk['payload']);
    if (is_array($data['tlvs']) && count($data['tlvs'])>0) foreach ($data['tlvs'] as &$tlv) {
      $tlv['tag_name']=eproto_itag_name(@$tlv['tag']);
      $off=0;
      if (@$tlv['tag']==EPROTO_INTERACTIVE_TAG_DELAY) {
        if ($tlv['len']>1) {
          $tlv['param_delay']=numcoder_decode_r($tlv['val'], $off, 2, $tlv['len']);
        }
      } else if (@$tlv['tag']==EPROTO_INTERACTIVE_TAG_SOUND) {
        if ($tlv['len']>4) {
          $tlv['param_sound_type']=numcoder_decode_r($tlv['val'], $off, 1, $tlv['len']);
          $tlv['param_sound_type_name']=eproto_itag_stype_name($tlv['param_sound_type']);
          $tlv['param_sound_freq']=numcoder_decode_r($tlv['val'], $off, 2, $tlv['len']);
          $tlv['param_sound_len']=numcoder_decode_r($tlv['val'], $off, 2, $tlv['len']);
          $tlv['param_sound_vol']=0xFF;
          if ($tlv['len']>5) {
            $tlv['param_sound_vol']=numcoder_decode_r($tlv['val'], $off, 1, $tlv['len']);
          }
        }
      } else if (@$tlv['tag']==EPROTO_INTERACTIVE_TAG_LIGHT) {
        if ($tlv['len']>0) {
          $tlv['param_brightness']=numcoder_decode_r($tlv['val'], $off, 1, $tlv['len']);
        }
      } else if (@$tlv['tag']==EPROTO_INTERACTIVE_TAG_WAITING) {
        if ($tlv['len']>1) {
          $tlv['param_delay']=numcoder_decode_r($tlv['val'], $off, 2, $tlv['len']);
          if ($tlv['len']>2) {
            $tlv['param_hg']=numcoder_decode_r($tlv['val'], $off, 1, $tlv['len']);
            if ($tlv['len']>3) {
              $tlv['param_tl']=numcoder_decode_r($tlv['val'], $off, 1, $tlv['len']);
            }
          }
        }
      }
      
    }
  } else if ($pk['cmd']==eproto_cmd_RelayControl) {
    $data['rno']=$pk['code'] & 0x0F;
    $data['time']=($pk['code'] & 0x3F) * 50;
  } else if ($pk['cmd']==eproto_cmd_RelayControlEx) {
    if (!@$pk['payload']) return false;
    $offset=0;
    $loffset=strlen($pk['payload']);
    if ($loffset<6) return false;
    $data['rce_tmo']=numcoder_decode_r($pk['payload'], $offset, 4, $loffset);
    $data['rce_flags']=numcoder_decode_r($pk['payload'], $offset, 1, $loffset);
    $data['rce_uid_len']=numcoder_decode_r($pk['payload'], $offset, 1, $loffset);
    if ($data['rce_uid_len']>POCKET_RELAY_UID_MAX_LEN) $data['rce_uid_len']=POCKET_RELAY_UID_MAX_LEN;
    if ($data['rce_uid_len']>($loffset-$offset)) return false;
    if ($data['rce_uid_len']>0) $data['rce_uid']=numcoder_decode_buf($pk['payload'], $offset, $data['rce_uid_len'], $loffset);
    
    if (@$data['rce_uid']) {
      $data['uid']=numcoder_dump_simple($data['rce_uid'], '', '');
      if ($data['rce_uid_len']>2) {
        $off=0;
        $data['wiegand']=','.numcoder_decode_r($data['rce_uid'], $off, 2);
        $data['wiegand']=numcoder_decode_r($data['rce_uid'], $off, 1).$data['wiegand'];
      }
    }

    $capt_len=$loffset-$offset;
    if ($capt_len>16) $capt_len=16;
    $data['caption']='';
    if ($capt_len>0) $data['caption']=numcoder_decode_buf($pk['payload'], $offset, $capt_len, $loffset);
  } else if ($pk['cmd']==eproto_resp_RelayControlEx) {
    $uid_len=$pk['payload_len'];
    $data['uid_raw']=$pk['payload'];
    $data['uid']=numcoder_dump_simple($data['uid_raw'], '', '');
    if ($uid_len>2) {
      $off=0;
      $data['wiegand']=','.numcoder_decode_r($data['uid_raw'], $off, 2);
      $data['wiegand']=numcoder_decode_r($data['uid_raw'], $off, 1).$data['wiegand'];
    }
    $data['passed']=($pk['code']!=0);
  } else if ($pk['cmd']==eproto_cmd_InputChanged) {
    $data['inputs_changed']=($pk['code'] >> 4) & 0x0F;
    $data['inputs_state']=$pk['code'] & 0x0F;
    $data['inputs_changed_text']=sprintf('%04b',  $data['inputs_changed']);
    $data['inputs_state_text']=sprintf('%04b',  $data['inputs_state']);    
  }
  
  
}









} // end incl_h
?>
