<?php
if (!defined("INC_PROTO_H")) {
     define("INC_PROTO_H", TRUE);

include("crc8.inc");

define("PROTO_PACKET_SIG", '*');
define("PROTO_PACKET_HDR_LEN", 16);
if (!defined("PROTO_PACKET_MAX_LEN")) define("PROTO_PACKET_MAX_LEN", 4096);

$GLOBALS['PROTO_SEQ_NO']=0;

  function proto_encode_num($val, $bytes_count=4) {
      $result = '';
      if ($bytes_count>3) $result .= chr(($val >> 24) & 0xFF);
      if ($bytes_count>2) $result .= chr(($val >> 16) & 0xFF);
      if ($bytes_count>1) $result .= chr(($val >> 8) & 0xFF);
      if ($bytes_count>0) $result .= chr($val);
      return $result;
  }

  function proto_decode_num($str, $bytes_count=4, $offset=0) {
      $len = strlen($str);
      if ($len<0) return 0;
      if ($len<4 && $bytes_count>$len) $bytes_count=$len;
      $i=$offset;
      $result = 0;
      if ($bytes_count>3) $result |= (ord($str{$i++}) << 24);
      if ($bytes_count>2) $result |= (ord($str{$i++}) << 16);
      if ($bytes_count>1) $result |= (ord($str{$i++}) << 8);
      if ($bytes_count>0) $result |= ord($str{$i++});
      return $result;
  }

  function proto_packet_enc($str, $seq_no=0) {
      $result = array();
      $len = strlen($str);
      $ml = PROTO_PACKET_MAX_LEN-PROTO_PACKET_HDR_LEN;
      while ($len>$ml) {
          $nl = $len-$ml;
          if ($nl>$ml) $nl=$ml;
          array_push($result, proto_packet_enc_(substr($str, 0, $ml), $nl, $seq_no));
//          array_push($result, proto_packet_enc_(substr($str, 0, $ml), $nl+PROTO_PACKET_HDR_LEN, $seq_no));
          $str=substr($str, $ml);
          $len = strlen($str);
      }
      if ($len>0) array_push($result, proto_packet_enc_($str, 0, $seq_no));
      return $result;
  }
   
  function proto_packet_get_seq_no() {
      $GLOBALS['PROTO_SEQ_NO']=$GLOBALS['PROTO_SEQ_NO']+1;
      return $GLOBALS['PROTO_SEQ_NO'];
  }

  function proto_packet_enc_($str, $next_len=0, $seq_no=0) {
      $packet = array();
      $len = strlen($str);
      $crc = 0;
      $flags = 0;
      if ($seq_no==0) $seq_no=proto_packet_get_seq_no();
      array_push($packet, PROTO_PACKET_SIG); // 0
      array_push($packet, proto_encode_num($crc, 1)); // 1
      array_push($packet, proto_encode_num($len, 2)); // 2
      array_push($packet, proto_encode_num($seq_no)); // 4
      array_push($packet, proto_encode_num($next_len, 2)); // 8
      array_push($packet, proto_encode_num($flags, 2)); // 10
      array_push($packet, proto_encode_num(0)); // 12
      array_push($packet, $str);
      $out_data=implode('', $packet);
      $crc = CRC8_BlockChecksum($out_data, 2, PROTO_PACKET_HDR_LEN-2);
      $out_data{1}=chr($crc);
      return $out_data;
  }

  function proto_packet_dec_head($buffer) {
     $len = strlen($buffer);
     if ($len<PROTO_PACKET_HDR_LEN) return false;

     $res = array();
     $res['sig']=$buffer{0};
     $res['crc']=ord($buffer{1});
     $res['len']=proto_decode_num($buffer, 2, 2);
     $res['plen']=$res['len']+PROTO_PACKET_HDR_LEN;
     $res['seq_no']=proto_decode_num($buffer, 4, 4);
     $res['next_len']=proto_decode_num($buffer, 2, 8);
     $res['flags']=proto_decode_num($buffer, 2, 10);
     $res['tmp']=proto_decode_num($buffer, 4, 12);
     if ($res['crc']!=0) {
        $crc = CRC8_BlockChecksum($buffer, 2, PROTO_PACKET_HDR_LEN-2);
//        $res['crco']=$crc;
        if ($crc!=$res['crc']) return false;
     }
     return $res;      
  }

  function proto_packet_dec($buffer) {
     $pk=proto_packet_dec_($buffer);
     if ($pk==false || $pk['sig']!=PROTO_PACKET_SIG) return false;
//     if ($pk['len']+PROTO_PACKET_HDR_LEN!=$pk['plen']) return false;
     return $pk;
  }                       

  function proto_packet_dec_($buffer) {
     $len = strlen($buffer);
     if ($len<PROTO_PACKET_HDR_LEN) return false;

     $res = proto_packet_dec_head($buffer);
     if ($res==false || $len<$res['plen']) return false;
     $res['data']=substr($buffer, PROTO_PACKET_HDR_LEN, $res['len']);
//     $dl = ($len-PROTO_PACKET_HDR_LEN);
//     $res['data']=substr($buffer, PROTO_PACKET_HDR_LEN, ($dl>$res['len'])?$res['len']:$dl);
     return $res;
  }

} // end incl_h
?>
