<?php  
if (!defined("INC_PROTO_HTTP_H")){
   define("INC_PROTO_HTTP_H", TRUE);

  $proto_http_status_codes=array(
      100 => 'Continue',
      101 => 'Switching Protocols',
      200 => 'OK',
      201 => 'Created',
      202 => 'Accepted',
      203 => 'Non-Authoritative Information',
      204 => 'No Content',
      205 => 'Reset Content',
      206 => 'Partial Content',
      300 => 'Multiple Choices',
      301 => 'Moved Permanently',
      302 => 'Found',
      303 => 'See Other',
      304 => 'Not Modified',
      305 => 'Use Proxy',
      306 => '(Unused)',
      307 => 'Temporary Redirect',
      400 => 'Bad Request',
      401 => 'Unauthorized',
      402 => 'Payment Required',
      403 => 'Forbidden',
      404 => 'Not Found',
      405 => 'Method Not Allowed',
      406 => 'Not Acceptable',
      407 => 'Proxy Authentication Required',
      408 => 'Request Timeout',
      409 => 'Conflict',
      410 => 'Gone',
      411 => 'Length Required',
      412 => 'Precondition Failed',
      413 => 'Request Entity Too Large',
      414 => 'Request-URI Too Long',
      415 => 'Unsupported Media Type',
      416 => 'Requested Range Not Satisfiable',
      417 => 'Expectation Failed',
      500 => 'Internal Server Error',
      501 => 'Not Implemented',
      502 => 'Bad Gateway',
      503 => 'Service Unavailable',
      504 => 'Gateway Timeout',
      505 => 'HTTP Version Not Supported',
  );

function proto_http_url_encode_arr($req) {
   $keys=array_keys($req);
   $res=array();
   foreach ($keys as $key) {
       $val=$req[$key];
       array_push($res, $key.'='.urlencode($val));
   }
   return implode('&',$res);
}

function proto_http_file($fname, $data='', $code=200) {
   global $proto_http_status_codes;
   $sts='OK';
   if (array_key_exists($code, $proto_http_status_codes)) $sts=$proto_http_status_codes[$code];

   $content=file_get_contents($fname).$data;
   $a=array();
   $a[]='HTTP/1.1 '.$code.' '.$sts;
   $a[]='Content-Type: text/html; charset=windows-1251';
   $a[]='Connection: close';
   $a[]='Server: WCMB Daemon';
   $a[]='Content-Length: '.strlen($content);

   return implode("\r\n", $a)."\r\n\r\n".$content;
}

function proto_http_decode_startline($data, $is_answer=false) {
   if ($is_answer) {
     $cnt=preg_match('/HTTP\/(\d\.\d)[\s]+([\d]+)[\s]+([^\n]+)/',$data, $matches);
     if ($cnt===false || $cnt<1) return false;
     return array(
       'http_ver'=>$matches[1],
       'status_code'=>$matches[2],
       'status_descr'=>$matches[3],
     );
   } else {
     $cnt=preg_match('/(OPTIONS|GET|HEAD|POST|PUT|DELETE|TRACE|CONNECT)[\s]+([^\s]+)[\s]+HTTP\/(\d\.\d)/',$data, $matches);
     if ($cnt===false || $cnt<1) return false;
     return array(
       'method'=>strtoupper($matches[1]),
       'uri'=>$matches[2],
       'http_ver'=>$matches[3],
     );
   }
}

function proto_http_decode_header($str) {
   $a=explode(':', $str, 2);
   if (!is_array($a) || count($a)!=2) return false;
   return array(trim($a[0]), trim($a[1]));
}

function proto_http_decode_headers($arr) {
   $l=count($arr);
   $ret=array();
   for ($i=0;$i<$l;$i++) {
      if (($hd=proto_http_decode_header($arr[$i]))!=false) {
         $key=strtolower($hd[0]);
         $key1=$hd[0];
         $val=$hd[1];
         if (!array_key_exists($key, $ret)) {
           $ret[$key]=$hd;
         } else {
           if (!is_array($ret[$key])) $ret[$key]=array($ret[$key]);
           array_push($ret[$key], $hd);
         }
      }
   }
   return $ret;
}

function proto_http_try_decode_req($buffer, &$readed=0, $is_answer=false) {
   $tmp=array();
   $p_=0;
   $r=false;
   $first=true;
   $startline=false;
   $status=false;
   $c=0;
   while (($p=strpos($buffer, "\n", $p_))!==false) {
      $p++;
      if ($p>65536) return false;
      $sl=$p-$p_;
      if ($sl>2048 || $sl<0) return false;
      $s=trim(substr($buffer, $p_, $sl), "\n\r");
      if ($first) {
         $startline=proto_http_decode_startline($s, $is_answer);
         if ($startline===false) return false;
      } else if ($s=='') {
        $r=true;
        break;
      } else {
        if ($c>0 && ($s{0}=="\t"||$s{0}==" ")) {
          $tmp[$c-1].=' '.substr($s,1);
        } else {
          array_push($tmp, $s); $c++;
        }
      }
      $p_=$p;
      $first=false;
   }
   if (!$r) return NULL;

   $headers=proto_http_decode_headers($tmp);
//   if (count($tmp)!=count($headers)) return false;
   $readed=$p;

   return array(
       'startline'=>$startline,
       'headers'=>$headers
   );
}

} // end incl_h
?>
