<?php  
if (!defined("INC_PROTO_PACK_H")){
   define("INC_PROTO_PACK_H", TRUE);

   define("PROTO_PACK_DT_BOOL", 0x01);
   define("PROTO_PACK_DT_INT",  0x02);
   define("PROTO_PACK_DT_DBL",  0x03);
   define("PROTO_PACK_DT_STR",  0x04);
   define("PROTO_PACK_DT_NUL",  0x05);
   define("PROTO_PACK_DT_HASH",  0x06);
   define("PROTO_PACK_DT_ARR",  0x07);
   define("PROTO_PACK_DT_BIN",  0x08);
                                

function proto_pack_int_len($value) {
  if (($value & 0x7F)==$value) return 1;
  if (($value & 0x7FFF)==$value) return 2;
  if (($value & 0x7FFFFF)==$value) return 3;
  return 4;
}                                  

function proto_pack_is_native_arr($array) {
   $keys1=array_keys($array);
   $keys2=array_keys(array_values($array));
   return (count(array_diff($keys1, $keys2))==0 && count(array_diff($keys2, $keys1))==0);
}

function proto_pack_encode_arr_ex($array) {
   $result=array();
   $l=count($array);
   for ($i=0;$i<$l;$i++) array_push($result, proto_pack_encode_val($array[$i]));
  return implode('', $result);
}

function proto_pack_encode_arr($array) {
  $keys=array_keys($array);
  $l=count($keys);
  $result=array();
  for ($i=0;$i<$l;$i++) {
     $key=$keys[$i];
     $val=$array[$key];
     array_push($result, proto_pack_encode_val($key));
     array_push($result, proto_pack_encode_val($val));
  }
  return implode('', $result);
}

function proto_pack_is_binary_string($value) {
  return preg_match('/[\x00-\x08\x0B-\x0C\x0E-\x1F]/', $value);
}
                                 
function proto_pack_encode_val($value) {
   $result=false;
   switch (gettype($value)) {
    case 'boolean':
        $result=proto_pack_tlv_new(PROTO_PACK_DT_BOOL, proto_pack_num_encode(($value)?1:0, 1));
        break;
    case 'integer':
        $result=proto_pack_tlv_new(PROTO_PACK_DT_INT, proto_pack_num2bin($value, true, proto_pack_int_len($value)));
        break;
    case 'double':
        $result=proto_pack_tlv_new(PROTO_PACK_DT_DBL, proto_pack_num2bin($value));
        break;
    case 'string':
        $result=proto_pack_tlv_new(proto_pack_is_binary_string($value)?PROTO_PACK_DT_BIN:PROTO_PACK_DT_STR, $value);
        break;
    case 'NULL':
        $result=proto_pack_tlv_new(PROTO_PACK_DT_NUL, '');
        break;
    case 'array':
        if (proto_pack_is_native_arr($value)) {
          $result=proto_pack_tlv_new(PROTO_PACK_DT_ARR, proto_pack_encode_arr_ex($value));
        } else {
          $result=proto_pack_tlv_new(PROTO_PACK_DT_HASH, proto_pack_encode_arr($value));
        }
        break;
    default:
        $result=proto_pack_tlv_new(PROTO_PACK_DT_NUL, '');
        break;
   }
   if ($result===false) return '';
   return proto_pack_tlv_encode($result);
}

function proto_pack_decode_arr_ex($data, $in_offset=0) {
   $res=false;
   $result=array();
   $item=proto_pack_decode_val($data, $res, $in_offset);
   if (!$res) return false;
   while ($res!==false) {
      array_push($result, $item);
      $item=proto_pack_decode_val($data, $res, $in_offset);
   }
   return $result;
}                             

function proto_pack_decode_arr($data, $in_offset=0) {
   $res=false;
   $result=array();
   while (true) {
     $key=proto_pack_decode_val($data, $res, $in_offset);
     if (!$res) return $result;
     $val=proto_pack_decode_val($data, $res, $in_offset);
     if (!$res) return $result;
     $result[$key]=$val;
   }
}                             

function proto_pack_decode_val($data, &$result=false, &$offset=0) {
   $result=false;
   $tlv=proto_pack_tlv_decode($data, $offset);
   if ($tlv==false) return false;
   $offset+=$tlv['length']+4;
   $result=true;
   $res=NULL;
   switch ($tlv['tag']) {
    case PROTO_PACK_DT_BOOL:
        $res=(proto_pack_num_decode_($tlv['value'], $tlv['length'])==1)?true:false;
        break;
    case PROTO_PACK_DT_INT:
        $res=proto_pack_bin2num($tlv['value'], true, $tlv['length']);
        break;
    case PROTO_PACK_DT_DBL:
        $res=proto_pack_bin2num($tlv['value']);
        break;
    case PROTO_PACK_DT_STR:
        $res=$tlv['value'];
        break;
    case PROTO_PACK_DT_NUL:
        $res=NULL;
        break;          
    case PROTO_PACK_DT_HASH:
        $res=proto_pack_decode_arr($tlv['value']);
        break;
    case PROTO_PACK_DT_ARR:
        $res=proto_pack_decode_arr_ex($tlv['value']);
        break;
    case PROTO_PACK_DT_BIN:
        $res=$tlv['value'];
        break;
   }
   return $res;
}

// ------------------------------------------------- //

function proto_pack_tlv_new($tag=0, $value='', $length=false) {
  $tlv=Array();
  $tlv['tag']=$tag;
  $tlv['length']=($length===false)?strlen($value):$length;
  $tlv['value']=$value;

  return $tlv;
}

function proto_pack_tlv_decode($data, $in_offset=0) {
  $dlen=strlen($data);
  $len=$dlen-$in_offset;
  if ($len<4) return false;
  $tlv=proto_pack_tlv_new();
  $offset=$in_offset;
  $tlv['tag']=proto_pack_decode_num($data, 1, $offset);
//  $tlv['type_hex']=sprintf("0x%02X",$tlv['tag']);
  $tlv['length']=proto_pack_decode_num($data, 3, $offset);
  $vmlen=$len-4;
  if ($tlv['length']>$vmlen) return false;
  $tlv['value']=substr($data, $offset, $tlv['length']);
  return $tlv;    
}

function proto_pack_tlv_encode($tlv) {
  $res=array();
  array_push($res, proto_pack_num_encode($tlv['tag'], 1));
  array_push($res, proto_pack_num_encode($tlv['length'], 3));
  array_push($res, $tlv['value']);
  return implode('',$res);
}

// ------------------------------------------------- //

function proto_pack_sign_mask($dcnt=4) {
  if ($dcnt==4) return 0x7FFFFFFF;
  if ($dcnt==3) return 0x7FFFFF;
  if ($dcnt==2) return 0x7FFF;
  return 0x7F;
}

function proto_pack_prec_mask($dcnt=4) {
  if ($dcnt==4) return 0x3B9ACA00;
  if ($dcnt==3) return 0x00989680;
  if ($dcnt==2) return 0x2710;
  return 0x64;
}

function proto_pack_sign_bit_mask($dcnt=4) {
  if ($dcnt==4) return 0x80000000;
  if ($dcnt==3) return 0x800000;
  if ($dcnt==2) return 0x8000;
  return 0x80;
}

function proto_pack_float_split($f, $prec, $bcnt=0) {
  $range_out=($f>0x7FFFFFFF || $f<-0x7FFFFFFF);
  $dbl=$f;       
  $neg=($dbl<0.0);
  if ($neg) $dbl*=-1.0;
  if ($bcnt>0) {
    $mlt=proto_pack_prec_mask($bcnt);
  } else {                     
    $mlt=pow(10,$prec);
  }
  $iv=intval($dbl);
  $fvi=intval(($dbl*$mlt)-($iv*$mlt));
  $fv=$fvi/$mlt;
  return array($neg, $iv, $fv, $fvi, $range_out);
}

function proto_pack_float_join($ival, $fval, $prec, $bcnt=0) {
  $range_out=($f>0x7FFFFFFF || $f<-0x7FFFFFFF);
  $dbl=$f;       
  $neg=($dbl<0.0);
  if ($neg) $dbl*=-1.0;
  if ($bcnt>0) {
    $mlt=proto_pack_prec_mask($bcnt);
  } else {                     
    $mlt=pow(10,$prec);
  }
  $iv=intval($dbl);
  $fvi=intval(($dbl*$mlt)-($iv*$mlt));
  $fv=$fvi/$mlt;
  return array($neg, $iv, $fv, $fvi, $range_out);
}

function proto_pack_num2bin($dbl, $is_int=false, $icnt=4, $fcnt=4) {
  $neg=($dbl<0.0);
  if ($neg) $dbl*=-1.0;
  $intval=intval($dbl) & proto_pack_sign_mask($icnt);
  $fval=$dbl-$intval;
  $fval=intval($fval*proto_pack_prec_mask($fcnt));
  if ($neg) $intval|=proto_pack_sign_bit_mask($icnt);
  $result=proto_pack_num_encode($intval, $icnt);
  if (!$is_int) $result.=proto_pack_num_encode($fval, $fcnt);
  return $result;
}

function proto_pack_bin2num($str, $is_int=false, $icnt=4, $fcnt=4) {
  $intval=proto_pack_num_decode_($str, $icnt);
  $neg=($intval & proto_pack_sign_bit_mask($icnt));
  $intval&=proto_pack_sign_mask($icnt);
  $ret=$intval;
  if (!$is_int) {
    $fval=proto_pack_num_decode($str, $fcnt, $icnt)/proto_pack_prec_mask($fcnt);
    $ret+=$fval;
  }
  if ($neg) $ret*=-1;
  return $ret;
}

function proto_pack_num2bin1($dbl, $is_int=false, $icnt=4, $fcnt=4, $range_out_value=0.0) {
  $fsr=proto_pack_float_split($dbl, $fcnt*2, $fcnt);
  print(var_export(array($dbl, $fsr), true)."\n");
  if ($fsr[4]) {
    if (!is_numeric($range_out_value)) return $range_out_value;
    $fsr=proto_pack_float_split($range_out_value, $fcnt*2, $fcnt);
  }
  $neg=$fsr[0];
  $intval=$fsr[1] & proto_pack_sign_mask($icnt);
//  $fval=intval($fsr[2]*proto_pack_prec_mask($fcnt));
  $fval=$fsr[3]; //proto_pack_to_bcd($fsr[3], $fcnt, true);
  if ($neg) $intval|=proto_pack_sign_bit_mask($icnt);
  $result=proto_pack_num_encode($intval, $icnt);
  if (!$is_int) $result.=proto_pack_num_encode($fval, $fcnt);
  return $result;
}

function proto_pack_bin2num1($str, $is_int=false, $icnt=4, $fcnt=4) {
  $intval=proto_pack_num_decode_($str, $icnt);
  $neg=($intval & proto_pack_sign_bit_mask($icnt));
  $intval&=proto_pack_sign_mask($icnt);
  $ret=$intval;
  if (!$is_int) {
    $fval=proto_pack_num_decode($str, $fcnt, $icnt)/proto_pack_prec_mask($fcnt);
//    $fval=proto_pack_num_decode($str, $fcnt, $icnt);
//    $fval=proto_pack_from_bcd($fval, $fcnt, true);
    $ret+=$fval;
  }
  if ($neg) $ret*=-1;
  return $ret;
}

function proto_pack_from_bcd($int_num, $ncnt=4, $is_float=false) {
   $ret_int=0;
   $ret=array();
   $scnt=$ncnt*2;
   $c=$scnt;
   if ($is_float) {
      $scnt--;
      $c=($int_num >> ($scnt*4)) & 0xF;
   }
   while ($scnt>0) {
      $d=($int_num >> ($scnt*4)) & 0xF;
      $ret_int=($ret_int*10)+$d;
      $scnt--;
   }

   return $ret_int/pow(10, $c);
}

function proto_pack_to_bcd($int_num, $ncnt=4, $is_float=false) {
   $ret=array();
   $ret_int=0;

   $scnt=$ncnt*2;
   if ($is_float) $scnt--;
   $l=$scnt;
   $c=0;
   while ($l>0) {
     $r=(int)($int_num/10);
     $d=(int)($int_num-($r*10));
     $int_num=$r;
     $ret[]=$d & 0xF;
     if ($d!=0 || $c!=0) $c++;
     $l--;
   }
   $l=count($ret);
   $i=0;
   for ($i=0;$i<$l;$i++) $ret_int |= ($ret[$i] & 0xF)<<($i*4);
   if ($is_float) $ret_int |= ($c & 0xF)<<($i*4);
   return $ret_int;
}

function proto_pack_num_encode($val, $bytes_count=4) {
   $result = '';
   if ($bytes_count>3) $result .= chr(($val >> 24) & 0xFF);
   if ($bytes_count>2) $result .= chr(($val >> 16) & 0xFF);
   if ($bytes_count>1) $result .= chr(($val >> 8) & 0xFF);
   if ($bytes_count>0) $result .= chr($val);
   return $result;
}

function proto_pack_num_decode_($data, $bytes_count=4, $offset=0) {
   $i=$offset;
   $result = 0;
   $res='';
//   if ($bytes_count>3) $res.= sprintf('%02X',ord($data{$i++}));
//   if ($bytes_count>2) $res.= sprintf('%02X',ord($data{$i++}));
//   if ($bytes_count>1) $res.= sprintf('%02X',ord($data{$i++}));
//   if ($bytes_count>0) $res.= sprintf('%02X',ord($data{$i++}));
//   return hexdec($res);


   if ($bytes_count>3) $result |= (ord($data{$i++}) << 24) & 0xFF000000;
   if ($bytes_count>2) $result |= (ord($data{$i++}) << 16) & 0xFF0000;
   if ($bytes_count>1) $result |= (ord($data{$i++}) << 8) & 0xFF00;
   if ($bytes_count>0) $result |= ord($data{$i++}) & 0xFF;
   return $result;
}

function proto_pack_decode_num($data, $bytes_count=4, &$offset=0) {
   $result = proto_pack_num_decode_($data, $bytes_count, $offset);
   $offset+=$bytes_count;
   return $result;
}

function proto_pack_num_decode($data, $bytes_count=4, $offset=0) {
   $len = strlen($data);
   $rlen=$len-$offset;
   if ($rlen<0) return 0;
   if ($rlen<4 && $bytes_count>$rlen) $bytes_count=$rlen;
   return proto_pack_num_decode_($data, $bytes_count, $offset);
}

// ------------------------------------------------- //

function proto_pack_dump($data, $line_prefix='') {
   $res=array();
   $l=strlen($data);
   $ind=0;
   while ($ind<$l) {
      $str=sprintf("0x%08X ",$ind);
      $ml=$l-$ind; if ($ml>16) $ml=16;
      $str1='';
      for ($i=0;$i<$ml;$i++) {
          $chc=ord($data{$ind+$i});
          $str.=sprintf(" %02X",$chc);
          $str1.=($chc>32)?$data{$ind+$i}:'.';
      }
      $str.=str_pad('', (16-$ml)*3);
      $str.='  '.$str1;
      array_push($res, $line_prefix.$str);
      $ind+=$ml;
   }
   return implode("\n",$res);
}

} // end incl_h
?>
