<?php
if (!defined("INC_SMS_CLIENT_H")){
   define("INC_SMS_CLIENT_H", TRUE);

include('sms_packets.inc');
include('icq_buffer.inc');
include('crypt.inc');
include('func.inc');
include('bit.inc');

                  
class sms_client {
  var $socket;
  var $buffer;
  var $dump_file_name;
  var $pklog_file_name;
  var $errno;
  var $errstr;
  var $terminated;
  var $redirected;
  var $config;
  var $capabilities;
  var $logged_in;
  var $login_packet;

  var $seq_num;

  var $on_error;
  var $on_packet_ready;
  var $on_client_ready;

  //Constructor
  function sms_client() {
    $this->dump_file_name='sms_client.log.txt';
    $this->pklog_file_name='sms_client.pk_log.txt';
    func_clear_log($this->dump_file_name, true);
    func_clear_log($this->pklog_file_name, true);
    $this->socket=false;
    $this->buffer = new icq_buffer();
    $this->on_error=null;
    $this->on_packet_ready=null;
    $this->on_client_ready=null;
    $this->seq_num=0;
    $this->config=array();
  }

  function init() {
    $this->terminated=false;
    $this->redirected=false;
    $this->seq_num=SMS_SEQ_NUM_MIN+((int)(crypt_gen_uni_id() & 0x0FFFFF));
    $this->config['cookie']='';
    $this->config['bos_ip']='';
    $this->config['bos_port']='';
//    $this->print_log("\n\n".$this->seq_num."\n");
    $this->config['contacts_fetched']=false;
    $this->logged_in=0;
    $this->login_packet=false;
  }

  function terminate() {
    $this->terminated=true;
  }

  function get_seq_num() {
    $this->seq_num++;
    if ($this->seq_num>=SMS_SEQ_NUM_MAX) $this->seq_num=SMS_SEQ_NUM_MIN;
    return $this->seq_num;
  }

  function connect($uin, $pass, $server='login.icq.com', $port=5190, $async=false) {
    $this->disconnect();
    $this->init();
    $this->config['uin']=(int)$uin;
    $this->config['password']=$pass;

    $this->print_log("\nConnecting: [".$server.":".$port."]... ", 0x03);
    if ($this->_connect($server, $port)) {
       $this->print_log("OK\n", 0x03);
    } else {
       return $this->print_log("FAIL\n", 0x03);
    }
    $this->print_log("\nLoggin in: [".$uin.":".$pass."]... ", 0x03);
    if ($this->login($uin, $pass)) {
       $this->print_log("OK\n", 0x03);
       if (!$async) $this->process();
    } else {
       $reason='login fail';
       if ($this->logged_in==-2) $reason='login timeout';
       return $this->print_log("FAIL($reason)\n", 0x03);
    }
    return true;
  }

  function _connect($server='login.icq.com', $port=5190) {
    $this->disconnect();

    $this->socket = @socket_create(AF_INET, SOCK_STREAM, SOL_TCP);
    if ($this->socket===FALSE) return $this->print_serr('socket_create', false);
    if (!@socket_connect($this->socket, $server, $port)) return $this->print_serr('socket_connect', false, $this->socket);
    if (!@socket_set_nonblock($this->socket)) return $this->print_serr('socket_set_nonblock', false, $this->socket);

    return true;
  }

  function make_pk_login($uin, $pass) {
     $res=sms_packets_new(SMS_CMD_BIND_TRANSMITTER, 0, $this->get_seq_num());
     $res['body']['SYSTEM_ID']=$uin;
     $res['body']['PASSWORD']=$pass;
     $res['body']['SYSTEM_TYPE']='';
     $res['body']['INTERFACE_VERSION']=0x34;
     $res['body']['ADDR_TON']=0;
     $res['body']['ADDR_NPI']=0;
     $res['body']['ADDRESS_RANGE']='';
     return $res;
  }
   
  function check_login_result(&$pk) {
     if ($this->logged_in!=0) return false;
     if ($this->login_packet['header']['seq_num']!=$pk['header']['seq_num']) return false;
     $this->logged_in=($pk['header']['cmd_status']==0)?1:-1;
     return true;
  }

  function login($uin, $pass, $timeout=60) {
      $this->login_packet=$this->make_pk_login($uin, $pass);
      $this->send_packet($this->login_packet);
      $btime=time();
      $etime=$btime+$timeout;
      while ($this->logged_in==0) {
         if ($etime<time()) {
            $this->logged_in=-2;
            return false;
         }
         $this->process_iteration();
         usleep(100);
      }
      return ($this->logged_in>0)?true:false;
  }

  function send_packet(&$pk) {
      $res=sms_packets_encode($pk);
      $this->write($res);
      $this->print_log("\nSent:\n", 0x03);
      $this->print_log($this->dump_packet($res, '   '));
      $this->print_log(var_export($pk, true), 0x02);
      $this->print_log("\n\n", 0x03);
  }

  function get_response_config($cmd_id) {
     global $sms_code2cmd_arr, $sms_cmd2code_arr;
     $fmt_key=(int)$cmd_id;
     if (!array_key_exists($fmt_key, $sms_code2cmd_arr)) return false;
     $ptype=$sms_code2cmd_arr[$fmt_key];
     if (count($ptype)<3) return false;
  
     $fmt_key=$ptype[2];
     if (!array_key_exists($fmt_key, $sms_cmd2code_arr)) return false;
     $ptype=$sms_cmd2code_arr[$fmt_key];
     return $ptype;
  }

  function get_response_cmd_id($cmd_id) {
     $ptype=$this->get_response_config($cmd_id);
     return ($ptype===false)?false:$ptype[1];
  }

  function auto_response(&$packet) {
     $fmt_key=$this->get_response_cmd_id($packet['header']['cmd_id']);
     if ($fmt_key!==false) {
       $pk=sms_packets_new($fmt_key, 0, $packet['header']['seq_num']);
       $this->send_packet($pk);
     }
  }

  function redirect($server='login.icq.com', $port=5190) {
    $this->redirected=true;
    $this->disconnect();
    $res=$this->_connect($server, $port);
    $this->process();
    return $res;
  }

  function disconnect() {
    if ($this->socket!==false) @socket_close($this->socket);
//    if ($this->socket) fclose($this->socket);
    $this->socket=false;
    $this->logged_in=0;
  }

  function simple_send_message($address, $text) {
     $text=iconv('CP1251', 'UCS-2BE', $text);
     $tarr=str_split($text, 160);
     $tal=count($tarr);
     $uni=crypt_gen_uni_id();
     $esmc=($tal>1)?64:0;
     for ($i=0;$i<$tal;$i++) {
       if ($tal>1) {
         $hd=chr(5).chr(0).chr(3).chr($uni).chr($tal).chr($i+1);
         $tarr[$i]=$hd.$tarr[$i];
       }
       $pk=sms_packets_new(SMS_CMD_SUBMIT_SM, 0, $this->get_seq_num());
       $pk['body']['SERVICE_TYPE']='';
       $pk['body']['SOURCE_ADDR_TON']=5;
       $pk['body']['SOURCE_ADDR_NPI']=0;
       $pk['body']['SOURCE_ADDR']='WorldClass';
       $pk['body']['DEST_ADDR_TON']=1;
       $pk['body']['DEST_ADDR_NPI']=1;
       $pk['body']['DESTINATION_ADDR']=$address;
       $pk['body']['ESM_CLASS']=$esmc;  
       $pk['body']['PROTOCOL_ID']=0;
       $pk['body']['PRIORITY_FLAG']=0;
       $pk['body']['SHEDULE_DELIVERY_TIME']=0;
       $pk['body']['VALIDITY_PERIOD']=0;
       $pk['body']['REGISTERED_DELIVERY']=1;
       $pk['body']['REPLACE_IF_PRESENT_FLAG']=0;
       $pk['body']['DATA_CODING']=8;
       $pk['body']['SM_DEFAULT_MSG_ID']=0;
       $pk['body']['SM_LENGTH']=strlen($tarr[$i]);
       $pk['body']['SHORT_MESSAGE']=$tarr[$i];
       $this->send_packet($pk);
     }
  }

  function report_error($str, $errno, $errstr) {
     $this->errno=$errno;
     $this->errstr=$errstr;
     if ($this->on_error) {
        $this->on_error($this, $str, $this->errno, $this->errstr);
     } else {
        print('Error ['.$this->errno.']: '.$this->errstr."\n".$str."\n");
     }
     return false;
  }

  function print_str($str) {
    print(iconv('CP1251', 'CP866', $str)."\r\n");
    return false;
  }

  function print_serr($prefix='', $need_exit=false, $sock=false) {
    $errcode=@socket_last_error($sock);
    $err_str=@socket_strerror($errcode);
    $this->print_str("Socket error [".$prefix."] [$errcode:$err_str]");
    if ($sock!==false) @socket_close($sock);
    if ($need_exit) exit(0);
    return false;
  }

  function try_read($prefix='') {
    if ($this->socket===false) return false;
    $write  = NULL;
    $except = NULL;
    $read = array($this->socket);
    $sres = @socket_select($read, $write, $except, 0);
    if ($sres===false) return $this->print_serr($prefix.' socket_select');
    if ($sres>0) {
      $s=@socket_read($this->socket, 2048);
      if ($s===false) return $this->print_str($prefix.' connection closed.');
      return $s;
    }
    return '';
  }

  function read($len) {
     if ($this->socket===false) return false;
     $blen=$this->buffer->count();
     $data = $this->try_read();
     while ($data!='') {
        if ($data===false) return $this->print_str('read operation failed.');
        $this->buffer->write($data);
        $data = $this->try_read();
     }

     $blen=$this->buffer->count();
//     print($blen."\n");
     if ($len>$blen) return false;
     return $this->buffer->read($len);
  }

  function write($data, $len=false) {
     if ($this->socket===false) return false;
     $length=($len)?$len:strlen($data);
     $wr_cnt=@socket_write($this->socket, $data, $length);
     if ($wr_cnt===FALSE) return $this->print_serr('socket_write', false, $this->socket);
     if ($wr_cnt!=$length) return $this->print_serr('cant write enough data', false, $this->socket);
     return true;

//     if (!$this->socket) return false;
//     $length=($len)?$len:strlen($data);
//     return fwrite($this->socket, $data, $length);
  }

  function process_iteration() {
      if ($this->terminated) return false;
      $hd=$this->read(16);
      if ($hd) {
        $pk_dec=sms_packets_decode_header($hd);
        if ($pk_dec) {
          $body=$this->read($pk_dec['header']['cmd_len']-16);
          if ($body) {
              $raw_data=$hd.$body;
              $this->print_log("\nReceived:\n", 0x03);
              $this->print_log($this->dump_packet($raw_data, '   '));
//              $pk_dec['raw_data']=$body;
              $body_off=16;
              $res=sms_packets_decode_pkdata($pk_dec, $raw_data, $body_off);
              if ($res) sms_packets_decode_tlvs($pk_dec, $raw_data, $body_off);
              $this->print_log(var_export($pk_dec, true), 0x02);
              $this->print_log("\n\n", 0x03);
              if (!$this->check_login_result($pk_dec)) {
                 if ($this->on_packet_ready) call_user_func($this->on_packet_ready, $this, $pk_dec, $raw_data);
              }
//              $this->process_flap($fl_dec, $raw_data);
          }
        }
      }
      return true;
  }

  function process() {
    while ($this->process_iteration()) usleep(100);
    $this->disconnect();
  }

  function print_log($str, $wich_log=0x01) {
    if ($wich_log & 0x01) func_print_log($this->dump_file_name, $str);
    if ($wich_log & 0x02) func_print_log($this->pklog_file_name, $str);
    return false;
  }

  function dump_packet($data, $line_prefix='') {
     $res=array();
     $l=strlen($data);
     $ind=0;
     while ($ind<$l) {
        $str=sprintf("0x%08X ",$ind);
        $ml=$l-$ind; if ($ml>16) $ml=16;
        $str1='';
        for ($i=0;$i<$ml;$i++) {
            $chc=ord($data{$ind+$i});
            $str.=sprintf(" %02X",$chc);
            if ($chc>32) {
              $str1.=chr($chc);
            } else {
              $str1.='.';
            }
        }
        $str.=str_pad('', (16-$ml)*3);
        $str.='  '.$str1;
        array_push($res, $line_prefix.$str);
        $ind+=$ml;
     }
      
     return implode("\n",$res);
  }

}



} // end incl_h
?>
