<?php
if (!defined("INC_SMS_DEF_H")){
   define("INC_SMS_DEF_H", TRUE);

   define("SMS_DT_INT", 0x01);
   define("SMS_DT_VAR_STR", 0x02);
   define("SMS_DT_FIX_STR", 0x03);
   define("SMS_DT_MAX_STR", 0x04);
   define("SMS_DT_DATE_STR", 0x05);
   define("SMS_DT_TLV", 0x06);
   define("SMS_DT_DEST_ADDR_LIST", 0x07);
   define("SMS_DT_DEST_UNSUC_LIST", 0x08);
   define("SMS_DT_SHORT_MESSAGE", 0x09);

   define("SMS_SEQ_NUM_MIN", 0x00000001);
   define("SMS_SEQ_NUM_MAX", 0x7FFFFFFF);

   $sms_cmdcodes_arr=array();
   $sms_cmdcodes_arr[]=Array("SMS_CMD_GENERIC_NACK",0x80000000);
   $sms_cmdcodes_arr[]=Array("SMS_CMD_BIND_RECEIVER", 0x00000001, "SMS_CMD_BIND_RECEIVER_RESP");
   $sms_cmdcodes_arr[]=Array("SMS_CMD_BIND_RECEIVER_RESP", 0x80000001);
   $sms_cmdcodes_arr[]=Array("SMS_CMD_BIND_TRANSMITTER", 0x00000002, "SMS_CMD_BIND_TRANSMITTER_RESP");
   $sms_cmdcodes_arr[]=Array("SMS_CMD_BIND_TRANSMITTER_RESP", 0x80000002);
   $sms_cmdcodes_arr[]=Array("SMS_CMD_QUERY_SM", 0x00000003, "SMS_CMD_QUERY_SM_RESP");
   $sms_cmdcodes_arr[]=Array("SMS_CMD_QUERY_SM_RESP", 0x80000003);
   $sms_cmdcodes_arr[]=Array("SMS_CMD_SUBMIT_SM", 0x00000004, "SMS_CMD_SUBMIT_SM_RESP");
   $sms_cmdcodes_arr[]=Array("SMS_CMD_SUBMIT_SM_RESP", 0x80000004);
   $sms_cmdcodes_arr[]=Array("SMS_CMD_DELIVER_SM", 0x00000005, "SMS_CMD_DELIVER_SM_RESP");
   $sms_cmdcodes_arr[]=Array("SMS_CMD_DELIVER_SM_RESP", 0x80000005);
   $sms_cmdcodes_arr[]=Array("SMS_CMD_UNBIND", 0x00000006, "SMS_CMD_UNBIND_RESP");
   $sms_cmdcodes_arr[]=Array("SMS_CMD_UNBIND_RESP", 0x80000006);
   $sms_cmdcodes_arr[]=Array("SMS_CMD_REPLACE_SM", 0x00000007, "SMS_CMD_REPLACE_SM_RESP");
   $sms_cmdcodes_arr[]=Array("SMS_CMD_REPLACE_SM_RESP", 0x80000007);
   $sms_cmdcodes_arr[]=Array("SMS_CMD_CANCEL_SM", 0x00000008, "SMS_CMD_CANCEL_SM_RESP");
   $sms_cmdcodes_arr[]=Array("SMS_CMD_CANCEL_SM_RESP", 0x80000008);
   $sms_cmdcodes_arr[]=Array("SMS_CMD_BIND_TRANSCEIVER", 0x00000009, "SMS_CMD_BIND_TRANSCEIVER_RESP");
   $sms_cmdcodes_arr[]=Array("SMS_CMD_BIND_TRANSCEIVER_RESP", 0x80000009);

   $sms_cmdcodes_arr[]=Array("SMS_CMD_OUTBIND", 0x8000000B);

   $sms_cmdcodes_arr[]=Array("SMS_CMD_ENQUIRE_LINK", 0x00000015, "SMS_CMD_ENQUIRE_LINK_RESP");
   $sms_cmdcodes_arr[]=Array("SMS_CMD_ENQUIRE_LINK_RESP", 0x80000015);

   $sms_cmdcodes_arr[]=Array("SMS_CMD_SUBMIT_MULTI", 0x00000021, "SMS_CMD_SUBMIT_MULTI_RESP");
   $sms_cmdcodes_arr[]=Array("SMS_CMD_SUBMIT_MULTI_RESP", 0x80000021);

   $sms_cmdcodes_arr[]=Array("SMS_CMD_ALERT_NOTIFICATION", 0x00000102);

   $sms_cmdcodes_arr[]=Array("SMS_CMD_DATA_SM", 0x00000103, "SMS_CMD_DATA_SM_RESP");
   $sms_cmdcodes_arr[]=Array("SMS_CMD_DATA_SM_RESP", 0x80000103);

   $sms_cmd2code_arr=array();
   $sms_code2cmd_arr=array();

   foreach ($sms_cmdcodes_arr as $a) {
      define($a[0], $a[1]);
      $sms_cmd2code_arr[$a[0]]=$a;
      $sms_code2cmd_arr[$a[1]]=$a;
   }

   $sms_cmdstatus_arr=array();
   $sms_cmdstatus_arr[]=Array("ESME_ROK", 0x00000000, "No Error");
   $sms_cmdstatus_arr[]=Array("ESME_RINVMSGLEN", 0x00000001, "Message Length is invalid");
   $sms_cmdstatus_arr[]=Array("ESME_RINVCMDLEN", 0x00000002, "Command Length is invalid");
   $sms_cmdstatus_arr[]=Array("ESME_RINVCMDID", 0x00000003, "Invalid Command ID");
   $sms_cmdstatus_arr[]=Array("ESME_RINVBNDSTS", 0x00000004, "Incorrect BIND Status for given command");
   $sms_cmdstatus_arr[]=Array("ESME_RALYBND", 0x00000005, "ESME Already in Bound State");
   $sms_cmdstatus_arr[]=Array("ESME_RINVPRTFLG", 0x00000006, "Invalid Priority Flag");
   $sms_cmdstatus_arr[]=Array("ESME_RINVREGDLVFLG", 0x00000007, "Invalid Registered Delivery Flag");
   $sms_cmdstatus_arr[]=Array("ESME_RSYSERR", 0x00000008, "System Error");

   $sms_cmdstatus_arr[]=Array("ESME_RINVSRCADR", 0x0000000A, "Invalid Source Address");
   $sms_cmdstatus_arr[]=Array("ESME_RINVDSTADR", 0x0000000B, "Invalid Dest Addr");
   $sms_cmdstatus_arr[]=Array("ESME_RINVMSGID", 0x0000000C, "Message ID is invalid");
   $sms_cmdstatus_arr[]=Array("ESME_RBINDFAIL", 0x0000000D, "Bind Failed");
   $sms_cmdstatus_arr[]=Array("ESME_RINVPASWD", 0x0000000E, "Invalid Password");
   $sms_cmdstatus_arr[]=Array("ESME_RINVSYSID", 0x0000000F, "Invalid System ID");

   $sms_cmdstatus_arr[]=Array("ESME_RCANCELFAIL", 0x00000011, "Cancel SM Failed");

   $sms_cmdstatus_arr[]=Array("ESME_RREPLACEFAIL", 0x00000013, "Replace SM Failed");


   $sms_cmdstatus_arr[]=Array("ESME_RMSGQFUL", 0x00000014, "Message Queue Full");
   $sms_cmdstatus_arr[]=Array("ESME_RINVSERTYP", 0x00000015, "Invalid Service Type");

   $sms_cmdstatus_arr[]=Array("ESME_RINVNUMDESTS", 0x00000033, "Invalid number of destinations");
   $sms_cmdstatus_arr[]=Array("ESME_RINVDLNAME", 0x00000034, "Invalid Distribution List name");

   $sms_cmdstatus_arr[]=Array("ESME_RINVDESTFLAG", 0x00000040, "Destination flag is invalid (submit_multi)");
   $sms_cmdstatus_arr[]=Array("ESME_RINVSUBREP", 0x00000042, "Invalid submit with replace request (i.e. submit_sm with replace_if_present_flag set)");
   $sms_cmdstatus_arr[]=Array("ESME_RINVESMCLASS", 0x00000043, "Invalid esm_class field data");
   $sms_cmdstatus_arr[]=Array("ESME_RCNTSUBDL", 0x00000044, "Cannot Submit to Distribution List");
   $sms_cmdstatus_arr[]=Array("ESME_RSUBMITFAIL", 0x00000045, "submit_sm or submit_multi failed");

   $sms_cmdstatus_arr[]=Array("ESME_RINVSRCTON", 0x00000048, "Invalid Source address TON");
   $sms_cmdstatus_arr[]=Array("ESME_RINVSRCNPI", 0x00000049, "Invalid Source address NPI");
   $sms_cmdstatus_arr[]=Array("ESME_RINVDSTTON", 0x00000050, "Invalid Destination address TON");
   $sms_cmdstatus_arr[]=Array("ESME_RINVDSTNPI", 0x00000051, "Invalid Destination address NPI");

   $sms_cmdstatus_arr[]=Array("ESME_RINVSYSTYP", 0x00000053, "Invalid system_type field");
   $sms_cmdstatus_arr[]=Array("ESME_RINVREPFLAG", 0x00000054, "Invalid replace_if_present flag");
   $sms_cmdstatus_arr[]=Array("ESME_RINVNUMMSGS", 0x00000055, "Invalid number of messages");
                                                              
   $sms_cmdstatus_arr[]=Array("ESME_RTHROTTLED", 0x00000058, "Throttling error (ESME has exceeded allowed message limits)");

   $sms_cmdstatus_arr[]=Array("ESME_RINVSCHED", 0x00000061, "Invalid Scheduled Delivery Time");
   $sms_cmdstatus_arr[]=Array("ESME_RINVEXPIRY", 0x00000062, "Invalid message validity period (Expiry time)");
   $sms_cmdstatus_arr[]=Array("ESME_RINVDFTMSGID", 0x00000063, "Predefined Message Invalid or Not Found");
   $sms_cmdstatus_arr[]=Array("ESME_RX_T_APPN", 0x00000064, "ESME Receiver Temporary App Error Code");
   $sms_cmdstatus_arr[]=Array("ESME_RX_P_APPN", 0x00000065, "ESME Receiver Permanent App Error Code");
   $sms_cmdstatus_arr[]=Array("ESME_RX_R_APPN", 0x00000066, "ESME Receiver Reject Message Error Code");
   $sms_cmdstatus_arr[]=Array("ESME_RQUERYFAIL", 0x00000067, "query_sm request failed");

   $sms_cmdstatus_arr[]=Array("ESME_RINVOPTPARSTREAM", 0x000000C0, "Error in the optional part of the PDU Body.");
   $sms_cmdstatus_arr[]=Array("ESME_ROPTPARNOTALLWD", 0x000000C1, "Optional Parameter not allowed");
   $sms_cmdstatus_arr[]=Array("ESME_RINVPARLEN", 0x000000C2, "Invalid Parameter Length.");
   $sms_cmdstatus_arr[]=Array("ESME_RMISSINGOPTPARAM", 0x000000C3, "Expected Optional Parameter missing");
   $sms_cmdstatus_arr[]=Array("ESME_RINVOPTPARAMVAL", 0x000000C4, "Invalid Optional Parameter Value");

   $sms_cmdstatus_arr[]=Array("ESME_RDELIVERYFAILURE", 0x000000FE, "Delivery Failure (used for data_sm_resp)");
   $sms_cmdstatus_arr[]=Array("ESME_RUNKNOWNERR", 0x000000FF, "Unknown Error");


   $sms_tlv_tags_arr=array();
   $sms_tlv_tags_arr[]=Array("DEST_ADDR_SUBUNIT", 0x0005, "GSM", SMS_DT_INT, 1);
   $sms_tlv_tags_arr[]=Array("DEST_NETWORK_TYPE", 0x0006, "Generic", SMS_DT_INT, 1);
   $sms_tlv_tags_arr[]=Array("DEST_BEARER_TYPE", 0x0007, "Generic", SMS_DT_INT, 1);
   $sms_tlv_tags_arr[]=Array("DEST_TELEMATICS_ID", 0x0008, "GSM", SMS_DT_INT, 2);
   $sms_tlv_tags_arr[]=Array("SOURCE_ADDR_SUBUNIT", 0x000D, "GSM", SMS_DT_INT, 1);
   $sms_tlv_tags_arr[]=Array("SOURCE_NETWORK_TYPE", 0x000E, "Generic", SMS_DT_INT, 1);
   $sms_tlv_tags_arr[]=Array("SOURCE_BEARER_TYPE", 0x000F, "Generic", SMS_DT_INT, 1);
   $sms_tlv_tags_arr[]=Array("SOURCE_TELEMATICS_ID", 0x0010, "GSM", SMS_DT_INT, 2);
   $sms_tlv_tags_arr[]=Array("QOS_TIME_TO_LIVE", 0x0017, "Generic", SMS_DT_INT, 4);
   $sms_tlv_tags_arr[]=Array("PAYLOAD_TYPE", 0x0019, "Generic", SMS_DT_INT, 1);
   $sms_tlv_tags_arr[]=Array("ADDITIONAL_STATUS_INFO_TEXT", 0x001D, "Generic", SMS_DT_VAR_STR, 256);
   $sms_tlv_tags_arr[]=Array("RECEIPTED_MESSAGE_ID", 0x001E, "Generic", SMS_DT_VAR_STR, 65);
   $sms_tlv_tags_arr[]=Array("MS_MSG_WAIT_FACILITIES", 0x0030, "GSM", SMS_DT_INT, 1);
   $sms_tlv_tags_arr[]=Array("PRIVACY_INDICATOR", 0x0201, "CDMA, TDMA", SMS_DT_INT, 1);
   $sms_tlv_tags_arr[]=Array("SOURCE_SUBADDRESS", 0x0202, "CDMA, TDMA", SMS_DT_VAR_STR, 23);
   $sms_tlv_tags_arr[]=Array("DEST_SUBADDRESS", 0x0203, "CDMA, TDMA", SMS_DT_VAR_STR, 23);
   $sms_tlv_tags_arr[]=Array("USER_MESSAGE_REFERENCE", 0x0204, "Generic", SMS_DT_INT, 2);
   $sms_tlv_tags_arr[]=Array("USER_RESPONSE_CODE", 0x0205, "CDMA, TDMA", SMS_DT_INT, 1);
   $sms_tlv_tags_arr[]=Array("LANGUAGE_INDICATOR", 0x020D, "CDMA, TDMA", SMS_DT_INT, 1);
   $sms_tlv_tags_arr[]=Array("SOURCE_PORT", 0x020A, "Generic", SMS_DT_INT, 2);
   $sms_tlv_tags_arr[]=Array("DESTINATION_PORT", 0x020B, "Generic", SMS_DT_INT, 2);
   $sms_tlv_tags_arr[]=Array("SAR_MSG_REF_NUM", 0x020C, "Generic", SMS_DT_INT, 2);
   $sms_tlv_tags_arr[]=Array("SAR_TOTAL_SEGMENTS", 0x020E, "Generic", SMS_DT_INT, 1);
   $sms_tlv_tags_arr[]=Array("SAR_SEGMENT_SEQNUM", 0x020F, "Generic", SMS_DT_INT, 1);
   $sms_tlv_tags_arr[]=Array("SC_INTERFACE_VERSION", 0x0210, "Generic", SMS_DT_INT, 1);
   $sms_tlv_tags_arr[]=Array("CALLBACK_NUM_PRES_IND", 0x0302, "TDMA", SMS_DT_INT, 1);
   $sms_tlv_tags_arr[]=Array("CALLBACK_NUM_ATAG", 0x0303, "TDMA", SMS_DT_VAR_STR, 65);
   $sms_tlv_tags_arr[]=Array("NUMBER_OF_MESSAGES", 0x0304, "CDMA", SMS_DT_INT, 1);
   $sms_tlv_tags_arr[]=Array("CALLBACK_NUM", 0x0381, "CDMA, TDMA, GSM, iDEN", SMS_DT_VAR_STR, 19);
   $sms_tlv_tags_arr[]=Array("DPF_RESULT", 0x0420, "Generic", SMS_DT_INT, 1);
   $sms_tlv_tags_arr[]=Array("SET_DPF", 0x0421, "Generic", SMS_DT_INT, 1);
   $sms_tlv_tags_arr[]=Array("MS_AVAILABILITY_STATUS", 0x0422, "Generic", SMS_DT_INT, 1);
   $sms_tlv_tags_arr[]=Array("NETWORK_ERROR_CODE", 0x0423, "Generic", SMS_DT_INT, 3);
   $sms_tlv_tags_arr[]=Array("MESSAGE_PAYLOAD", 0x0424, "Generic", SMS_DT_VAR_STR, 0);
   $sms_tlv_tags_arr[]=Array("DELIVERY_FAILURE_REASON", 0x0425, "Generic", SMS_DT_INT, 1);
   $sms_tlv_tags_arr[]=Array("MORE_MESSAGES_TO_SEND", 0x0426, "GSM", SMS_DT_INT, 1);
   $sms_tlv_tags_arr[]=Array("MESSAGE_STATE", 0x0427, "Generic", SMS_DT_INT, 1);
   $sms_tlv_tags_arr[]=Array("USSD_SERVICE_OP", 0x0501, "GSM (USSD)", SMS_DT_INT, 1);
   $sms_tlv_tags_arr[]=Array("DISPLAY_TIME", 0x1201, "CDMA, TDMA", SMS_DT_INT, 1);
   $sms_tlv_tags_arr[]=Array("SMS_SIGNAL", 0x1203, "TDMA", SMS_DT_INT, 2);
   $sms_tlv_tags_arr[]=Array("MS_VALIDITY", 0x1204, "CDMA, TDMA", SMS_DT_INT, 1);
   $sms_tlv_tags_arr[]=Array("ALERT_ON_MESSAGE_DELIVERY", 0x130C, "CDMA", SMS_DT_INT, 0);
   $sms_tlv_tags_arr[]=Array("ITS_REPLY_TYPE", 0x1380, "CDMA", SMS_DT_INT, 1);
   $sms_tlv_tags_arr[]=Array("ITS_SESSION_INFO", 0x1383, "CDMA", SMS_DT_VAR_STR, 2);

   $sms_tlv_by_tag=array();
   $sms_tlv_by_code=array();

   foreach ($sms_tlv_tags_arr as $a) {
      $sms_tlv_by_tag[$a[0]]=$a;
      $sms_tlv_by_code[$a[1]]=$a;
   }


   $sms_cmd_formats=array();

   $sms_cmd_formats[SMS_CMD_BIND_TRANSMITTER]=Array(
       7,
       Array('SYSTEM_ID',SMS_DT_VAR_STR, 16),
       Array('PASSWORD',SMS_DT_VAR_STR, 16),
       Array('SYSTEM_TYPE',SMS_DT_VAR_STR, 13),
       Array('INTERFACE_VERSION',SMS_DT_INT, 1),
       Array('ADDR_TON',SMS_DT_INT, 1),
       Array('ADDR_NPI',SMS_DT_INT, 1),
       Array('ADDRESS_RANGE',SMS_DT_VAR_STR, 41),
   );

   $sms_cmd_formats[SMS_CMD_BIND_TRANSMITTER_RESP]=Array(
       1,
       Array('SYSTEM_ID',SMS_DT_VAR_STR, 16),
       // --------- Optional parameters: --------- //
       Array('SK_INTERFACE_VERSION',SMS_DT_TLV, 0),
   );

   $sms_cmd_formats[SMS_CMD_BIND_RECEIVER]=Array(
       7,
       Array('SYSTEM_ID',SMS_DT_VAR_STR, 16),
       Array('PASSWORD',SMS_DT_VAR_STR, 16),
       Array('SYSTEM_TYPE',SMS_DT_VAR_STR, 13),
       Array('INTERFACE_VERSION',SMS_DT_INT, 1),
       Array('ADDR_TON',SMS_DT_INT, 1),
       Array('ADDR_NPI',SMS_DT_INT, 1),
       Array('ADDRESS_RANGE',SMS_DT_VAR_STR, 41),
   );

   $sms_cmd_formats[SMS_CMD_BIND_RECEIVER_RESP]=Array(
       1,
       Array('SYSTEM_ID',SMS_DT_VAR_STR, 16),
       // --------- Optional parameters: --------- //
       Array('SK_INTERFACE_VERSION',SMS_DT_TLV, 0),
   );

   $sms_cmd_formats[SMS_CMD_BIND_TRANSCEIVER]=Array(
       7,
       Array('SYSTEM_ID',SMS_DT_VAR_STR, 16),
       Array('PASSWORD',SMS_DT_VAR_STR, 16),
       Array('SYSTEM_TYPE',SMS_DT_VAR_STR, 13),
       Array('INTERFACE_VERSION',SMS_DT_INT, 1),
       Array('ADDR_TON',SMS_DT_INT, 1),
       Array('ADDR_NPI',SMS_DT_INT, 1),
       Array('ADDRESS_RANGE',SMS_DT_VAR_STR, 41),
   );

   $sms_cmd_formats[SMS_CMD_BIND_TRANSCEIVER_RESP]=Array(
       1,
       Array('SYSTEM_ID',SMS_DT_VAR_STR, 16),
       // --------- Optional parameters: --------- //
       Array('SK_INTERFACE_VERSION',SMS_DT_TLV, 0),
   );

   $sms_cmd_formats[SMS_CMD_OUTBIND]=Array(
       2,
       Array('SYSTEM_ID',SMS_DT_VAR_STR, 16),
       Array('PASSWORD',SMS_DT_VAR_STR, 9),
   );


   $sms_cmd_formats[SMS_CMD_UNBIND]=Array(
       0
   );

   $sms_cmd_formats[SMS_CMD_UNBIND_RESP]=Array(
       0
   );

   $sms_cmd_formats[SMS_CMD_GENERIC_NACK]=Array(
       0
   );

   $sms_cmd_formats[SMS_CMD_SUBMIT_SM]=Array(
       18,
       Array('SERVICE_TYPE',SMS_DT_VAR_STR, 6),
       Array('SOURCE_ADDR_TON',SMS_DT_INT, 1),
       Array('SOURCE_ADDR_NPI',SMS_DT_INT, 1),
       Array('SOURCE_ADDR',SMS_DT_VAR_STR, 21),
       Array('DEST_ADDR_TON',SMS_DT_INT, 1),
       Array('DEST_ADDR_NPI',SMS_DT_INT, 1),
       Array('DESTINATION_ADDR',SMS_DT_VAR_STR, 21),
       Array('ESM_CLASS',SMS_DT_INT, 1),
       Array('PROTOCOL_ID',SMS_DT_INT, 1),
       Array('PRIORITY_FLAG',SMS_DT_INT, 1),
       Array('SHEDULE_DELIVERY_TIME',SMS_DT_DATE_STR, 17),
       Array('VALIDITY_PERIOD',SMS_DT_DATE_STR, 17),
       Array('REGISTERED_DELIVERY',SMS_DT_INT, 1),
       Array('REPLACE_IF_PRESENT_FLAG',SMS_DT_INT, 1),
       Array('DATA_CODING',SMS_DT_INT, 1),
       Array('SM_DEFAULT_MSG_ID',SMS_DT_INT, 1),
       Array('SM_LENGTH',SMS_DT_INT, 1),
       Array('SHORT_MESSAGE',SMS_DT_SHORT_MESSAGE, 0),
       // --------- Optional parameters: --------- //
       Array('USER_MESSAGE_REFERENCE',SMS_DT_TLV, 0),
       Array('SOURCE_PORT',SMS_DT_TLV, 0),
       Array('SOURCE_ADDR_SUBUNIT',SMS_DT_TLV, 0),
       Array('DESTINATION_PORT',SMS_DT_TLV, 0),
       Array('DEST_ADDR_SUBUNIT',SMS_DT_TLV, 0),
       Array('SAR_MSG_REF_NUM',SMS_DT_TLV, 0),
       Array('SAR_TOTAL_SEGMENTS',SMS_DT_TLV, 0),
       Array('SAR_SEGMENT_SEQNUM',SMS_DT_TLV, 0),
       Array('MORE_MESSAGES_TO_SEND',SMS_DT_TLV, 0),
       Array('PAYLOAD_TYPE',SMS_DT_TLV, 0),
       Array('MESSAGE_PAYLOAD',SMS_DT_TLV, 0),
       Array('PRIVACY_INDICATOR',SMS_DT_TLV, 0),
       Array('CALLBACK_NUM',SMS_DT_TLV, 0),
       Array('CALLBACK_NUM_PRES_IND',SMS_DT_TLV, 0),
       Array('CALLBACK_NUM_ATAG',SMS_DT_TLV, 0),
       Array('SOURCE_SUBADDRESS',SMS_DT_TLV, 0),
       Array('USER_RESPONCE_CODE',SMS_DT_TLV, 0),
       Array('DISPLAY_TIME',SMS_DT_TLV, 0),
       Array('SMS_SIGNAL',SMS_DT_TLV, 0),
       Array('MS_VALIDITY',SMS_DT_TLV, 0),
       Array('MS_MSG_WAIT_FACILITIES',SMS_DT_TLV, 0),
       Array('NUMBER_OF_MESSAGES',SMS_DT_TLV, 0),
       Array('ALERT_ON_MSG_DELIVERY',SMS_DT_TLV, 0),
       Array('LANGUAGE_INDICATOR',SMS_DT_TLV, 0),
       Array('ITS_REPLY_TYPE',SMS_DT_TLV, 0),
       Array('ITS_SESSION_INFO',SMS_DT_TLV, 0),
       Array('USSD_SERVICE_OP',SMS_DT_TLV, 0),
   );
  
   $sms_cmd_formats[SMS_CMD_SUBMIT_SM_RESP]=Array(
       1,
       Array('MESSAGE_ID',SMS_DT_VAR_STR, 65),
   );

   $sms_cmd_formats[SMS_CMD_SUBMIT_MULTI]=Array(
       17,
       Array('SERVICE_TYPE',SMS_DT_VAR_STR, 6),
       Array('SOURCE_ADDR_TON',SMS_DT_INT, 1),
       Array('SOURCE_ADDR_NPI',SMS_DT_INT, 1),
       Array('SOURCE_ADDR',SMS_DT_VAR_STR, 21),
       Array('NUMBER_OF_DESTS',SMS_DT_INT, 1),
       Array('DEST_SADDRESSES',SMS_DT_DEST_ADDR_LIST, 0),
       Array('ESM_CLASS',SMS_DT_INT, 1),
       Array('PROTOCOL_ID',SMS_DT_INT, 1),
       Array('PRIORITY_FLAG',SMS_DT_INT, 1),
       Array('SHEDULE_DELIVERY_TIME',SMS_DT_DATE_STR, 17),
       Array('VALIDITY_PERIOD',SMS_DT_DATE_STR, 17),
       Array('REGISTERED_DELIVERY',SMS_DT_INT, 1),
       Array('REPLACE_IF_PRESENT_FLAG',SMS_DT_INT, 1),
       Array('DATA_CODING',SMS_DT_INT, 1),
       Array('SM_DEFAULT_MSG_ID',SMS_DT_INT, 1),
       Array('SM_LENGTH',SMS_DT_INT, 1),
       Array('SHORT_MESSAGE',SMS_DT_SHORT_MESSAGE, 0),
       // --------- Optional parameters: --------- //
       Array('USER_MESSAGE_REFERENCE',SMS_DT_TLV, 0),
       Array('SOURCE_PORT',SMS_DT_TLV, 0),
       Array('SOURCE_ADDR_SUBUNIT',SMS_DT_TLV, 0),
       Array('DESTINATION_PORT',SMS_DT_TLV, 0),
       Array('DEST_ADDR_SUBUNIT',SMS_DT_TLV, 0),
       Array('SAR_MSG_REF_NUM',SMS_DT_TLV, 0),
       Array('SAR_TOTAL_SEGMENTS',SMS_DT_TLV, 0),
       Array('SAR_SEGMENT_SEQNUM',SMS_DT_TLV, 0),
       Array('PAYLOAD_TYPE',SMS_DT_TLV, 0),
       Array('MESSAGE_PAYLOAD',SMS_DT_TLV, 0),
       Array('PRIVACY_INDICATOR',SMS_DT_TLV, 0),
       Array('CALLBACK_NUM',SMS_DT_TLV, 0),
       Array('CALLBACK_NUM_PRES_IND',SMS_DT_TLV, 0),
       Array('CALLBACK_NUM_ATAG',SMS_DT_TLV, 0),
       Array('SOURCE_SUBADDRESS',SMS_DT_TLV, 0),
       Array('DEST_SUBADDRESS',SMS_DT_TLV, 0),
       Array('DISPLAY_TIME',SMS_DT_TLV, 0),
       Array('SMS_SIGNAL',SMS_DT_TLV, 0),
       Array('MS_VALIDITY',SMS_DT_TLV, 0),
       Array('MS_MSG_WAIT_FACILITIES',SMS_DT_TLV, 0),
       Array('ALERT_ON_MSG_DELIVERY',SMS_DT_TLV, 0),
       Array('LANGUAGE_INDICATOR',SMS_DT_TLV, 0),
   );
  
   $sms_cmd_formats[SMS_CMD_SUBMIT_MULTI_RESP]=Array(
       1,
       Array('MESSAGE_ID',SMS_DT_VAR_STR, 65),
       Array('NO_UNSUCCESS',SMS_DT_INT, 1),
       Array('UNSUCCESS_SMES',SMS_DT_DEST_UNSUC_LIST, 0),
   );


   $sms_cmd_formats[SMS_CMD_DELIVER_SM]=Array(
       18,
       Array('SERVICE_TYPE',SMS_DT_VAR_STR, 6),
       Array('SOURCE_ADDR_TON',SMS_DT_INT, 1),
       Array('SOURCE_ADDR_NPI',SMS_DT_INT, 1),
       Array('SOURCE_ADDR',SMS_DT_VAR_STR, 21),
       Array('DEST_ADDR_TON',SMS_DT_INT, 1),
       Array('DEST_ADDR_NPI',SMS_DT_INT, 1),
       Array('DESTINATION_ADDR',SMS_DT_VAR_STR, 21),
       Array('ESM_CLASS',SMS_DT_INT, 1),
       Array('PROTOCOL_ID',SMS_DT_INT, 1),
       Array('PRIORITY_FLAG',SMS_DT_INT, 1),
       Array('SHEDULE_DELIVERY_TIME',SMS_DT_DATE_STR, 17),
       Array('VALIDITY_PERIOD',SMS_DT_DATE_STR, 17),
       Array('REGISTERED_DELIVERY',SMS_DT_INT, 1),
       Array('REPLACE_IF_PRESENT_FLAG',SMS_DT_INT, 1),
       Array('DATA_CODING',SMS_DT_INT, 1),
       Array('SM_DEFAULT_MSG_ID',SMS_DT_INT, 1),
       Array('SM_LENGTH',SMS_DT_INT, 1),
       Array('SHORT_MESSAGE',SMS_DT_SHORT_MESSAGE, 0),
       // --------- Optional parameters: --------- //
       Array('USER_MESSAGE_REFERENCE',SMS_DT_TLV, 0),
       Array('SOURCE_PORT',SMS_DT_TLV, 0),
       Array('DESTINATION_PORT',SMS_DT_TLV, 0),
       Array('SAR_MSG_REF_NUM',SMS_DT_TLV, 0),
       Array('SAR_TOTAL_SEGMENTS',SMS_DT_TLV, 0),
       Array('SAR_SEGMENT_SEQNUM',SMS_DT_TLV, 0),
       Array('USER_RESPONCE_CODE',SMS_DT_TLV, 0),
       Array('PRIVACY_INDICATOR',SMS_DT_TLV, 0),
       Array('PAYLOAD_TYPE',SMS_DT_TLV, 0),
       Array('MESSAGE_PAYLOAD',SMS_DT_TLV, 0),
       Array('CALLBACK_NUM',SMS_DT_TLV, 0),
       Array('SOURCE_SUBADDRESS',SMS_DT_TLV, 0),
       Array('DEST_SUBADDRESS',SMS_DT_TLV, 0),
       Array('LANGUAGE_INDICATOR',SMS_DT_TLV, 0),
       Array('ITS_SESSION_INFO',SMS_DT_TLV, 0),
       Array('NETWORK_ERROR_CODE',SMS_DT_TLV, 0),
       Array('MESSAGE_STATE',SMS_DT_TLV, 0),
       Array('RECEIPTED_MESSAGE_ID',SMS_DT_TLV, 0),
   );
  
   $sms_cmd_formats[SMS_CMD_DELIVER_SM_RESP]=Array(
       1,
       Array('MESSAGE_ID',SMS_DT_VAR_STR, 65),
   );


   $sms_cmd_formats[SMS_CMD_DATA_SM]=Array(
       10,
       Array('SERVICE_TYPE',SMS_DT_VAR_STR, 6),
       Array('SOURCE_ADDR_TON',SMS_DT_INT, 1),
       Array('SOURCE_ADDR_NPI',SMS_DT_INT, 1),
       Array('SOURCE_ADDR',SMS_DT_VAR_STR, 21),
       Array('DEST_ADDR_TON',SMS_DT_INT, 1),
       Array('DEST_ADDR_NPI',SMS_DT_INT, 1),
       Array('DESTINATION_ADDR',SMS_DT_VAR_STR, 21),
       Array('ESM_CLASS',SMS_DT_INT, 1),
       Array('REGISTERED_DELIVERY',SMS_DT_INT, 1),
       Array('DATA_CODING',SMS_DT_INT, 1),
       // --------- Optional parameters: --------- //
       Array('SOURCE_PORT',SMS_DT_TLV, 0),
       Array('SOURCE_ADDR_SUBUNIT',SMS_DT_TLV, 0),
       Array('SOURCE_NETWORK_TYPE',SMS_DT_TLV, 0),
       Array('SOURCE_BEARER_TYPE',SMS_DT_TLV, 0),
       Array('SOURCE_TELEMATICS_ID',SMS_DT_TLV, 0),
       Array('DESTINATION_PORT',SMS_DT_TLV, 0),
       Array('DEST_ADDR_SUBUNIT',SMS_DT_TLV, 0),
       Array('DEST_NETWORK_TYPE',SMS_DT_TLV, 0),
       Array('DEST_BEARER_TYPE',SMS_DT_TLV, 0),
       Array('DEST_TELEMATICS_ID',SMS_DT_TLV, 0),
       Array('SAR_MSG_REF_NUM',SMS_DT_TLV, 0),
       Array('SAR_TOTAL_SEGMENTS',SMS_DT_TLV, 0),
       Array('SAR_SEGMENT_SEQNUM',SMS_DT_TLV, 0),
       Array('MORE_MESSAGES_TO_SEND',SMS_DT_TLV, 0),
       Array('QOS_TIME_TO_LIVE',SMS_DT_TLV, 0),
       Array('PAYLOAD_TYPE',SMS_DT_TLV, 0),
       Array('MESSAGE_PAYLOAD',SMS_DT_TLV, 0),
       Array('SET_DPF',SMS_DT_TLV, 0),
       Array('RECEIPTED_MESSAGE_ID',SMS_DT_TLV, 0),
       Array('MESSAGE_STATE',SMS_DT_TLV, 0),
       Array('NETWORK_ERROR_CODE',SMS_DT_TLV, 0),
       Array('USER_MESSAGE_REFERENCE',SMS_DT_TLV, 0),
       Array('PRIVACY_INDICATOR',SMS_DT_TLV, 0),
       Array('CALLBACK_NUM',SMS_DT_TLV, 0),
       Array('CALLBACK_NUM_PRES_IND',SMS_DT_TLV, 0),
       Array('CALLBACK_NUM_ATAG',SMS_DT_TLV, 0),
       Array('SOURCE_SUBADDRESS',SMS_DT_TLV, 0),
       Array('DEST_SUBADDRESS',SMS_DT_TLV, 0),
       Array('USER_RESPONCE_CODE',SMS_DT_TLV, 0),
       Array('DISPLAY_TIME',SMS_DT_TLV, 0),
       Array('SMS_SIGNAL',SMS_DT_TLV, 0),
       Array('MS_VALIDITY',SMS_DT_TLV, 0),
       Array('MS_MSG_WAIT_FACILITIES',SMS_DT_TLV, 0),
       Array('NUMBER_OF_MESSAGES',SMS_DT_TLV, 0),
       Array('ALERT_ON_MSG_DELIVERY',SMS_DT_TLV, 0),
       Array('LANGUAGE_INDICATOR',SMS_DT_TLV, 0),
       Array('ITS_REPLY_TYPE',SMS_DT_TLV, 0),
       Array('ITS_SESSION_INFO',SMS_DT_TLV, 0),
   );
  
   $sms_cmd_formats[SMS_CMD_DATA_SM_RESP]=Array(
       1,
       Array('MESSAGE_ID',SMS_DT_VAR_STR, 65),
       // --------- Optional parameters: --------- //
       Array('DELIVERY_FAILURE_REASON',SMS_DT_TLV, 0),
       Array('NETWORK_ERROR_CODE',SMS_DT_TLV, 0),
       Array('ADDITIONAL_STATUS_INFO_TEXT',SMS_DT_TLV, 0),
       Array('DPF_RESULT',SMS_DT_TLV, 0),
   );

   $sms_cmd_formats[SMS_CMD_QUERY_SM]=Array(
       4,
       Array('MESSAGE_ID',SMS_DT_VAR_STR, 65),
       Array('SOURCE_ADDR_TON',SMS_DT_INT, 1),
       Array('SOURCE_ADDR_NPI',SMS_DT_INT, 1),
       Array('SOURCE_ADDR',SMS_DT_VAR_STR, 21),
   );
  
   $sms_cmd_formats[SMS_CMD_QUERY_SM_RESP]=Array(
       4,
       Array('MESSAGE_ID',SMS_DT_VAR_STR, 65),
       Array('FINAL_DATE',SMS_DT_DATE_STR, 17),
       Array('MESSAGE_STATE',SMS_DT_INT, 1),
       Array('ERROR_CODE',SMS_DT_INT, 1),
   );

   $sms_cmd_formats[SMS_CMD_CANCEL_SM]=Array(
       8,
       Array('SERVICE_TYPE',SMS_DT_VAR_STR, 6),
       Array('MESSAGE_ID',SMS_DT_VAR_STR, 65),
       Array('SOURCE_ADDR_TON',SMS_DT_INT, 1),
       Array('SOURCE_ADDR_NPI',SMS_DT_INT, 1),
       Array('SOURCE_ADDR',SMS_DT_VAR_STR, 21),
       Array('DEST_ADDR_TON',SMS_DT_INT, 1),
       Array('DEST_ADDR_NPI',SMS_DT_INT, 1),
       Array('DESTINATION_ADDR',SMS_DT_VAR_STR, 21),
   );
  
   $sms_cmd_formats[SMS_CMD_CANCEL_SM_RESP]=Array(
       0,
   );

   $sms_cmd_formats[SMS_CMD_REPLACE_SM]=Array(
       10,
       Array('MESSAGE_ID',SMS_DT_VAR_STR, 65),
       Array('SOURCE_ADDR_TON',SMS_DT_INT, 1),
       Array('SOURCE_ADDR_NPI',SMS_DT_INT, 1),
       Array('SOURCE_ADDR',SMS_DT_VAR_STR, 21),
       Array('SHEDULE_DELIVERY_TIME',SMS_DT_DATE_STR, 17),
       Array('VALIDITY_PERIOD',SMS_DT_DATE_STR, 17),
       Array('REGISTERED_DELIVERY',SMS_DT_INT, 1),
       Array('SM_DEFAULT_MSG_ID',SMS_DT_INT, 1),
       Array('SM_LENGTH',SMS_DT_INT, 1),
       Array('SHORT_MESSAGE',SMS_DT_SHORT_MESSAGE, 0),
   );
  
   $sms_cmd_formats[SMS_CMD_REPLACE_SM_RESP]=Array(
       0,
   );

   $sms_cmd_formats[SMS_CMD_ENQUIRE_LINK]=Array(
       0,
   );

   $sms_cmd_formats[SMS_CMD_ENQUIRE_LINK_RESP]=Array(
       0,
   );

   $sms_cmd_formats[SMS_CMD_ALERT_NOTIFICATION]=Array(
       6,
       Array('SOURCE_ADDR_TON',SMS_DT_INT, 1),
       Array('SOURCE_ADDR_NPI',SMS_DT_INT, 1),
       Array('SOURCE_ADDR',SMS_DT_VAR_STR, 21),
       Array('ESME_ADDR_TON',SMS_DT_INT, 1),
       Array('ESME_ADDR_NPI',SMS_DT_INT, 1),
       Array('ESME_ADDR',SMS_DT_VAR_STR, 21),
       // --------- Optional parameters: --------- //
       Array('MS_AVAILABILITY_STATUS',SMS_DT_TLV, 0),
   );

} // end incl_h
?>
