<?php  
if (!defined("INC_SMS_PACKETS_H")){
   define("INC_SMS_PACKETS_H", TRUE);

function sms_packets_num_encode($val, $bytes_count=4) {
   $result = '';
   if ($bytes_count>3) $result .= chr(($val >> 24) & 0xFF);
   if ($bytes_count>2) $result .= chr(($val >> 16) & 0xFF);
   if ($bytes_count>1) $result .= chr(($val >> 8) & 0xFF);
   if ($bytes_count>0) $result .= chr($val);
   return $result;
}

function sms_packets_num_decode_($data, $bytes_count=4, $offset=0) {
   $i=$offset;
   $result = 0;
/*
   $res='';
   if ($bytes_count>3) $res.= sprintf('%02X',ord($data{$i++}));
   if ($bytes_count>2) $res.= sprintf('%02X',ord($data{$i++}));
   if ($bytes_count>1) $res.= sprintf('%02X',ord($data{$i++}));
   if ($bytes_count>0) $res.= sprintf('%02X',ord($data{$i++}));
   return hexdec($res);
*/

   if ($bytes_count>3) $result |= (ord($data{$i++}) << 24) & 0xFF000000;
   if ($bytes_count>2) $result |= (ord($data{$i++}) << 16) & 0xFF0000;
   if ($bytes_count>1) $result |= (ord($data{$i++}) << 8) & 0xFF00;
   if ($bytes_count>0) $result |= ord($data{$i++}) & 0xFF;
   return $result;
}

function sms_packets_decode_num($data, $bytes_count=4, &$offset=0) {
   $result = sms_packets_num_decode_($data, $bytes_count, $offset);
   $offset+=$bytes_count;
   return $result;
}

function sms_packets_num_decode($data, $bytes_count=4, $offset=0) {
   $len = strlen($data);
   $rlen=$len-$offset;
   if ($rlen<0) return 0;
   if ($rlen<4 && $bytes_count>$rlen) $bytes_count=$rlen;
   return sms_packets_num_decode_($data, $bytes_count, $offset);
}

function sms_packets_num_encode_r($val, $bytes_count=4) {
   $result = '';
   if ($bytes_count>0) $result .= chr($val);
   if ($bytes_count>1) $result .= chr(($val >> 8) & 0xFF);
   if ($bytes_count>2) $result .= chr(($val >> 16) & 0xFF);
   if ($bytes_count>3) $result .= chr(($val >> 24) & 0xFF);
   return $result;
}

function sms_packets_num_decode_r_($data, $bytes_count=4, $offset=0) {
   $i=$offset;
   $result = 0;
   if ($bytes_count>0) $result |= ord($data{$i++});
   if ($bytes_count>1) $result |= (ord($data{$i++}) << 8);
   if ($bytes_count>2) $result |= (ord($data{$i++}) << 16);
   if ($bytes_count>3) $result |= (ord($data{$i++}) << 24);
   return $result;
}

function sms_packets_decode_num_r($data, $bytes_count=4, &$offset=0) {
   $result = sms_packets_num_decode_r_($data, $bytes_count, $offset);
   $offset+=$bytes_count;
   return $result;
}                                

function sms_packets_num_decode_r($data, $bytes_count=4, $offset=0) {
   $len = strlen($data);
   $rlen=$len-$offset;
   if ($rlen<0) return 0;
   if ($rlen<4 && $bytes_count>$rlen) $bytes_count=$rlen;
   return sms_packets_num_decode_r_($data, $bytes_count, $offset);
}

function sms_packets_decode_str($data, $bytes_count=0, &$offset=0) {
   $result=substr($data, $offset, $bytes_count);
   $offset+=$bytes_count;
   return $result;
}

function sms_packets_encode_string($str, $max_len=0) {
  $result=$str;
  $len=strlen($str);
  if ($max_len>0 && $len>$max_len-1) {
    $result=substr($str, 0, $max_len-1);
  }
  $result.="\x00";
  return $result;
}

function sms_packets_decode_string_($data, &$offset, $max_len=0) {
   $len=strlen($data);

   if ($max_len<=0 || $max_len>$len-$offset) $max_len=$len-$offset;
   if ($max_len<=0) return '';
   $loffset=$offset+$max_len;

   $pos=strpos($data, "\0", $offset);
   if ($pos===false || $pos>$loffset) $pos=$loffset;
   $start=$offset; $offset=$pos;
   return substr($data, $start, $pos-$start);
}

function sms_packets_decode_string($data, &$offset, $max_len=0) {
   $len=strlen($data);
   $mlen=(($max_len>0) && ($len>($offset+$max_len)))?$offset+$max_len:$len;
   $result='';
   while($offset<$mlen) {
      $ch=$data{$offset};
      $code=ord($ch);
      $offset++;
      if ($code==0x00) break;
      $result.=$ch;
   }
   return $result;
}

function sms_packets_new($cmd_id=0, $cmd_status=0, $seq_num=0) {
  $packet=Array();
  $packet['header']=Array();
  $packet['body']=Array();
  $packet['tlvs']=Array();
  $packet['header']['cmd_len']=0;
  $packet['header']['cmd_id']=$cmd_id;
  $packet['header']['cmd_status']=$cmd_status;
  $packet['header']['seq_num']=$seq_num;
  return $packet;
}

function sms_packets_decode_header($data, $in_offset=0) {
  $packet=sms_packets_new();
  $dlen=strlen($data);     
  $max_offset=$dlen-16;
  $offset=$in_offset;

  if ($offset>$max_offset) return false;
  $packet['header']['cmd_len']=sms_packets_decode_num($data, 4, $offset);
  if ($packet['header']['cmd_len']<16 || $packet['header']['cmd_len']>1024) return false;
  $packet['header']['cmd_id']=sms_packets_decode_num($data, 4, $offset);
  $packet['header']['cmd_status']=sms_packets_decode_num($data, 4, $offset);
  $packet['header']['seq_num']=sms_packets_decode_num($data, 4, $offset);
  return $packet;
}                    

function sms_packets_decode_packet($data, $in_offset=0) {
   $offset=$in_offset;
   $packet=sms_packets_decode_header($data, $offset);
   if (!$packet) return false;
   $dlen=strlen($data);
   $max_offset=$dlen-$packet['header']['cmd_len'];
   if ($offset>$max_offset) return false;
   $offset+=16;
   $res=sms_packets_decode_pkdata($packet, $data, $offset);
   if ($res) sms_packets_decode_tlvs($packet, $data, $offset);
   return $packet;
}

function sms_packets_encode_dest_addr($val_arr) {
  $res=array();
  $count=count($val_arr);
  for ($i=0;$i<$count;$i++) {
    $addr=$val_arr[$i];
    array_push($res, sms_packets_num_encode($addr['dest_flag'], 1));
    if ($addr['dest_flag']==1) {
       array_push($res, sms_packets_num_encode($addr['dest_address']['dest_addr_ton'], 1));
       array_push($res, sms_packets_num_encode($addr['dest_address']['dest_addr_npi'], 1));
       array_push($res, sms_packets_encode_string($addr['dest_address']['destination_addr'], 21));
    } else if ($addr['dest_flag']==2) {
       array_push($res, sms_packets_encode_string($addr['dl_name'], 21));
    }
  }
  return implode('',$res);
}

function sms_packets_decode_dest_addr($data, &$offset, $count) {
   $result=Array();
   for ($i=0;$i<$count;$i++) {
      $addr=Array();
      $addr['dest_flag']=sms_packets_decode_num($data, 1, $offset);
      $addr['dest_address']=Array();
      $addr['dl_name']='';
      if ($addr['dest_flag']==1) {
        $addr['dest_address']['dest_addr_ton']=sms_packets_decode_num($data, 1, $offset);
        $addr['dest_address']['dest_addr_npi']=sms_packets_decode_num($data, 1, $offset);
        $addr['dest_address']['destination_addr']=sms_packets_decode_string($data,$offset,21);
      } else if ($addr['dest_flag']==2) {
        $addr['dl_name']=sms_packets_decode_string($data,$offset,21);
      }
      $result[]=$addr;
   }
   return $result;
}

function sms_packets_encode_unsuc_smes($val_arr) {
  $res=array();
  $count=count($val_arr);
  for ($i=0;$i<$count;$i++) {
    $addr=$val_arr[$i];
    array_push($res, sms_packets_num_encode($addr['dest_addr_ton'], 1));
    array_push($res, sms_packets_num_encode($addr['dest_addr_npi'], 1));
    array_push($res, sms_packets_encode_string($addr['destination_addr'], 21));
    array_push($res, sms_packets_num_encode($addr['error_status_code'], 4));
  }
  return implode('',$res);
}

function sms_packets_decode_unsuc_smes($data, &$offset, $count) {
   $result=Array();
   for ($i=0;$i<$count;$i++) {
      $addr=Array();
      $addr['dest_addr_ton']=sms_packets_decode_num($data, 1, $offset);
      $addr['dest_addr_npi']=sms_packets_decode_num($data, 1, $offset);
      $addr['destination_addr']=sms_packets_decode_string($data,$offset,21);
      $addr['error_status_code']=sms_packets_decode_num($data, 4, $offset);
      $result[]=$addr;
   }
   return $result;
}

function sms_packets_encode_date_str($uts=false, $is_relative=false) {
   $sec_in_quarter=15*60;
   $sec_in_min=60;
   $sec_in_hour=$sec_in_min*60;
   $sec_in_day=$sec_in_hour*24;
   $sec_in_mon=$sec_in_day*30;
   $sec_in_year=$sec_in_day*365;

   if ($uts===0) return '';

   if ($is_relative) {
     if ($uts===false) return '';
     return "\x00";
//     $res='';
//     $temp=(int)($uts/$sec_in_year); $uts=$uts-($temp*$sec_in_year);
//     $temp=$temp.''; if (strlen($temp)<2)
     

   } else {
     if ($uts===false) $uts=time();
     $dif=(int)date('Z', $uts);
     $dif=(int)($dif/$sec_in_quarter);
     $sign=($dif>=0)?'+':'-';
     return date('ymdHis0', $uts).sprintf("%02d", $dif).$sign;
   }
}

function sms_packets_decode_date_str($str) {
  $sec_in_quarter=15*60;
  $sec_in_min=60;
  $sec_in_hour=$sec_in_min*60;
  $sec_in_day=$sec_in_hour*24;
  $sec_in_mon=$sec_in_day*30;
  $sec_in_year=$sec_in_day*365;
  

  $str=trim($str);
  $len=strlen($str);
  if ($len<16) return false;
  if ($len>16) $str=substr($str,0,16);
  if (!preg_match('/([\d]{2})([\d]{2})([\d]{2})([\d]{2})([\d]{2})([\d]{2})([\d])([\d]{2})([\+\-\R])/', $str, $matches)) return false;
  $year=(int)$matches[1];
  $mon=(int)$matches[2];
  $day=(int)$matches[3];
  $hour=(int)$matches[4];
  $min=(int)$matches[5];
  $sec=(int)$matches[6];
  $ten=(int)$matches[7];
  $dif=(int)$matches[8];
  $sign=$matches[9];


  $is_relative=false;
  $timeval=0;
  $gmtimeval=0;

  if ($sign=='R') {
    $is_relative=true;
    $timeval=$sec+
             $min*$sec_in_min+
             $hour*$sec_in_hour+
             $day*$sec_in_day+
             $mon*$sec_in_mon+
             $year*$sec_in_year;
  } else {
    $timeval=gmmktime($hour, $min, $sec, $mon, $day, $year);
    if ($sign=='+') {
       $dif=$dif;
    } else if ($sign=='-') {
       $dif=-$dif;
    }
    $diff_secs=$dif*$sec_in_quarter;
    $timeval=$timeval-$diff_secs;
  }
  return Array($timeval, $dif, $is_relative);
}

function sms_packets_decode_field($data, &$offset, $fmt, $len, &$packet=NULL) {
     $result=false;
     if ($fmt==SMS_DT_INT) {
         $result=sms_packets_decode_num($data, $len, $offset);
     } else if ($fmt==SMS_DT_VAR_STR) {
         $result=sms_packets_decode_string($data,$offset,$len);
     } else if ($fmt==SMS_DT_FIX_STR) {
         $result=sms_packets_decode_string($data,$offset,$len);
     } else if ($fmt==SMS_DT_MAX_STR) {
         $result=sms_packets_decode_string($data,$offset,$len);
     } else if ($fmt==SMS_DT_DATE_STR) {
         $result=sms_packets_decode_date_str(sms_packets_decode_string($data,$offset,$len));
     } else if ($fmt==SMS_DT_DEST_ADDR_LIST && $packet!=NULL) {
         if ( array_key_exists('NUMBER_OF_DESTS', $packet['body']) &&
              array_key_exists('data', $packet['body']['NUMBER_OF_DESTS']) &&
              $packet['body']['NUMBER_OF_DESTS']['data']>0
              ) {
             $result=sms_packets_decode_dest_addr($data, $offset, $packet['body']['NUMBER_OF_DESTS']['data']);
         }
     } else if ($fmt==SMS_DT_DEST_UNSUC_LIST && $packet!=NULL) {
         if ( array_key_exists('NO_UNSUCCESS', $packet['body']) &&
              array_key_exists('data', $packet['body']['NO_UNSUCCESS']) &&
              $packet['body']['NO_UNSUCCESS']['data']>0
              ) {
             $result=sms_packets_decode_unsuc_smes($data, $offset, $packet['body']['NO_UNSUCCESS']['data']);
         }
     } else if ($fmt==SMS_DT_SHORT_MESSAGE && $packet!=NULL) {
         $result=sms_packets_decode_str($data, $packet['body']['SM_LENGTH'], $offset);
     }
     return $result;
}

function sms_packets_encode_field($value, $fmt, $len) {
     $result='';
     if ($fmt==SMS_DT_INT) {
         $result=sms_packets_num_encode($value, $len);
     } else if ($fmt==SMS_DT_VAR_STR) {
         $result=sms_packets_encode_string($value, $len);
     } else if ($fmt==SMS_DT_FIX_STR) {
         $result=sms_packets_encode_string($value, $len);
     } else if ($fmt==SMS_DT_MAX_STR) {
         $result=sms_packets_encode_string($value, $len);
     } else if ($fmt==SMS_DT_DATE_STR) {
         $result=sms_packets_encode_string(sms_packets_encode_date_str($value), $len);
     } else if ($fmt==SMS_DT_DEST_ADDR_LIST) {
         $result=sms_packets_encode_dest_addr($value);
     } else if ($fmt==SMS_DT_DEST_UNSUC_LIST) {
         $result=sms_packets_encode_unsuc_smes($value);
     } else if ($fmt==SMS_DT_SHORT_MESSAGE) {
         $result=$value;
     }
     return $result;
}

function sms_packets_decode_pkdata(&$packet, $data, &$offset) {
  global $sms_code2cmd_arr, $sms_cmd_formats;
  $fmt_key=(int)$packet['header']['cmd_id'];
//  $packet['fmt_key']=gettype($packet['header']['cmd_id']);
  if (!array_key_exists($fmt_key, $sms_code2cmd_arr)) return false;
  $packet['cmd_str']=$sms_code2cmd_arr[$fmt_key][0];
  if (!array_key_exists($fmt_key, $sms_cmd_formats)) return false;
  $fmt=$sms_cmd_formats[$fmt_key];
  $fix_param_count=$fmt[0];
  for ($i=1;$i<=$fix_param_count;$i++) {
     $cur_fmt=$fmt[$i];
     $packet['body'][$cur_fmt[0]]=sms_packets_decode_field($data, $offset, $cur_fmt[1], $cur_fmt[2], $packet);
  }
  return true;
}

function sms_packets_encode_body(&$packet) {
  global $sms_code2cmd_arr, $sms_cmd_formats;
  $res=array();
  $fmt_key=(int)$packet['header']['cmd_id'];
  if (!array_key_exists($fmt_key, $sms_code2cmd_arr)) return false;
  $packet['cmd_str']=$sms_code2cmd_arr[$fmt_key][0];
  if (!array_key_exists($fmt_key, $sms_cmd_formats)) return false;
  $fmt=$sms_cmd_formats[$fmt_key];
  $fix_param_count=$fmt[0];
  $offset=0;
  for ($i=1;$i<=$fix_param_count;$i++) {
     $cur_fmt=$fmt[$i];
     $val='';
     if (array_key_exists($cur_fmt[0], $packet['body'])) $val=$packet['body'][$cur_fmt[0]];
     array_push($res, sms_packets_encode_field($val, $cur_fmt[1], $cur_fmt[2]));
  }
  return implode('',$res);
}

function sms_packets_encode(&$packet) {
  $res=array();
  $body_data=sms_packets_encode_body($packet);
  $tlvs_data=sms_packets_encode_tlvs($packet);
  
  $packet['header']['cmd_len']=16+strlen($body_data)+strlen($tlvs_data);

  array_push($res, sms_packets_num_encode($packet['header']['cmd_len'], 4));
  array_push($res, sms_packets_num_encode($packet['header']['cmd_id'], 4));
  array_push($res, sms_packets_num_encode($packet['header']['cmd_status'], 4));
  array_push($res, sms_packets_num_encode($packet['header']['seq_num'], 4));
  array_push($res, $body_data);
  array_push($res, $tlvs_data);
  return implode('',$res);
}

function sms_packets_decode_tlvs(&$packet, $data, &$offset) {
  global $sms_tlv_by_tag, $sms_tlv_by_code;
  while(($tlv=sms_packets_tlv_decode($data, $offset))!==false) {
     $offset+=4+$tlv['length'];
     $tag=$tlv['tag'];
     if (array_key_exists($tag, $sms_tlv_by_code)) {
       $tlv_conf=$sms_tlv_by_code[$tag];
       $offs=0;
       $val=sms_packets_decode_field($tlv['value'], $offs, $tlv_conf[3], $tlv_conf[4]);
       $packet['tlvs'][$tlv_conf[0]]=$val;
     }
  }
}

function sms_packets_encode_tlvs(&$packet) {
  global $sms_tlv_by_tag, $sms_tlv_by_code;
  $res=array();
  foreach ($packet['tlvs'] as $key=>$val) {
     if (array_key_exists($key, $sms_tlv_by_tag)) {
       $tlv_conf=$sms_tlv_by_tag[$key];
       $tag=$tlv_conf[1];
       $value=sms_packets_encode_field($packet['tlvs'][$key], $tlv_conf[3], $tlv_conf[4]);
       $tlv=sms_packets_tlv_new($tag, $value);
       array_push($res, sms_packets_tlv_encode($tlv));
     }
  }
  return implode('',$res);
}

function sms_packets_tlv_new($tag=0, $value='', $length=false) {
  $tlv=Array();
  $tlv['tag']=$tag;
  $tlv['length']=($length===false)?strlen($value):$length;
  $tlv['value']=$value;

  return $tlv;
}

function sms_packets_tlv_decode($data, $in_offset=0) {
  $dlen=strlen($data);
  $len=$dlen-$in_offset;
  if ($len<4) return false;
  $tlv=sms_packets_tlv_new();
  $offset=$in_offset;
  $tlv['tag']=sms_packets_decode_num($data, 2, $offset);
//  $tlv['type_hex']=sprintf("0x%02X",$tlv['tag']);
  $tlv['length']=sms_packets_decode_num($data, 2, $offset);
  $vmlen=$len-4;
  if ($tlv['length']>$vmlen) return false;
  $tlv['value']=substr($data, $offset, $tlv['length']);
  return $tlv;    
}

function sms_packets_tlv_encode(&$tlv) {
  $res=array();
  array_push($res, sms_packets_num_encode($tlv['tag'], 2));
  array_push($res, sms_packets_num_encode($tlv['length'], 2));
  array_push($res, $tlv['value']);
  return implode('',$res);
}

function sms_packets_tlv_chain_decode($data, &$in_offset=0, $limit=0) {
  $chain=array();                     
  $offset=$in_offset;
  $dlen=strlen($data);
  $is_cont=true;
  $tlv_num=0;
  while ($is_cont && $dlen>$offset+4) {
     $tlv_num++;
     if ($limit>0 && $tlv_num>$limit) break;
     $tlv=sms_packets_tlv_decode($data, $offset);
     if ($tlv==false) {
        $is_cont=false;
     } else {
        $tlv['tlv_no']=$tlv_num;
        $chain[$tlv['tag']]=$tlv;
        $offset+=$tlv['length']+4;
     }
  }
  $keys=array_keys($chain);
  $in_offset=$offset;
  if (count($keys)==0) return false;
  return $chain;
}


} // end incl_h
?>
