<?php
if (!defined("INC_SVC_H")){
   define("INC_SVC_H", TRUE);

include("udp_client.inc");

class svc_client {
  var $pid;
  var $client;
  var $server_host;
  var $server_port;
  var $server_password;
  var $commands;
  var $init_data;
  var $log_dir;
  var $log_file;
  var $bin_log_file;
  var $current_status;
  var $need_stop;
  

  function svc_client() {
     $this->client=null;
     $this->server_host='127.0.0.1';
     $this->server_port=3060;
     $this->server_password='';
     $this->commands = array();
     $this->pid = posix_getpid();
     $this->init_data=null;
     $this->log_dir="./pids/";
     $this->log_file=null;    
     $this->current_status='stopped';
     $this->need_stop=false;
  }

  function _print_log($fname, $str, $noformat=false) {
    $fp = @fopen ($fname, "ab");
    if (!$fp) return false;
    if (flock($fp, LOCK_EX)) {
      if (!$noformat) {
          if ($str!='') $str=date("[m-d-y H:i:s] ").$str;
          $str.="\n";
      }
      fwrite($fp, $str, strlen($str));
      flock($fp, LOCK_UN);
    } else {
      fclose ($fp);
      return false;
    }                            
    fclose ($fp);
    return true;
  }

  function print_log($str) {
    return $this->_print_log($this->log_file, $str);
  }

  function print_bin_log($str) {
    return $this->_print_log($this->bin_log_file, $str, true);
  }

  function start() {
     $this->log_file=$this->log_dir.'svc_'.$this->pid.".log";
     $this->bin_log_file=$this->log_dir.'svc_bin_'.$this->pid.".log";
     $this->print_log("-------------------- service started --------------------");

     $error = '';
     $this->client = new udp_client();
     if (!$this->client->start($this->server_host, $this->server_port, $this->server_password)) {
        $error="Cannot create socket to talk [".$this->client->err_code."] [".$this->client->err_str."].";
        $this->print_log("starting error: $error");
        return false;
     }

     $cmd=$this->init();
     return true;
  }

  function stop() {
    $this->send_status("stopped");
    $this->client->stop();
    $this->print_log("-------------------- service stopped --------------------");
  }                                               

  function send_str($str) {
     $this->client->send($str);
  }

  function init() {
     $res=$this->comm("_svc_reg ".$this->pid);
     $this->init_data=unserialize(trim($res['data']));
     $this->print_log("init command:\n".var_export($this->init_data, true));
     return $res;
  }

  function re_init() {
     $res=$this->comm("_svc_full_reg ".$this->pid.' '.$this->init_data[1].' '.rawurlencode(serialize($this->init_data)) );
//     $this->init_data=unserialize(trim($res['data']));
     $this->print_log("reinit command:\n".var_export(unserialize(trim($res['data'])), true));
//     $this->print_log("reinit command:\n".var_export($this->init_data, true));
     return $res;
  }

  function set_status($status) {
     $this->current_status=strtoupper(trim($status));
     return $this->current_status;
  }

  function send_status($status) {
     $this->set_status($status);
     $r=$this->comm('_svc_status '.$this->pid.' '.$this->current_status);
     $this->print_log("status answer: [".$r['raw_dump']."]");
     return $r;
  }

  function comm($str) {
     $this->client->send($str);
     return $this->get_answer();
  }

  function process() {
     $r=false;
     $cmd=$this->get_command();
     if ($cmd[0]!==false) {
        array_push($this->commands, $cmd);
        $r=true;
     }
     return $r;
  }

  function get_answer() {
     $res = $this->client->recv();
     $ra = explode("\n", $res[0], 2);
     $r=array();
     $r['raw_dump'] = $res[0];
     $r['raw_packets'] = $res[1];
     $r['status_str'] = $ra[0];
     $r['status_code'] = 0;
     if (preg_match('/\+(\d+)\s+.*/', $ra[0], $m)) {
         $r['status_code'] = (int)$m[1];
         $r['data'] = $ra[1];
     }
     return $r;
  }

  function get_command() {
     $res = $this->client->recv();
//     $this->print_bin_log($res[1].chr(255));
     return $res;
  }
   
}



} // end incl_h
?>
