<?php

if (!defined("INC_TCP_CLIENT_H")){
   define("INC_TCP_CLIENT_H", TRUE);

include("proto.inc");
//include("crypt.inc");

class tcp_client {
  var $socket;
  var $server_host;
  var $server_port;
  var $server_password;
  var $server_err_code;
  var $server_err_str;
  var $err_code;
  var $err_str;

  var $on_command;

  //Constructor
  function tcp_client()
  {
    $this->socket=false;
    $this->server_host='';
    $this->server_port='';
    $this->server_password='';

    $this->client_err_code=0;
    $this->client_err_str='';
    $this->err_code=0;
    $this->err_str='';

    $this->on_command=null;
  }

  function _start_client() {
     $socket=socket_create(AF_INET, SOCK_STREAM, SOL_TCP);
     if (!$socket) {
         $this->client_err_code=socket_last_error();
         $this->client_err_str=socket_strerror($this->client_err_code);
         return false;
     }

     if (!socket_connect($socket, $this->server_host, $this->server_port)) {
         $this->client_err_code=socket_last_error();
         $this->client_err_str=socket_strerror($this->client_err_code);
         socket_close($socket);
         return false;
     }
      
     if (!socket_set_nonblock($socket)) {
         $this->client_err_code=socket_last_error();
         $this->client_err_str=socket_strerror($this->client_err_code);
         socket_close($socket);
         return false;
     }

//     socket_set_timeout($socket, 2, 0);
     return $socket;
  }

  function _stop_client() {
     if ($this->socket) socket_close($this->socket);
     $this->socket=false;
  }

  function start($server_host, $server_port, $server_password = "") {
     $this->server_host=$server_host;
     $this->server_port=$server_port;
     $this->server_password=$server_password;
     $this->socket=$this->_start_client();
     if (!$this->socket) {
         $this->err_code=$this->client_err_code;
         $this->err_str=$this->client_err_str;
         return false;
     }
     return true;
  }

  function connected() {
     return (!$this->socket)?false:true;
  }

  function stop() {
     $this->_stop_client();
  }

  function send($str) {
     $sended=0;
     $pka = proto_packet_enc($str);
     foreach ($pka as $pk) {
        $s=@socket_write($this->socket, $pk, strlen($pk));
        if ($s===false) {
          $this->err_code=-1;
          $this->err_str="Cannot write to socket";
          $this->stop();
          return false;
        }
        $sended+=$s;
     }
     return $sended;
  }

  function recv_packet($tm_out=5) {
     $tm_start=time();
     $buffer = '';

     while (strlen($buffer)<PROTO_PACKET_HDR_LEN) {
        $recv=@socket_read($this->socket, PROTO_PACKET_HDR_LEN, PHP_BINARY_READ);
        if ($recv!==false && $recv!='') $buffer .= $recv;
        if (time()>$tm_start+$tm_out) return false;
     }
//print("1:".crypt_str_to_hex($buffer)."\n");
     $pkh=proto_packet_dec_head($buffer);
//print("2\n");
     if ($pkh===false) return false;
//print("3\n");
     while (strlen($buffer)<$pkh['plen']) {
        $recv=@socket_read($this->socket, $pkh['plen']-strlen($buffer), PHP_BINARY_READ);
        if ($recv!==false && $recv!='') $buffer .= $recv;
        if (time()>$tm_start+$tm_out) return false;
     }
      
     return proto_packet_dec($buffer);
  }

  function recv($tm_out=5) {
     $pk=$this->recv_packet($tm_out);
     if (!$pk) return false;
     $ret = $pk['data'];
     while ($pk['next_len']>0) {
          $pk=$this->recv_packet($tm_out);
          if (!$pk) return false;
          $ret .= $pk['data'];
     }
     return $ret;
  }

  function process() {
     if (!$this->socket) return false;

     $cmd=$this->recv();
     $func = $this->on_command;
     if ($func) $func($this, $cmd[0], $cmd[1]);
     return true;
  }

  function process1($w_only=false) {
     if (!$this->socket) return false;

     $null=NULL;
     $r = array($this->socket);
     $clients=$this->get_clients();
     $r_set=array($this->socket);
     $e_set=array($this->socket);
     $w_set=array($this->socket);
     if ($w_only) $r_set=NULL;

     $ret=@socket_select($r_set, $w_set, $e_set, 0);
     if ($ret===false) return false;
     if ($ret>0) {
         foreach ($e_set as $client) {
            $err_code=socket_last_error($client);
//            if ($err_code!=11) {
              $err_str=socket_strerror($err_code);
              $key=$this->get_key_by_conn($client);
              if ($key!==false) {
                  print("error [$key] [$err_code:$err_str]\n");
                  $this->dispose_client($key);
              }
//            }
         }
         foreach ($w_set as $client) {
            $key=$this->get_key_by_conn($client);
            if ($key!==false) {
                $this->try_send_packet($key);
            }
         }
         if (!$w_only) foreach ($r_set as $client) {
            if ($client == $this->socket) {
               $conn = @socket_accept($this->socket);
               if ($conn!=false) {
                  if (!@socket_set_nonblock($conn)) {
                      @socket_close($conn);
                  } else {
                    $key=$this->make_new_client($conn);
                    if ($key) $this->process_cli_connect($key);
                  }
               }
            } else {
              $key=$this->get_key_by_conn($client);
              if ($key!==false) {
                if ($this->try_read_client($key)) {
                  $this->try_decode_client($key);
                  $this->process_one_command($key);
                } else {
                  $this->dispose_client($key, socket_last_error($client));
                }
              }
            }
         }
         return true;
     }

     return false;
  }

}

} // end incl_h
?>
