<?php

if (!defined("INC_TCP_SERVER_H")){
   define("INC_TCP_SERVER_H", TRUE);

include("proto.inc");
include("crypt.inc");
include("tcp_socket_pool.inc");


function tcp_server_on_client_pool_disconnect(&$pool, $cli_key, $err_code=0) {
   $pool->parent->process_cli_disconnect($cli_key, $err_code);
}

function tcp_server_on_client_pool_data(&$pool, $cli_key) {
   $pool->parent->process_one_command($cli_key);
}

class tcp_server {
  var $socket;
  var $server_ip;
  var $server_port;
  var $server_password;
  var $server_err_code;
  var $server_err_str;
  var $err_code;
  var $err_str;

  var $client_pool;

  var $on_command;
  var $on_connect;
  var $on_disconnect;

  //Constructor
  function tcp_server()
  {
    $this->socket=false;
    $this->server_ip='';
    $this->server_port='';
    $this->server_password='';

    $this->server_err_code=0;
    $this->server_err_str='';
    $this->err_code=0;
    $this->err_str='';

    $this->client_pool=new tcp_socket_pool();
    $this->client_pool->parent=&$this;
    $this->client_pool->on_disconnect='tcp_server_on_client_pool_disconnect';
    $this->client_pool->on_data='tcp_server_on_client_pool_data';


    $this->on_command=null;
    $this->on_connect=null;
    $this->on_disconnect=null;
  }

  function _start_server() {
     $socket=socket_create(AF_INET, SOCK_STREAM, SOL_TCP);
     if (!$socket) {
         $this->server_err_code=socket_last_error($socket);
         $this->server_err_str=socket_strerror($this->server_err_code);
         return false;
     }

     if (!socket_set_option($socket, SOL_SOCKET, SO_REUSEADDR, 1)) {
         $this->server_err_code=socket_last_error($socket);
         $this->server_err_str=socket_strerror($this->server_err_code);
         socket_close($socket);
         return false;
     }

     if (!socket_bind($socket, $this->server_ip, $this->server_port)) {
         $this->server_err_code=socket_last_error($socket);
         $this->server_err_str=socket_strerror($this->server_err_code);
         socket_close($socket);
         return false;
     }
     if (!socket_listen($socket)) {
         $this->server_err_code=socket_last_error($socket);
         $this->server_err_str=socket_strerror($this->server_err_code);
         socket_close($socket);
         return false;
     }

     if (!socket_set_nonblock($socket)) {
         $this->server_err_code=socket_last_error($socket);
         $this->server_err_str=socket_strerror($this->server_err_code);
         socket_close($socket);
         return false;
     }
     return $socket;
  }

  function _stop_server() {
     $this->client_pool->do_close_all();
     if ($this->socket) socket_close($this->socket);
     $this->socket=false;
  }

  function start($server_ip, $server_port, $server_password = "") {
     $this->server_ip=$server_ip;
     $this->server_port=$server_port;
     $this->server_password=$server_password;
//     print("\n".var_export($this, true)."\n");
     $this->socket=$this->_start_server();
     if (!$this->socket) {
         $this->err_code=$this->server_err_code;
         $this->err_str=$this->server_err_str;
         return false;
     }
     return true;
  }

  function stop($halt=false) {
     if (!$halt) {
       while ($this->process(true)) usleep(1);
     }
     $this->_stop_server();
  }

  function send($str, $cli_key) {
     return $this->client_pool->send($cli_key, $str);
  }

  function process_cli_connect($cli_key) {
     $func = $this->on_connect;
     if (!$func) return false;
     $func($this, $this->client_pool->list[$cli_key]['addr'], $this->client_pool->list[$cli_key]['port'], $cli_key);
     return true;
  }

  function process_cli_disconnect($cli_key, $err_code=0) {
     $func = $this->on_disconnect;
     if (!$func) return false;
     $func($this, $this->client_pool->list[$cli_key]['addr'], $this->client_pool->list[$cli_key]['port'], $cli_key, $err_code);
     return true;
  }

  function process_one_command($cli_key) {
     $cnt=count($this->client_pool->list[$cli_key]['cmd_buf']);
     if ($cnt==0) return false;
     $func = $this->on_command;
     if (!$func) return false;
     $func($this, array_shift($this->client_pool->list[$cli_key]['cmd_buf']), $this->client_pool->list[$cli_key]['addr'], $this->client_pool->list[$cli_key]['port'], $cli_key);
     return true;
  }

  function try_accept() {
     if (!$this->socket) return false;
     $null=NULL;
     $r_set = array($this->socket);

     $ret=@socket_select($r_set, $null, $null, 0);
     if ($ret===false) return false;
     if ($ret>0) {
         foreach ($r_set as $sock) {
            if ($sock == $this->socket) {
               $conn = @socket_accept($this->socket);
               if ($conn!=false) {
                  if (!@socket_set_nonblock($conn)) {
                      @socket_close($conn);
                  } else {
                    $key=$this->client_pool->make_new_socket($conn);
                    if ($key) $this->process_cli_connect($key);
                  }
               }
            }
         }
     }
     return true;
  }

  function process($w_only=false) {
     $this->try_accept();
     $this->client_pool->process($w_only);
  }

  function process1($w_only=false) {
     if (!$this->socket) return false;

     $null=NULL;
     $r = array($this->socket);
     $clients=$this->client_pool->get_sockets();
     $r_set=array_merge($r, $clients);
     $e_set=$clients;
     $w_set=$this->client_pool->get_sockets_w();
     if ($w_only) $r_set=NULL;

     $ret=@socket_select($r_set, $w_set, $e_set, 0);
     if ($ret===false) return false;
     if ($ret>0) {
         foreach ($e_set as $client) {
            $err_code=socket_last_error($client);
//            if ($err_code!=11) {
              $err_str=socket_strerror($err_code);
              $key=$this->client_pool->get_key_by_conn($client);
              if ($key!==false) {
                  print("error [$key] [$err_code:$err_str]\n");
                  $this->process_cli_disconnect($key);
                  $this->client_pool->dispose_socket($key);
              }
//            }
         }
         foreach ($w_set as $client) {
            $key=$this->client_pool->get_key_by_conn($client);
            if ($key!==false) {
                $this->client_pool->try_send_packet($key);
            }
         }
         if (!$w_only) foreach ($r_set as $client) {
            if ($client == $this->socket) {
               $conn = @socket_accept($this->socket);
               if ($conn!=false) {
                  if (!@socket_set_nonblock($conn)) {
                      @socket_close($conn);
                  } else {
                    $key=$this->client_pool->make_new_socket($conn);
                    if ($key) $this->process_cli_connect($key);
                  }
               }
            } else {
              $key=$this->client_pool->get_key_by_conn($client);
              if ($key!==false) {
                if ($this->client_pool->try_read_socket($key)) {
                  $this->client_pool->try_decode_socket($key);
                  $this->process_one_command($key);
                } else {
                  $this->process_cli_disconnect($key, socket_last_error($client));
                  $this->client_pool->dispose_socket($key);
                }
              }
            }
         }
         return true;
     }

     return false;
  }

}

} // end incl_h
?>
