<?php

if (!defined("INC_TCP_SOCKET_POOL_H")){
   define("INC_TCP_SOCKET_POOL_H", TRUE);

include("proto.inc");
include("crypt.inc");

define("TCP_SP_DEF_PREF", 'INT_');

define("TCP_SP_TYPE_SERVER", 0x01);
define("TCP_SP_TYPE_CHILD", 0x02);
define("TCP_SP_TYPE_CLIENT", 0x03);
define("TCP_SP_TYPE_OTHER", 0x04);

class tcp_socket_pool {
  var $list;
  var $srv_list;
  var $link_task_list;
  var $last_socket_key;
  var $seq_gen;
  var $max_read_len;
  var $select_timeout;
  var $parent;
  var $no_accept;
  var $on_connect;
  var $on_disconnect;
  var $on_data;
  var $on_link_task_start;
  var $on_link_task_stop;
  var $on_debug;
  var $on_recv;
  var $on_send;
  var $on_low_recv;
  var $on_low_send;

  //Constructor
  function tcp_socket_pool() {
    $this->last_socket_key=0;
    $this->seq_gen=1;
    $this->max_read_len=PROTO_PACKET_MAX_LEN;
    $this->select_timeout=array(0,0);
    $this->list=array();
    $this->srv_list=array();
    $this->link_task_list=array();
    $this->parent=null;
    $this->no_accept=false;
    $this->on_connect=null;
    $this->on_disconnect=null;
    $this->on_data=null;
    $this->on_link_task_start=null;
    $this->on_link_task_stop=null;
    $this->on_debug=null;
    $this->on_recv=null;
    $this->on_send=null;
    $this->on_low_recv=null;
    $this->on_low_send=null;
  }

  function tmset_from_timeout($tmout) {
    $tm_set=array(0, 0);
    if (is_array($tmout)) {
      if (count($tmout)>0) $tm_set[0]=(int)$tmout[0];
      if (count($tmout)>1) $tm_set[1]=(int)$tmout[1];
    } else if (is_float($tmout)) {
      $tm_set[0]=(int)$tmout;
      $tm_set[1]=(int)(($tmout-$tm_set[0])*1000000);
    } else {
      $tm_set=array((int)$tmout, 0);
    }
//    print(var_export(array('tmout'=>$tmout, 'tm_set'=>$tm_set), true)."\n");
    return $tm_set; 
  }

  function set_select_timeout($tm_val, $mtm_val=0) {
     $this->select_timeout[0]=$tm_val;
     $this->select_timeout[1]=$mtm_val;
     return true;
  }

  function do_debug($str) {
    $func = $this->on_debug;
    if ($func) $func($this, $str);
  }

  function get_int_seq() {
     return $this->seq_gen++;
  }        

  function get_mta($which=-1) {
     $mt=microtime();
     list($usec, $sec) = explode(" ", $mt);
     if ($which==0 && $which!==0) $which=-1;
     if ($which==0) return (float)$sec;
     if ($which==1) return (float)$usec;
     if ($which==2) return (float)((float)$sec+(float)$usec);
     return array((float)$sec, (float)$usec, (float)$sec+(float)$usec);
  }

  function add_link_task($key, $send_data, $seq_no=0, $transfer_key=false, $func=false, $params=false) {
//    global $dmn_main_conn; $daemon=$dmn_main_conn['daemon'];
    if (!array_key_exists($key, $this->link_task_list)) $this->link_task_list[$key]=array();
    
    $int_seq=$this->get_int_seq();

    if (!array_key_exists($int_seq, $this->link_task_list[$key])) $this->link_task_list[$key][$int_seq]=array();

    $this->link_task_list[$key][$int_seq]['mta']=$this->get_mta();
    $this->link_task_list[$key][$int_seq]['key']=$key;
    $this->link_task_list[$key][$int_seq]['send_data']=$send_data;
    $this->link_task_list[$key][$int_seq]['seq_no']=$seq_no;
    $this->link_task_list[$key][$int_seq]['int_seq_no']=$int_seq;
    $this->link_task_list[$key][$int_seq]['transfer_key']=$transfer_key;
    $this->link_task_list[$key][$int_seq]['func']=$func;
    $this->link_task_list[$key][$int_seq]['params']=$params;
    $this->link_task_list[$key][$int_seq]['supressed']=false;
    $func = $this->on_link_task_start;
    if ($func) $func($this, $this->link_task_list[$key][$int_seq], $send_data);
    $this->send($key, $send_data, $int_seq);
//    $daemon->print_log("add_link_task \n".var_export($this->link_task_list[$key][$int_seq],true)."\n\n".var_export($this->link_task_list,true));
    return $int_seq;
  }

  function get_tasks_seq_keys($key) {
     if (!array_key_exists($key, $this->link_task_list)) return false;
     return array_keys($this->link_task_list[$key]);
  }

  function get_expired_tasks_keys($key, $timeout) {
     $seq_keys=$this->get_tasks_seq_keys($key);
     if ($seq_keys===false) return false;
     $ret=array();
     $mta_c=$this->get_mta();
     $tex=$mta_c[2]-(float)$timeout;
     foreach ($seq_keys as $seq_key) {
        $mta_s=$this->link_task_list[$key][$seq_key]['mta'];
        if ($mta_s[2]<$tex) array_push($ret, $seq_key);
     }
     return $ret;
  }

  function get_link_task($key, $int_seq) {
    if (!array_key_exists($key, $this->link_task_list)) return false;
    if (!array_key_exists($int_seq, $this->link_task_list[$key])) return false;
    return $this->link_task_list[$key][$int_seq];
  }

  function drop_link_task($key, $int_seq) {
    if (!array_key_exists($key, $this->link_task_list)) return false;
    if (!array_key_exists($int_seq, $this->link_task_list[$key])) return false;
    unset($this->link_task_list[$key][$int_seq]);
    return true;
  }

  function supress_link_task($key, $int_seq) {
    if (!array_key_exists($key, $this->link_task_list)) return false;
    if (!array_key_exists($int_seq, $this->link_task_list[$key])) return false;
    $this->link_task_list[$key][$int_seq]['supressed']=true;
    return true;
  }

  function drop_link_tasks($key) {
    if (!array_key_exists($key, $this->link_task_list)) return false;
    unset($this->link_task_list[$key]);
    return true;
  }


  function check_link_task($key) {
//    global $daemon;
//    global $dmn_main_conn; $daemon=$dmn_main_conn['daemon'];
    $data=$this->lookup_data($key);
    $int_seq=$data[1];
    $data=$data[0];
//    $daemon->print_log("*check_link_task ".var_export(array($key, $int_seq),true));
    $task=$this->get_link_task($key, $int_seq);
    if (!$task) return false;
    $this->drop_link_task($key, $int_seq);
    $this->get_data($key);
    if ($task['supressed']) return true;
    if ($task['func']) {
       $r=$task['func']($this, $task, $data);
       if ($r!==false) $this->send($task['transfer_key'], $r, $task['seq_no']);
    } else if ($task['transfer_key']) {
       $this->send($task['transfer_key'], $data, $task['seq_no']);
    }
    $func = $this->on_link_task_stop;
    if ($func) $func($this, $task, $data);
//    $daemon->print_log("check_link_task \n".var_export($task,true)."\n\n".var_export($this->link_task_list,true));
    return true;
  }

  function make_key($prefix=TCP_SP_DEF_PREF) {
     return 'KEY_'.($this->last_socket_key++);
     return $prefix.($this->last_socket_key++);
  }

  function keys() {
     return array_keys($this->list);
  }

  function send($key, $data, $seq_no=0) {
     if (!array_key_exists($key, $this->list)) return false;

     $func = $this->on_send;
     if ($this->list[$key]['on_send']) $func = $this->list[$key]['on_send'];
     $pka = false;

     if ($func) $pka = (array)$func($this, $key, $data, $seq_no);

     if ($pka===false) $pka = proto_packet_enc($data, $seq_no);

     if (is_array($pka)) foreach ($pka as $pk) array_push($this->list[$key]['send_stack'],$pk);
     $this->list[$key]['timings']['last_write']=time();
     
     return $pka;
  }

  function try_send_packet($key) {
     if (!array_key_exists($key, $this->list)) return false;
     $null=NULL;
         
     $str=$this->list[$key]['send_stack'][0];
     $len=strlen($str);

     $func = $this->on_low_send;
     if ($this->list[$key]['on_low_send']) $func = $this->list[$key]['on_low_send'];
     $ret=true;
     if ($func) $ret=($func($this, $key, $str)!==false);
     if ($ret!==true) $ret=false;
     if ($ret) {
       $ret=@socket_write($this->list[$key]['socket'], $str, $len);
       if ($ret===false) {
  //       $err_code=socket_last_error($socket);
  //       $err_str=socket_strerror($err_code);
  //       print("error [$err_code:$err_str]\n");
         return false;
       } else if ($ret<=0) {
         return false;
       } else if ($ret<$len) {
          $this->list[$key]['send_stack'][0]=substr($this->list[$key]['send_stack'][0], $ret);
          return true;
       }
       socket_set_option($this->list[$key]['socket'], SOL_SOCKET, TCP_NODELAY, 1);
       socket_set_option($this->list[$key]['socket'], SOL_SOCKET, TCP_NODELAY, 0);
//       print('sended: "'.$str.'"'."\r\n");
     }
     array_shift($this->list[$key]['send_stack']);
     $this->list[$key]['timings']['last_low_write']=time();
     if ($this->list[$key]['drop_after_send'] && count($this->list[$key]['send_stack'])==0) $this->drop_connection($key);
     return true;
  }

  function get_key_by_conn($conn) {
     $keys=array_keys($this->list);
     $cnt=count($keys);
     for ($i=0;$i<$cnt;$i++) if ($this->list[$keys[$i]]['socket']==$conn) return $keys[$i];
     return false;
  }

  function get_sockets() {
    $keys=array_keys($this->list);
    $cnt=count($keys);
    $ret=array();
    for ($i=0;$i<$cnt;$i++) {
      array_push($ret, $this->list[$keys[$i]]['socket']);
    }
    return $ret;
  }

  function get_sockets_r() {
     $keys=array_keys($this->list);
     $cnt=count($keys);
     $ret=array();
     $mta=$this->get_mta(2);
     for ($i=0;$i<$cnt;$i++) {
       if ($this->is_socket_type($keys[$i], TCP_SP_TYPE_CLIENT) && !$this->list[$keys[$i]]['connected']) {
          if ($this->list[$keys[$i]]['connect_tmo']<$mta) {
            // connection failed
            $this->do_disconnect($keys[$i], 'connect timeout');
          } 
          continue;
       }
       if ($this->no_accept) {
         if (!$this->is_socket_type($key, TCP_SP_TYPE_SERVER)) array_push($ret, $this->list[$keys[$i]]['socket']);
       } else {
         array_push($ret, $this->list[$keys[$i]]['socket']);
       }
     }
     return $ret;
  }

  function get_sockets_w() {
     $keys=array_keys($this->list);
     $cnt=count($keys);
     $ret=array();
     for ($i=0;$i<$cnt;$i++) {
        if (count($this->list[$keys[$i]]['send_stack'])>0 || !$this->list[$keys[$i]]['connected']) array_push($ret, $this->list[$keys[$i]]['socket']);
     }
     return $ret;
  }

  function get_sockets_e() {
     $keys=array_keys($this->list);
     $cnt=count($keys);
     $ret=array();
     for ($i=0;$i<$cnt;$i++) {
       if ($this->no_accept) {
         if (!$this->is_socket_type($key, TCP_SP_TYPE_SERVER)) array_push($ret, $this->list[$keys[$i]]['socket']);
       } else {
         array_push($ret, $this->list[$keys[$i]]['socket']);
       }
     }
     return $ret;
  }

  function make_new_socket(&$conn, $prefix=TCP_SP_DEF_PREF) {
     $key=$this->make_key($prefix);
     $this->list[$key]=array();
     $this->list[$key]['socket']=$conn;
     $this->list[$key]['connected']=false;
     $this->list[$key]['created']=$this->get_mta(2);
     $this->list[$key]['connect_tmo']=$this->list[$key]['created']+120.0;
     $this->list[$key]['buffer']='';
     $this->list[$key]['recv_stack']=array();
     $this->list[$key]['recv_raw_stack']=array();
     $this->list[$key]['send_stack']=array();
     $this->list[$key]['nl']=array();
     $this->list[$key]['cmd_buf']=array();
     $this->list[$key]['addr']='';
     $this->list[$key]['port']=0;
     $this->list[$key]['local_addr']='';
     $this->list[$key]['local_port']=0;
     $this->list[$key]['type']=TCP_SP_TYPE_OTHER;
     $this->list[$key]['srv_key']=false;
     $this->list[$key]['drop_after_send']=false;
     $this->list[$key]['timings']=array();
     $this->list[$key]['timings']['started']=$this->get_mta(2);
     $this->list[$key]['timings']['last_read']=0;
     $this->list[$key]['timings']['last_write']=0;
     $this->list[$key]['timings']['last_low_read']=0;
     $this->list[$key]['timings']['last_low_write']=0;
     $this->list[$key]['on_recv']=null;
     $this->list[$key]['on_send']=null;
     $this->list[$key]['on_low_recv']=null;
     $this->list[$key]['on_low_send']=null;
     $this->list[$key]['on_data']=null;
     $this->list[$key]['on_connect']=null;
     $this->list[$key]['on_disconnect']=null;
//     @socket_getsockname($this->list[$key]['socket'], $this->list[$key]['addr'], $this->list[$key]['port']);
     return $key;
  }

  function auto_resolve($key) {
    @socket_getsockname($this->list[$key]['socket'], $this->list[$key]['local_addr'], $this->list[$key]['local_port']);
    @socket_getpeername($this->list[$key]['socket'], $this->list[$key]['addr'], $this->list[$key]['port']);
    return;

     if ($this->is_socket_type($key, TCP_SP_TYPE_CHILD)) {
        @socket_getsockname($this->list[$key]['socket'], $this->list[$key]['addr'], $this->list[$key]['port']);
     } else if ($this->is_socket_type($key, TCP_SP_TYPE_SERVER)) {
        @socket_getsockname($this->list[$key]['socket'], $this->list[$key]['addr'], $this->list[$key]['port']);
     } else if ($this->is_socket_type($key, TCP_SP_TYPE_CLIENT)) {
        @socket_getpeername($this->list[$key]['socket'], $this->list[$key]['addr'], $this->list[$key]['port']);
     } else {
        if (!@socket_getsockname($this->list[$key]['socket'], $this->list[$key]['addr'], $this->list[$key]['port']) )
        @socket_getpeername($this->list[$key]['socket'], $this->list[$key]['addr'], $this->list[$key]['port']);
     }
  }

  function get_link_timings($key) {
     return $this->list[$key]['timings'];
  }


  function get_connect_params($key) {
     if (!array_key_exists($key, $this->list)) return false;
     return array($this->list[$key]['addr'], $this->list[$key]['port']);
  }

  function set_connected($key, $val=true) {
     if (!array_key_exists($key, $this->list)) return false;
     $this->list[$key]['connected']=$val;
     return true;
  }

  function set_connect_timeout($key, $val=120.0) {
     if (!array_key_exists($key, $this->list)) return false;
     $this->list[$key]['connect_tmo']=$this->list[$key]['created']+$val;
     return true;
  }
  
  function set_socket_type($key, $type=TCP_SP_TYPE_OTHER, $srv_key=false) {
     if (!array_key_exists($key, $this->list)) return false;
     $this->list[$key]['type']=$type;
     $this->list[$key]['srv_key']=$srv_key;
     return true;
  }

  function set_socket_handlers($key, $recv_handler=NULL, $send_handler=NULL, $data_handler=NULL, $disconnect_handler=NULL, $connect_handler=NULL) {
     if (!array_key_exists($key, $this->list)) return false;
     $this->list[$key]['on_recv']=$recv_handler;
     $this->list[$key]['on_send']=$send_handler;
     $this->list[$key]['on_data']=$data_handler;
     $this->list[$key]['on_connect']=$connect_handler;
     $this->list[$key]['on_disconnect']=$disconnect_handler;
  }

  function set_socket_low_handlers($key, $low_recv_handler=NULL, $low_send_handler=NULL) {
     if (!array_key_exists($key, $this->list)) return false;
     $this->list[$key]['on_low_recv']=$low_recv_handler;
     $this->list[$key]['on_low_send']=$low_send_handler;
  }

  function is_socket_type($key, $type) {
     if (!array_key_exists($key, $this->list)) return false;
     return ($this->list[$key]['type']==$type);
  }

  function dispose_socket($key) {
     @socket_close($this->list[$key]['socket']);
//     unset($this->list[$key]['socket']);
//     unset($this->list[$key]['buffer']);
//     unset($this->list[$key]['recv_stack']);
//     unset($this->list[$key]['recv_raw_stack']);
//     unset($this->list[$key]['nl']);
//     unset($this->list[$key]['cmd_buf']);
     unset($this->list[$key]);
     return false;
  }

  function get_data($key) {
     if (count($this->list[$key]['cmd_buf'])==0) return false;
     return array_shift($this->list[$key]['cmd_buf']);
  }

  function lookup_data($key) {
     if (count($this->list[$key]['cmd_buf'])==0) return false;
     return $this->list[$key]['cmd_buf'][0];
  }

  function do_data($key) {
     if (!$this->check_link_task($key)) {
       $func = $this->on_data;
       if ($this->list[$key]['on_data']) $func = $this->list[$key]['on_data'];
       if ($func) $func($this, $key);

//       if ($func)
//          $func($this, $key);
//       } else {
//          $this->get_data($key);
//       }
     }
  }

  function set_srv_client($srv_key, $cli_key) {
     if (!array_key_exists($srv_key, $this->srv_list)) return false;
     $this->srv_list[$srv_key][$cli_key]=true;
  }

  function get_srv_keys() {
     return array_keys($this->srv_list);
  }

  function get_srv_client_keys($srv_key) {
     if (!array_key_exists($srv_key, $this->srv_list)) return false;
     return array_keys($this->srv_list[$srv_key]);
  }

  function get_srv_by_client($cli_key) {
     if (!array_key_exists($cli_key, $this->list)) return false;
     if ($this->list[$cli_key]['srv_key']) return $this->list[$cli_key]['srv_key'];
     
     $keys=$this->get_srv_keys();
     foreach ($keys as $srv_key) {
        if (array_key_exists($cli_key, $this->srv_list[$srv_key])) return $srv_key;
     }
     return false;
  }

  function remove_srv_client($cli_key) {
     while (($srv_key=$this->get_srv_by_client($cli_key))!==false) {
        if ($this->list[$cli_key]['srv_key']) $this->list[$cli_key]['srv_key']=false;
        unset($this->srv_list[$srv_key][$cli_key]);
     }
  }
  
  function transfer_handler($srv_key, $key, $handler) {
    $this->list[$key][$handler]=$this->list[$srv_key][$handler];
  }
  
  function transfer_handlers($srv_key, $key) {
     if (!array_key_exists($srv_key, $this->list)) return false;
     if (!array_key_exists($key, $this->list)) return false;
    
    $this->transfer_handler($srv_key, $key, 'on_recv');
    $this->transfer_handler($srv_key, $key, 'on_send');
    $this->transfer_handler($srv_key, $key, 'on_data');
    $this->transfer_handler($srv_key, $key, 'on_connect');
    $this->transfer_handler($srv_key, $key, 'on_disconnect');
  }

  function transfer_low_handlers($srv_key, $key) {
     if (!array_key_exists($srv_key, $this->list)) return false;
     if (!array_key_exists($key, $this->list)) return false;
    
    $this->transfer_handler($srv_key, $key, 'on_low_recv');
    $this->transfer_handler($srv_key, $key, 'on_low_send');
  }
  
  function do_connect(&$conn, $srv_key=false, $stype=false, $existent=false) {
     $key=($existent===false)?$this->make_new_socket($conn):$existent;
     if ($key) {
       if ($srv_key) {
          $this->set_srv_client($srv_key, $key);
          $this->set_socket_type($key, TCP_SP_TYPE_CHILD, $srv_key);
          $this->transfer_handlers($srv_key, $key);
          $this->transfer_low_handlers($srv_key, $key);
       }
       if ($stype!==false) $this->set_socket_type($key, $stype, $srv_key);
       $this->set_connected($key);
       $this->auto_resolve($key);
       $func = $this->on_connect;
       if ($this->list[$key]['on_connect']) $func = $this->list[$key]['on_connect'];
       if ($func) $func($this, $key);
     }
     return $key;
  }

  function drop_after_send($key) {
     if (!array_key_exists($key, $this->list)) return false;
     $this->list[$key]['drop_after_send']=true;
     return true;
  }

  function drop_connection($key, $err_code=0) {
     if (!array_key_exists($key, $this->list)) return false;
     $this->do_disconnect($key, $err_code);
     return true;
  }

  function do_disconnect($key, $err_code=0) {
     $func = $this->on_disconnect;
     if ($this->list[$key]['on_disconnect']) $func = $this->list[$key]['on_disconnect'];
     if ($func) $func($this, $key, $err_code);
     $this->remove_srv_client($key);
     $this->dispose_socket($key);
  }

  function do_close_all() {
     $keys=$this->keys();
     $cnt=count($keys);
     for ($i=0;$i<$cnt;$i++) {
        $this->do_disconnect($keys[$i]);
     }
  }

  function stop_server($srv_key) {
     $keys=$this->get_srv_client_keys($srv_key);
     if (!$keys) return false;
     $cnt=count($keys);
     for ($i=0;$i<$cnt;$i++) {
        $this->do_disconnect($keys[$i]);
     }
     unset($this->srv_list[$srv_key]);
     $this->do_disconnect($srv_key);
  }

  function try_read_socket($key) {
     $recv=@socket_read($this->list[$key]['socket'], $this->max_read_len, PHP_BINARY_READ);
     if ($recv===false || $recv=='') return false;
     $this->list[$key]['timings']['last_low_read']=time();
     $func = $this->on_low_recv;
     if ($this->list[$key]['on_low_recv']) $func = $this->list[$key]['on_low_recv'];
     $ret=true;
     if ($func) $ret=($func($this, $key, $recv)!==false);
     if ($ret!==true) $ret=false;
     if ($ret) $this->list[$key]['buffer'].=$recv;
     return $ret;
  }
   
  function internal_on_recv(&$pool, $key, $buffer, &$readed=0, &$wait_len=0, &$seq_no=0) {
     $pk=proto_packet_dec($buffer);
     if (!$pk) return false;
     $wait_len=(int)$pk['next_len'];
     $readed=$pk['plen'];
     $seq_no=$pk['seq_no'];
     return $pk['data'];
  }

  function internal_perform_recv(&$pool, $key, $buffer, &$readed=0, &$wait_len=0, &$seq_no=0) {
     $func = $this->on_recv; if ($this->list[$key]['on_recv']) $func = $this->list[$key]['on_recv'];
     $data=false;
     if ($func) $data=$func($this, $key, $buffer, $readed, $wait_len, $seq_no);
     if ($data===false) $data=$this->internal_on_recv($this, $key, $buffer, $readed, $wait_len, $seq_no);
     return $data;
  }

  function try_decode_socket($key) {                                     
//    global $daemon;
//    global $dmn_main_conn; $daemon=$dmn_main_conn['daemon'];
//     $func = $this->on_recv;
//     if ($this->list[$key]['on_recv']) $func = $this->list[$key]['on_recv'];
     $wait_len=0;
     $readed = 0;
     $seq_no=0;                                      
     $data=false;

//     if ($func) $data=$func($this, $key, $this->list[$key]['buffer'], $readed, $wait_len, $seq_no);
//     if ($data===false) $data=$this->internal_on_recv($this, $key, $this->list[$key]['buffer'], $readed, $wait_len, $seq_no);
//     $daemon->print_log("*try_decode_socket ".var_export(array($key, $seq_no, $readed, $wait_len),true));

     while (($data=$this->internal_perform_recv($this, $key, $this->list[$key]['buffer'], $readed, $wait_len, $seq_no))!==false && $readed>0) {
          $raw_data=substr($this->list[$key]['buffer'], 0, $readed);
          $this->list[$key]['buffer']=substr($this->list[$key]['buffer'], $readed);
          if (!array_key_exists($seq_no, $this->list[$key]['recv_stack'])) $this->list[$key]['recv_stack'][$seq_no]=array();
          if (!array_key_exists($seq_no, $this->list[$key]['recv_raw_stack'])) $this->list[$key]['recv_raw_stack'][$seq_no]=array();
          array_push($this->list[$key]['recv_stack'][$seq_no], $data);
          array_push($this->list[$key]['recv_raw_stack'][$seq_no], $raw_data);
          $this->list[$key]['nl'][$seq_no]=(int)$wait_len;
  //        $daemon->print_log("*try_decode_socket1 ".var_export(array($key, $seq_no, $readed, $wait_len),true));
  
          if ($this->list[$key]['nl'][$seq_no]==0) {
  //           $daemon->print_log("*try_decode_socket2 ".var_export(array($key, $seq_no, $readed, $wait_len),true));
             if (count($this->list[$key]['recv_stack'][$seq_no])>1) {
                $cmd=implode('', $this->list[$key]['recv_stack'][$seq_no]);
             } else {
                $cmd=array_shift($this->list[$key]['recv_stack'][$seq_no]);
             }
             $raw_data=$this->list[$key]['recv_raw_stack'][$seq_no];
             unset($this->list[$key]['recv_stack'][$seq_no]);
             unset($this->list[$key]['recv_raw_stack'][$seq_no]);
             array_push($this->list[$key]['cmd_buf'],array($cmd, $seq_no, $raw_data));
             $this->list[$key]['timings']['last_read']=time();
             return true;    
          }
     }
     return false;
  }

  function do_recv($key) {
     while ($this->try_decode_socket($key)) $this->do_data($key);
  }

  function process($w_only=false, $tmout=false) {
     $tm_set=$this->tmset_from_timeout(($tmout!==false)?$tmout:$this->select_timeout);

     $r_set=($w_only)?NULL:$this->get_sockets_r();
     $w_set=$this->get_sockets_w();
     $e_set=$this->get_sockets_e();
     $result=false;
//     $result=count($w_set)>0;

     $ret=@socket_select($r_set, $w_set, $e_set, $tm_set[0], $tm_set[1]);
     if ($ret===false) return false;
     if ($ret>0) {
         foreach ($e_set as $conn) {
//            $err_code=socket_last_error($conn);
//            if ($err_code!=11) {
              $key=$this->get_key_by_conn($conn);
              if ($key!==false) {
                if (!$this->is_socket_type($key, TCP_SP_TYPE_SERVER)) $this->do_recv($key);
                $this->do_disconnect($key, socket_last_error($conn));
                $result=true;
              }
//            } 
         }
         foreach ($w_set as $conn) {
            $key=$this->get_key_by_conn($conn);
            if ($key!==false) {
              if ($this->is_socket_type($key, TCP_SP_TYPE_CLIENT) && 
                  !$this->list[$key]['connected']) {
                  if (!$w_only) {  
                    $err_code=socket_get_option($conn, SOL_SOCKET, SO_ERROR);
                    if ($err_code!=0) {
                      $this->do_disconnect($key, $err_code);
                    } else $this->do_connect($conn, false, false, $key);
                    $result=true;
                  }
              } else if (count($this->list[$key]['send_stack'])>0) {
                if ($this->try_send_packet($key)) $result=true;
              }
            }
         }
         if (!$w_only && !$result) $result=count($r_set)>0;
         if (!$w_only) foreach ($r_set as $conn) {
              $key=$this->get_key_by_conn($conn);
              if ($key!==false) {
                if ($this->is_socket_type($key, TCP_SP_TYPE_SERVER)) {
                  $new_conn = @socket_accept($conn);
                  if ($new_conn!==false) {
                     if (!@socket_set_nonblock($new_conn)) {
                        @socket_close($new_conn);
                     } else {
                        @socket_clear_error($new_conn);
                        $this->do_connect($new_conn, $key);
                     }
                  }
                } else if (!$this->is_socket_type($key, TCP_SP_TYPE_CLIENT) || $this->list[$key]['connected']) {
                  if ($this->try_read_socket($key)) {
                    $this->do_recv($key);
/*                    
                    if ($this->is_socket_type($key, TCP_SP_TYPE_CLIENT) && 
                        !$this->list[$key]['connected']) {
                      $this->do_connect($conn, false, false, $key);
                    }  
*/                    
                  } else {
                    $this->do_recv($key);
                    $this->do_disconnect($key, socket_last_error($conn));
                  }
                }
              }
         }
     }

     return $result;
  }


  function start_server($server_addr, $server_port, &$err_code=0, &$err_str='') {
     $socket=@socket_create(AF_INET, SOCK_STREAM, SOL_TCP);
     if ($socket === false) {
         $err_code=socket_last_error($socket);
         $err_str=socket_strerror($err_code);
         return false;
     }

     if (!@socket_set_option($socket, SOL_SOCKET, SO_REUSEADDR, 1)) {
         $err_code=socket_last_error($socket);
         $err_str=socket_strerror($err_code);
         socket_close($socket);
         return false;
     }

     if (!@socket_bind($socket, $server_addr, $server_port)) {
         $err_code=socket_last_error($socket);
         $err_str=socket_strerror($err_code);
         socket_close($socket);
         return false;
     }

     if (!@socket_listen($socket)) {
         $err_code=socket_last_error($socket);
         $err_str=socket_strerror($err_code);
         socket_close($socket);
         return false;
     }

     if (!@socket_set_nonblock($socket)) {
         $err_code=socket_last_error($socket);
         $err_str=socket_strerror($err_code);
         socket_close($socket);
         return false;
     }
     @socket_clear_error($socket);

     $key=$this->make_new_socket($socket);
     if (!$key) {
         $err_code=-1;
         $err_str='make_new_socket server failure';
         socket_close($socket);
         return false;
     }
     $this->srv_list[$key]=array();
     $this->set_socket_type($key, TCP_SP_TYPE_SERVER);
     $this->set_connected($key);
     $this->auto_resolve($key);
     return $key;
  }


  function start_client($server_addr, $server_port, $tmo=false, &$err_code=0, &$err_str='') {
     $is_win=(stristr(php_uname('s'), 'windows')==FALSE)?false:true;
     $socket=@socket_create(AF_INET, SOCK_STREAM, SOL_TCP);
     if (!$socket) {
         $err_code=socket_last_error($socket);
         $err_str=socket_strerror($err_code);
         return false;
     }
      
     if (!@socket_set_nonblock($socket)) {
         $err_code=socket_last_error($socket);
         $err_str=socket_strerror($err_code);
         socket_close($socket);
         return false;
     }

     if (!@socket_connect($socket, $server_addr, $server_port)) {
         $ec=socket_last_error($socket);
         if (($is_win && $err_code!=10035)&&(!$is_win && $err_code!=115)) { //      .
           $err_code=$ec;
           $err_str=socket_strerror($err_code);
           socket_close($socket);
           return false;
         }
     }

     @socket_clear_error($socket);
     

//     $key=$this->do_connect($socket, false, TCP_SP_TYPE_CLIENT);     
     $key=$this->make_new_socket($socket);
     if (!$key) {
         $err_code=-1;
         $err_str='make_new_socket client failure';
         socket_close($socket);
         return false;
     }
     $this->set_socket_type($key, TCP_SP_TYPE_CLIENT);
     if ($tmo!==false) $this->set_connect_timeout($key, (float)$tmo);
     return $key;
  }

  function start_client_tmo($server_addr, $server_port, $timeout=1, &$err_code=0, &$err_str='') {
     $is_win=(stristr(php_uname('s'), 'windows')==FALSE)?false:true;
     $timeout=(int)$timeout;
     if ($timeout<1) $timeout=1;
     if ($timeout>600) $timeout=600;
     
     $socket=@socket_create(AF_INET, SOCK_STREAM, SOL_TCP);
     if (!$socket) {
         $err_code=socket_last_error($socket);
         $err_str=socket_strerror($err_code);
         return false;
     }

     if (!@socket_set_nonblock($socket)) {
         $err_code=socket_last_error($socket);
         $err_str=socket_strerror($err_code);
         socket_close($socket);
         return false;
     }

     if (!@socket_connect($socket, $server_addr, $server_port)) {
         $ec=socket_last_error($socket);
         if (($is_win && $err_code!=10035)&&(!$is_win && $err_code!=115)) { //      .
           $err_code=$ec;
           $err_str=socket_strerror($err_code);
           socket_close($socket);
           return false;
         }
     }

     @socket_clear_error($socket);
     $r_set=array($socket);
     $w_set=array($socket);
     $e_set=array($socket);
     $r_r=false;
     $r_w=false;
     $r_e=false;
     
     $ret=@socket_select($r_set, $w_set, $e_set, $timeout);
     if ($ret===false) {
        $err_code=socket_last_error($socket);
        $err_str=socket_strerror($err_code);
        socket_close($socket);
        return false;
     } else if ($ret>0) {
        foreach ($e_set as $client) {
           $r_e=true;
        }
        foreach ($r_set as $client) {
           $r_r=true;
        }
        foreach ($w_set as $client) {
           $r_w=true;
        }
     } else if ($ret<0) {
        $err_code=socket_last_error($socket);
        $err_str=socket_strerror($err_code);
        socket_close($socket);
        return false;
     } else {
        $err_code=socket_last_error($socket);
        $err_str=socket_strerror($err_code);
        socket_close($socket);
        return false;
     }

     if ($r_e || !$r_w) {
        $err_code=socket_last_error($socket);
        $err_str=socket_strerror($err_code);
        socket_close($socket);
        return false;
     }
     @socket_clear_error($socket);
      
     $key=$this->do_connect($socket, false, TCP_SP_TYPE_CLIENT);
     if (!$key) {
         $err_code=-1;
         $err_str='make_new_socket client failure';
         socket_close($socket);
         return false;
     }

     if ($r_r) {
        if ($this->try_read_socket($key)) {
           do_recv($key);
        } else {
           $this->do_disconnect($key, socket_last_error($socket));
           $key=false;
        }
     }

     return $key;
  }

  function dump_packet($data, $line_prefix='') {
     $res=array();
     $l=strlen($data);
     $ind=0;
     while ($ind<$l) {
        $str=sprintf("0x%08X ",$ind);
        $ml=$l-$ind; if ($ml>16) $ml=16;
        $str1='';
        for ($i=0;$i<$ml;$i++) {
            $chc=ord($data{$ind+$i});
            $str.=sprintf(" %02X",$chc);
            if ($chc>32) {
              $str1.=chr($chc);
            } else {
              $str1.='.';
            }
        }
        $str.=str_pad('', (16-$ml)*3);
        $str.='  '.$str1;
        array_push($res, $line_prefix.$str);
        $ind+=$ml;
     }
      
     return implode("\n",$res);
  }

} // end class

} // end incl_h
?>
