<?php

if (!defined("INC_UDP_CLIENT_H")){
   define("INC_UDP_CLIENT_H", TRUE);

include("proto.inc");

class udp_client {
  var $socket;
  var $server_host;
  var $server_port;
  var $server_password;
  var $server_err_code;
  var $server_err_str;
  var $err_code;
  var $err_str;

  var $on_command;

  //Constructor
  function udp_client()
  {
    $this->socket=false;
    $this->server_host='';
    $this->server_port='';
    $this->server_password='';

    $this->client_err_code=0;
    $this->client_err_str='';
    $this->err_code=0;
    $this->err_str='';

    $this->on_command=null;
  }

  function _start_client() {
     $socket = fsockopen("udp://".$this->server_host, $this->server_port, $this->client_err_code, $this->client_err_str, 5);
     if (!$socket) return false;
     socket_set_timeout($socket, 2, 0);
     return $socket;
  }

  function _stop_client() {
     if ($this->socket) fclose($this->socket);
     $this->socket=false;
  }

  function start($server_host, $server_port, $server_password = "") {
     $this->server_host=$server_host;
     $this->server_port=$server_port;
     $this->server_password=$server_password;
     $this->socket=$this->_start_client();
     if (!$this->socket) {
         $this->err_code=$this->client_err_code;
         $this->err_str=$this->client_err_str;
         return false;
     }
     return true;
  }

  function stop() {
     $this->_stop_client();
  }

  function send($str) {
     $sended=0;
     $pka = proto_packet_enc($str);
     foreach ($pka as $pk) {
        $s=fwrite($this->socket, $pk, strlen($pk));
        if (!$s) {
          $this->err_code=-1;
          $this->err_str="Cannot write to socket";
          $this->stop();
          return false;
        }
        $sended+=$s;
     }
     return $sended;
  }

  function recv() {
     $buffer = fread($this->socket, 1);
     $status = socket_get_status($this->socket);
     $urb = (int)$status["unread_bytes"];
     if ($urb>0) $buffer .= fread($this->socket, $status["unread_bytes"]);
     $res=false;

//     $packets=$buffer.chr(254);
     $packets=$buffer;

     if (strlen($buffer)>0) {
         $pk=proto_packet_dec($buffer);
         if ($pk) {
             $res = $pk['data'];
             while ($pk && ($pk['next_len']>0 || strlen($buffer)>=$pk['next_len'])) {
                 $buffer = substr($buffer, $pk['plen']);
                 $nl=$pk['next_len']-strlen($buffer);
                 if ($nl>0) {
                    $buf = fread($this->socket, $nl);
                    $buffer .= $buf;

//                    $packets .= chr(254).'['.$nl.':'.strlen($buf).']'.$buf.chr(254);
                    $packets .= $buf;

                 }
                 $pk=proto_packet_dec($buffer);
                 if ($pk) $res .= $pk['data'];
             }
         }
     }
     return array($res, $packets);
  }

  function process() {
     if (!$this->socket) return false;

     $cmd=$this->recv();
     $func = $this->on_command;
     if ($func) $func($this, $cmd[0], $cmd[1]);
     return true;
  }

}

} // end incl_h
?>
