<?php

if (!defined("INC_UDP_SERVER_H")){
   define("INC_UDP_SERVER_H", TRUE);

include("proto.inc");

class udp_server {
  var $socket;
  var $server_ip;
  var $server_port;
  var $server_password;
  var $server_err_code;
  var $server_err_str;
  var $err_code;
  var $err_str;
  var $pack_arr;

  var $on_command;

  //Constructor
  function udp_server()
  {
    $this->socket=false;
    $this->server_ip='';
    $this->server_port='';
    $this->server_password='';

    $this->server_err_code=0;
    $this->server_err_str='';
    $this->err_code=0;
    $this->err_str='';
    $this->pack_arr = array();

    $this->on_command=null;
  }

  function _start_server() {
     $socket=socket_create(AF_INET, SOCK_DGRAM, SOL_UDP);
     if (!$socket) {
         $this->server_err_code=socket_last_error();
         $this->server_err_str=socket_strerror();
         return false;
     }
     if (!socket_bind($socket, $this->server_ip, $this->server_port)) {
         $this->server_err_code=socket_last_error();
         $this->server_err_str=socket_strerror();
         socket_close($socket);
         return false;
     }
     if (!socket_set_nonblock($socket)) {
         $this->server_err_code=socket_last_error();
         $this->server_err_str=socket_strerror();
         socket_close($socket);
         return false;
     }
     return $socket;
  }

  function _stop_server() {
     if ($this->socket) socket_close($this->socket);
     $this->socket=false;
  }

  function start($server_ip, $server_port, $server_password = "") {
     $this->server_ip=$server_ip;
     $this->server_port=$server_port;
     $this->server_password=$server_password;
//     print("\n".var_export($this, true)."\n");
     $this->socket=$this->_start_server();
     if (!$this->socket) {
         $this->err_code=$this->server_err_code;
         $this->err_str=$this->server_err_str;
         return false;
     }
     return true;
  }

  function stop() {
     $this->_stop_server();
  }

  function send($str, $client_addr , $client_port) {
     $pka = proto_packet_enc($str);
     foreach ($pka as $pk) socket_sendto($this->socket, $pk, strlen($pk), 0, $client_addr , $client_port);
     return $pka;
  }

  function process_rdata($recv_command, $client_addr , $client_port) {
      $key=strtolower(trim($client_addr).':'.trim($client_port));
      if (!array_key_exists($key, $this->pack_arr)) $this->pack_arr[$key]=array('buffer'=>'', 'command'=>'', 'next_len'=>0);
      $this->pack_arr[$key]['buffer'].=$recv_command;
      $pk=proto_packet_dec($recv_command);
      if (!$pk) {
          $this->err_code=-1;
          $this->err_str='wrong packet';
          return false;
      }
      $this->pack_arr[$key]['command'].=$pk['data'];
      $this->pack_arr[$key]['next_len']=(int)$pk['next_len'];
      if ($this->pack_arr[$key]['next_len']==0) {
         $func = $this->on_command;
         if ($func) $func($this, $this->pack_arr[$key]['command'], $client_addr , $client_port, $this->pack_arr[$key]['buffer']);
         $this->pack_arr[$key]['command']='';
         $this->pack_arr[$key]['buffer']='';
         return true;
      }
      return false;
  }

  function process() {
     if (!$this->socket) return false;

     $packets = '';
     $command = '';
     $nrl = PROTO_PACKET_MAX_LEN;
     $r = PROTO_PACKET_MAX_LEN;
     while (true) {
        $r=@socket_recvfrom($this->socket, $recv_command, $nrl, 0, $client_addr , $client_port);
        if ($r==0) return false;
        if ($r<0) {
            $err_code=socket_last_error();
            $err_str=socket_strerror($err_code);
            if ($err_code>0 && $err_code!=35 && $err_code!=11) {
                $this->err_code=$this->server_err_code;
                $this->err_str=$this->server_err_str;
//        print(".[".$err_code.':'.$err_str."]\n");
                $this->stop();
            }
            return false;
        }
        $this->process_rdata($recv_command, $client_addr , $client_port);
//        if (strlen($packets)>0 && $r<$nrl) return false;
//        $packets.=$recv_command;
//        $pk=proto_packet_dec($recv_command);
//        if (strlen($packets)>0) fs_print_log1(DAEMON_BIN_LOG, '|'.$recv_command."|\n".var_export($pk, true)."|\n");
//        if (!$pk) {
//            $this->err_code=-1;
//            $this->err_str='wrong packet';
//            return true;
//        }
//        $nrl=(int)$pk['next_len'];
//        $command.=$pk['data'];
     }
//     $func = $this->on_command;
//     if ($func) $func($this, $command, $client_addr , $client_port, $packets);
     return true;
  }

}

} // end incl_h
?>
