<?php
if (!defined("INC_WEBSOCKET_H")) {
     define("INC_WEBSOCKET_H", TRUE);

include("numcoder.inc");
include("crc8.inc");
include("crypt.inc");

$GLOBALS['WEBSOCKET_DUMP_HELPER']=true;
$GLOBALS['WEBSOCKET_DUMP_HELPER_PAYLOAD']=false;

define('WEBSOCKET_OPCODE_CONTINUATION', 0x00);
define('WEBSOCKET_OPCODE_TEXT', 0x01);
define('WEBSOCKET_OPCODE_BINARY', 0x02);
define('WEBSOCKET_OPCODE_RNCF1', 0x03);
define('WEBSOCKET_OPCODE_RNCF2', 0x04);
define('WEBSOCKET_OPCODE_RNCF3', 0x05);
define('WEBSOCKET_OPCODE_RNCF4', 0x06);
define('WEBSOCKET_OPCODE_RNCF5', 0x07);
define('WEBSOCKET_OPCODE_CLOSE', 0x08);
define('WEBSOCKET_OPCODE_PING', 0x09);
define('WEBSOCKET_OPCODE_PONG', 0x0A);
define('WEBSOCKET_OPCODE_RCF1', 0x0B);
define('WEBSOCKET_OPCODE_RCF2', 0x0C);
define('WEBSOCKET_OPCODE_RCF3', 0x0D);
define('WEBSOCKET_OPCODE_RCF4', 0x0E);
define('WEBSOCKET_OPCODE_RCF5', 0x0F);


$GLOBALS['WEBSOCKET_OpCodes']=array(
  WEBSOCKET_OPCODE_CONTINUATION=>'WEBSOCKET_OPCODE_CONTINUATION',
  WEBSOCKET_OPCODE_TEXT=>'WEBSOCKET_OPCODE_TEXT',
  WEBSOCKET_OPCODE_BINARY=>'WEBSOCKET_OPCODE_BINARY',
  WEBSOCKET_OPCODE_RNCF1=>'WEBSOCKET_OPCODE_RNCF1',
  WEBSOCKET_OPCODE_RNCF2=>'WEBSOCKET_OPCODE_RNCF2',
  WEBSOCKET_OPCODE_RNCF3=>'WEBSOCKET_OPCODE_RNCF3',
  WEBSOCKET_OPCODE_RNCF4=>'WEBSOCKET_OPCODE_RNCF4',
  WEBSOCKET_OPCODE_RNCF5=>'WEBSOCKET_OPCODE_RNCF5',
  WEBSOCKET_OPCODE_CLOSE=>'WEBSOCKET_OPCODE_CLOSE',
  WEBSOCKET_OPCODE_PING=>'WEBSOCKET_OPCODE_PING',
  WEBSOCKET_OPCODE_PONG=>'WEBSOCKET_OPCODE_PONG',
  WEBSOCKET_OPCODE_RCF1=>'WEBSOCKET_OPCODE_RCF1',
  WEBSOCKET_OPCODE_RCF2=>'WEBSOCKET_OPCODE_RCF2',
  WEBSOCKET_OPCODE_RCF3=>'WEBSOCKET_OPCODE_RCF3',
  WEBSOCKET_OPCODE_RCF4=>'WEBSOCKET_OPCODE_RCF4',
  WEBSOCKET_OPCODE_RCF5=>'WEBSOCKET_OPCODE_RCF5',
);

function websocket_avok(&$array, $key, $not_found_val=false) {
  if ((is_int($key) || is_string($key)) && array_key_exists($key, $array)) return $array[$key];
  return $not_found_val;
}

function websocket_opcode_name($cmd, $not_found_val=false) {
  $name=websocket_avok($GLOBALS['WEBSOCKET_OpCodes'], $cmd & 0x7F);
  if ($name==false) return $not_found_val;
  return $name;
}

function websocket_packet($opcode, $masked=false, $data=false) {
  $pk=array();
  $pk['fin']=true;
  $pk['rsv1']=false;
  $pk['rsv2']=false;
  $pk['rsv3']=false;
  $pk['opcode']=$opcode & 0x0F;
  $pk['mask']=($masked)?true:false;
  $pk['payload']=(is_string($data))?$data:'';
  if ($GLOBALS['WEBSOCKET_DUMP_HELPER']) {
    $pk['opcode_hex']=sprintf('0x%02X',$pk['opcode']);
    $pk['opcode_name']=websocket_opcode_name($pk['opcode'], 'Unknown');
    if ($GLOBALS['WEBSOCKET_DUMP_HELPER_PAYLOAD']) if (is_string($pk['payload']) && strlen($pk['payload'])>0) $pk['payload_hex']=numcoder_dump_simple($pk['payload']);
  }
  return $pk;
}

function websocket_mask($mkey, $data) {
//  return $data;
  if (!is_string($mkey) || strlen($mkey)!=4) return $data;
  $len=strlen($data);
  for ($i=0;$i<$len;$i++) $data[$i]=chr(ord($data[$i])^ord($mkey[$i % 4]));
  return $data;
}

function websocket_packet_encode(&$pk) {
  $pk['payload_len']=0;
  if (array_key_exists('payload', $pk) && is_string($pk['payload']) && strlen($pk['payload'])>0) $pk['payload_len']=strlen($pk['payload']);
  if ($pk['payload_len']<0 || $pk['payload_len']>0x7FFFFFFF) return false;

  $byte=0x00;
  if ($pk['fin']) $byte|=(0x01 << 7);
  if ($pk['rsv1']) $byte|=(0x01 << 6);
  if ($pk['rsv2']) $byte|=(0x01 << 5);
  if ($pk['rsv3']) $byte|=(0x01 << 4);
  $byte|=((int)$pk['opcode'] & 0x0F);
  $ret=numcoder_encode($byte, 1);
  
  $byte=0x00;
  if ($pk['mask']) $byte|=(0x01 << 7);
  if ($pk['payload_len']<0x7E) {
    $byte|=($pk['payload_len'] & 0x7F);
    $ret.=numcoder_encode($byte, 1);
  } else if ($pk['payload_len']<0x10000) {
    $byte|=0x7E;
    $ret.=numcoder_encode($byte, 1);
    $ret.=numcoder_encode($pk['payload_len'], 2);
  } else {
    $byte|=0x7F;
    $ret.=numcoder_encode($byte, 1);
    $ret.=numcoder_encode(0x00000000, 4);
    $ret.=numcoder_encode($pk['payload_len'], 4);
  }
  
  $pk['mkey']=false;
  if ($pk['mask']) {
    $pk['mkey']=numcoder_encode(crypt_gen_uni_id(), 4);
    $ret.=$pk['mkey'];
  }
    
  if ($pk['payload_len']>0) $ret.=websocket_mask($pk['mkey'], $pk['payload']);

  if ($GLOBALS['WEBSOCKET_DUMP_HELPER']) {
    $pk['opcode_hex']=sprintf('0x%02X',$pk['opcode']);
    $pk['opcode_name']=websocket_opcode_name($pk['opcode'], 'Unknown');
    if (is_string($pk['mkey']) && strlen($pk['mkey'])>0) $pk['mkey_hex']=numcoder_dump_simple($pk['mkey']);
    if ($GLOBALS['WEBSOCKET_DUMP_HELPER_PAYLOAD']) if (is_string($pk['payload']) && strlen($pk['payload'])>0) $pk['payload_hex']=numcoder_dump_simple($pk['payload']);
  }

  return $ret;
}


function websocket_packet_try_read_header($buf, &$offset=0, &$pk=false) {
  $loffset=strlen($buf);
  $len=$loffset-$offset;
  if (2>$len) return 2-$len;

  $byte=numcoder_decode($buf, $offset, 1, $loffset);
  $pk['fin']=($byte & 0x80)?true:false;
  $pk['rsv1']=($byte & 0x40)?true:false;
  $pk['rsv2']=($byte & 0x20)?true:false;
  $pk['rsv3']=($byte & 0x10)?true:false;
  $pk['opcode']=$byte & 0x0F;
  $pk['fbyte']=$byte & 0xFF;
  
  $byte=numcoder_decode($buf, $offset, 1, $loffset);
  $pk['mask']=($byte & 0x80)?true:false;
  $plen=$byte & 0x7F;
  if ($plen==0x7F) {
    if (8>$loffset-$offset) return 8-($loffset-$offset);
    $plen=numcoder_decode($buf, $offset, 4, $loffset);
    if ($plen!=0x00000000) return -1;
    $plen=numcoder_decode($buf, $offset, 4, $loffset);
    if ($plen<0 || $plen>0x7FFFFFFF) return -2;
  } else if ($plen==0x7E) {
    $plen=numcoder_decode($buf, $offset, 2, $loffset);    
  } 
  $pk['payload_len']=$plen;
  $pk['sbyte']=$byte & 0xFF;
  
  
  $pk['mkey']=false;
  if ($pk['mask']) {
    if (4>$loffset-$offset) return 4-($loffset-$offset);
    $pk['mkey']=numcoder_decode($buf, $offset, 1, $loffset);
  }
  
  return 0;
}
  
function websocket_packet_decode($buf, &$offset=0, &$pk=false) {
  $pk=array();
  $offset_=$offset;
  $hd_len=websocket_packet_try_read_header($buf, $offset_, $pk);
  if ($hd_len!=0) return $hd_len;
  $hd_len=$offset_-$offset;

  $pk_len=$hd_len+$pk['payload_len'];

  $loffset=strlen($buf);
  if ($pk_len>$loffset-$offset) return $pk_len-($loffset-$offset);
  $pk['payload']=substr($buf, $offset+$hd_len, $pk['payload_len']);
  if ($GLOBALS['WEBSOCKET_DUMP_HELPER']) {
    $pk['opcode_hex']=sprintf('0x%02X',$pk['opcode']);
    $pk['opcode_name']=websocket_opcode_name($pk['opcode'], 'Unknown');
    if (is_string($pk['mkey']) && strlen($pk['mkey'])>0) $pk['mkey_hex']=numcoder_dump_simple($pk['mkey']);
    if ($GLOBALS['WEBSOCKET_DUMP_HELPER_PAYLOAD']) if (is_string($pk['payload']) && strlen($pk['payload'])>0) $pk['payload_hex']=numcoder_dump_simple($pk['payload']);
  }
  
  $offset+=$pk_len;

  return $pk;
}

function websocket_gen_sec_key() {
  $simbols = "1234567890qwertyuiopasdfgjklzxcvbnm";
  return base64_encode(substr(str_shuffle($simbols), 0, 16));
}

function websocket_gen_accept($sec_key) {
  return base64_encode(pack('H*', sha1($sec_key . '258EAFA5-E914-47DA-95CA-C5AB0DC85B11')));
}

function websocket_gen_sec_pair() {
  $k=websocket_gen_sec_key();
  return array($k, websocket_gen_accept($k));
}

function websocket_parse_close_body($payload) {
  $code=0;
  $reason='';
  $len=strlen($payload);
  if ($len>=2) {
    $offset=0;
    $code=numcoder_decode($payload, $offset, 2, $len);
    if ($len>2) $reason=substr($payload, $offset, $len);
  }
  return array($code, $reason);
}

function websocket_gen_close_body($ecode=false, $reason=false) {
  $ecode=(int)$ecode;
  if ($ecode<=0 || $ecode>0xFFFF) return '';
  if (!is_string($reason)) $reason='';
  return numcoder_encode($ecode, 2).$reason;
}
  
} // end incl_h
?>
