<?php
if (!defined("INC_ALF_INL_H")){
   define("INC_ALF_INL_H", TRUE);

  include("hexutil.inc");
  include("util.inl");

  define('GLOB_ALF_DATA_KEY', '__alf_data');
  $GLOBALS[GLOB_ALF_DATA_KEY]=array();

function alf_init() {
  if (false===($alfd=&alf_data())) return false;
  $alfd['next_check_time']=0.0;
  $alfd['file_data']=array();
  return true;
}

function &alf_data($key=false) {
  $fret=false;
  if (!array_key_exists(GLOB_ALF_DATA_KEY, @$GLOBALS) || !is_array(@$GLOBALS[GLOB_ALF_DATA_KEY])) return $fret;
  if (is_string($key)) {
    if (!array_key_exists($key, @$GLOBALS[GLOB_ALF_DATA_KEY])) return $fret;
    return $GLOBALS[GLOB_ALF_DATA_KEY][$key];
  }
  return $GLOBALS[GLOB_ALF_DATA_KEY];
}

function alf_idle_proc(&$pool, $mtf=false) {
  global $dmn_main_conn, $glob;

  if (!is_float($mtf)) $mtf=get_mtf();
  if (false===($alfd=&alf_data())) return false;
  
  $cct=(float)@$alfd['next_check_time'];
  if ($cct>0.0) {
    $min_mtf=$mtf-$cct;
    if ((float)$glob['crt_last_check']<$min_mtf) {
      if (false===($crtd=&crt_data())) return false;
      $ft=crt_fmt_time('Y-m-d\TH:i:s.u', $crtd['fetched_time']);
      $take=($ft)?20:1;
      $url=$glob['crt_service_url'].'CameraEvent/GetItems?criteria.matchDateSortType=2&criteria.ignoreMatchcesOnSameCameras=true&criteria.includeAllFaceCards=true';
      if ($ft) $url.='&criteria.matchDateFrom='.$ft;
      $url.='&criteria.take='.$take;
//      $url=$glob['crt_service_url'].'CameraEvent/GetItems?criteria.matchDateSortType=2&criteria.matchDateFrom=2019-04-25T13%3A59%3A44.36&criteria.ignoreMatchcesOnSameCameras=true&criteria.includeAllFaceCards=true&criteria.take=20';
//      $res=httpr_new($dmn_main_conn['pool'], false, REQ_TAG_CRT, crt_hcfg_http(1), $glob['crt_service_url'].'MatchDetailMessage/GetItems?criteria.orderType=1&criteria.take=1', array('crt-stage'=>1, 'no_logs'=>true));
      $res=httpr_new($dmn_main_conn['pool'], false, REQ_TAG_CRT, crt_hcfg_http(1), $url, array('crt-stage'=>1, 'no_logs'=>true, 'mtf'=>get_mtf()));
      
      
      if ($res) {
//        plogs("crt0:".var_export($res, true)."\n");
        $glob['crt_check_time']=-$cct;
        $glob['crt_last_check']=get_mtf();
      }
    }
  }
}

   

} // end incl_h
?>
