<?php
if (!defined("INC_CONN_INL_H")){
  define("INC_CONN_INL_H", TRUE);
  
define('GLOB_KEY_CONNECTIONS', 'connections');
$glob[GLOB_KEY_CONNECTIONS]=array();
define('GLOB_KEY_RECONNECTIONS', 'reconnections');
$glob[GLOB_KEY_RECONNECTIONS]=array();
define('GLOB_KEY_PROXY_SERVERS', 'proxy_servers');
$glob[GLOB_KEY_PROXY_SERVERS]=array();

include("proxy.inl");
include("fm3056.inl");
include("ds9208.inl");
  
function &conn_obj_get($key) {
  global $glob;
  $ret=false;
  if (!array_key_exists($key, $glob[GLOB_KEY_CONNECTIONS]) || !is_array($glob[GLOB_KEY_CONNECTIONS][$key])) return $ret;
  return $glob[GLOB_KEY_CONNECTIONS][$key];
}

function &conn_obj_get_by_id($id) {
  global $glob;
  $ret=false;
  if ($id=='') return $ret;
  if (!($settings=&conn_get_settings_by_id($id))) return $ret;
  return conn_obj_get($settings['key']);
}
  
function &conn_get_settings(&$obj, $apkey='MAIN', $auto_add=false) {
  global $glob;
  $conn=$obj;
  $ret=false;
  if (is_string($obj) && !($conn=&conn_obj_get($obj))) return $ret;
//  logp($glob['log_file'], "conn_get_settings:\n".var_d(array($obj, $apkey, $conn), true)."\n", true);
  if (!is_array($conn)) return $ret;
  if ($apkey && array_key_exists('apkeys', @$conn) && is_array(@$conn['apkeys'])) {
    if (array_key_exists($apkey, @$conn['apkeys']) && is_array(@$conn['apkeys'][$apkey])) {
      return $conn['apkeys'][$apkey];
    }
  } else if ($apkey && is_array(@$conn['uapkeys'][$apkey])) {
    return $conn['uapkeys'][$apkey];
  } else if ($apkey=='MAIN' && array_key_exists('settings', @$conn) && is_array(@$conn['settings'])) {
    return $conn['settings'];
  }
  
  if ($auto_add && $apkey) {
    if (array_key_exists('settings', @$conn) && is_array(@$conn['settings'])) {
      if (!is_array(@$conn['uapkeys'])) $conn['uapkeys']=array();
      if (!array_key_exists($apkey, $conn['uapkeys'])) $conn['uapkeys'][$apkey]=$conn['settings'];
      $conn['uapkeys'][$apkey]['id']='';
      $conn['uapkeys'][$apkey]['apkey']=$apkey;
      $conn['uapkeys'][$apkey]['uapkey']=$apkey;
      return $conn['uapkeys'][$apkey];
    }
  }
    
  return $ret;
}

function &conn_get_settings_by_id($id) {
  global $glob;
  $ret=false;
  if ($id=='') return $ret;
  foreach ($glob[GLOB_KEY_CONNECTIONS] as &$conn) {
    if (is_array(@$conn['apkeys']) && count($conn['apkeys'])>0) {
      foreach ($conn['apkeys'] as &$settings) {
        if (@$settings['id']==$id) {
          $settings['key']=$conn['key'];
          return $settings;
        }
      }
    } else if (is_array(@$conn['settings'])) {
        if (@$conn['settings']['id']==$id) {
          $conn['settings']['key']=$conn['key'];
          return $conn['settings'];
        }
    }
  }
  foreach ($glob[GLOB_KEY_RECONNECTIONS] as &$conn) {
    if (is_array(@$conn['apkeys']) && count($conn['apkeys'])>0) {
      foreach ($conn['apkeys'] as &$settings) {
        if (@$settings['id']==$id) {
          $settings['key']=$conn['key'];
          return $settings;
        }
      }
    } else if (is_array(@$conn['settings'])) {
        if (@$conn['settings']['id']==$id) {
          $conn['settings']['key']=$conn['key'];
          return $conn['settings'];
        }
    }
  }
  return $ret;
}

function conn_find_key_($term) {
  global $glob;
  if (!$term) return false;
  foreach (array_keys($glob[GLOB_KEY_CONNECTIONS]) as $key) {
    if ($glob[GLOB_KEY_CONNECTIONS][$key]['ip']==$term['ip'] && $glob[GLOB_KEY_CONNECTIONS][$key]['port']==$term['port']) return $key;
  }
  foreach (array_keys($glob[GLOB_KEY_RECONNECTIONS]) as $key) {
    if ($glob[GLOB_KEY_RECONNECTIONS][$key]['ip']==$term['ip'] && $glob[GLOB_KEY_RECONNECTIONS][$key]['port']==$term['port']) return $key;
  }
  return false;
}

function conn_find_key($term) {
  global $glob;
  $term=term_parse($term);
  return conn_find_key_($term);
}

function conn_upd_sarr(&$dst, &$src) {
  if (!is_array($dst) || !is_array($src)) {
    if ($dst!==$src) $dst=$src;
  } else foreach (array_keys($src) as $k) {
    if (is_array($src[$k])) {
      if (!array_key_exists($k, $dst)) $dst[$k]=array();
      conn_upd_sarr($dst[$k], $src[$k]);
      continue;
    }
    
    if ($k=='id') {
      if (strlen($src[$k])==0) {
        if (array_key_exists($k, $dst)) continue;
        $src[$k]=gen_id();
      }
    }
    $dst[$k]=$src[$k];
  }
}

function conn_upd_settings(&$conn, &$term) {
  if (!is_array(@$conn['settings'])) $conn['settings']=array();
  conn_upd_sarr($conn['settings'], $term['settings']);
  if (is_array(@$term['apkeys'])) {
    if (!is_array(@$conn['apkeys'])) $conn['apkeys']=array();
    conn_upd_sarr($conn['apkeys'], $term['apkeys']);
  }
  if (is_array(@$term['uapkeys'])) {
    if (!is_array(@$conn['uapkeys'])) $conn['uapkeys']=array();
    conn_upd_sarr($conn['uapkeys'], $term['uapkeys']);
  }
}

function conn_upd_($term) {
  global $glob;
  $tkey=conn_find_key_($term); if (!$tkey) return false;
//  logp($glob['log_file'],"\n\nconn_upd_ term:\n".var_export($term, true)."\n", true);//exit(0);
  if (array_key_exists($tkey, $glob[GLOB_KEY_CONNECTIONS])) conn_upd_settings($glob[GLOB_KEY_CONNECTIONS][$tkey], $term);
  if (array_key_exists($tkey, $glob[GLOB_KEY_RECONNECTIONS])) conn_upd_settings($glob[GLOB_KEY_RECONNECTIONS][$tkey], $term);
  return $tkey;
}

function conn_upd($term) {
  global $glob;
  $term=term_parse($term); if (!$term) return false;
  return conn_upd_($term);
}

function conn_on_child_connect(&$pool, $key) {
  global $glob;
  $srv_key=$pool->list[$key]['srv_key'];

  if ($glob['ucs_server_key']!==false && $glob['ucs_server_key']==$srv_key) return ucs_on_connect($pool, $key);
  if (@$glob['txp_server_key']!==false && $glob['txp_server_key']==$srv_key) return txp_on_connect($pool, $key);
  if (@jsp_data('jsp_server_key')!==false && jsp_data('jsp_server_key')==$srv_key) return jsp_on_connect($pool, $key);
  if (array_key_exists($srv_key, $glob[GLOB_KEY_PROXY_SERVERS])) return proxy_on_connect($pool, $key);  
}

function conn_on_connect(&$pool, $key) {
  global $glob;
  if ($pool->is_socket_type($key, TCP_SP_TYPE_CHILD)) return conn_on_child_connect($pool, $key);
  if (!$pool->is_socket_type($key, TCP_SP_TYPE_CLIENT)) return false;
  $addr=$pool->list[$key]['addr'];
  $port=$pool->list[$key]['port'];
  plogs("connected [".$key."]: [".$addr.":".$port."]\n");
  if (array_key_exists($key, $glob[GLOB_KEY_CONNECTIONS])) {
//    logp($glob['log_file'],"\n\nconn_on_connect conn:\n".var_export($glob[GLOB_KEY_CONNECTIONS][$key], true)."\n", true);//exit(0);
    tlogs_add($glob[GLOB_KEY_CONNECTIONS][$key]['con_key'], array('tkey'=>$glob[GLOB_KEY_CONNECTIONS][$key]['con_key'], 'type'=>'CONNECT', 'time'=>get_mtf()));
    if ($glob[GLOB_KEY_CONNECTIONS][$key]['settings']['type']==TTYPE_POCKET) {
      $pk=eproto_packet(eproto_cmd_Enquire, 0, numcoder_encode_r((int)$glob['term_autoping_interval'], 2).numcoder_encode_r((int)$glob['term_autoping_timeout'], 2));
      $pool->send($key, $pk);
      $pk=eproto_packet(eproto_cmd_Beep);
      $pool->send($key, $pk);
      if (@$glob[GLOB_KEY_CONNECTIONS][$key]['settings']['fm3056']) {
         fm3056_init_buf($key);
         $pk=eproto_packet(eproto_cmd_USARTRaw);
         $pk['flags']=EPROTO_PK_FLAGS_RT_MAIN;
         $pk['payload']=fm3056_init();
         $pool->send($key, $pk);
      }
      if (@$glob[GLOB_KEY_CONNECTIONS][$key]['settings']['ds9208']) {
         ds9208_init_buf($key);
      }
        
    } else if ($glob[GLOB_KEY_CONNECTIONS][$key]['settings']['type']==TTYPE_GAT) {
      $pk=gat_packet(0xFF, 0xF5, 0);
      $pool->send($key, $pk);
    } else if ($glob[GLOB_KEY_CONNECTIONS][$key]['settings']['type']==TTYPE_SPHINX) {
      sphinx_on_connect($pool, $key);
    } else if ($glob[GLOB_KEY_CONNECTIONS][$key]['settings']['type']==TTYPE_JSP) {
      dev_jsp_on_connect($pool, $key);
    }
    $glob[GLOB_KEY_CONNECTIONS][$key]['last_activity_time']=get_mtf();
    if (array_key_exists('rc', $glob[GLOB_KEY_CONNECTIONS][$key])) unset($glob[GLOB_KEY_CONNECTIONS][$key]['rc']);
  }
}

function conn_on_child_disconnect(&$pool, $key, $err_code=0) {
  global $glob;
  $srv_key=$pool->list[$key]['srv_key'];
  if ($glob['ucs_server_key']!==false && $glob['ucs_server_key']==$srv_key) return ucs_on_disconnect($pool, $key, $err_code);
  if (@$glob['txp_server_key']!==false && $glob['txp_server_key']==$srv_key) return txp_on_disconnect($pool, $key, $err_code);
  if (@jsp_data('jsp_server_key')!==false && jsp_data('jsp_server_key')==$srv_key) return jsp_on_disconnect($pool, $key, $err_code);
  if (array_key_exists($srv_key, $glob[GLOB_KEY_PROXY_SERVERS])) return proxy_on_disconnect($pool, $key, $err_code);
}

function conn_on_disconnect(&$pool, $key, $err_code=0) {
  global $glob;
  if ($pool->is_socket_type($key, TCP_SP_TYPE_CHILD)) return conn_on_child_disconnect($pool, $key, $err_code);
  if (!$pool->is_socket_type($key, TCP_SP_TYPE_CLIENT)) return false;
  $es='disconnected ['.$key.']';
  if ($err_code!==0) {
    if (is_integer($err_code)) {
      $es.=' ['.$err_code.':'.cp866(trim(socket_strerror($err_code))).']';
    } else {
      $es.=' ['.$err_code.']';
    }
  }
  plogs($es."\n");

  httpr_fin($key, $es);
  if (array_key_exists($key, $glob[GLOB_KEY_CONNECTIONS])) {
    $con_key=$glob[GLOB_KEY_CONNECTIONS][$key]['con_key'];
    $ip=$glob[GLOB_KEY_CONNECTIONS][$key]['ip'];
    $port=$glob[GLOB_KEY_CONNECTIONS][$key]['port'];
    if ($glob[GLOB_KEY_CONNECTIONS][$key]['settings']['type']==TTYPE_SPHINX) {
      sphinx_on_disconnect($pool, $key, $err_code);
    } else if ($glob[GLOB_KEY_CONNECTIONS][$key]['settings']['type']==TTYPE_JSP) {
      dev_jsp_on_disconnect($pool, $key, $err_code);
    }
    $cnt=1;
    if (array_key_exists('rc', $glob[GLOB_KEY_CONNECTIONS][$key])) {
      $cnt=(int)@$glob[GLOB_KEY_CONNECTIONS][$key]['rc']['count']+1;
    } else {
      tlogs_add($con_key, array('tkey'=>$con_key, 'type'=>'DISCONNECT', 'time'=>get_mtf(), 'reason'=>$es));
    }
    $glob[GLOB_KEY_RECONNECTIONS][$key]=array('key'=>$key, 'con_key'=>$con_key, 'ip'=>$ip, 'port'=>$port, 'settings'=>$glob[GLOB_KEY_CONNECTIONS][$key]['settings'],
                                       'vars'=>$glob[GLOB_KEY_CONNECTIONS][$key]['vars'],
                                       'time'=>get_mtf(), 'ntime'=>conn_calc_rc_ntime($cnt), 'count'=>$cnt);
    if (is_array(@$glob[GLOB_KEY_CONNECTIONS][$key]['apkeys'])) $glob[GLOB_KEY_RECONNECTIONS][$key]['apkeys']=$glob[GLOB_KEY_CONNECTIONS][$key]['apkeys'];
    if (is_array(@$glob[GLOB_KEY_CONNECTIONS][$key]['uapkeys'])) $glob[GLOB_KEY_RECONNECTIONS][$key]['uapkeys']=$glob[GLOB_KEY_CONNECTIONS][$key]['uapkeys'];
    unset($glob[GLOB_KEY_CONNECTIONS][$key]);
  }
}

function conn_on_debug(&$pool, $str) {
   plogs("debug [".$str."]\n");
}

function conn_on_recv(&$pool, $key, $buffer, &$readed=0, &$wait_len=0, &$seq_no=0) {
   global $dmn_main_conn, $glob;

   if (!$pool->is_socket_type($key, TCP_SP_TYPE_CLIENT)) return false;

   if (array_key_exists($key, $glob[GLOB_KEY_CONNECTIONS])) {
     $offset=0;
     $prlog=!@$glob['llock'];

     if ($glob[GLOB_KEY_CONNECTIONS][$key]['settings']['type']==TTYPE_POCKET) {
       $ret=eproto_packet_decode($buffer, $offset, $pk);
       if (is_int($ret) && $ret<0) {
         plogs("pde:".var_d($ret, true)."\n");
         $ret=false;
       }
       if (@$pk['cmd']) pocket_parse_packet($pk);
       if (@$pk['cmd'] && @$glob['log_exclude_pings'] && ($pk['cmd'] & 0x7F)==eproto_cmd_Enquire) $prlog=false;
     } else if ($glob[GLOB_KEY_CONNECTIONS][$key]['settings']['type']==TTYPE_GAT) {
       $ret=gat_decode_packet($buffer, $offset, $pk);
       if (@$pk['cmd'] && @$glob['log_exclude_pings'] && ($pk['cmd'] & 0xEF)==GAT_CMD_REQ_MASTER) $prlog=false;
     }

     if ($ret===false) {
       plogs("packet decode error. halting.\n");
       $pool->drop_connection($key, 'packet decode error. stream broken.');
       return false;
     }
     $glob[GLOB_KEY_CONNECTIONS][$key]['last_activity_time']=get_mtf();
     if (!is_array($ret)) return $ret;
     $readed=$offset;
     $buf=substr($buffer, 0, $readed);

     if ($prlog) logp($glob['log_file'],
                      "received [".$key.':'.$seq_no."]:".NL.
                      $pool->dump_packet($buf).
                      NL.NL."Data:".NL.
                      var_d($pk, true).NL,
                      true);

      if (array_key_exists('rc', $glob[GLOB_KEY_CONNECTIONS][$key])) unset($glob[GLOB_KEY_CONNECTIONS][$key]['rc']);
  //   plogs("received:\n".var_d($pk, true));
     return $pk;
   }
   return false;
}

function conn_on_send(&$pool, $key, $data, $seq_no) {
  global $dmn_main_conn, $glob;

  if (!$pool->is_socket_type($key, TCP_SP_TYPE_CLIENT)) return false;

  if (array_key_exists($key, $glob[GLOB_KEY_CONNECTIONS])) {
    $prlog=!@$glob['llock'];
    if ($glob[GLOB_KEY_CONNECTIONS][$key]['settings']['type']==TTYPE_POCKET) {
      pocket_parse_packet($data);
      $buf=eproto_packet_encode($data);
      if (@$glob['log_exclude_pings'] && ($data['cmd'] & 0x7F)==eproto_cmd_Enquire) $prlog=false;
    } else if ($glob[GLOB_KEY_CONNECTIONS][$key]['settings']['type']==TTYPE_GAT) {
      $buf=gat_encode_packet($data);
      if (@$glob['log_exclude_pings'] && ($data['cmd'] & 0xEF)==GAT_CMD_REQ_MASTER) $prlog=false;
    }
    if ($prlog) logp($glob['log_file'],
                     "sended [".$key.':'.$seq_no."]:".NL.
                     $pool->dump_packet($buf).
                     NL.NL."Data:".NL.
                     var_d($data, true).NL,
                     true);
//   plogs("sended:\n".var_d($data, true));
    return $buf;
  }
  return $data;
}

function conn_on_low_recv(&$pool, $key, $data) {
   global $dmn_main_conn, $glob;
   if (!@$dmn_main_conn['need_raw_dump'] || !@$dmn_main_conn['low_raw_enabled']) return true;
   if (array_key_exists($key, $glob[GLOB_KEY_HTTP_REQUESTS])) {
     logp($glob['log_file_low'], "received [".$key."]:".NL.$data.NL, true);
   } else logp($glob['log_file_low'], "received [".$key."]:".NL.$pool->dump_packet($data).NL, true);
   return true;
}

function conn_on_low_send(&$pool, $key, $data) {
   global $dmn_main_conn, $glob;
   if (!@$dmn_main_conn['need_raw_dump'] || !@$dmn_main_conn['low_raw_enabled']) return true;
   if (array_key_exists($key, $glob[GLOB_KEY_HTTP_REQUESTS])) {
     logp($glob['log_file_low'], "sended [".$key."]:".NL.$data.NL, true);
   } else logp($glob['log_file_low'], "sended [".$key."]:".NL.$pool->dump_packet($data).NL, true);
   return true;
}

function conn_on_data(&$pool, $key) {
   global $glob;

   if (!$pool->is_socket_type($key, TCP_SP_TYPE_CLIENT)) return false;

   $data=$pool->get_data($key);
//   logp($glob['log_file'], "answer0 [".$key."]:\n".var_d($data, true)."\n", true);
//   return false;
   if ($data===false) return false;
   if (!is_array($data[2])) return false;
   $raw_data=(string)implode('', $data[2]);
   $seq_no=$data[1];
   $data=$data[0];
//   plogs("raw_data_s:\n[\n".$raw_data."\n]\n\n\n");
//   plogs("raw_data:\n".var_d($raw_data, true));
//   logp($glob['log_file'], "answer [".$key."]:\n".var_d($data[2], true)."\n", true);

   if (!array_key_exists($key, $glob[GLOB_KEY_CONNECTIONS])) return true;
   if (!@$data['cmd']) return true;

   if ($glob[GLOB_KEY_CONNECTIONS][$key]['settings']['type']==TTYPE_POCKET) {
     return pocket_on_packet($pool, $key, $raw_data, $seq_no, $data);
   } else if ($glob[GLOB_KEY_CONNECTIONS][$key]['settings']['type']==TTYPE_GAT) {
     return gat_on_packet($pool, $key, $raw_data, $seq_no, $data);
   }
   return true;
}

function con_gen_answer($key, $result, $message, $a, $gat_cmd, $llock=false, $rce_flags=false) {
  global $dmn_main_conn, $glob;
  $glob['llock']=$llock;
//  plogs(var_d(array($key, $result, $message, $a, $gat_cmd), true)."\n");
//  plogs(var_d($glob[GLOB_KEY_CONNECTIONS][$key], true)."\n");
//  plogs(var_d($message, true)."\n");
  if ($glob[GLOB_KEY_CONNECTIONS][$key]['settings']['utf']) $message=to_utf8($message);
//  plogs(var_d($message, true)."\n");
  $skey = session_key($a, $key);
  $sobj=@$glob[GLOB_KEY_SESSIONS][$skey];
  if ($glob[GLOB_KEY_CONNECTIONS][$key]['settings']['type']==TTYPE_POCKET) {
    $message=colon2nl($message);
    if ($result>0) {
      if (!is_int($rce_flags)) $rce_flags=POCKET_RELAY_FLAG_DOWNCOUNT | POCKET_RELAY_FLAG_ZSECOND;
      if (is_array($sobj)) {
//        logp($glob['log_file'], "session[".$skey."]:\n".var_d($sobj, true));
        if (@$sobj['data']['rfid']['temp_card'] && @$glob[GLOB_KEY_CONNECTIONS][$key]['settings']['ctrole']=='card_taker') $rce_flags|=POCKET_RELAY_FLAG_TAKE_CARD;
      }

//      logp($glob['log_file'], "rce_flags[".$skey."]:\n".var_d($rce_flags, true));
      if (!($rce_flags & POCKET_RELAY_FLAG_DOWNCOUNT)) {
        $pk=eproto_packet(eproto_cmd_Interactive);
        $pk['flags']=(int)@$sobj['data']['rfid']['reader_type'];
        $pk['payload']=pocket_interactive($message, 8000, 0, true);
        $dmn_main_conn['pool']->send($key, $pk);
      }
      $pk=eproto_packet(eproto_cmd_RelayControlEx);
      $pk['flags']=(int)@$sobj['data']['rfid']['reader_type'];
      $pk['payload']=relay_on_ex(8000, $rce_flags, $message, $sobj['s_id']);
//      $pk['payload']=relay_on_ex(8000, $rce_flags, $message, $a);
      $dmn_main_conn['pool']->send($key, $pk);
//      $dmn_main_conn['pool']->send($key, eproto_packet(eproto_cmd_Beep));
    } else {
      $dmn_main_conn['pool']->send($sobj['key'], eproto_packet(eproto_cmd_RelayControlEx, (int)@$sobj['data']['rfid']['reader_type'], relay_on_ex(0x1FFFFFFF)));
      $pk=eproto_packet(eproto_cmd_Interactive);
      $pk['flags']=(int)@$sobj['data']['rfid']['reader_type'];
      $pk['payload']=pocket_interactive($message, 1500, 4, true);
      $dmn_main_conn['pool']->send($key, $pk);
    }
  } else if ($glob[GLOB_KEY_CONNECTIONS][$key]['settings']['type']==TTYPE_SPHINX) {
    sphinx_send($key, 'DELEGATION_REPLY', $a, 'NORMAL', ($result>0)?'255':'0', '0', '0', '0', '0');    
  } else if ($glob[GLOB_KEY_CONNECTIONS][$key]['settings']['type']==TTYPE_GAT) {
    $pk=gat_packet($a, $gat_cmd, ($result>0)?0:1, $message);
    $dmn_main_conn['pool']->send($key, $pk);
  }
  
  if (!$result && $glob['ucs_child_key'] && ($cset=&conn_get_settings($sobj['key'], $sobj['apkey']))) {
    if (is_array(@$cset[UCS_SENT_REQUEST_KEY])) {
      $pa=$cset[UCS_SENT_REQUEST_KEY];
      ucs_send_transaction($dmn_main_conn['pool'], $pa[0], $pa[1], UCS_CANCEL_SYMBOL);
    }
  }

  $glob['llock']=false;
}
  
function conn_calc_rc_ntime($cnt) {
  global $dmn_main_conn, $glob;
  $wt=(float)$cnt*(float)$glob['reconnection_wait_time_step'];
//  plogs('wt: '.$wt."\n");
  $wtm=(float)$glob['reconnection_wait_time_max'];
  if ($wt>$wtm) $wt=$wtm;
  if ($wt<0.1) $wt=0.1;
  return get_mtf()+$wt;
}
  
function conn_idle_proc(&$pool, $mtf) {
  global $glob;
  
  $min_mtf=$mtf-((float)$glob['term_autoping_timeout']);
  foreach (array_keys($glob[GLOB_KEY_CONNECTIONS]) as $key) {
    if (@$glob[GLOB_KEY_CONNECTIONS][$key]['settings']['type']==TTYPE_SPHINX) continue;
    if (@$glob[GLOB_KEY_CONNECTIONS][$key]['settings']['type']==TTYPE_JSP) continue;
    if (!@$glob[GLOB_KEY_CONNECTIONS][$key]['rc'] && $glob[GLOB_KEY_CONNECTIONS][$key]['last_activity_time']<$min_mtf) {
      $pool->drop_connection($key, 'activity timeout');
//      unset($glob[GLOB_KEY_CONNECTIONS][$key]);
    }
  }

  $min_mtf=$mtf;
  $okeys=array_keys($glob[GLOB_KEY_RECONNECTIONS]);
  foreach ($okeys as $okey) {
    if ($glob[GLOB_KEY_RECONNECTIONS][$okey]['ntime']<$min_mtf) {
      $settings=$glob[GLOB_KEY_RECONNECTIONS][$okey]['settings'];
      $vars=$glob[GLOB_KEY_RECONNECTIONS][$okey]['vars'];
      $con_key=$glob[GLOB_KEY_RECONNECTIONS][$okey]['con_key'];
      $ip=$glob[GLOB_KEY_RECONNECTIONS][$okey]['ip'];
      $port=$glob[GLOB_KEY_RECONNECTIONS][$okey]['port'];
      plogs("trying reconnection... [".$ip.":".$port."]\n");
      $key=$pool->start_client($ip, $port, $glob['terminal_connect_timeout'], $err_code, $err_str);
      if ($key!==false) {
        if ($settings['type']==TTYPE_SPHINX) {
          $pool->set_socket_handlers($key, 'sphinx_on_recv', 'sphinx_on_send', 'sphinx_on_data', 'conn_on_disconnect');
        } else if ($settings['type']==TTYPE_JSP) {
          $pool->set_socket_handlers($key, 'dev_jsp_on_recv', 'dev_jsp_on_send', 'dev_jsp_on_data', 'conn_on_disconnect');
        } else {
          $pool->set_socket_handlers($key, 'conn_on_recv', 'conn_on_send', 'conn_on_data', 'conn_on_disconnect');
        }
        $pool->set_socket_low_handlers($key, 'conn_on_low_recv', 'conn_on_low_send');
        $glob[GLOB_KEY_CONNECTIONS][$key]=array('key'=>$key, 'con_key'=>$con_key, 'ip'=>$ip, 'port'=>$port, 'settings'=>$settings, 'vars'=>$vars, 'start_time'=>get_mtf(), 'last_activity_time'=>get_mtf(), 'rc'=>$glob[GLOB_KEY_RECONNECTIONS][$okey]);
        $pkey=@$glob[GLOB_KEY_CONNECTIONS][$key]['vars']['proxy_key'];
        if ($pkey && array_key_exists($pkey, $glob[GLOB_KEY_PROXY_SERVERS])) {
          $glob[GLOB_KEY_PROXY_SERVERS][$pkey]['ckey']=$key;
        }
        if (is_array(@$glob[GLOB_KEY_RECONNECTIONS][$okey]['apkeys'])) $glob[GLOB_KEY_CONNECTIONS][$key]['apkeys']=$glob[GLOB_KEY_RECONNECTIONS][$okey]['apkeys'];
        if (is_array(@$glob[GLOB_KEY_RECONNECTIONS][$okey]['uapkeys'])) $glob[GLOB_KEY_CONNECTIONS][$key]['uapkeys']=$glob[GLOB_KEY_RECONNECTIONS][$okey]['uapkeys'];
        unset($glob[GLOB_KEY_RECONNECTIONS][$okey]);
      } else {
        $glob[GLOB_KEY_RECONNECTIONS][$okey]['count']++;
        $glob[GLOB_KEY_RECONNECTIONS][$okey]['ntime']=conn_calc_rc_ntime($glob[GLOB_KEY_RECONNECTIONS][$okey]['count']);
      }
    }
  }

}
  
  
  
} // end incl_h
?>
