<?php
if (!defined("INC_CRT_INL_H")){
   define("INC_CRT_INL_H", TRUE);

  include("hexutil.inc");
  include("util.inl");
  include("session.inl");

  define('GLOB_CRT_DATA_KEY', '__crt_data');
  $GLOBALS[GLOB_CRT_DATA_KEY]=array();

function crt_init() {
  global $dmn_main_conn, $glob;
  if (false===($crtd=&crt_data())) return false;
  $crtd['fetched_time']=0.0;//get_mtf()-86400.0;
  $crtd['cam_events']=array();
  $crtd['cam_seen']=array();
  $crtd['person_seen']=array();
  $crtd['person_cam_ban']=array();
  $crtd['seen_idle_next_time']=0.0;
  $crtd['ban_idle_next_time']=0.0;
  $crtd['session_requests']=array();
  return true;
}

function crt_session_request_add($slink, $cam_id, $pid) {
  global $glob;
  $cam_id=''.trim(@$cam_id); if (strlen($cam_id)<1) return false;
  $pid=''.trim(@$pid); if (strlen($pid)<1) return false;
  if (false===($crtd=&crt_data())) return false;
  $rid=$cam_id.'_'.$pid;
  if (!($sobj=&session_obj_get($slink))) return false;
  $sid=$sobj['s_id']; if (strlen($sid)<1) return false;
  $stmo=(float)@$glob['crt_seen_timeout']; if ($stmo<=0.0) return false;
 
  $mtf=get_mtf();
  $crtd['session_requests'][$rid]=array();
  $crtd['session_requests'][$rid]['rid']=$rid;
  $crtd['session_requests'][$rid]['s_id']=$sid;
  $crtd['session_requests'][$rid]['time']=$mtf;
  $crtd['session_requests'][$rid]['timeout']=$mtf+$stmo;
  $crtd['session_requests'][$rid]['cam_id']=$cam_id;
  $crtd['session_requests'][$rid]['pid']=$pid;
  
  if (crt_session_request_try($cam_id, $pid)) return false;
  
  return $rid;
}

function crt_session_request_try($cam_id, $pid) {
  $cam_id=''.trim(@$cam_id); if (strlen($cam_id)<1) return false;
  $pid=''.trim(@$pid); if (strlen($pid)<1) return false;
  if (false===($crtd=&crt_data())) return false;
  $rid=$cam_id.'_'.$pid;
  
  $rdata=@$crtd['session_requests'][$rid];
  if (!is_array($rdata)) return false;
  
  $data=@$crtd['cam_seen'][$cam_id][$pid];
  if (!is_array($data)) return false;
  
  if ($sobj=&session_obj_get(@$rdata['s_id'])) {
    session_set_cam_result($sobj, CAM_RES_YES, array('cam_answer_data'=>$data));
    session_check_done($sobj);
  }
  
  unset($crtd['session_requests'][$rid]);
  return $data;
}

function &crt_data($key=false) {
  $fret=false;
  if (!array_key_exists(GLOB_CRT_DATA_KEY, @$GLOBALS) || !is_array(@$GLOBALS[GLOB_CRT_DATA_KEY])) return $fret;
  if (is_string($key)) return @$GLOBALS[GLOB_CRT_DATA_KEY][$key];
  return $GLOBALS[GLOB_CRT_DATA_KEY];
}

function &crt_vars($key) {
  $fret=false;
  if (false===($crtd=&crt_data())) return $fret;
  if (!array_key_exists($key, @$crtd['crt_connections']) || !is_array(@$crtd['crt_connections'][$key])) return $fret;
  if (!is_string(@$crtd['crt_connections'][$key]['buf'])) $crtd['crt_connections'][$key]['buf']='';
  return $crtd['crt_connections'][$key];
}

function &crt_requests() {
  $fret=false;
  if (false===($crtd=&crt_data())) return $fret;
  if (!array_key_exists('requests', $crtd)) return $fret;
  return $crtd['requests'];
}

function crt_get_session_key_by_id($id) {
  global $glob;
  $cset=&conn_get_settings_by_id($id);
  $skey=@$glob[GLOB_KEY_CONNECTIONS][$cset['key']]['vars']['last_started_session'];
  if ($skey && array_key_exists($skey, $glob[GLOB_KEY_SESSIONS]) && !@$glob[GLOB_KEY_SESSIONS][$skey]['processed']) return $skey;
  return false;

  foreach (array_keys($glob[GLOB_KEY_SESSIONS]) as $skey) {
    if ($glob[GLOB_KEY_SESSIONS][$skey]['key']==$ckey) return $skey;
  }
  return false;
}

function crt_fmt_usec($usec, $len=6) {
    $ret=(string)$usec;
    $ret=str_pad($ret, $len, '0', STR_PAD_RIGHT);
    return $ret;
}

function crt_fmt_time($format, $tms) {
  if (!is_float($tms) || $tms<=0.0) return false;
  $sec=(int)$tms;
  $usec=$tms-(float)$sec;
  $usec=round($usec*1000000);
  $format=str_replace('u', crt_fmt_usec($usec, 7), $format);
  return date($format, $sec);
}

function crt_str2mtf($str) {
//  2019-04-25T13:59:46.9470000Z
  if (!is_string($str)) return false;
  if (!preg_match('/(\d{4})\-(\d{2})\-(\d{2})T(\d{2})\:(\d{2})\:(\d{2})\.(\d+)Z/', $str, $matches)) return false;
//  plogs("crt_process_items pm:\n".var_d(array($str, $matches), true)."\n");
  $fract=(float)('0.'.$matches[7]);
  $itime=mktime((int)$matches[4], (int)$matches[5], (int)$matches[6], (int)$matches[2], (int)$matches[3], (int)$matches[1]);
  return (float)($itime+$fract);
}

function crt_unset(&$arr, $key) {
  if (!is_array($arr)) return false;
  if (!array_key_exists($key, $arr)) return false;
  unset($arr[$key]);
  return true;
}
  
function crt_hcfg_http($params=false) {
  global $glob;
  $sct=(float)@$glob['crt_service_connect_time1'];
  if ($params===2) $sct=(float)@$glob['crt_service_connect_time2'];
  if ($params===3) $sct=(float)@$glob['crt_service_connect_time3'];
  if ($sct<=0.0) $sct=HTTPR_DEF_CONNECT_TIMEOUT;
  
  $ret=array(
    'ip'=>$glob['crt_service_ip'],
    'port'=>$glob['crt_service_port'],
    'host'=>@$glob['crt_service_name'],
    'connect_timeout'=>$sct,
    'expire_time'=>((float)@$glob['crt_service_expire_time']>0)?(float)@$glob['crt_service_expire_time']:HTTPR_DEF_EXPIRE_TIME,
    'extra_headers'=>array(),
  );
  if (is_array(@$glob['crt_service_request_extra_headers'])) foreach ($glob['crt_service_request_extra_headers'] as $hd) if (is_string($hd)) $ret['extra_headers'][]=$hd;
  $ret['extra_headers'][]='Accept: application/json';

  return $ret;
}

function crt_process_items($key, $robj, $data) {
  global $dmn_main_conn, $glob;
  $rparams=$robj['params'];
  if (!is_array($rparams)) return;
  if (!@$rparams['no_logs']) logp($glob['log_file'], "crt_process_items:\n".var_d(array($key, $robj, $data), true)."\n", true);
  $rstage=(int)@$rparams['crt-stage'];
  if ($rstage<1) return;
  if (!is_array($data)) return;
  if (count($data)==0) return;
  if (false===($crtd=&crt_data())) return false;


  
  if ($rstage==1) {
    $events=crt_get_cameraEvents($data, $maxdate);
    $maxfdate=crt_str2mtf($maxdate);
    if (!$maxfdate) return false;
    $first=($crtd['fetched_time']==0.0);
    $crtd['fetched_time']=$maxfdate+1.0;
    if ($first) return;
    
    if (!@$rparams['no_logs']) logp($glob['log_file'], "crt_process_items1:\n".var_d(array($maxdate,  $maxfdate, crt_fmt_time('Y-m-d\TH:i:s.u\Z', $maxfdate), $events), true)."\n", true);
    
//    plogs("crt1:".var_export(count($data), true)."\n");
    foreach ($events as $key=>$item) {
      $fcid=(int)@$item['FACECARDID'];
      if ($fcid>0 && $fcid!=(int)@$crtd['cam_events'][$key]['FACECARDID']) {
        $crtd['cam_events'][$key]=$item;
        
        $term_id=crt_cam2term($key); if (!$term_id) continue;
//        $skey=crt_get_session_key_by_id($term_id); if ($skey) continue;
        
        $url=$glob['crt_service_url'].'MatchDetailMessage/GetItems?criteria.parentFaceCardId='.$fcid.'&criteria.orderType=1&criteria.take=1';
        $rparams['crt-stage']=2;
//        $rparams['no_logs']=true;
        $rparams['no_logs']=false;
        $rparams['face_card_id']=$fcid;
        $rparams['cam_id']=''.$item['CAMERAID'];
//        $rparams['cam_id_str']=$key;
        $rparams['term_id']=$term_id;
        $rparams['event']=$item;
        

        $res=httpr_new($dmn_main_conn['pool'], false, REQ_TAG_CRT, crt_hcfg_http(2), $url, $rparams);
//        plogs("crt2:".var_export($res, true)."\n");
      }
    }
  } else if ($rstage==2) {
    if (!@$rparams['no_logs']) logp($glob['log_file'], "crt_process_items2:\n".var_d(array($data), true)."\n", true);
    $msg=crt_get_MatchDetailMessage($data); if (!is_array($msg)) return;
//    $skey=crt_get_session_key_by_id(@$rparams['term_id']); if ($skey) return;
    
    $cfcid=(int)@$msg['CHILDFACECARDID'];
    if ($cfcid>0) {
      $rparams['crt-stage']=3;
//      $rparams['no_logs']=true;
      $rparams['match']=$msg;
      $rparams['score']=(float)@$msg['SCORE'];
      $rparams['score_prc_str']=crt_fmt_score($rparams['score']);      
      $rparams['child_face_card_id']=$cfcid;
      $url=$glob['crt_service_url'].'PersonCard/GetItems?criteria.faceCardId='.$cfcid.'&criteria.includePersonCardPropertyValues=true&criteria.take=1';

      $res=httpr_new($dmn_main_conn['pool'], false, REQ_TAG_CRT, crt_hcfg_http(3), $url, $rparams);
//      plogs("crt3:".var_export($res, true)."\n");
    }
  } else if ($rstage==3) {
    $pdata=crt_get_PersonCard_data($data); if (!is_array($pdata)) return;
    if (!@$rparams['no_logs']) logp($glob['log_file'], "crt_process_items3:\n".var_d(array(@$rparams, $data, $pdata), true)."\n", true);


    $pcard=@$pdata['pcard'];
    $match=@$rparams['match'];
    $event=@$rparams['event'];
    crt_unset($pdata, 'pcard');
    crt_unset($rparams, 'match');
    crt_unset($rparams, 'event');
    
    
    crt_unset($rparams, 'crt-stage');
    crt_unset($rparams, 'no_logs');
    $rparams['pid']=@$pdata['pid'];
    $rparams['pdata']=$pdata;

//    $rparams['event']=$event;
//    $rparams['match']=$match;
//    $rparams['pcard']=$pcard;

    crt_process_identification($rparams);    
//    ecmdh_halt(false, false); return;
  }
    
}

function crt_cam2term($cam_id_str) {
  global $glob;
  if (!array_key_exists($cam_id_str, @$glob['crt_cam_links'])) return false;
  return $glob['crt_cam_links'][$cam_id_str];
}

function crt_get_PersonCard_data($arr) {
  $pcard=false;
  if (is_array($arr)) foreach ($arr as $item) {
    if (!array_key_exists('PERSONCARDPROPERTYVALUES', $item) || !array_key_exists('ALTERNATEID', $item) || !array_key_exists('INFORMATION', $item)) return;
    $pcard=$item;
    if (is_array($pcard)) break;
  }  
  if (!is_array($pcard)) return false;
 
  $ret=array();
  $ret['fio']=crt_extract_PersonCardPropertyValues_fio(@$pcard['PERSONCARDPROPERTYVALUES']);
  $ret['pid']=trim(@$pcard['INFORMATION']); if (strlen($ret['pid'])==0) return false;
//  $ret['cam_id']=true;//crt_extract_FileMetadatas_cam_id(@$pcard['FILEMETADATAS'], $cfcid);
  $ret['header']=trim(@$pcard['HEADER']);
  $ret['pcard']=$pcard;
  return $ret;
}

function crt_fmt_score($score) {
  if ($score>0.0 && !($score>1.0)) {
      $score=(int)round($score*100);
      return sprintf('%d%%', $score);
  }
  return '';
}

function crt_get_MatchDetailMessage($arr) {
  $msg=false;
  if (is_array($arr)) foreach ($arr as $item) {
    if (!array_key_exists('CHILDFACECARDID', $item) || !array_key_exists('SCORE', $item)) continue;
    $score=(float)@$item['SCORE'];
    if ($score<=0.0 || $score>1.0) continue;
    if (!is_array($msg) || $score>(float)@$msg['SCORE']) $msg=$item;
  }  
  return $msg;
}

function crt_get_cameraEvents($arr, &$maxdate) {
  $maxdate=false;
  $events=array();
  if (is_array($arr)) foreach ($arr as $item) {
    if (!$maxdate) $maxdate=@$item['DATECREATED'];
    $cam_id=(string)trim(''.@$item['CAMERAID']);
    if (strlen($cam_id)>0) {
      if (!array_key_exists($cam_id, $events)) $events[$cam_id]=$item;      
    }
  }
  return $events;  
}

function crt_extract_PersonCardPropertyValues_fio($arr) {
  if (is_array($arr)) foreach ($arr as $item) {
    if (@$item['PROPERTYTEMPLATEENTRY']['NAME']=='_fio' && is_string(@$item['VALUE']) && strlen($item['VALUE'])>0) return $item['VALUE'];
  }
  return false;
}

function crt_extract_FileMetadatas_cam_id($arr, $fcid) {
  if (is_array($arr)) foreach ($arr as $item) {
    if (@$item['FACECARD']['ID']==$fcid) {
      $cid=@$item['FACECARD']['CAMERAID'];
      if (is_int($cid)) return $cid;
      return false;
    }
  }
  return false;
}

function crt_process_identification($data) {
  global $dmn_main_conn, $glob;
  logp($glob['log_file'], "crt_process_identification:\n".var_d($data, true)."\n", true);
  plogs("crt_process_identification:\n".var_d($data, true)."\n");
  
  if (false===($crtd=&crt_data())) return false;
  $cam_id=''.trim(@$data['cam_id']); if (strlen($cam_id)<1) return false;
  $pid=''.trim(@$data['pid']); if (strlen($pid)<1) return false;
  $cpid=$cam_id.'_'.$pid;
  
  $crtd['cam_seen'][$cam_id][$pid]=$data;
  $crtd['person_seen'][$pid][$cam_id]=$data;
  
  if (!@$glob['crt_service_identification_mode']) {
    if (crt_session_request_try($cam_id, $pid)) return true;
    return true;
  }
  
//  logp($glob['log_file'], "crt_process_identification0:\n".var_d(@$crtd['person_cam_ban'], true)."\n", true);
  
  $ban_tmo=(float)@$crtd['person_cam_ban'][$cpid];

  if ($ban_tmo>0.0 && get_mtf()<$ban_tmo) return false;

  $ban_time=(float)@$glob['crt_ban_cam_pid_time'];
  $ban_start=(@$glob['crt_ban_from_catch'])?(float)@$data['mtf']:get_mtf();
  if ($ban_time>0.0 && !@$glob['crt_ban_pass_only']) $crtd['person_cam_ban'][$cpid]=$ban_start+$ban_time;
  
//  logp($glob['log_file'], "crt_process_identification1:\n".var_d($crtd, true)."\n", true);
  
    $skey=crt_get_session_key_by_id(@$data['term_id']); if ($skey) return;
    if (!($conn=&conn_get_settings_by_id(@$data['term_id']))) return true;

//    logp($glob['log_file'], "crt_process_identification2:\n".var_d(array($skey, $conn), true)."\n", true);
    if (!($sobj=&dev_session_auto_renew($dmn_main_conn['pool'], (string)$data['pid'], @$conn['key'], @$conn['apkey']))) return true;
    
      $facedata=array(
      'reader_type' => 16,
      'reader_type_name' => 'MAIN',
      'src_pk_code' => 0,
      'src_pk_flags' => 0,
      'pid'=>$data['pid'],
      'fio'=>$data['pdata']['fio'],
      'cam_id'=>$data['cam_id'],
      'data'=>(string)$data['pid'],
      'crt'=>$data,
    );
  

  $os='Terminal used: ['.@$conn['key']."]\n";
  $os.='Terminal id: '.@$conn['id']."\n";
  $os.='Terminal address: ['.@$conn['ip'].':'.@$conn['port']."]\n";
  $os.="Terminal type: POCKET\n";
//  $os.='DATA: '.@$facedata['data']."\n";
  foreach ($facedata as $k=>$v) $os.=$k.': '.var_d($v, true)."\n";
  plogs($os);

  
    session_set_faceid_data($sobj, $facedata);

    
    if (@$glob['crt_no_kpo_pass']) {
      $msg=trim(@$data['pdata']['fio']).', '.trim(@$data['score_prc_str']);
      if (strlen($msg)<3) $msg=$glob['service_fixed_msg'];
      session_set_kpo_result($sobj, KPO_RES_YES, $msg, array('kpo_answer_data'=>'autofix'));
      $sobj['stage']='kpo_result';
      $sobj['ap_mode']=true;
      $sobj['no_report']=true;
    }
    
//    session_wait($sobj, SESSION_PROC_KPO, 'kpo_result');
//    session_lp_update($sobj);
//    session_set_kpo_result($sobj, KPO_RES_YES, $data['pdata']['fio'].', '.$data['score_prc_str'], array('kpo_answer_data'=>$facedata));
//    $sobj['stage']='kpo_result';
//    logp($glob['log_file'], "crt_process_identification done 1.\n", true);

    session_check_done($sobj['id']);

//    logp($glob['log_file'], "crt_process_identification done 2.\n", true);
}

function crt_try_ban_after_pass($slink) {
  global $glob;
  if (!($sobj=&session_obj_get($slink))) return false;
  if (!is_bool(@$sobj['passed']['passed']) || !@$sobj['passed']['passed']) return false;
  $cdata=@$sobj['data']['faceid']['crt'];
//  logp($glob['log_file'], "crt_try_ban_after_pass:\n".var_d($sobj, true)."\n", true);
  if (is_array($cdata)) {
//    logp($glob['log_file'], "crt_try_ban_after_pass1:\n".var_d($cdata, true)."\n", true);
    if (false===($crtd=&crt_data())) return false;
//    logp($glob['log_file'], "crt_try_ban_after_pass2:\n".var_d($crtd, true)."\n", true);
    $cam_id=''.trim(@$cdata['cam_id']); if (strlen($cam_id)<1) return false;
    $pid=''.trim(@$cdata['pid']); if (strlen($pid)<1) return false;
    $cpid=$cam_id.'_'.$pid;
    $ban_time=(float)@$glob['crt_ban_cam_pid_time'];
    $ban_start=(@$glob['crt_ban_from_catch'])?(float)@$cdata['mtf']:get_mtf();
    if ($ban_time>0.0 && @$glob['crt_ban_pass_only']) $crtd['person_cam_ban'][$cpid]=$ban_start+$ban_time;
  }
}

function crt_session_done($slink, $prev_stage) {
  if (!($sobj=&session_obj_get($slink))) return false;
  crt_try_ban_after_pass($sobj);
}

function crt_idle_seen(&$pool, $mtf) {
  global $glob;
  $stmo=(float)@$glob['crt_seen_timeout']; if ($stmo<=0.0) return false;
  if (false===($crtd=&crt_data())) return false;
  if ((float)@$crtd['seen_idle_next_time']>$mtf) return false;
  $stmo=$mtf-$stmo;
  if (is_array(@$crtd['cam_seen'])) foreach (array_keys($crtd['cam_seen']) as $cam_id) {
    if (is_array(@$crtd['cam_seen'][$cam_id])) foreach (array_keys($crtd['cam_seen'][$cam_id]) as $pid) {
      $imtf=@$crtd['cam_seen'][$cam_id][$pid]['mtf'];
      if (is_float($imtf) && $imtf<$stmo) {
        unset($crtd['cam_seen'][$cam_id][$pid]);
        if (count($crtd['cam_seen'][$cam_id])==0) unset($crtd['cam_seen'][$cam_id]);
      }
    }
  }
  if (is_array(@$crtd['person_seen'])) foreach (array_keys($crtd['person_seen']) as $pid) {
    if (is_array(@$crtd['person_seen'][$pid])) foreach (array_keys($crtd['person_seen'][$pid]) as $cam_id) {
      $imtf=@$crtd['person_seen'][$pid][$cam_id]['mtf'];
      if (is_float($imtf) && $imtf<$stmo) {
        unset($crtd['person_seen'][$pid][$cam_id]);
        if (count($crtd['person_seen'][$pid])==0) unset($crtd['person_seen'][$pid]);
      }
    }
  }
  $crtd['seen_idle_next_time']=$mtf+10.0;
  return true;
}

function crt_idle_ban(&$pool, $mtf) {
  global $glob;
  if (false===($crtd=&crt_data())) return false;
  if ((float)@$crtd['ban_idle_next_time']>$mtf) return false;
  if (is_array(@$crtd['person_cam_ban'])) foreach (array_keys($crtd['person_cam_ban']) as $ban_id) {
    $imtf=@$crtd['person_cam_ban'][$ban_id];
    if (is_float($imtf) && $imtf<$mtf) {
      unset($crtd['person_cam_ban'][$ban_id]);
    }
  }
  $crtd['ban_idle_next_time']=$mtf+10.0;
  return true;
}

function crt_idle_session_requests(&$pool, $mtf) {
  global $glob;
  if (false===($crtd=&crt_data())) return false;
  
  if (is_array(@$crtd['session_requests'])) foreach (array_keys($crtd['session_requests']) as $rid) {
    if (!is_float(@$crtd['session_requests'][$rid]['timeout']) || $crtd['session_requests'][$rid]['timeout']<$mtf) {
      unset($crtd['session_requests'][$rid]);
    }
  }
}

function crt_idle_proc(&$pool, $mtf) {
  global $dmn_main_conn, $glob;

  crt_idle_seen($pool, $mtf);
  crt_idle_ban($pool, $mtf);
  crt_idle_session_requests($pool, $mtf);
  
  $cct=(float)@$glob['crt_check_time'];
  if ($cct>0.0) {
    $min_mtf=$mtf-$cct;
    if ((float)$glob['crt_last_check']<$min_mtf) {
      if (false===($crtd=&crt_data())) return false;
      $ft=crt_fmt_time('Y-m-d\TH:i:s.u', $crtd['fetched_time']);
      $take=($ft)?20:1;
      $url=$glob['crt_service_url'].'CameraEvent/GetItems?criteria.matchDateSortType=2&criteria.ignoreMatchcesOnSameCameras=true&criteria.includeAllFaceCards=true';
      if ($ft) $url.='&criteria.matchDateFrom='.$ft;
      $url.='&criteria.take='.$take;
//      $url=$glob['crt_service_url'].'CameraEvent/GetItems?criteria.matchDateSortType=2&criteria.matchDateFrom=2019-04-25T13%3A59%3A44.36&criteria.ignoreMatchcesOnSameCameras=true&criteria.includeAllFaceCards=true&criteria.take=20';
//      $res=httpr_new($dmn_main_conn['pool'], false, REQ_TAG_CRT, crt_hcfg_http(1), $glob['crt_service_url'].'MatchDetailMessage/GetItems?criteria.orderType=1&criteria.take=1', array('crt-stage'=>1, 'no_logs'=>true));
      $res=httpr_new($dmn_main_conn['pool'], false, REQ_TAG_CRT, crt_hcfg_http(1), $url, array('crt-stage'=>1, 'no_logs'=>true, 'mtf'=>get_mtf()));
      
      
      if ($res) {
//        plogs("crt0:".var_export($res, true)."\n");
        $glob['crt_check_time']=-$cct;
        $glob['crt_last_check']=get_mtf();
      }
    }
  }
}


} // end incl_h
?>
