<?php
if (!defined("INC_DEV_JSP_INL_H")){
   define("INC_DEV_JSP_INL_H", TRUE);

   include("hexutil.inc");
   include("util.inl");
   include("handler.inl");
   
   
function dev_jsp_init() {
  global $dmn_main_conn, $glob;
  if (false===($jspd=&jsp_data())) return false;
  if (!is_array(@$jspd['jsp_connections'])) return false;
  return true;
}

function dev_jsp_on_connect(&$pool, $key) {
  global $glob;
  if (false===($jspd=&jsp_data())) return false;
  $addr=$pool->list[$key]['addr'];
  $port=$pool->list[$key]['port'];
  plogs("jsp dev connected [".$key."]: [".$addr.":".$port."]\n");
  jsp_init_vars($key, false);
  jsp_upd_autoping($pool, $key, 2);
  if (@$glob['jsp_dev_autoping_enabled']) jsp_set_autoping($pool, $key, (int)$glob['term_autoping_interval'],(int)$glob['term_autoping_timeout']);
}

function dev_jsp_on_disconnect(&$pool, $key, $err_code=0) {
  if (false===($jspd=&jsp_data())) return false;
  plogs("jsp dev disconnected [".$key."]\n");
//  $jspd['jsp_con_evt_time']=get_mtf();
  if (array_key_exists($key, $jspd['jsp_connections'])) unset($jspd['jsp_connections'][$key]);
}
   
function dev_jsp_on_recv(&$pool, $key, $buffer, &$readed=0, &$wait_len=0, &$seq_no=0) {
   global $dmn_main_conn, $glob;
      
//   plogs("jspr#1: [".var_d($buffer)."]\n");
   if (!is_string($buffer) || strlen($buffer)==0) return false;
//   plogs("jspr#1a\n");
   if (!array_key_exists($key, $glob[GLOB_KEY_CONNECTIONS])) return false;
   if (array_key_exists('rc', $glob[GLOB_KEY_CONNECTIONS][$key])) unset($glob[GLOB_KEY_CONNECTIONS][$key]['rc']);
   if (false===($vars=&jsp_vars($key))) return false;
//   plogs("jspr#2, vars: [".var_d($vars)."]\n");
   $vars['buf'].=$buffer;
   $readed=strlen($buffer);
   $result=array();
   while (true) {
     $res=jsp_try_read_packet($key);
//     plogs("jspr#3, res: [".var_d($res)."]\n");
     if (is_bool($res)) {
       if ($res===false) break;
       continue;
     }
     if (is_int($res) && $res>=0) {
       $wait_len=$res;
       break;
     }
     if (is_string($res)) {
       $glob[GLOB_KEY_CONNECTIONS][$key]['last_activity_time']=get_mtf();
       if ($prlog) logp($glob['log_file'],
                        "jsp received garbage [".$key.':'.$seq_no."]:\n".
                        $pool->dump_packet($res).
                        "\n\nData:\n".
                        var_export($res, true)."\n", 
                        true);
       $result[]=$res;
       continue;
     }
     if (!is_array($res)) break;
     $pk=@jsondec($res[1]);
     $_pk=jsp_arr_lower($pk);
     if (!is_array($pk)) $pk=false;

     $prlog=!@$glob['llock'];
     if (is_string(@$_pk['cmd']) && @$glob['log_exclude_pings'] && strtolower(trim($_pk['cmd']))=='pong') $prlog=false;

     jsp_upd_autoping($pool, $key, 2);

     $glob[GLOB_KEY_CONNECTIONS][$key]['last_activity_time']=get_mtf();
     if ($prlog) logp($glob['log_file'],
                      "jsp received [".$key.':'.$seq_no."]:\n".   
                      $pool->dump_packet($res[0]).
                      "\n\nJSON:\n".
                      $res[1].
                      "\n\nData:\n".
                      var_export($pk, true)."\n", 
                      true);
     $res[]=$pk;
     $result[]=$res;
   }
   if (count($result)==0) return false;
   return $result;
}

function dev_jsp_on_send(&$pool, $key, $data, $seq_no) {
  global $dmn_main_conn, $glob;

  if (!array_key_exists($key, $glob[GLOB_KEY_CONNECTIONS])) return false;
  $prlog=!@$glob['llock'];
  if (is_string($data)) { $buf=$data; $pkdata=$data; } else $buf=jsp_encode_packet($data, $pkdata);
//  $buf=jsp_encode_packet($data);

  $_data=jsp_arr_lower($data);
  if (is_string(@$_data['cmd']) && @$glob['log_exclude_pings'] && strtolower(trim($_data['cmd']))=='ping') $prlog=false;
      
  if ($prlog) logp($glob['log_file'],
                   "jsp sended [".$key.':'.$seq_no."]:\n".   
                   $pool->dump_packet($buf).
                   "\n\nJSON:\n".
                   $pkdata.
                   "\n\nData:\n".
                   var_export($data, true)."\n", 
                   true);
//  plogs("sended:\n".var_export($data, true));
  return $buf;
}

function dev_jsp_on_data(&$pool, $key) {
  global $dmn_main_conn, $glob;
//function on_data(&$pool, $key, $data, $seq_no) {
   global $glob;
   
   $data=$pool->get_data($key);
   if ($data===false) return false;
   $raw_data=$data[2];
   $seq_no=$data[1];
   $data=$data[0];
   if (!is_array($data) || count($data)==0) return false;
//   plogs("jsp data:\n".var_export($data, true)."\n");
//   plogs("raw_data:\n".var_export($raw_data, true));
//   logp($glob['log_file'], "answer [".$key."]:\n".var_export($data[2], true)."\n", true);
   foreach ($data as $pk) dev_jsp_process_packet($pool, $key, $pk);
   return true;
}

// 'lockers_data' => '62:180,33:26',


function dev_jsp_transform_lockers_data(&$pk) {
  if (!is_array($pk)) return false;
  if (!array_key_exists('lockers_data', $pk)) return false;
  if (is_array($pk['lockers_data'])) return false;
  $lds=$pk['lockers_data'];
  $pk['_lockers_data']=$lds;
  unset($pk['lockers_data']);
  if (!is_string($lds) || strlen($lds)==0) return false;
  $lda=preg_split('/[\,\;]+/', $lds);
  if (!is_array($lda) || count($lda)==0) return false;
  $ret=array();
  foreach ($lda as $ldr) {
    if (!is_string($ldr) || !preg_match('/(([A-Z\d]+)\:)?([\d]+)/', $ldr, $m)) continue;
    $let=$m[2];
    $num=(int)$m[3];
    $r=array (
        'auth_err' => 0,
        'read_err' => 0,
        'is_passtech' => false,
        'block_no' => (int)$let,
//        'litera' => 'M',
        'locked' => true,
        'cab_no' => $num,
      );
    if (preg_match('/^[\-A-Za-z]$/', $let, $lm)) {
      $r['is_passtech']=true;
      $r['litera']=strtoupper($let);
      $r['block_no']=($let=='-')?0:ord($r['litera'])-ord('A')+1;
    }
    $ret[]=$r;
  }
  if (count($ret)==0) return false;
  $pk['lockers_data']=$ret;
  return true;
}

function dev_jsp_process_packet(&$pool, $key, $_pk) {
  $req=false;
  if (is_array($_pk) && count($_pk)==3 && is_array($_pk[2])) {
    plogs("jsp dev packet:\n".var_export($_pk, true)."\n");
    $pk=jsp_arr_lower($_pk[2]);
    if (is_string(@$pk['cmd'])) {
      if (!($conn=&conn_get_settings($key))) return false;
      if ($pk['cmd']=='tag_read') {
        $tid=agov($pk, 'tid', NULL);
        $uid=agov($pk, 'uid', '');
        $rid=agov($pk, 'rid', false);
        if (!is_string($uid)) return false;
        dev_jsp_transform_lockers_data($pk);
        if (!($sobj=&dev_session_auto_renew($pool, $uid, $key, @$conn['apkey']))) return false;
        $sobj['uid_raw']=hexutil_hex2buf($uid);
        if (is_string($rid) && strlen($rid)>0) $sobj['jsp_rid']=$rid;
        dev_process_lockers_data($pk);
        session_set_rfid_data($sobj, $pk);
        session_check_done($sobj['id']);        
      } else if ($pk['cmd']=='pass_report') {
        if (!($sobj=&session_obj_get(@$pk['sid']))) {
          if (!($sobj=&session_obj_get(@$pk['uid']))) {
            if (!($cobj=&conn_obj_get($key))) return true;
            if (!($sobj=&session_obj_get(@$cobj['vars']['last_started_session']))) return true;          
          }
        }
        $pk['key']=$key;
        $pk['time']=get_mtf();
//        $sobj['uid_raw']=@hexutil_hex2buf(@$pk['uid']);
        session_set_passed_data($sobj, $pk);
        session_check_done($sobj['id']);
      } else if (is_string(@$pk['rid'])) {
        jsp_answer_request($key, $pk['rid'], $pk);      
      }
    } else if (is_string(@$pk['rid'])) {
      if (false===($requests=&jsp_requests())) return false;
      if (array_key_exists($pk['rid'], $requests) && is_array($requests[$pk['rid']])) {
        handler_exec('jsp_event', array(&$requests[$pk['rid']], &$pool, $key, 'answer', $pk, $_pk), $result);
        jsp_delete_request($pk['rid']);
      }
    }
  } else if (is_string($_pk)) {
    plogs("jsp dev garbage packet:\n".var_export($_pk, true)."\n");
  } else {
    plogs("jsp dev unknown packet:\n".var_export($_pk, true)."\n");
  }
  return true;
}


} // end incl_h
?>
