<?php
if (!defined("INC_DS9208_INL_H")){
   define("INC_DS9208_INL_H", TRUE);


define('DS9208_CMD_PREFIX', "\x7E\x01\x30\x30\x30\x30"); // '~<SOH>0000'
define('DS9208_CMD_STYPE_SAVE', "\x40"); // '@'
define('DS9208_CMD_STYPE_WRITE', "\x23"); // '#'

define('DS9208_CMD_SUFFIX', "\x03"); // '<ETX>'


include("eproto.inc");
//include("ds9208.inl");
include("pocket.inl");

function ds9208_init() {
  return ds9208_pack(DS9208_CMD_STYPE_WRITE, 'PWBENA0;GRBENA1,VOL2;RRDENA1,DUR1500;TSUENA0;APSENA0;PACKAG2;');
}

function ds9208_init_buf($key) {
  global $glob;
  $glob[GLOB_KEY_CONNECTIONS][$key]['vars']['usart_buf']='';
}

function ds9208_symb_name($symb, $not_found_val='Unknown') {
  return eproto_avok($GLOBALS['DS9208_Symbologies'], $symb, $not_found_val);
}

function ds9208_make($data) {
  return DS9208_CMD_PREFIX.$data.DS9208_CMD_SUFFIX;
}

function ds9208_pack_tag($tag, $varr) {
  if (is_string($varr)) return $tag.$varr.';';
  return $tag.@implode(',', $varr).';';
}

function ds9208_pack($stype, $data) {
  if (is_string($data)) return DS9208_CMD_PREFIX.$stype.$data.DS9208_CMD_SUFFIX;
  if (!is_array($data)) return false;
  $ret=array();
  foreach ($data as $key=>$val) {
    if (!is_array($val) && !is_string($val)) return false;
    $ret[]=ds9208_pack_tag($key, $val);
  }
  return DS9208_CMD_PREFIX.$stype.implode('', $ret).DS9208_CMD_SUFFIX;
}

function ds9208_buff_shift($key, $count=0) {
  global $glob;
  if ($count>0) $glob[GLOB_KEY_CONNECTIONS][$key]['vars']['usart_buf']=substr($glob[GLOB_KEY_CONNECTIONS][$key]['vars']['usart_buf'], $count);
  return $glob[GLOB_KEY_CONNECTIONS][$key]['vars']['usart_buf'];
}

function ds9208_parse_stream($key) {
  $buf=ds9208_buff_shift($key);
  $pos=strpos($buf, "\x02");
  if ($pos===false) return false;
  $buf=ds9208_buff_shift($key, $pos);
  $pos=strpos($buf, "\x03\x04");
  if ($pos===false) return false;  
  $data=substr($buf, 1, $pos-1);
  ds9208_buff_shift($key, $pos+2);
  
  plogs("barcode data[".$key."]:\n".var_export($data, true)."\n");
  if (!is_string($data) || strlen($data)<4 || $data{0}!=']') return array('data'=>$data, 'error'=>from_utf8("Ошибка\nчтения\nштрих-кода"));
  $type=$data{1};
  $subtype=$data{2};
  $data=substr($data, 3);
//  $data=str_pad($data, 14, '0', STR_PAD_LEFT);
  plogs("barcode int data[".$key."]:\n".var_export($data, true)."\n");
//  if (strlen($data)<4 || strlen($data)>32) return array('data'=>$data, 'error'=>from_utf8("\nНекорректный\nкод\n"));
  
  return array('type'=>$type, 'subtype'=>$subtype, 'data'=>$data);
}

function ds9208_pkpfill(&$dst, $src, $key) {
  if (is_array($src) && array_key_exists($key, $src)) {
    $dst[$key]=$src[$key];
  }
}

function ds9208_process_stream(&$pool, $key, $pk) {
  global $glob;
  $glob[GLOB_KEY_CONNECTIONS][$key]['vars']['usart_buf'].=$pk['payload'];
  $need_loop=true;
  while ($need_loop!==false) {
    $need_loop=ds9208_parse_stream($key);
    if (is_string($need_loop)) {
      plogs("ds9208 received [".$key."]:[".$need_loop."]\n");
    } else if (is_array($need_loop)) {
      plogs("ds9208 received [".$key."]:[".var_d($need_loop, true)."]\n");
//      if ($need_loop['type']===0) {
        ds9208_pkpfill($need_loop, @$pk['data'], 'reader_type');
        ds9208_pkpfill($need_loop, @$pk['data'], 'reader_type_name');
        plogs("ds9208 received #1 [".$key."]:[".var_d($need_loop, true)."]\n");
        ds9208_process_code($pool, $key, $need_loop);
//      }
    }
  }
//  plogs("ds9208 buf [".$key."]:[".$glob[GLOB_KEY_CONNECTIONS][$key]['vars']['usart_buf']."]\n");
}

function ds9208_process_code(&$pool, $key, $aparams) {
  if (!is_array($aparams)) return true;

  if (!($conn=&conn_get_settings($key, @$aparams['reader_type_name'], true))) return true;

  if (session_is_alive(@$conn['reader_locked'])) {
    $pk=eproto_packet(eproto_cmd_Interactive);
    $pk['flags']=(int)@$aparams['reader_type'];
    $text=from_utf8("Ожидайте...");
    $pk['payload']=pocket_interactive($text, 0, 0, true);
//    $pk['payload']=pocket_interactive_text($text);
    $pool->send($key, $pk);
    return true;
  }

  $gpkey=cgate_get_op_conn($conn);
  if (!($sobj=&dev_session_auto_renew($pool, @$aparams['data'], $key, @$aparams['reader_type_name']))) return true;

  $os='Terminal used: ['.$key."]\n";
  $os.='Terminal id: '.@$conn['id']."\n";
  $os.='Terminal address: ['.@$conn['ip'].':'.@$conn['port']."]\n";
  $os.="Terminal type: POCKET\n";
//  $os.='DATA: '.@$aparams['data']."\n";
  foreach ($aparams as $k=>$v) $os.=$k.': '.var_d($v, true)."\n";
  plogs($os);

//  session_set_kpo_result($sobj, NULL);
  session_set_barcode_data($sobj, $aparams);

  if (is_string(@$aparams['error'])) {
    $sobj['data']['error_message']=$aparams['error'];
    $sobj['stage']=1;
//    session_set_kpo_result($sobj, KPO_RES_NO, $aparams['error'], array('kpo_answer_data'=>'barcode error'));
  }
  
  session_check_done($sobj['id']);
  return true;    
}

} // end incl_h
?>