<?php
if (!defined("INC_EXT_CMD_INL_H")){
  define("INC_EXT_CMD_INL_H", TRUE);

include("proxy.inl");
  
function get_stats() {
  global $glob, $dmn_main_conn, $term_logs;
  $jspd=&jsp_data();
  $stats=$glob['stats'];
  $stats['cur_time']=get_mtf();
  $stats['total_event_count']=(int)@count(aarr($term_logs, 'common'));
  $stats['jsp_subscriber_key']=@$jspd['jsp_subscriber_key'];
  return $stats;
}

$settings_path=array(
  'term_list_check_time'=>array(
    'get'=>function () { global $glob; return $glob['term_list_check_time']; },
    'set'=>function ($val) { global $glob; return set_float($glob['term_list_check_time'], $val, 0.0, 86400.0); },
  ),

  'log_event_count'=>array(
    'get'=>function () { global $glob; return $glob['log_event_count']; },
    'set'=>function ($val) { global $glob; return set_int($glob['log_event_count'], $val, 0, 50000); },
  ),

  'log_dev_event_count'=>array(
    'get'=>function () { global $glob; return $glob['log_dev_event_count']; },
    'set'=>function ($val) { global $glob; return set_int($glob['log_dev_event_count'], $val, 0, 50000); },
  ),

  'cam_service_active'=>array(
    'get'=>function () { global $glob; return $glob['cam_service_active']; },
    'set'=>function ($val) { global $glob; $glob['cam_service_active']=(bool)$val; return true; },
  ),

);

function hndl_settings($params, $cli_key, $seq_no=0) {
  global $glob, $dmn_main_conn, $settings_path;
  if (!is_array($params) || count($params)==0) {
    $settings=array();
    $skeys=array_keys($settings_path);
    foreach ($skeys as $skey) $settings[$skey]=$settings_path[$skey]['get']();
    return dmn_main_gen_result(200, $settings);
  }
  $cmd=strtolower(trim(array_shift($params)));
  if ($cmd=='get') {
    if (count($params)==0) return dmn_main_gen_result(505, 'No params');
    $skey=strtolower(trim(array_shift($params)));
    if (!array_key_exists($skey, $settings_path)) return dmn_main_gen_result(505, 'Parameter not found');
    return dmn_main_gen_result(200, $settings_path[$skey]['get']());
  } else if ($cmd=='set') {
    if (count($params)<2) return dmn_main_gen_result(505, 'No params');
    $skey=strtolower(trim(array_shift($params)));
    $sval=array_shift($params);
    if (!array_key_exists($skey, $settings_path)) return dmn_main_gen_result(505, 'Parameter not found');
    return dmn_main_gen_result(200, $settings_path[$skey]['set']($sval));
  }
}

function hndl_tlogs($params, $cli_key, $seq_no=0) {
  global $glob, $dmn_main_conn, $term_logs;
  if (!is_array($params) || count($params)==0) {
    return dmn_main_gen_result(200, $term_logs);
  }
  $cmd=strtolower(trim(array_shift($params)));
  if ($cmd=='get') {
    if (count($params)==0) return dmn_main_gen_result(505, 'No params');
    $skey=strtolower(trim(array_shift($params)));
    if (!array_key_exists($skey, $term_logs)) return dmn_main_gen_result(505, 'Parameter not found');
    return dmn_main_gen_result(200, $term_logs[$skey]);
  } else if ($cmd=='count') {
    if (count($params)==0) return dmn_main_gen_result(505, 'No params');
    $skey=strtolower(trim(array_shift($params)));
    if (!array_key_exists($skey, $term_logs)) return dmn_main_gen_result(505, 'Parameter not found');
    return dmn_main_gen_result(200, count($term_logs[$skey]));
  } else if ($cmd=='get_page' || $cmd=='get_page_r') {
    $reversed=($cmd=='get_page_r');
    if (count($params)<1) return dmn_main_gen_result(505, 'Not enough params');
    $skey=strtolower(trim(array_shift($params)));
    if (!array_key_exists($skey, $term_logs) || !is_array($term_logs[$skey])) return dmn_main_gen_result(505, 'Parameter not found');
    $lcount=count($term_logs[$skey]);
    if (count($params)==0) return dmn_main_gen_result(200, $lcount);
    $plen=(int)array_shift($params); if ($plen<1 || $plen>500) $plen=20;
    $pmax=(int)(($lcount-1)/$plen);
    if (count($params)==0) return dmn_main_gen_result(200, $pmax+1);

    if ($lcount==0) return dmn_main_gen_result(200, array());
    $pno=array_shift($params);
    if (is_numeric($pno)) {
      $pno=(int)$pno;
      if ($pno<0) $pno=0;
    } else if (strtolower(trim($pno))=='first') {
      $pno=0;
    } else if (strtolower(trim($pno))=='last') {
      $pno=$pmax;
    } else {
      return dmn_main_gen_result(505, 'Invalid page number (0-'.$pmax.')');
    }
    if ($pno>$pmax) return dmn_main_gen_result(200, array());

    $offset=$pno*$plen;
    $slen=$plen;
    if ($offset+$slen>$lcount) $slen=$lcount-$offset;
    if ($reversed) $offset=$lcount-$offset-$slen;
    $res=array_slice($term_logs[$skey], $offset, $slen);
    if ($reversed) $res=array_reverse($res);

    return dmn_main_gen_result(200, $res);
  }
}

function ecmdh_system($params, $cli_key, $seq_no=0) {
  global $glob, $dmn_main_conn, $term_logs;
  if (!is_array($params) || count($params)==0) return dmn_main_gen_result(200, 'Ok');
  $cmd=strtolower(trim(array_shift($params)));
  if ($cmd=='cmdlist') {
    return dmn_main_gen_result(200, $dmn_main_conn['cmd_array']);
  } else if ($cmd=='check_db') {
    return dmn_main_gen_result(200, req_db_termlist());
  } else if ($cmd=='parse') {
    if (count($params)==0) return dmn_main_gen_result(505, 'No params');
    $term=array_shift($params);
    return dmn_main_gen_result(200, term_parse($term));
  } else if ($cmd=='settings') {
    return hndl_settings($params, $cli_key, $seq_no);
  } else if ($cmd=='stats') {
    return dmn_main_gen_result(200, get_stats());
  } else if ($cmd=='glob') {
    return dmn_main_gen_result(200, $glob);
  } else if ($cmd=='tlogs') {
    return hndl_tlogs($params, $cli_key, $seq_no);
  }
  return dmn_main_gen_result(505, 'Unknown params');
}

function get_termlist_active() {
  global $glob, $dmn_main_conn;
  $rlist=array();
  if (is_array($glob[GLOB_KEY_CONNECTIONS])) foreach ($glob[GLOB_KEY_CONNECTIONS] as $key=>$item) {
    if (!array_key_exists('rc', $item)) {
      $rlist[$key]=$item;
    }
  }
  return $rlist;
}

function get_termlist_inactive() {
  global $glob, $dmn_main_conn;
  $rlist=array();
  if (is_array($glob[GLOB_KEY_CONNECTIONS])) foreach ($glob[GLOB_KEY_CONNECTIONS] as $key=>$item) {
    if (array_key_exists('rc', $item)) {
      $rlist[$key]=$item['rc'];
    }
  }
  if (is_array($glob[GLOB_KEY_RECONNECTIONS])) foreach ($glob[GLOB_KEY_RECONNECTIONS] as $key=>$item) {
      $rlist[$key]=$item;
  }
  return $rlist;
}

function ecmdh_termlist($params, $cli_key, $seq_no=0) {
  global $glob, $dmn_main_conn;
  if (!is_array($params) || count($params)==0) return dmn_main_gen_result(200, get_termlist_active());
  $cmd=strtolower(trim(array_shift($params)));
  if ($cmd=='inactive') {
    return dmn_main_gen_result(200, get_termlist_inactive());
  } else if ($cmd=='proxies') {
    return dmn_main_gen_result(200, $glob[GLOB_KEY_PROXY_SERVERS]);
  } else if ($cmd=='add') {
    if (count($params)==0) return dmn_main_gen_result(505, 'No params');
    $tlist=array_shift($params);
    $was_arr=is_array($tlist);
    if (!$was_arr) $tlist=array($tlist);
    $ret=array();
    foreach (term_parse_list($tlist) as $term) {
      $ckey=$dmn_main_conn['pool']->start_client($term['ip'], $term['port'], $glob['terminal_connect_timeout'], $err_code, $err_str);
      if ($ckey!==false) {
        if ($term['settings']['type']==TTYPE_SPHINX) {
          $dmn_main_conn['pool']->set_socket_handlers($ckey, 'sphinx_on_recv', 'sphinx_on_send', 'sphinx_on_data', 'conn_on_disconnect');
        } else if ($term['settings']['type']==TTYPE_JSP) {
          $dmn_main_conn['pool']->set_socket_handlers($ckey, 'dev_jsp_on_recv', 'dev_jsp_on_send', 'dev_jsp_on_data', 'conn_on_disconnect');
        } else {
          $dmn_main_conn['pool']->set_socket_handlers($ckey, 'conn_on_recv', 'conn_on_send', 'conn_on_data', 'conn_on_disconnect');
        }
        $dmn_main_conn['pool']->set_socket_low_handlers($ckey, 'conn_on_low_recv', 'conn_on_low_send');

//        if (strlen(@$term['settings']['id'])==0) $term['settings']['id']=gen_id();
        $glob[GLOB_KEY_CONNECTIONS][$ckey]=array('key'=>$ckey, 'con_key'=>$term['con_key'], 'ip'=>$term['ip'], 'port'=>$term['port'], 'vars'=>array(), 'settings'=>false, 'start_time'=>get_mtf(), 'last_activity_time'=>get_mtf());
        conn_upd_settings($glob[GLOB_KEY_CONNECTIONS][$ckey], $term);
//        if (is_array(@$term['apkeys'])) $glob[GLOB_KEY_CONNECTIONS][$ckey]['apkeys']=$term['apkeys'];
        $ret[]=$glob[GLOB_KEY_CONNECTIONS][$ckey];
        $proxy_port=(int)@$term['settings']['proxy'];
        if ($proxy_port>0) {
          $pkey=$dmn_main_conn['pool']->start_server($dmn_main_conn['srvaddr'], $proxy_port, $err_code, $err_str);
          if ($pkey!==false) {
            $glob[GLOB_KEY_CONNECTIONS][$ckey]['vars']['proxy_key']=$pkey;
            $glob[GLOB_KEY_PROXY_SERVERS][$pkey]=array('ckey'=>$ckey, 'con_key'=>$term['con_key'], 'port'=>$proxy_port, 'child_key'=>false, 'child_vars'=>array());
          }
        }
        
      }
    }
    if (count($ret)==0) return dmn_main_gen_result(505, 'No valid terms to add');
    if (!$was_arr) return dmn_main_gen_result(200, array_shift($ret));
    return dmn_main_gen_result(200, $ret);
  } else if ($cmd=='del') {
    if (count($params)==0) return dmn_main_gen_result(505, 'No params');
    $tlist=array_shift($params);
    $was_arr=is_array($tlist);
    if (!$was_arr) $tlist=array($tlist);
    $ret=array();
    foreach ($tlist as $tkey) {
      if (strpos($tkey, ':')!==false || strpos($tkey, '.')!==false) $tkey=conn_find_key($tkey);
      if (!$tkey) continue;
      if (array_key_exists($tkey, $glob[GLOB_KEY_RECONNECTIONS])) {
        $ret[]=$glob[GLOB_KEY_RECONNECTIONS][$tkey];
        unset($glob[GLOB_KEY_RECONNECTIONS][$tkey]);
      }  
      if (array_key_exists($tkey, $glob[GLOB_KEY_CONNECTIONS])) {
        $ret[]=$glob[GLOB_KEY_CONNECTIONS][$tkey];
        unset($glob[GLOB_KEY_CONNECTIONS][$tkey]);
        $dmn_main_conn['pool']->drop_connection($tkey);
      }  
    }
    foreach ($ret as $robj) {
      $pkey=@$robj['vars']['proxy_key'];
      if (array_key_exists($pkey, $glob[GLOB_KEY_PROXY_SERVERS])) {
        $child_key=@$glob[GLOB_KEY_PROXY_SERVERS][$pkey]['child_key'];
        if ($child_key) $dmn_main_conn['pool']->drop_connection($child_key);
        $dmn_main_conn['pool']->drop_connection($pkey);
        unset($glob[GLOB_KEY_PROXY_SERVERS][$pkey]);
      }
    }
    if (count($ret)==0) return dmn_main_gen_result(505, 'No valid terms to remove');
    if (!$was_arr) return dmn_main_gen_result(200, array_shift($ret));
    return dmn_main_gen_result(200, $ret);    
  } else if ($cmd=='check') {
    if (count($params)==0) return dmn_main_gen_result(505, 'No params');
    $tlist=array_shift($params);
    $was_arr=is_array($tlist);
    if (!$was_arr) $tlist=array($tlist);
    $ret=array();
    $r=array();
    $a=array();
    $u=array();
    $d=array();
    foreach (term_parse_list($tlist) as $term) {
      $t=conn_upd_($term);
      if (!$t) {
        $a[]=$term;
      } else {
        if (array_key_exists($t, $glob[GLOB_KEY_RECONNECTIONS])) $r[$t]=$glob[GLOB_KEY_RECONNECTIONS][$t];
        if (array_key_exists($t, $glob[GLOB_KEY_CONNECTIONS])) $r[$t]=$glob[GLOB_KEY_CONNECTIONS][$t];
      }
    }
    foreach (array_keys($glob[GLOB_KEY_RECONNECTIONS]) as $tkey) if (!array_key_exists($tkey, $r)) $d[$tkey]=$glob[GLOB_KEY_RECONNECTIONS][$tkey];
    foreach (array_keys($glob[GLOB_KEY_CONNECTIONS]) as $tkey) if (!array_key_exists($tkey, $r)) $d[$tkey]=$glob[GLOB_KEY_CONNECTIONS][$tkey];
    if (count($d)>0) {
      $rd=proto_pack_decode_arr_ex(ecmdh_termlist(array('del', array_keys($d)), false));
      if (is_array($rd) && count($rd)==2 && $rd[0]==200) $ret['del']=$rd[1];      
    }
    if (count($r)>0) $ret['upd']=array_values($r);    
    if (count($a)>0) {
      $ra=proto_pack_decode_arr_ex(ecmdh_termlist(array('add', $a), false));
      if (is_array($ra) && count($ra)==2 && $ra[0]==200) $ret['add']=$ra[1];      
    }
    return dmn_main_gen_result(200, $ret);
  } else if ($cmd=='check_db') {
    return dmn_main_gen_result(200, req_db_termlist());
  }
  return dmn_main_gen_result(505, 'Unknown params');
}

function ecmdh_clist($params, $cli_key, $seq_no=0) {
  global $glob, $dmn_main_conn;
  $list=&garr('gmclist');
  if (!is_array($params) || count($params)==0) return dmn_main_gen_result(200, $list);
  $cmd=strtolower(trim(array_shift($params)));
  if ($cmd=='add') {
    if (count($params)==0) return dmn_main_gen_result(505, 'No params');
    $clist=array_shift($params);
    $was_arr=is_array($clist);
    if (!$was_arr) $clist=array($clist);
    $ret=array();
    foreach ($clist as $c) {
      $c=parse_gmc($c); if (!$c) continue;
      $ret[]=$c;
      $list[$c]=$c;
    }
    if (count($ret)==0) return dmn_main_gen_result(505, 'No valid values to add');
    if (!$was_arr) return dmn_main_gen_result(200, array_shift($ret));
    return dmn_main_gen_result(200, $ret);
  } else if ($cmd=='del') {
    if (count($params)==0) return dmn_main_gen_result(505, 'No params');
    $clist=array_shift($params);
    $was_arr=is_array($clist);
    if (!$was_arr) $clist=array($clist);
    $ret=array();
    foreach ($clist as $c) {
      $c=parse_gmc($c); if (!$c) continue;
      if (array_key_exists($c, $list)) {
        $ret[]=$c;
        unset($list[$c]);
      }
    }
    if (count($ret)==0) return dmn_main_gen_result(505, 'No valid values to remove');
    if (!$was_arr) return dmn_main_gen_result(200, array_shift($ret));
    return dmn_main_gen_result(200, $ret);
  } else if ($cmd=='check') {
    if (count($params)==0) return dmn_main_gen_result(505, 'No params');
    $clist=array_shift($params);
    $was_arr=is_array($clist);
    if (!$was_arr) $clist=array($clist);
    $ret=array();
    $r=array();
    $a=array();
    $d=array();
    foreach ($clist as $c) {
      $c=parse_gmc($c); if (!$c) continue;
      if (!array_key_exists($c, $list)) {
        $a[]=$c;
      } else {
        $r[$c]=true;
      }
    }
    foreach (array_keys($list) as $с) if (!array_key_exists($с, $r)) $d[$с]=true;
    if (count($d)>0) {
      $rd=proto_pack_decode_arr_ex(ecmdh_clist(array('del', array_keys($d)), false));
      if (is_array($rd) && count($rd)==2 && $rd[0]==200) $ret['del']=$rd[1];
    }
    if (count($a)>0) {
      $ra=proto_pack_decode_arr_ex(ecmdh_clist(array('add', $a), false));
      if (is_array($ra) && count($ra)==2 && $ra[0]==200) $ret['add']=$ra[1];
    }
    return dmn_main_gen_result(200, $ret);
  }
  return dmn_main_gen_result(505, 'Unknown params');
}

function ecmdh_halt($params, $cli_key, $seq_no=0) {
   global $dmn_main_conn;
   $dmn_main_conn['need_exit']=true;
   $dmn_main_conn['need_halt']=true;
   return dmn_main_gen_result(200);
}

  
} // end incl_h
?>
