<?php
if (!defined("INC_FM3056_INL_H")){
   define("INC_FM3056_INL_H", TRUE);


define('FM3056_CMD_PREFIX', "\x7E\x01\x30\x30\x30\x30"); // '~<SOH>0000'
define('FM3056_CMD_STYPE_SAVE', "\x40"); // '@'
define('FM3056_CMD_STYPE_WRITE', "\x23"); // '#'

define('FM3056_CMD_SUFFIX', "\x03"); // '<ETX>'

define('FM3056_SYMB_CODE128', 2);
define('FM3056_SYMB_EAN128',  3);
define('FM3056_SYMB_EAN8',  4);
define('FM3056_SYMB_EAN13',  5);
define('FM3056_SYMB_UPCE',  6);
define('FM3056_SYMB_UPCA',  7);
define('FM3056_SYMB_INTER25',  8);
define('FM3056_SYMB_ITF14',  9);
define('FM3056_SYMB_ITF6', 10);
define('FM3056_SYMB_MATRIX25', 11);
define('FM3056_SYMB_CODE39', 13);
define('FM3056_SYMB_CODABAR', 15);
define('FM3056_SYMB_CODE93', 17);
define('FM3056_SYMB_AIM128', 20);
define('FM3056_SYMB_ISSN', 23);
define('FM3056_SYMB_ISBN', 24);
define('FM3056_SYMB_IND25', 25);
define('FM3056_SYMB_STAN25', 26);
define('FM3056_SYMB_PLESSEY', 27);
define('FM3056_SYMB_CODE11', 28);
define('FM3056_SYMB_MSIPLESSEY', 29);
define('FM3056_SYMB_DATABAR', 31);
define('FM3056_SYMB_PDF417', 32);
define('FM3056_SYMB_QRCODE', 33);
define('FM3056_SYMB_DATAMATRIX', 35);
define('FM3056_SYMB_CSC', 39);

$GLOBALS['FM3056_Symbologies']=array(
  FM3056_SYMB_CODE128=>'Code 128',
  FM3056_SYMB_EAN128=>'GS1-128 (UCC/EAN-128)',
  FM3056_SYMB_EAN8=>'EAN-8',
  FM3056_SYMB_EAN13=>'EAN-13',
  FM3056_SYMB_UPCE=>'UPC-E',
  FM3056_SYMB_UPCA=>'UPC-A',
  FM3056_SYMB_INTER25=>'Interleaved 2 of 5, Febraban',
  FM3056_SYMB_ITF14=>'ITF-14',
  FM3056_SYMB_ITF6=>'ITF-6',
  FM3056_SYMB_MATRIX25=>'Matrix 2 of 5',
  FM3056_SYMB_CODE39=>'Code 39, Code 32',
  FM3056_SYMB_CODABAR=>'Codabar',
  FM3056_SYMB_CODE93=>'Code 93',
  FM3056_SYMB_AIM128=>'AIM 128',
  FM3056_SYMB_ISSN=>'ISSN',
  FM3056_SYMB_ISBN=>'ISBN',
  FM3056_SYMB_IND25=>'Industrial 25',
  FM3056_SYMB_STAN25=>'Standard 25',
  FM3056_SYMB_PLESSEY=>'Plessey',
  FM3056_SYMB_CODE11=>'Code11',
  FM3056_SYMB_MSIPLESSEY=>'MSI-Plessey',
  FM3056_SYMB_DATABAR=>'GS1 Databar (RSS)',
  FM3056_SYMB_PDF417=>'PDF417',
  FM3056_SYMB_QRCODE=>'QR Code',
  FM3056_SYMB_DATAMATRIX=>'Data Matrix',
  FM3056_SYMB_CSC=>'Chinese Sensible Code',
);

include("eproto.inc");
//include("fm3056.inl");
include("pocket.inl");

function fm3056_init() {
  return fm3056_pack(FM3056_CMD_STYPE_WRITE, 'PWBENA0;GRBENA1,VOL2;RRDENA1,DUR1500;TSUENA0;APSENA0;PACKAG2;');
}

function fm3056_init_buf($key) {
  global $glob;
  $glob[GLOB_KEY_CONNECTIONS][$key]['vars']['usart_buf']='';
}

function fm3056_symb_name($symb, $not_found_val='Unknown') {
  return eproto_avok($GLOBALS['FM3056_Symbologies'], $symb, $not_found_val);
}

function fm3056_make($data) {
  return FM3056_CMD_PREFIX.$data.FM3056_CMD_SUFFIX;
}

function fm3056_pack_tag($tag, $varr) {
  if (is_string($varr)) return $tag.$varr.';';
  return $tag.@implode(',', $varr).';';
}

function fm3056_pack($stype, $data) {
  if (is_string($data)) return FM3056_CMD_PREFIX.$stype.$data.FM3056_CMD_SUFFIX;
  if (!is_array($data)) return false;
  $ret=array();
  foreach ($data as $key=>$val) {
    if (!is_array($val) && !is_string($val)) return false;
    $ret[]=fm3056_pack_tag($key, $val);
  }
  return FM3056_CMD_PREFIX.$stype.implode('', $ret).FM3056_CMD_SUFFIX;
}

function fm3056_buff_shift($key, $count=0) {
  global $glob;
  if ($count>0) $glob[GLOB_KEY_CONNECTIONS][$key]['vars']['usart_buf']=substr($glob[GLOB_KEY_CONNECTIONS][$key]['vars']['usart_buf'], $count);
  return $glob[GLOB_KEY_CONNECTIONS][$key]['vars']['usart_buf'];
}

function fm3056_parse_stream($key) {
  $buf=fm3056_buff_shift($key);
  $pos=strpos($buf, "\x02");
  if ($pos===false) return false;
  $buf=fm3056_buff_shift($key, $pos);
  $len=strlen($buf);
  if ($len<6) return false;
  $offset=1;
  $sch=numcoder_decode($buf, $offset, 1);
  if ($sch==0x01) {
    if (substr($buf, $offset, 4)!="\x30\x30\x30\x30") {
      fm3056_buff_shift($key, $offset);
      return true;
    }
    $offset+=4;
    $pos=strpos($buf, "\x03", $offset);
    if ($pos===false) return false;
    $pos++;
    $data=substr($buf, $offset, $pos-$offset);
    fm3056_buff_shift($key, $pos);
    return array('type'=>$sch, 'data'=>$data);
//    return chr($sch).$data;
  } else if ($sch==0x00) {
    $dlen=numcoder_decode($buf, $offset, 2);
    $atch=numcoder_decode($buf, $offset, 1);
    if ($atch!==0x3B && $atch!==0x36) {
      fm3056_buff_shift($key, 2);
      return true;
    }
    $symb=0;
    if ($atch==0x3B) $symb=numcoder_decode($buf, $offset, 1);
    if ($len-$offset<$dlen) return false;
    $data='';
    if ($dlen>1) $data=substr($buf, $offset, $dlen-1);
    $offset+=$dlen;
    if ($dlen>0) {
      $offset--;
      $lrc=numcoder_decode($buf, $offset, 1);
    }
    fm3056_buff_shift($key, $offset);
    return array('type'=>$sch, 'symb'=>$symb, 'symb_name'=>fm3056_symb_name($symb), 'data'=>$data);
//    return chr($sch).chr($symb).$data;
  }
  fm3056_buff_shift($key, 1);
  return true;
}

function fm3056_pkpfill(&$dst, $src, $key) {
  if (is_array($src) && array_key_exists($key, $src)) {
    $dst[$key]=$src[$key];
  }
}

function fm3056_process_stream(&$pool, $key, $pk) {
  global $glob;
  $glob[GLOB_KEY_CONNECTIONS][$key]['vars']['usart_buf'].=$pk['payload'];
  $need_loop=true;
  while ($need_loop!==false) {
    $need_loop=fm3056_parse_stream($key);
    if (is_string($need_loop)) {
      plogs("fm3056 received [".$key."]:[".$need_loop."]\n");
    } else if (is_array($need_loop)) {
      plogs("fm3056 received [".$key."]:[".var_d($need_loop, true)."]\n");
      if ($need_loop['type']===0) {
        fm3056_pkpfill($need_loop, @$pk['data'], 'reader_type');
        fm3056_pkpfill($need_loop, @$pk['data'], 'reader_type_name');
        plogs("fm3056 received #1 [".$key."]:[".var_d($need_loop, true)."]\n");
        fm3056_process_code($pool, $key, $need_loop);
      }
    }
  }
//  plogs("fm3056 buf [".$key."]:[".$glob[GLOB_KEY_CONNECTIONS][$key]['vars']['usart_buf']."]\n");
}

function fm3056_process_code(&$pool, $key, $aparams) {
  if (!is_array($aparams)) return true;

  if (!($conn=&conn_get_settings($key, @$aparams['reader_type_name'], true))) return true;

  if (session_is_alive(@$conn['reader_locked'])) {
    $pk=eproto_packet(eproto_cmd_Interactive);
    $pk['flags']=(int)@$aparams['reader_type'];
    $text=from_utf8("Ожидайте...");
    $pk['payload']=pocket_interactive($text, 0, 0, true);
//    $pk['payload']=pocket_interactive_text($text);
    $pool->send($key, $pk);
    return true;
  }

  $gpkey=cgate_get_op_conn($conn);
  if (!($sobj=&dev_session_auto_renew($pool, @$aparams['data'], $key, @$aparams['reader_type_name']))) return true;

  $os='Terminal used: ['.$key."]\n";
  $os.='Terminal id: '.@$conn['id']."\n";
  $os.='Terminal address: ['.@$conn['ip'].':'.@$conn['port']."]\n";
  $os.="Terminal type: POCKET\n";
//  $os.='DATA: '.@$aparams['data']."\n";
  foreach ($aparams as $k=>$v) $os.=$k.': '.var_d($v, true)."\n";
  plogs($os);

  
//  session_set_kpo_result($sobj, NULL);
  session_set_barcode_data($sobj, $aparams);

  session_check_done($sobj['id']);
  return true;    
}

} // end incl_h
?>