<?php
if (!defined("INC_GAT_INL_H")){
  define("INC_GAT_INL_H", TRUE);

function gat_on_packet(&$pool, $key, $raw_data, $seq_no, $pk) {
   global $glob;

   if ($data['cmd']==GAT_CMD_REQ_MASTER) {
     $pk=gat_packet($data['adr'], gat_resp($data['cmd']), 0xAC);
     $loffset=strlen($data['data']);
     if ($loffset>0) {
       $offset=0;
       $ttype=numcoder_decode($data['data'], $offset, 1, $loffset);
       if (!array_key_exists('ttype', $glob[GLOB_KEY_CONNECTIONS][$key]) || @$glob[GLOB_KEY_CONNECTIONS][$key]['ttype']!=$ttype) {
         $glob[GLOB_KEY_CONNECTIONS][$key]['ttype']=$ttype;
         $glob[GLOB_KEY_CONNECTIONS][$key]['ttype_name']=gat_avok($GLOBALS['GAT_Terminals'], $ttype, 'Unknown');
       }
     }
     if ($glob['cntrl']) {
       $pk['te_status']=0x00;
     } else $glob['cntrl']=true;
//     $pk=gat_packet($data['adr'], 0xF5, 0);
     $pool->send($key, $pk);
     unset($pk);
//     print('.');
   } else if ($data['cmd']==GAT_CMD_ACTION_STARTED) {
     $pk=gat_packet($data['adr'], gat_resp($data['cmd']), 0);
     $pool->send($key, $pk);
     unset($pk);

     $loffset=strlen($data['data']);
     if ($loffset>12) {
       $aparams=array();
       $offset=0;
       $ttype=numcoder_decode($data['data'], $offset, 1, $loffset);
       $rtype=numcoder_decode($data['data'], $offset, 1, $loffset);
       $dvalid=numcoder_decode($data['data'], $offset, 1, $loffset);
       $uid=numcoder_decode_buf($data['data'], $offset, 10, $loffset);
       if ($ttype==GAT_TTYPE_ACCESS) {
         $offset=$loffset-1;
         $aparams['ares']=numcoder_decode_r($data['data'], $offset, 1, $loffset);
       } else if ($ttype==GAT_TTYPE_TIME) {
         $offset=$loffset-10;
         $aparams['vend']=numcoder_decode_r($data['data'], $offset, 4, $loffset);
         $aparams['price']=numcoder_decode_r($data['data'], $offset, 4, $loffset);
         $aparams['time']=numcoder_decode_r($data['data'], $offset, 2, $loffset);
       }

       $l=strlen($uid);
       $p=-1; while ($p<$l && ord($uid{++$p})==0);
       $uid=substr($uid, $p, $l-$p);

       $id=$glob[GLOB_KEY_CONNECTIONS][$key]['settings']['id'];
       $ip=$glob[GLOB_KEY_CONNECTIONS][$key]['ip'];
       $port=$glob[GLOB_KEY_CONNECTIONS][$key]['port'];
       if (@$glob['def_uid']) $uid=hexutil_hex2buf($glob['def_uid']) || '';
       if (@$glob['def_id']) $id=$glob['def_id'];
       if (@$glob['def_ip']) $ip=$glob['def_ip'];
       if (@$glob['def_port']) $port=$glob['def_port'];
       $uid_hex=uid2hex($uid);
       $m=garr('gmclist', $uid_hex, ''); if (strlen($m)>0) return true;
       $os='Terminal used: ['.$key."]\n";
       $os.='Terminal id: '.$id."\n";
       $os.='Terminal address: ['.$ip.':'.$port."]\n";
       $os.='Terminal type: '.gat_avok($GLOBALS['GAT_Terminals'], $ttype, 'Unknown')."\n";
       $os.='Reader type: '.gat_avok($GLOBALS['GAT_Readers'], $rtype, 'Unknown')."\n";
       $os.='UID: '.$uid_hex."\n";
       foreach ($aparams as $k=>$v) {
         $os.=$k.': '.$v."\n";
       }
       plogs($os);

//       $lp=&tlogs_add($glob[GLOB_KEY_CONNECTIONS][$key]['con_key'], array('tkey'=>$glob[GLOB_KEY_CONNECTIONS][$key]['con_key'], 'type'=>'ACTION_STARTED', 'time'=>get_mtf(), 'uid'=>$uid_hex, 'params'=>$aparams));
       if (array_key_exists('lp', $glob[GLOB_KEY_CONNECTIONS][$key]) && is_array($glob[GLOB_KEY_CONNECTIONS][$key]['lp'])) {// && @$lp[0]['uid']==$uid_hex) {
         $glob[GLOB_KEY_CONNECTIONS][$key]['lp']['action']=array('time'=>get_mtf(), 'params'=>$aparams);
       } else {
         $glob[GLOB_KEY_CONNECTIONS][$key]['lp']=&tlogs_add($glob[GLOB_KEY_CONNECTIONS][$key]['con_key'], array('tkey'=>$glob[GLOB_KEY_CONNECTIONS][$key]['con_key'], 'type'=>'ACTION_STARTED', 'time'=>get_mtf(), 'uid'=>$uid_hex, 'params'=>$aparams));
       }


       $m=garr('mclist', $uid_hex, ''); if (strlen($m)>0) return true;
       if ($glob[GLOB_KEY_CONNECTIONS][$key]['settings']['reg_query']) return true;
       if ($ttype==GAT_TTYPE_ACCESS && $aparams['ares']!=GAT_ARES_USED) return true;


       $sql_text="exec [dbo].[ZD_ZONE_ACCESS] '".$uid_hex."', '".$id."', 1";
       if ($ttype==GAT_TTYPE_TIME) $sql_text="exec [dbo].[ZD_SOLAR_SALE] '".$uid_hex."', '".$id."', '".(int)@$aparams['time']."', 1";

       $skey=session_key($uid, $key);

       if ($glob['http_service_active']) {
         if ($ttype==GAT_TTYPE_TIME) {
           if (!httpr_new($pool, $key, REQ_TAG_REG, hcfg_http(), $glob['http_service_solar_path'].'/'.$id.'/'.$uid_hex.'/'.(int)@$aparams['time'].'/1', $skey)) {
             plogs("solar request fail. link down.\n");
           }
         } else {
           if (!httpr_new($pool, $key, REQ_TAG_REG, hcfg_http(), $glob['http_service_ident_path'].'/'.$id.'/'.$uid_hex.'/1/0/0/0/0', $skey)) {
             plogs("reg request fail. link down.\n");
           }
         }
       }
     }
   } else if ($data['cmd']==GAT_CMD_HOST_CONTROL) {
     $offset=1;
     $cdata=numcoder_decode($data['data'], $offset, 2);
     $cdata=gat_encode_hca($cdata);
     $pk=gat_packet($data['adr'], gat_resp($data['cmd']), 0, numcoder_encode($cdata, 2));
     $pool->send($key, $pk);
     unset($pk);
//     print(':');
   } else if ($data['cmd']==GAT_CMD_CARD_IDENT) {
//     print("\n");
     $loffset=strlen($data['data']);
     if ($loffset>12) {
       $aparams=array();
       $offset=0;
       $ttype=numcoder_decode($data['data'], $offset, 1, $loffset);
       $rtype=numcoder_decode($data['data'], $offset, 1, $loffset);
       $dvalid=numcoder_decode($data['data'], $offset, 1, $loffset);
       $uid=numcoder_decode_buf($data['data'], $offset, 10, $loffset);
       $offset=$loffset-4;
       if ($ttype==GAT_TTYPE_TIME) {
         $offset=$loffset-10;
         $aparams['time']=numcoder_decode_r($data['data'], $offset, 2, $loffset);
         $aparams['price']=numcoder_decode_r($data['data'], $offset, 4, $loffset);
       }
       $aparams['vend']=numcoder_decode_r($data['data'], $offset, 4, $loffset);

       $l=strlen($uid);
       $p=-1; while ($p<$l && ord($uid{++$p})==0);
       $uid=substr($uid, $p, $l-$p);

       $id=$glob[GLOB_KEY_CONNECTIONS][$key]['settings']['id'];
       $ip=$glob[GLOB_KEY_CONNECTIONS][$key]['ip'];
       $port=$glob[GLOB_KEY_CONNECTIONS][$key]['port'];
       if (@$glob['def_uid']) $uid=hexutil_hex2buf($glob['def_uid']) || '';
       if (@$glob['def_id']) $id=$glob['def_id'];
       if (@$glob['def_ip']) $ip=$glob['def_ip'];
       if (@$glob['def_port']) $port=$glob['def_port'];
       $uid_hex=uid2hex($uid);

       $os='Request from: ['.$key."]\n";
       $os.='Terminal id: '.$id."\n";
       $os.='Terminal address: ['.$ip.':'.$port."]\n";
       $os.='Terminal type: '.gat_avok($GLOBALS['GAT_Terminals'], $ttype, 'Unknown')."\n";
       $os.='Reader type: '.gat_avok($GLOBALS['GAT_Readers'], $rtype, 'Unknown')."\n";
       $os.='UID: '.$uid_hex."\n";
       foreach ($aparams as $k=>$v) {
         $os.=$k.': '.$v."\n";
       }
       plogs($os);

       $glob[GLOB_KEY_CONNECTIONS][$key]['lp']=&tlogs_add($glob[GLOB_KEY_CONNECTIONS][$key]['con_key'], array('tkey'=>$glob[GLOB_KEY_CONNECTIONS][$key]['con_key'], 'type'=>'CARD_IDENT', 'time'=>get_mtf(), 'uid'=>$uid_hex, 'params'=>$aparams));

       $rq=($glob[GLOB_KEY_CONNECTIONS][$key]['settings']['reg_query'])?1:0;

       $sql_text="exec [dbo].[ZD_ZONE_ACCESS] '".$uid_hex."', '".$id."', ".$rq;
       if ($ttype==GAT_TTYPE_TIME) {
         $sql_text="exec [dbo].[ZD_SOLAR_SALE] '".$uid_hex."', '".$id."', '".(int)@$aparams['time']."', ".$rq;
       }

       $skey=session_create($uid_hex, $key);
       $glob[GLOB_KEY_SESSIONS][$skey]['gat_cmd']=$data['cmd'];
       $glob[GLOB_KEY_SESSIONS][$skey]['gat_adr']=$data['adr'];


       if ($glob['http_service_active']) {
         if ($ttype==GAT_TTYPE_TIME) {
           if (!httpr_new($pool, $key, REQ_TAG_QRY, hcfg_http(), $glob['http_service_solar_path'].'/'.$id.'/'.$uid_hex.'/'.(int)@$aparams['time'].'/'.$rq, $skey)) {
             plogs("qry request fail. link down.\n");
           }
           return true;
         } else {
           if (!httpr_new($pool, $key, REQ_TAG_QRY, hcfg_http(), $glob['http_service_ident_path'].'/'.$id.'/'.$uid_hex.'/'.$rq.'/0/0/0/0', $skey)) {
             plogs("qry request fail. link down.\n");
           }
         }
       }
     }

   }
   return true;
}

  
  
} // end incl_h
?>
