<?php
if (!defined("INC_HELIOS_INL_H")){
   define("INC_HELIOS_INL_H", TRUE);

  include("hexutil.inc");
  include("util.inl");
  include("websocket.inc");
  include("handler.inl");

  define('GLOB_KEY_HELIOS_REQUESTS', 'helios_requests');
  $glob[GLOB_KEY_HELIOS_REQUESTS]=array();
  define('HELIOS_DEF_CONNECT_TIMEOUT', 5.0);
  define('HELIOS_DEF_EXPIRE_TIME', 7.0);
       

if (!function_exists('helios_parse_headers')) { function helios_parse_headers($str, &$orig=false) {
  $a=explode("\r\n", $str);
  if (!is_array($a) || count($a)==0) return false;
  $orig=array();
  foreach ($a as $s) {
    $ha=explode(':', $s, 2);
    if (is_array($ha) && count($ha)==2) $orig[$ha[0]]=trim($ha[1]);
  }
  if (count($orig)==0) return false;
  $ret=array_change_key_case($orig, CASE_LOWER);
  return $ret;
}}

function helios_get_http_header($hdarr, $key, $defval=false) {
  $ret=$defval;
  $key=strtolower($key);
  if (array_key_exists($key, $hdarr)) $ret=$hdarr[$key];
  return $ret;
}

function helios_new(&$pool, $key, $tag, $cfg, $path, $params=NULL) {
  global $glob;
  $rkey=$pool->start_client($cfg['ip'], $cfg['port'], $cfg['connect_timeout'], $err_code, $err_str);
  if ($rkey===false) return false;
  $pool->set_socket_handlers($rkey, 'helios_on_hd_recv', 'helios_on_hd_send', 'helios_on_data', 'helios_on_disconnect', 'helios_on_connect');
//  $path='/api/cameras/'.@$path['cam_pid'].'/verify?person_id='.@$path['person_id'].'&subscribe=detect&max_mps=10&detect_face=none&correlation_face=none';
//  $path='/api/cameras/'.@$path['cam_pid'].'/verify?person_id='.@$path['person_id'].'&subscribe=correlation&max_mps=10&detect_face=none&correlation_face=none';
  $path='/api/cameras/'.@$path['cam_pid'].'/verify?person_id='.@$path['person_id'].'&subscribe=&max_mps=10&detect_face=none&correlation_face=none';
  $url=$path;
  $sec_data=array();
  $sec_data['key']=websocket_gen_sec_key();
  $sec_data['accept']=websocket_gen_accept($sec_data['key']);

  $rarr=array();
  $rarr[]='GET '.$url.' HTTP/1.1';
  $rarr[]='Host: '.((@$cfg['host'])?$cfg['host']:$cfg['ip']);
  $rarr[]='Connection: Upgrade';
  $rarr[]='Upgrade: websocket';
  $rarr[]='Origin: pkdaemon';
  $rarr[]='Sec-WebSocket-Key: '.$sec_data['key'];
  $rarr[]='Sec-WebSocket-Protocol: verification';
  $rarr[]='Sec-WebSocket-Version: 13';
  
  if (is_array(@$cfg['extra_headers'])) foreach ($cfg['extra_headers'] as $hd) if (is_string($hd)) $rarr[]=$hd;

  $rarr[]='';
  $rarr[]='';


  $glob[GLOB_KEY_HELIOS_REQUESTS][$rkey]=array();
  $glob[GLOB_KEY_HELIOS_REQUESTS][$rkey]['tag']=$tag;
  $glob[GLOB_KEY_HELIOS_REQUESTS][$rkey]['processed']=false;
  $glob[GLOB_KEY_HELIOS_REQUESTS][$rkey]['completed']=false;
  $glob[GLOB_KEY_HELIOS_REQUESTS][$rkey]['time']=get_mtf();
  $glob[GLOB_KEY_HELIOS_REQUESTS][$rkey]['rkey']=$rkey;
  $glob[GLOB_KEY_HELIOS_REQUESTS][$rkey]['linked_key']=$key;
  $glob[GLOB_KEY_HELIOS_REQUESTS][$rkey]['path']=$path;
  $glob[GLOB_KEY_HELIOS_REQUESTS][$rkey]['cfg']=$cfg;
  $glob[GLOB_KEY_HELIOS_REQUESTS][$rkey]['sec_data']=$sec_data;
  $glob[GLOB_KEY_HELIOS_REQUESTS][$rkey]['close_sent']=false;
  $glob[GLOB_KEY_HELIOS_REQUESTS][$rkey]['close_received']=false;

  if ($params!==NULL) $glob[GLOB_KEY_HELIOS_REQUESTS][$rkey]['params']=$params;
  $glob[GLOB_KEY_HELIOS_REQUESTS][$rkey]['buffer']='';

  $sdata=implode("\r\n", $rarr);
//  logp($glob['cam_service_log_file'], "request sec [".$sec_data['key'].''.$sec_data['accept']."]\n\n");
  $pool->send($rkey, $sdata);

  return $rkey;
}


function helios_on_connect(&$pool, $key) {
  global $glob;
  $addr=$pool->list[$key]['addr'];
  $port=$pool->list[$key]['port'];
  plogs("helios connected [".$key."]: [".$addr.":".$port."]\n");
}

function helios_on_disconnect(&$pool, $key, $err_code=0) {
  $es='';
  if ($err_code!==0) {
    if (is_integer($err_code)) {
      $es.=$err_code.':'.cp866(trim(socket_strerror($err_code)));
    } else {
      $es.=$err_code;
    }
  }
  plogs('helios disconnected ['.$key.'] ['.$es."]\n");

  helios_fin($key, $es);
}

function helios_on_hd_recv(&$pool, $key, $buffer, &$readed=0, &$wait_len=0, &$seq_no=0) {
  global $glob;

  if (!array_key_exists($key, $glob[GLOB_KEY_HELIOS_REQUESTS]) || !is_array($glob[GLOB_KEY_HELIOS_REQUESTS][$key])) return false;
  $request=&$glob[GLOB_KEY_HELIOS_REQUESTS][$key];

  $request['buffer']=$buffer;
//    $readed=strlen($buffer);
  $a=explode("\r\n\r\n", $request['buffer'], 2);
  if (!is_array($a) || count($a)!=2) { $wait_len=1; return false; }
  
  $b=explode("\r\n", $a[0], 2);
  if (!is_array($b) || count($b)!=2) return false;
  $status=explode(' ', $b[0], 3);
  if (!is_array($status) || count($status)!=3) return false;
  $status_code=(int)$status[1];
  $status_code_f=floor($status_code/100);
//    if ($status_code_f!=2) return false;
  if ($status_code_f==0) return false;
  $hdarr=helios_parse_headers($b[1], $ohdarr);
  if (!is_array($hdarr) || count($hdarr)<1) return false;
  
  
  $readed=strlen($a[0])+4;
  $dbrt=get_mtf()-$request['r_time'];
  logp($glob['cam_service_log_file'],
        "received headers [".$key.':'.$seq_no.']('.(float)sprintf('%.6f', $dbrt).'):'.NL.
        $pool->dump_packet($a[0]).
        NL.NL."Data:".NL.
        var_d(array($status, $ohdarr), true).NL,
        true);

  $request['buffer']='';
  if ($status_code==101
      && helios_get_http_header($hdarr, 'Connection')=='Upgrade'
      && helios_get_http_header($hdarr, 'Upgrade')=='websocket'
      && helios_get_http_header($hdarr, 'Sec-WebSocket-Accept')==$request['sec_data']['accept']) {
    logp($glob['cam_service_log_file'],"helios websocket accepted\n\n");
  } else {
    plogs("wrong websocket accept. halting.\n");
    $pool->drop_connection($key, 'wrong websocket accept');
    return false;
  }

  $pool->set_socket_handlers($key, 'helios_on_recv', 'helios_on_send', 'helios_on_data', 'helios_on_disconnect', 'helios_on_connect');
  
//  return helios_on_recv(&$pool, $key, $buffer, $readed, $wait_len, $seq_no);
  return true;
}

function helios_on_hd_send(&$pool, $key, $data, $seq_no) {
  global $glob;

  if (!array_key_exists($key, $glob[GLOB_KEY_HELIOS_REQUESTS]) || !is_array($glob[GLOB_KEY_HELIOS_REQUESTS][$key])) return false;
  $request=&$glob[GLOB_KEY_HELIOS_REQUESTS][$key];
  
  $b=explode("\r\n", $data, 2);
  if (!is_array($b) || count($b)!=2) return $data;
  $hdarr=helios_parse_headers($b[1], $ohdarr);
  $status=explode(' ', $b[0], 3);
  $status[3]=@$status[1];
  $status[1]=parse_url(@$status[1]);
  $host_name=helios_get_http_header($hdarr, 'Host', $request['cfg']['host']);
  if ($request['cfg']['port']!=80) $host_name.=':'.$request['cfg']['port'];
  $status[4]='http://'.$host_name.@$status[3];
  if (@$status[1]['query']) parse_str($status[1]['query'], $status[1]['query']);
  $request['r_time']=get_mtf();
  logp($glob['cam_service_log_file'],
       "sended [".$key.':'.$seq_no."]:".NL.
       $pool->dump_packet($data).
       NL.NL."Data:".NL.
       var_d(array('request'=>$status, 'headers'=>$ohdarr), true).NL,
       true);
  return $data;
}

function helios_on_recv(&$pool, $key, $buffer, &$readed=0, &$wait_len=0, &$seq_no=0) {
  global $glob;
  if (!array_key_exists($key, $glob[GLOB_KEY_HELIOS_REQUESTS]) || !is_array($glob[GLOB_KEY_HELIOS_REQUESTS][$key])) return false;
  $request=&$glob[GLOB_KEY_HELIOS_REQUESTS][$key];

  $request['buffer']=$buffer;
  $readed=strlen($buffer);

  $offset=0;
  $ret=websocket_packet_decode($buffer, $offset, $pk);
  if (is_int($ret)) {
    if ($ret<0) {
      plogs("packet decode error. halting.\n");
      $pool->drop_connection($key, 'packet decode error. stream broken.');
      return false;
    } else {
      $wait_len=$ret;
      return false;
    }
  }
  
  if (!is_array($ret)) {
    plogs("packet decode error. halting.\n");
    $pool->drop_connection($key, 'packet decode error. stream broken.');
    return $ret;
  }
  $readed=$offset;
  $buf=substr($buffer, 0, $readed);

  logp($glob['cam_service_log_file'],
                   "received [".$key.':'.$seq_no."]:".NL.
                   $pool->dump_packet($buf).
                   NL.NL."Data:".NL.
                   var_d($ret, true).NL,
                   true);
  $request['buffer']='';

  return $pk;
}

function helios_on_send(&$pool, $key, $data, $seq_no) {
  global $glob;

  if (!array_key_exists($key, $glob[GLOB_KEY_HELIOS_REQUESTS]) || !is_array($glob[GLOB_KEY_HELIOS_REQUESTS][$key])) return false;
  $request=&$glob[GLOB_KEY_HELIOS_REQUESTS][$key];
  
  $buf=websocket_packet_encode($data);
  
  logp($glob['cam_service_log_file'],
       "sended [".$key.':'.$seq_no."]:".NL.
       $pool->dump_packet($buf).
       NL.NL."Data:".NL.
       var_d($data, true)."\n",
       true);
   return $buf;
}
  
function helios_on_data(&$pool, $key) {
   global $glob;

   $data=$pool->get_data($key);
   if ($data===false) return false;
   $raw_data=(string)implode('', $data[2]);
   $seq_no=$data[1];
   $data=$data[0];
   if (!array_key_exists($key, $glob[GLOB_KEY_HELIOS_REQUESTS]) || !is_array($glob[GLOB_KEY_HELIOS_REQUESTS][$key])) return false;
   $result=false;
   
   if (!is_array($data)) return false;
   
//   logp($glob['cam_service_log_file'],"helios on data:\n\n".var_d(array($data), true)."\n\n");
   
   if ($data['opcode']==WEBSOCKET_OPCODE_CLOSE) {
     $glob[GLOB_KEY_HELIOS_REQUESTS][$key]['close_received']=get_mtf();
     list($ecode, $reason)=websocket_parse_close_body((string)@$data['payload']);
     if ($glob[GLOB_KEY_HELIOS_REQUESTS][$key]['close_sent']!==false) {
       $glob[GLOB_KEY_HELIOS_REQUESTS][$key]['completed']=true;
       return false;
     }
     
     if($ecode==4002 && strpos($reason, 'Unknown person: ') === 0) {
       handler_exec('helios_event', array(&$glob[GLOB_KEY_HELIOS_REQUESTS][$key], &$pool, $key, $ecode.':'.$reason, 'NF'), $result);
       helios_fin($key);
     }
       
     $glob[GLOB_KEY_HELIOS_REQUESTS][$key]['close_reason']=$ecode.':'.$reason;
     $pool->drop_after_send($key);
     helios_close($pool, $key, $ecode, $reason);
     helios_fin($key, $ecode.':'.$reason);
     return false;
   } else if ($data['opcode']==WEBSOCKET_OPCODE_PING) {
     $pool->send($key, websocket_packet(WEBSOCKET_OPCODE_PONG, true, (string)@$data['payload']));
   } else if ($data['opcode']==WEBSOCKET_OPCODE_PONG) {
//     helios_close($pool, $key, 100, 'autoclose');
   } else if ($data['opcode']==WEBSOCKET_OPCODE_TEXT) {
     $json=@jsondec($data['payload']);
     if (is_array($json)) {
       logp($glob['cam_service_log_file'],"helios json received:\n\n".var_d($json, true)."\n\n");
       if (array_key_exists('verified', $json)) {
         // exec handler
         handler_exec('helios_event', array(&$glob[GLOB_KEY_HELIOS_REQUESTS][$key], &$pool, $key, $json, 'YES'), $result);
//         handler_exec('helios_on_verified', array(&$glob[GLOB_KEY_HELIOS_REQUESTS][$key], &$pool, $key, $json), $result);
         helios_fin($key);
         helios_close($pool, $key, 100, 'autoclose');
       }
       if (array_key_exists('terminated', $json)) {
         helios_close($pool, $key, 100, 'autoclose');
       }
       if (array_key_exists('correlations', $json)) {
         handler_exec('helios_event', array(&$glob[GLOB_KEY_HELIOS_REQUESTS][$key], &$pool, $key, $json, 'COR'), $result);
//         handler_exec('helios_on_correlations', array(&$glob[GLOB_KEY_HELIOS_REQUESTS][$key], &$pool, $key, $json), $result);
       }
     }
   } else {
//     $pool->send($key, websocket_packet(WEBSOCKET_OPCODE_PING, true, 'This is my ping'));
     // exec handler
//     handler_exec('helios_on_data', array($data, $raw_data, &$glob[GLOB_KEY_HELIOS_REQUESTS][$key], &$pool, $key), $result);
     
     
     
     
   }
   
   return $result;
}

function helios_close(&$pool, $key, $ecode=false, $reason=false) {
  global $dmn_main_conn, $glob;
  if (!array_key_exists($key, $glob[GLOB_KEY_HELIOS_REQUESTS])) return false;
  if (@$glob[GLOB_KEY_HELIOS_REQUESTS][$key]['close_sent']===false) {
    $glob[GLOB_KEY_HELIOS_REQUESTS][$key]['close_sent']=get_mtf();
    $pk=websocket_packet(WEBSOCKET_OPCODE_CLOSE, true, websocket_gen_close_body($ecode, $reason));
    $pool->send($key, $pk);
//    $pool->drop_after_send($key);
  }
  return true;
}
  
function helios_fin($key, $drop_reason=false) {
  global $dmn_main_conn, $glob;
  if (!$key) return false;
  if (!array_key_exists($key, $glob[GLOB_KEY_HELIOS_REQUESTS])) return false;
  if (@$glob[GLOB_KEY_HELIOS_REQUESTS][$key]['completed']) return false;
  if ($drop_reason && !$glob[GLOB_KEY_HELIOS_REQUESTS][$key]['processed']) {
    $glob[GLOB_KEY_HELIOS_REQUESTS][$key]['drop_info']=array(
      'time'=>get_mtf(),
      'reason'=>$drop_reason,
    );
  }

/*  
  if (!$glob[GLOB_KEY_HELIOS_REQUESTS][$key]['processed']) {
    handler_exec('helios_event', array(&$glob[GLOB_KEY_HELIOS_REQUESTS][$key], &$dmn_main_conn['pool'], $key, $drop_reason, 'FAIL'), $ec);
    $glob[GLOB_KEY_HELIOS_REQUESTS][$key]['processed']=true;
  }
*/  
  if (!$drop_reason) $glob[GLOB_KEY_HELIOS_REQUESTS][$key]['processed']=true;
  $glob[GLOB_KEY_HELIOS_REQUESTS][$key]['completed']=true;  
  return true;
}

function helios_del(&$pool, $key, $reason=false) {
  global $dmn_main_conn, $glob;
  if (!array_key_exists($key, $glob[GLOB_KEY_HELIOS_REQUESTS]) || !is_array($glob[GLOB_KEY_HELIOS_REQUESTS][$key])) return;

//  plogs("helios_del [".var_d($glob[GLOB_KEY_HELIOS_REQUESTS][$key], true)."]\n");

  if (!$glob[GLOB_KEY_HELIOS_REQUESTS][$key]['processed']) {
    handler_exec('helios_event', array(&$glob[GLOB_KEY_HELIOS_REQUESTS][$key], &$pool, $key, $reason, 'FAIL'), $ec);
    $glob[GLOB_KEY_HELIOS_REQUESTS][$key]['processed']=true;
  }

  handler_exec('helios_event', array(&$glob[GLOB_KEY_HELIOS_REQUESTS][$key], &$pool, $key, $reason, 'DEL'), $ec);
  
  unset($glob[GLOB_KEY_HELIOS_REQUESTS][$key]);
  $pool->drop_connection($key, $ec);
//  plogs("helios request deleted [".$key.", ".$reason."]\n");
}

  

function helios_idle_proc(&$pool, $mtf) {
  global $glob;
  $rkeys=array_keys($glob[GLOB_KEY_HELIOS_REQUESTS]);
  foreach ($rkeys as $rkey) {
    $request=&$glob[GLOB_KEY_HELIOS_REQUESTS][$rkey];
    $ex_time=(float)$request['cfg']['expire_time'];
    if ($ex_time==0.0) continue;
    $mmtf=$mtf-$ex_time;
    if ($request['processed'] || $request['completed']) {
      $reason=@$request['drop_info']['reason'];
      if (!$reason) $reason=($request['processed'])?'processed':'completed';
      helios_del($pool, $rkey, $reason);
    } else if ($request['time']<$mmtf) {
      handler_exec('helios_event', array(&$glob[GLOB_KEY_HELIOS_REQUESTS][$rkey], &$pool, $rkey, 'timeout', 'NO'), $result);
      $request['processed']=true;
      helios_del($pool, $rkey, 'timeout');
    }
  }
}
   

} // end incl_h
?>
