<?php
if (!defined("INC_HTTPR_INL_H")){
  define("INC_HTTPR_INL_H", TRUE);

  define('GLOB_KEY_HTTP_REQUESTS', 'http_requests');
  $glob[GLOB_KEY_HTTP_REQUESTS]=array();
  define('HTTPR_DEF_CONNECT_TIMEOUT', 5.0);
  define('HTTPR_DEF_EXPIRE_TIME', 7.0);

  
if (!function_exists('http_parse_headers')) { function http_parse_headers($str, &$orig=false) {
  $body='';
  $a=explode("\r\n\r\n", $str, 2);
  if (count($a)>0) {
    $str=$a[0];
  } else return false;
  if (count($a)>1) $body=$a[1];
  $a=explode("\r\n", $str);
  if (!is_array($a) || count($a)==0) return false;
  $orig=array();
  foreach ($a as $s) {
    $ha=explode(':', $s, 2);
    if (is_array($ha) && count($ha)==2) $orig[$ha[0]]=trim($ha[1]);
  }
  if (count($orig)==0) return false;
  $ret=array_change_key_case($orig, CASE_LOWER);
  return $ret;
}}

function httpr_parse_headers($str, &$orig=false, &$body=false) {
  $body='';
  $a=explode("\r\n\r\n", $str, 2);
  if (count($a)>0) {
    $str=$a[0];
  } else return false;
  if (count($a)>1) $body=$a[1];
  $a=explode("\r\n", $str);
  if (!is_array($a) || count($a)==0) return false;
  $orig=array();
  foreach ($a as $s) {
    $ha=explode(':', $s, 2);
    if (is_array($ha) && count($ha)==2) $orig[$ha[0]]=trim($ha[1]);
  }
  if (count($orig)==0) return false;
  $ret=array_change_key_case($orig, CASE_LOWER);
  return $ret;
}

function httpr_get_header($hdarr, $key, $defval=false) {
  $ret=$defval;
  $key=strtolower($key);
  if (array_key_exists($key, $hdarr)) $ret=$hdarr[$key];
  return $ret;
}

function httpr_on_connect(&$pool, $key) {
  global $glob;
  $addr=$pool->list[$key]['addr'];
  $port=$pool->list[$key]['port'];
  $request=&$glob[GLOB_KEY_HTTP_REQUESTS][$key];
  if (!agov(@$request['params'], 'no_logs'))
  if (@$request['tag']!=REQ_TAG_CRT) 
  plogs("httpr connected [".$key."]: [".$addr.":".$port."]\n");
}

function httpr_on_disconnect(&$pool, $key, $err_code=0) {
  global $glob;
  $es='httpr disconnected ['.$key.']';
  if ($err_code!==0) {
    if (is_integer($err_code)) {
      $es.=' ['.$err_code.':'.cp866(trim(socket_strerror($err_code))).']';
    } else {
      $es.=' ['.$err_code.']';
    }
  }
  $request=&$glob[GLOB_KEY_HTTP_REQUESTS][$key];
  if (@$request['tag']!=REQ_TAG_CRT || $err_code!==0) {
    if (!agov(@$request['params'], 'no_logs')) {
      logp($glob['log_file'],$request['buffer']);
      plogs($es."\n");
    }
  }

  httpr_fin($key, $es);
}

function httpr_on_recv(&$pool, $key, $buffer, &$readed=0, &$wait_len=0, &$seq_no=0) {
  global $glob;

  if (!array_key_exists($key, $glob[GLOB_KEY_HTTP_REQUESTS]) || !is_array($glob[GLOB_KEY_HTTP_REQUESTS][$key])) return false;
  $request=&$glob[GLOB_KEY_HTTP_REQUESTS][$key];

  $request['buffer']=$buffer;
//    $readed=strlen($buffer);
  $a=explode("\r\n\r\n", $request['buffer'], 2);
  if (!is_array($a) || count($a)!=2) { $wait_len=1; return false; }
  $b=explode("\r\n", $a[0], 2);
  if (!is_array($b) || count($b)!=2) return false;
  $status=explode(' ', $b[0], 3);
  if (!is_array($status) || count($status)!=3) return false;
  $status_code=(int)$status[1];
  $status_code=floor($status_code/100);
//    if ($status_code!=2) return false;
  if ($status_code==0) return false;
  $hdarr=httpr_parse_headers($b[1], $ohdarr);
  if (!is_array($hdarr) || count($hdarr)<1) return false;
  $asize=httpr_get_header($hdarr, 'Content-Length');
  if ($asize===false) return false;
  $asize=(int)$asize;
//    if ($asize<=0) return false;
//    logp($glob['log_file'],"cldbg:\n[\n".var_d($a, true)."\n]\n\n\n[\n".strlen($a[1])."\n]\n\n\n[\n".$asize."\n]\n\n\n");
  if ($asize>strlen($a[1])) {
    $wait_len=$asize-strlen($a[1]);
//      logp($glob['log_file'],"cldbg1:\n[\n".$readed."\n]\n\n\n[\n".$wait_len."\n]\n\n\n");
    return false;//$buffer;
  }
  $readed=strlen($buffer);
  $ret=array($status, $hdarr, $a[1], jsondec($a[1]));

  $log_arr=array('status'=>$status, 'headers'=>$ohdarr);
  if ($ret[3]) {
    $log_arr['body_json']=$ret[3];
  } else $log_arr['body']=$ret[2];
  $dbrt=get_mtf()-$request['r_time'];
//  if (@$request['tag']!=REQ_TAG_CRT || @$request['params']['crt-stage']==2)
  if (!agov(@$request['params'], 'no_logs')) 
  logp($glob['log_file'],
        "received [".$key.':'.$seq_no.']('.(float)sprintf('%.6f', $dbrt).'):'.NL.
        $pool->dump_packet($request['buffer']).
        NL.NL."Data:".NL.
        var_d($log_arr, true).NL,
        true);
  $request['buffer']='';
  return $ret;
}

function httpr_on_send(&$pool, $key, $data, $seq_no) {
  global $glob;

  if (!array_key_exists($key, $glob[GLOB_KEY_HTTP_REQUESTS]) || !is_array($glob[GLOB_KEY_HTTP_REQUESTS][$key])) return false;
  $request=&$glob[GLOB_KEY_HTTP_REQUESTS][$key];
  
  $b=explode("\r\n", $data, 2);
  if (!is_array($b) || count($b)!=2) return $data;
  $hdarr=httpr_parse_headers($b[1], $ohdarr, $body);
  $status=explode(' ', $b[0], 3);
  $status[3]=@$status[1];
  $status[1]=parse_url(@$status[1]);
  $host_name=httpr_get_header($hdarr, 'Host', $request['cfg']['host']);
  if ($request['cfg']['port']!=80) $host_name.=':'.$request['cfg']['port'];
  $status[4]='http://'.$host_name.@$status[3];
  if (@$status[1]['query']) parse_str($status[1]['query'], $status[1]['query']);
  $request['r_time']=get_mtf();
//  if (@$request['tag']!=REQ_TAG_CRT || @$request['params']['crt-stage']==2)
  if (!(agov(@$request['params'], 'no_logs')))
  logp($glob['log_file'],
       "sended [".$key.':'.$seq_no."]:".NL.
       $pool->dump_packet($data).
       NL.NL."Data:".NL.
       var_d(array('request'=>$status, 'headers'=>$ohdarr, 'body'=>$body), true).NL,
       true);
  return $data;
}
  
function httpr_on_data(&$pool, $key) {
   global $glob;

   $data=$pool->get_data($key);
   if ($data===false) return false;
   $raw_data=(string)implode('', $data[2]);
   $seq_no=$data[1];
   $data=$data[0];
   if (!array_key_exists($key, $glob[GLOB_KEY_HTTP_REQUESTS]) || !is_array($glob[GLOB_KEY_HTTP_REQUESTS][$key])) return false;
   $result=false;
   // exec handler
   handler_exec('httpr_on_data', array($data, $raw_data, &$glob[GLOB_KEY_HTTP_REQUESTS][$key], &$pool, $key), $result);
   return $result;
}
  
function httpr_fin_rt($key, $is_drop=false) {
  httpr_fin($key, $is_drop);
  return true;
}

function httpr_fin($key, $is_drop=false) {
  global $dmn_main_conn, $glob;
  if (!$key) return false;
  if (!array_key_exists($key, $glob[GLOB_KEY_HTTP_REQUESTS])) return false;
  if ($is_drop && !$glob[GLOB_KEY_HTTP_REQUESTS][$key]['processed']) {
    $glob[GLOB_KEY_HTTP_REQUESTS][$key]['drop_info']=array(
      'time'=>get_mtf(),
      'reason'=>$is_drop,
    );
  }
  if (!$is_drop) $glob[GLOB_KEY_HTTP_REQUESTS][$key]['processed']=true;
  $glob[GLOB_KEY_HTTP_REQUESTS][$key]['completed']=true;
  return true;
}

function httpr_del(&$pool, $key) {
  global $dmn_main_conn, $glob;
  if (!array_key_exists($key, $glob[GLOB_KEY_HTTP_REQUESTS]) || !is_array($glob[GLOB_KEY_HTTP_REQUESTS][$key])) return;
  // exec handler
  handler_exec('httpr_del', array(&$glob[GLOB_KEY_HTTP_REQUESTS][$key], &$pool, $key), $ec);
  
  $pool->drop_connection($key, $ec);
  unset($glob[GLOB_KEY_HTTP_REQUESTS][$key]);
//    plogs("request deleted [".$key."]\n");
}


function httpr_new(&$pool, $key, $tag, $cfg, $path, $params=NULL) {
  global $glob;
  $rkey=$pool->start_client($cfg['ip'], $cfg['port'], $cfg['connect_timeout'], $err_code, $err_str);
  if ($rkey===false) return false;
  $pool->set_socket_handlers($rkey, 'httpr_on_recv', 'httpr_on_send', 'httpr_on_data', 'httpr_on_disconnect', 'httpr_on_connect');
  $url=$path;
  $body='';
  if (@$cfg['post_body']) $body=(string)@$cfg['post_body'];
  
  $rarr=array();
  $rarr[]=((@$cfg['post_params'] || @$cfg['post_body'])?'POST':'GET').' '.$url.' HTTP/1.1';
  $rarr[]='Host: '.((@$cfg['host'])?$cfg['host']:$cfg['ip']);
  $rarr[]='Connection: close';
  $rarr[]='Cache-Control: no-cache,max-age=0';
  if (is_array(@$cfg['extra_headers'])) foreach ($cfg['extra_headers'] as $hd) if (is_string($hd)) $rarr[]=$hd;

//  $rarr[]='Accept: text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,*/*;q=0.8';
  $rarr[]='User-Agent: Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.99 Safari/537.36';
//  $rarr[]='Accept-Encoding: gzip, deflate, sdch';
  $rarr[]='Accept-Encoding: identity';
  $rarr[]='Accept-Language: ru-RU,ru;q=0.8,en-US;q=0.6,en;q=0.4';

  $rarr[]='';
  $rarr[]=$body;
  

  $glob[GLOB_KEY_HTTP_REQUESTS][$rkey]=array();
  $glob[GLOB_KEY_HTTP_REQUESTS][$rkey]['tag']=$tag;
  $glob[GLOB_KEY_HTTP_REQUESTS][$rkey]['processed']=false;
  $glob[GLOB_KEY_HTTP_REQUESTS][$rkey]['completed']=false;
  $glob[GLOB_KEY_HTTP_REQUESTS][$rkey]['time']=get_mtf();
  $glob[GLOB_KEY_HTTP_REQUESTS][$rkey]['rkey']=$rkey;
  $glob[GLOB_KEY_HTTP_REQUESTS][$rkey]['linked_key']=$key;
  $glob[GLOB_KEY_HTTP_REQUESTS][$rkey]['path']=$path;
  $glob[GLOB_KEY_HTTP_REQUESTS][$rkey]['cfg']=$cfg;

  if ($params!==NULL) $glob[GLOB_KEY_HTTP_REQUESTS][$rkey]['params']=$params;
  $glob[GLOB_KEY_HTTP_REQUESTS][$rkey]['buffer']='';

  $sdata=implode("\r\n", $rarr);
//    logp($glob['log_file'], "request\r\n\r\n".$sdata);
  $pool->send($rkey, $sdata);

  return $rkey;
}

function httpr_idle_proc(&$pool, $mtf) {
  global $glob;
  foreach (array_keys($glob[GLOB_KEY_HTTP_REQUESTS]) as $rkey) {
    $request=&$glob[GLOB_KEY_HTTP_REQUESTS][$rkey];
    $ex_time=(float)@$request['cfg']['expire_time'];
    if ($ex_time==0.0) $ex_time=15.0;
    $mmtf=$mtf-$ex_time;
    if ($request['processed'] || $request['completed'] || $request['time']<$mmtf) {
      httpr_del($pool, $rkey);
    }
  }
}
  
} // end incl_h
?>
