<?php
if (!defined("INC_JSP_INL_H")){
   define("INC_JSP_INL_H", TRUE);

   include("hexutil.inc");
   include("util.inl");
   include("handler.inl");
   
   
  define('GLOB_JSP_DATA_KEY', '__jsp_data');
  $GLOBALS[GLOB_JSP_DATA_KEY]=array();
  $GLOBALS[GLOB_JSP_DATA_KEY]['sof']="\x03";//'<SOF>';
  $GLOBALS[GLOB_JSP_DATA_KEY]['eof']="\x02";//'<EOF>';
  $GLOBALS[GLOB_JSP_DATA_KEY]['rtimeout']=15.0; // default request timeout, sec.
  $GLOBALS[GLOB_JSP_DATA_KEY]['requests']=array();

  define('JSP_PING_INT_MIN', 0x05);
  define('JSP_PING_INT_MAX', 0x78);
  define('JSP_PING_TMO_MIN', 0x05);
  define('JSP_PING_TMO_MAX', 0x1E);

function jsp_init() {
  global $dmn_main_conn, $glob;
  if (false===($jspd=&jsp_data())) return false;
  $jspd['jsp_server_key']=false;
  $jspd['jsp_subscriber_key']=false;
  $jspd['jsp_debug_key']=false;
  $jspd['jsp_rid']=0;
  $jspd['jsp_emu_sessions']=array();
  $jspd['jsp_connections']=array();
  
  $ulp=(int)@$glob['jsp_listener_port'];
  if ($ulp>0) {
    $ukey=$dmn_main_conn['pool']->start_server($dmn_main_conn['srvaddr'], $ulp, $err_code, $err_str);
    if ($ukey!==false) {
      $jspd['jsp_server_key']=$ukey;
    } else {
      plogs("cannot start jsp server. halting...");
      $dmn_main_conn['need_exit']=true;
      return false;
    }
  }
  return true;
}

function &jsp_data($key=false) {
  $fret=false;
  if (!array_key_exists(GLOB_JSP_DATA_KEY, @$GLOBALS) || !is_array(@$GLOBALS[GLOB_JSP_DATA_KEY])) return $fret;
  if (is_string($key)) {
    if (!array_key_exists($key, @$GLOBALS[GLOB_JSP_DATA_KEY])) $GLOBALS[GLOB_JSP_DATA_KEY][$key]=null;
    return $GLOBALS[GLOB_JSP_DATA_KEY][$key];
  }
  return $GLOBALS[GLOB_JSP_DATA_KEY];
}

function &jsp_vars($key) {
  $fret=false;
  if (false===($jspd=&jsp_data())) return $fret;
  if (!array_key_exists($key, @$jspd['jsp_connections']) || !is_array(@$jspd['jsp_connections'][$key])) return $fret;
  if (!is_string(@$jspd['jsp_connections'][$key]['buf'])) $jspd['jsp_connections'][$key]['buf']='';
  return $jspd['jsp_connections'][$key];
}

function &jsp_requests() {
  $fret=false;
  if (false===($jspd=&jsp_data())) return $fret;
  if (!array_key_exists('requests', $jspd)) return $fret;
  return $jspd['requests'];
}

function &jsp_get_request(&$rlink) {
  global $glob;
  $args=func_get_args();
  $c=count($args);
  $rkey=false;
  $robj=false;
  if (false===($requests=&jsp_requests())) return $robj;

  if ($c>0) {
    if (is_array($rlink)) return $rlink;
    if (!is_string($rlink)) return $robj;
    if (preg_match('/RID[0-9A-Fa-f]{6}/', $rlink)) {
      if (array_key_exists($rlink, $requests) && is_array($requests[$rlink])) return $requests[$rlink];
    } else if (preg_match('/S[0-9A-Fa-f]{8}/', $rlink)) {
      foreach ($requests as &$_robj) {
        if ($_robj['s_id']==$rlink) return $requests[$_robj['id']];
      }
    } else {
      if (array_key_exists($rlink, $requests) && is_array($requests[$rlink])) return $requests[$rlink];
    }
    return $robj;
  }
  return $robj;
}

function &jsp_create_request($cmd=false, $params=false, $cparams=false, $rparams=false) {
  $fret=false;
  if (false===($requests=&jsp_requests())) return $fret;
  $rid=jsp_rid();
  $requests[$rid]=array();
  $r=&$requests[$rid];
  $r['id']=$rid;
  $r['rkey']=$rid;
  if (is_string($cmd)) $r['cmd']=$cmd;
  $r['time']=get_mtf();
  if (is_array($params)) $r['params']=$params;
  if (is_array($cparams)) $r['cparams']=$cparams;
  if ($rparams!==false) $r['rparams']=$rparams;
  return $requests[$rid];
}

function jsp_delete_request($rkey) {
  if (false===($requests=&jsp_requests())) return false;
  if (array_key_exists($rkey, $requests) && is_array($requests[$rkey])) {
    unset($requests[$rkey]);
    return true;
  }
  return false;
}

function jsp_rid($prefix='RID') {
  if (false===($jspd=&jsp_data())) return false;
  if (!is_int(@$jspd['jsp_rid']) || $jspd['jsp_rid']<0 || $jspd['jsp_rid']>0x00FFFFFF) $jspd['jsp_rid']=0;
  return $prefix.sprintf('%06X', $jspd['jsp_rid']++);
}
   
function jsp_init_vars($key, $skey_set=false) {
  if (false===($jspd=&jsp_data())) return false;
  if ($skey_set) $jspd['jsp_subscriber_key']=$key;
  $jspd['jsp_connections'][$key]=array();
//  $jspd['jsp_con_evt_time']=get_mtf();
  if (false===($vars=&jsp_vars($key))) return false;
  $vars['con_evt_time']=get_mtf();    
  $vars['ping_interval']=0;
  $vars['ping_timeout']=0;
  $vars['ping_timer']=0;
  $vars['ping_since_last']=0;
  $vars['ping_timer_']=0;
  $vars['ping_sent']=0;
  $vars['buf']='';
}

function jsp_set_autoping(&$pool, $key, $interval, $timeout) {
  if (!@$pool->list[$key]['connected']) return $key;
  if (false===($jspd=&jsp_data())) return false;
  if (false===($vars=&jsp_vars($key))) return false;
  $vars['ping_interval']=$interval;
  $vars['ping_timeout']=$timeout;
  $vars['last_sent_time']=get_mtf();
  jsp_upd_autoping($pool, $key, 2);
  jsp_send($key, array('cmd'=>'ping', 'rid'=>jsp_rid()));
//    print("\n".var_export($vars, true)."\n");
  return $key;
}

function jsp_get_tick() {
  return (int)(get_mtf()*1000);
}

function jsp_upd_autoping(&$pool, $key, $reset=0) {
  if (!@$pool->list[$key]['connected']) return 0;
  if (false===($jspd=&jsp_data())) return false;
  if (false===($vars=&jsp_vars($key))) return false;
    
  $ts=jsp_get_tick();
    
  if ($reset!=0) {
    $vars['ping_sent']=0;
    $vars['ping_timer']=0;
    if ($reset>1) $vars['ping_since_last']=0;
    $vars['ping_timer_']=jsp_get_tick();
  }
  
  $e_ms=$ts-$vars['ping_timer_'];
  $e_s=(int)($e_ms/1000);
  
  if ($e_s) {
    $vars['ping_timer']+=$e_s;
    $vars['ping_since_last']+=$e_s;
  
    $e_ms-=$e_s*1000;
    $vars['ping_timer_']=$ts-$e_ms;
    return 1;
  }
  return 0;
}

function jsp_check_autoping(&$pool, $key) {
  if (!jsp_upd_autoping($pool, $key, 0)) return;
  if (!@$pool->list[$key]['connected']) return;
  if (false===($jspd=&jsp_data())) return false;
  if (false===($vars=&jsp_vars($key))) return false;
  if ($vars['ping_sent'] && $vars['ping_timeout']>0 && $vars['ping_since_last']>=$vars['ping_timeout']) {
    $vars['ping_interval']=0;
    $vars['ping_timeout']=0;
    $pool->drop_connection($key, 'ping timeout.');
  } else if (!$vars['ping_sent'] && $vars['ping_interval']>0 && $vars['ping_timer']>=$vars['ping_interval']) {
    jsp_send($key, array('cmd'=>'ping', 'rid'=>jsp_rid()));
    jsp_upd_autoping($pool, $key, 2);
    $vars['ping_sent']=1;
//    print("jsp autoping:[".$key."]\n");
  }
}

function jsp_on_connect(&$pool, $key) {
  $srv_key=$pool->list[$key]['srv_key'];
  if (false===($jspd=&jsp_data())) return false;
/*
  if ($jspd['jsp_subscriber_key']!==false && $key!=$jspd['jsp_subscriber_key']) {
    plogs("dropping jsp secondary connection.\n");
    $pool->drop_connection($key);
    return;
  }

  if ($jspd['jsp_subscriber_key']!==false) {
    plogs("duplicated jsp connect event.\n");
    return;
  }
*/
  $addr=$pool->list[$key]['addr'];
  $port=$pool->list[$key]['port'];
  plogs("jsp client connected [".$key.":".$srv_key."]: [".$addr.":".$port."]\n");
  $pool->set_socket_handlers($key, 'jsp_on_recv', 'jsp_on_send', 'jsp_on_data', 'jsp_on_disconnect');
  $pool->set_socket_low_handlers($key, 'conn_on_low_recv', 'conn_on_low_send');        
  jsp_init_vars($key, true);
  jsp_upd_autoping($pool, $key, 2);
}

function jsp_on_disconnect(&$pool, $key, $err_code=0) {
  $srv_key=$pool->list[$key]['srv_key'];
  if (false===($jspd=&jsp_data())) return false;
/*  
  if ($jspd['jsp_subscriber_key']===false) {
    plogs("unknown jsp disconnect event #1.\n");
    return;
  }
  if ($key!=$jspd['jsp_subscriber_key']) {
    plogs("unknown jsp disconnect event #2.\n");
    return;
  }
*/
  plogs("jsp client disconnected [".$key.":".$srv_key."]\n");
  if ($err_code!==0) {
    $es='';
    if (is_integer($err_code)) {
      $es.=' ['.$err_code.':'.cp866(trim(socket_strerror($err_code))).']';
    } else {
      $es.=' ['.$err_code.']';
    }
    plogs($es."\n");
  }
  if ($key==$jspd['jsp_subscriber_key']) $jspd['jsp_subscriber_key']=false;
//  $jspd['jsp_con_evt_time']=get_mtf();
  if (array_key_exists($key, $jspd['jsp_connections'])) unset($jspd['jsp_connections'][$key]);
}

function jsp_buff_shift($key, $count=0, $ret_strip=false) {
  if (false===($vars=&jsp_vars($key))) return false;
  if ($count>0) {
    $ret='';
    if ($ret_strip) $ret=substr($vars['buf'], 0, $count);
    $vars['buf']=substr($vars['buf'], $count);
    if ($ret_strip) return $ret;
  }
  return $vars['buf'];
}

function jsp_encode_packet($pk, &$pkdata='') {
//  plogs('jsp_encode_packet: '.var_d($pk)."\n");
  if (!is_array($pk)) return '';
  if (false===($jspd=&jsp_data())) return false;
  $pkdata=jsonenc($pk);  
  return $jspd['sof'].sprintf('%04X', strlen($pkdata)).$pkdata.$jspd['eof'];
}

function jsp_decode_hex($hstr) {
  $hstr=strtoupper(trim($hstr));
  $len=strlen($hstr);
  if ($len%2!=0) return false;
  if ($len<2 || $len>6) return false;
  if (preg_match('[^\dA-F]', $hstr)) return false;
  return hexdec($hstr);
}

function jsp_try_read_packet($key) {
  if (false===($jspd=&jsp_data())) return false;
  if (false===($vars=&jsp_vars($key))) return false;
  $buf=jsp_buff_shift($key);
  $blen=strlen($buf);
  if ($blen==0) return false;
  $pos=strpos($buf, $jspd['sof']);
  if ($pos===false) {
    return jsp_buff_shift($key, $blen, true);
  }
  if ($pos>0) {
    return jsp_buff_shift($key, $pos, true);
  }
//  $buf=jsp_buff_shift($key, $pos);
//  $blen=strlen($buf);
  $sof_len=strlen($jspd['sof']);
  $eof_len=(is_string($jspd['eof']))?strlen($jspd['eof']):0;
  $hl_len=4;
  $hdlen=$sof_len+$hl_len;
  if ($blen<$hdlen) return $hdlen-$blen;
  $hexlen=jsp_decode_hex(substr($buf, $sof_len, $hl_len));
  if ($hexlen===false) {
    return jsp_buff_shift($key, 1, true);
  }
  $pklen=$sof_len+$hl_len+$hexlen+$eof_len;
  if ($blen<$pklen) return $pklen-$blen;
  $toffset=$sof_len+$hl_len+$hexlen;
  if ($eof_len>0) {
    $pos=strpos($buf, $jspd['eof'], $toffset);
    if ($pos!==$toffset) {
//    print("pos:[".var_d(array($buf, $jspd['eof'], $sof_len+$hl_len+$hexlen, $pos, $sof_len, $hl_len, $hexlen))."]\n");
      return jsp_buff_shift($key, 1, true);
    }
  }  
  $ret=array(substr($buf, 0, $pklen), substr($buf, $sof_len+$hl_len, $hexlen));
  jsp_buff_shift($key, $pklen);
  return $ret;
}
   
function jsp_on_recv(&$pool, $key, $buffer, &$readed=0, &$wait_len=0, &$seq_no=0) {
   global $dmn_main_conn, $glob;
      
//   plogs("jspr#1: [".var_d($buffer)."]\n");
   if (!is_string($buffer) || strlen($buffer)==0) return false;
//   plogs("jspr#1a\n");
   if (false===($vars=&jsp_vars($key))) return false;
//   plogs("jspr#2, vars: [".var_d($vars)."]\n");
   $vars['buf'].=$buffer;
   $readed=strlen($buffer);
   $result=array();
   while (true) {
     $res=jsp_try_read_packet($key);
//     plogs("jspr#3, res: [".var_d($res)."]\n");
     if (is_bool($res)) {
       if ($res===false) break;
       continue;
     }
     if (is_int($res) && $res>=0) {
       $wait_len=$res;
       break;
     }
     if (is_string($res)) {
       if ($prlog) logp($glob['log_file'].'.jsp',
                        "received garbage [".$key.':'.$seq_no."]:\n".   
                        $pool->dump_packet($res).
                        "\n\nData:\n".
                        var_export($res, true)."\n", 
                        true);
       $result[]=$res;
       continue;
     }
     if (!is_array($res)) break;
     $pk=@jsondec($res[1]);
     if (!is_array($pk)) $pk=false;

     $prlog=!@$glob['llock'];

     jsp_upd_autoping($pool, $key, 2);

     if ($prlog) logp($glob['log_file'].'.jsp',
                      "received [".$key.':'.$seq_no."]:\n".   
                      $pool->dump_packet($res[0]).
                      "\n\nJSON:\n".
                      $res[1].
                      "\n\nData:\n".
                      var_export($pk, true)."\n", 
                      true);
     $res[]=$pk;
     $result[]=$res;
   }
   if (count($result)==0) return false;
   return $result;
}

function jsp_on_send(&$pool, $key, $data, $seq_no) {
  global $dmn_main_conn, $glob;

    $prlog=!@$glob['llock'];
    if (is_string($data)) { $buf=$data; $pkdata=$data; } else $buf=jsp_encode_packet($data, $pkdata);
//    $buf=jsp_encode_packet($data);
      
    if ($prlog) logp($glob['log_file'].'.jsp',
                     "sended [".$key.':'.$seq_no."]:\n".   
                     $pool->dump_packet($buf).
                      "\n\nJSON:\n".
                      $pkdata.
                     "\n\nData:\n".
                     var_export($data, true)."\n", 
                     true);
//   plogs("sended:\n".var_export($data, true));
    return $buf;
}

function jsp_send($key, $data) {
  global $dmn_main_conn;
//  $data['tid']='12';
  return $dmn_main_conn['pool']->send($key, $data);
}

function jsp_send_request($key, $cmd, $params=false, $cparams=false, $rparams=false) {
  $rid=false;
  if ($rparams!==false) {
    if (false===($request=&jsp_create_request($cmd, $params, $cparams, $rparams))) return NULL;
    $rid=$request['id'];
  }
  $data=array('cmd'=>$cmd);
  if ($rid) $data['rid']=$rid;
  if (is_array($params)) foreach ($params as $_key=>$val) $data[$_key]=$val;
  if (jsp_send($key, $data)===false) return NULL;
  return $rid;
}

function jsp_answer_request($key, $rid, $params=false) {
  $data=array('rid'=>$rid);
  if (is_array($params)) foreach ($params as $_key=>$val) $data[$_key]=$val;
  if (array_key_exists('cmd', $data)) unset($data['cmd']);
  jsp_send($key, $data);
  return false;
}

function jsp_send_() {
  global $dmn_main_conn, $glob;
  $args=func_get_args();
  $key=array_shift($args);
  $dmn_main_conn['pool']->send($key, $args);
  return false;
}

function jsp_arr_lower($array) {
  if (!is_array($array)) return $array;
  $array=array_change_key_case($array, CASE_LOWER);
  foreach (array_keys($array) as $key) {
    $array[$key]=jsp_arr_lower($array[$key]);
  }
  return $array;
}

function jsp_get_con_key_by_id($id) {
  global $glob;
  foreach (array_keys($glob[GLOB_KEY_CONNECTIONS]) as $key) {
    if ($glob[GLOB_KEY_CONNECTIONS][$key]['settings']['id']==$id) return $key;
  }
  return false;
}

function jsp_get_session_key_by_id($id) {
  global $glob;
  $cset=&conn_get_settings_by_id($id);
  $skey=@$glob[GLOB_KEY_CONNECTIONS][$cset['key']]['vars']['last_started_session'];
  if ($skey && array_key_exists($skey, $glob[GLOB_KEY_SESSIONS]) && !@$glob[GLOB_KEY_SESSIONS][$skey]['processed']) return $skey;
  return false;

  foreach (array_keys($glob[GLOB_KEY_SESSIONS]) as $skey) {
    if ($glob[GLOB_KEY_SESSIONS][$skey]['key']==$ckey) return $skey;
  }
  return false;
}

function jsp_get_session_key_by_id1($id) {
  global $glob;
  $ckey=jsp_get_con_key_by_id($id);
  foreach (array_keys($glob[GLOB_KEY_SESSIONS]) as $skey) {
    if ($glob[GLOB_KEY_SESSIONS][$skey]['key']==$ckey) return $skey;
  }
  return false;
}

function jsp_start_session($key, $uid) {
  global $dmn_main_conn, $glob;
  $skey=session_create($key, $uid);
  if (!$skey) return false;
    
  $glob[GLOB_KEY_SESSIONS][$skey]['data']['rfid']=$uid;

  $os='Read Tag ['.uid2hex($uid)."]\n";
  plogs($os);
    
  $glob[GLOB_KEY_SESSIONS][$skey]['kpo_result']=KPO_RES_UNDEF;
  $glob[GLOB_KEY_SESSIONS][$skey]['ap_mode']=false;
  $glob[GLOB_KEY_SESSIONS][$skey]['req_time']=get_mtf();
  session_check_done($skey);
  return $skey;
}

function jsp_on_data(&$pool, $key) {
  global $dmn_main_conn, $glob;
//function on_data(&$pool, $key, $data, $seq_no) {
   global $glob;
   
   $data=$pool->get_data($key);
   if ($data===false) return false;
   $raw_data=$data[2];
   $seq_no=$data[1];
   $data=$data[0];
   if (!is_array($data) || count($data)==0) return false;
//   plogs("jsp data:\n".var_export($data, true)."\n");
//   plogs("raw_data:\n".var_export($raw_data, true));
//   logp($glob['log_file'], "answer [".$key."]:\n".var_export($data[2], true)."\n", true);
   foreach ($data as $pk) jsp_process_packet($pool, $key, $pk);
   return true;
}

function jsp_process_packet(&$pool, $key, $_pk) {
  $req=false;
  if (is_array($_pk) && count($_pk)==3 && is_array($_pk[2])) {
    plogs("jsp packet:\n".var_export($_pk, true)."\n");
    $pk=jsp_arr_lower($_pk[2]);
    if (is_string(@$pk['cmd'])) {
      if (!handler_exec('jsp_event', array(&$req, &$pool, $key, 'command', $pk, $_pk), $result)) {
        if (is_string(@$pk['rid'])) jsp_answer_request($key, $pk['rid'], $pk);
      }
    } else if (is_string(@$pk['rid'])) {
      if (false===($requests=&jsp_requests())) return false;
      if (array_key_exists($pk['rid'], $requests) && is_array($requests[$pk['rid']])) {
        handler_exec('jsp_event', array(&$requests[$pk['rid']], &$pool, $key, 'answer', $pk, $_pk), $result);
        jsp_delete_request($pk['rid']);
      }
    }
  } else if (is_string($_pk)) {
    plogs("jsp garbage packet:\n".var_export($_pk, true)."\n");
  } else {
    plogs("jsp unknown packet:\n".var_export($_pk, true)."\n");
  }
  return true;
}

function jsp_idle_proc(&$pool, $mtf) {
  global $dmn_main_conn, $glob;
  if (false===($jspd=&jsp_data())) return false;
    
  foreach (array_keys($jspd['jsp_connections']) as $key) {
    jsp_check_autoping($pool, $key);
  }
  
  if ($requests=&jsp_requests()) {
    $ex_time=(float)$jspd['rtimeout'];
    if ($ex_time==0.0) return false;
    $mmtf=$mtf-$ex_time;
    $rkeys=array_keys($requests);
    foreach ($rkeys as $rkey) {
      $request=&$requests[$rkey];
      if ($request['time']<$mmtf) {
        handler_exec('jsp_event', array(&$requests[$rkey], &$pool, false, 'timeout', false, false), $result);
        jsp_delete_request($rkey);
      }
    }
  }
  

}


} // end incl_h
?>
