<?php
if (!defined("INC_MEMREG_INL_H")){
   define("INC_MEMREG_INL_H", TRUE);

   include("hexutil.inc");
   include("util.inl");
   include("handler.inl");
   
   
  define('GLOB_MEMREG_DATA_KEY', '__memreg_data');
  $GLOBALS[GLOB_MEMREG_DATA_KEY]=array();
  $GLOBALS[GLOB_MEMREG_DATA_KEY]['clr_timeout']=15.0; // default clear timeout, sec.

  define('MEMREG_MODE_AUTO',   0x00);
  define('MEMREG_MODE_SET',    0x01);
  define('MEMREG_MODE_CLR',    0x02);

  define('MEMREG_MSG_INFO_SET',      0x00);
  define('MEMREG_MSG_INFO_CLR',      0x01);
  define('MEMREG_MSG_SET',      0x02);
  define('MEMREG_MSG_CLR',      0x03);
  define('MEMREG_MSG_DENIED',   0x04);
  define('MEMREG_MSG_SET_',      0x05);
  define('MEMREG_MSG_CLR_',      0x06);

function memreg_init() {
  global $dmn_main_conn, $glob;
  if (false===($mrd=&memreg_data())) return false;
  $mrd['storage']=array();
  return true;
}

function memreg_key($key, &$rkey=null, &$mode=null) {
  global $glob;
  if (!is_string($key)) return false;
  $_key=trim($key);
  $l=strlen($_key);
  if ($l<1 || $l>64) return false;
  if (!preg_match('/([A-Za-z\d\_\-\+]+)(?:\/([A-Za-z\d\_\-\+]+))?/', $_key, $m)) return false;
  if (count($m)<2) return false;
  $rkey=$m[1];
  $mode=MEMREG_MODE_AUTO;
  if (count($m)>2) {
    $smode=strtolower(trim($m[2]));
    if ($smode=='set' || $smode=='add') {
      $mode=MEMREG_MODE_SET;
    } else if ($smode=='clr' || $smode=='clear' || $smode=='del') {
      $mode=MEMREG_MODE_CLR;
    }
  }
//  logp($glob['log_file'],"\n\nmemreg_key matches:\n".var_export($m, true)."\n", true);
  return true;
}

function &memreg_data($key=false) {
  $fret=false;
  if (!array_key_exists(GLOB_MEMREG_DATA_KEY, @$GLOBALS) || !is_array(@$GLOBALS[GLOB_MEMREG_DATA_KEY])) return $fret;
  if (is_string($key)) {
    if (!array_key_exists($key, @$GLOBALS[GLOB_MEMREG_DATA_KEY])) $GLOBALS[GLOB_MEMREG_DATA_KEY][$key]=null;
    return $GLOBALS[GLOB_MEMREG_DATA_KEY][$key];
  }
  return $GLOBALS[GLOB_MEMREG_DATA_KEY];
}

function &memreg_storage($key) {
  $fret=false;
  if (!memreg_key($key, $_key)) return $fret;
  if (false===($mrs=&memreg_data('storage'))) return $fret;
  if (!array_key_exists($_key, @$mrs) || !is_array(@$mrs[$_key])) $mrs[$_key]=array();
  return $mrs[$_key];
}

function memreg_set($storage, $key, $val=true) {
  if (!memreg_key($storage, $s_key)) return false;
  if (!memreg_key($key, $_key)) return false;
  if (false===($mrs=&memreg_storage($s_key))) return false;
  $mrs[$_key]=$val;
  return true;
}

function memreg_get($storage, $key) {
  if (!memreg_key($storage, $s_key)) return null;
  if (!memreg_key($key, $_key)) return null;
  if (false===($mrs=&memreg_storage($s_key))) return null;
  if (array_key_exists($_key, $mrs)) return $mrs[$_key];
  return null;
}

function memreg_del($storage, $key) {
  if (!memreg_key($storage, $s_key)) return false;
  if (!memreg_key($key, $_key)) return false;
  if (false===($mrs=&memreg_storage($s_key))) return false;
  if (array_key_exists($_key, $mrs)) unset($mrs[$_key]);
  return true;
}

function memreg_message_key($mtype) {
  if ($mtype==MEMREG_MSG_INFO_SET) return 'msg_info_set';
  if ($mtype==MEMREG_MSG_INFO_CLR) return 'msg_info_clr';
  if ($mtype==MEMREG_MSG_SET) return 'msg_set';
  if ($mtype==MEMREG_MSG_CLR) return 'msg_clr';
  if ($mtype==MEMREG_MSG_DENIED) return 'msg_denied';
  if ($mtype==MEMREG_MSG_SET_) return 'msg_set_';
  if ($mtype==MEMREG_MSG_CLR_) return 'msg_clr_';
  return false;  
}

function memreg_message_($mtype, $storage) {
  global $glob;
  $mkey=memreg_message_key($mtype);
  $ret=trim(@$glob['memreg'][$mkey].'');
  if (memreg_key($storage, $s_key) && is_string(@$glob['memreg']['custom_storage'][$s_key][$mkey])) {
    $ret=trim($glob['memreg']['custom_storage'][$s_key][$mkey].'');
  }
  if (!is_string($ret) || strlen($ret)<1) return false;
  return $ret;
}

function memreg_message($mtype, $storage) {
  $ret=memreg_message_($mtype, $storage);
  if (!is_string($ret)) {
    if ($mtype==MEMREG_MSG_SET_) $ret=memreg_message_(MEMREG_MSG_SET, $storage);
    if ($mtype==MEMREG_MSG_CLR_) $ret=memreg_message_(MEMREG_MSG_CLR, $storage);
  }
  return $ret;
}

function memreg_idle_proc(&$pool, $mtf) {
  global $dmn_main_conn, $glob;
  return false;
  if (false===($mrs=&memreg_data('storage'))) return false;
/*    
  if ($requests=&jsp_requests()) {
    $ex_time=(float)$jspd['rtimeout'];
    if ($ex_time==0.0) return false;
    $mmtf=$mtf-$ex_time;
    $rkeys=array_keys($requests);
    foreach ($rkeys as $rkey) {
      $request=&$requests[$rkey];
      if ($request['time']<$mmtf) {
        handler_exec('jsp_event', array(&$requests[$rkey], &$pool, false, 'timeout', false, false), $result);
        jsp_delete_request($rkey);
      }
    }
  }
*/

}


} // end incl_h
?>
