<?php
if (!defined("INC_MEMREG_DEV_INL_H")){
   define("INC_MEMREG_DEV_INL_H", TRUE);

   include("memreg.inl");
   
   
function memreg_dev_rth(&$pool, $key, $raw_data, $pk) {
  global $glob;
  
  $aparams=@$pk['data'];
  if (!is_array($aparams)) return false;
  
  if (!($conn=&conn_get_settings($key, @$aparams['reader_type_name'], true))) return false;

  $rtr=(bool)($pk['cmd']==eproto_cmd_ReadTag);
  $fr=(bool)@$pk['fast_react'];
  if ((bool)@$conn['rtreact']!=$rtr) return false;


  if (!memreg_key(@$conn['memreg_dev'], $rkey, $rmode)) return false;

  $os='Terminal used: ['.$key."]\n";
  $os.='Terminal id: '.@$conn['id']."\n";
  $os.='Terminal address: ['.@$conn['ip'].':'.@$conn['port']."]\n";
  $os.="Terminal type: POCKET\n";
//  $os.='UID: '.@$aparams['uid']."\n";
  foreach ($aparams as $k=>$v) $os.=$k.': '.var_d($v, true)."\n";
  plogs($os);

  if (!memreg_key($aparams['uid'], $uid_key)) return false;
  
  $cval=memreg_get($rkey, $uid_key);
  $message=false;
  $sound=3;
    
  $inp=(int)@$conn['inputs'];
  $s_inp=0; if (is_int(@$conn['memreg_inputs'])) $s_inp=(int)$conn['memreg_inputs'];
    
  if ($s_inp>0 && !($inp & $s_inp)) {
    $sound=1;
    if (!is_null($cval)) {
      $message=memreg_message(MEMREG_MSG_INFO_SET, $rkey);
    } else {
      $message=memreg_message(MEMREG_MSG_INFO_CLR, $rkey);
    }
  } else if ($rmode==MEMREG_MODE_AUTO) {
    if (is_null($cval)) {
      if (memreg_set($rkey, $uid_key)) {
        $message=memreg_message(MEMREG_MSG_SET, $rkey);
        $sound=1;
      }
    } else {
      if (memreg_del($rkey, $uid_key)) {
        $message=memreg_message(MEMREG_MSG_CLR, $rkey);
        $sound=1;
      }
    }
  } else if ($rmode==MEMREG_MODE_SET) {
    if (memreg_set($rkey, $uid_key)) {
      if (is_null($cval)) {
        $message=memreg_message(MEMREG_MSG_SET, $rkey);
      } else {
        $message=memreg_message(MEMREG_MSG_SET_, $rkey);
      }
      $sound=1;
    }
  } else if ($rmode==MEMREG_MODE_CLR) {
    if (memreg_del($rkey, $uid_key)) {
      if (!is_null($cval)) {
        $message=memreg_message(MEMREG_MSG_CLR, $rkey);
      } else {
        $message=memreg_message(MEMREG_MSG_CLR_, $rkey);
      }
      $sound=1;
    }
  }
  
  if (!is_string($message)) $message=from_utf8('Ошибка');
      
  $pk=eproto_packet(eproto_cmd_Interactive);
  $pk['flags']=(int)@$sobj['data']['rfid']['reader_type'];
  $pk['payload']=pocket_interactive(colon2nl($message), 3000, $sound, true);
  $pool->send($key, $pk);


  return true;  
}


} // end incl_h
?>
