<?php
if (!defined("INC_POCKET_INL_H")){
  define("INC_POCKET_INL_H", TRUE);
  include("dev.inl");
  include("proxy.inl");
  include("cgate.inl");
  include("handler.inl");
  include("fm3056.inl");
  include("ds9208.inl");
  include("memreg_dev.inl");

  
function pocket_handle_cmd_ReadTagExtended(&$pool, $key, $raw_data, $pk) {
  global $glob;
  
  
//  logp($glob['log_file'], "eproto_cmd_ReadTagExtended [".$key."]:\n".var_d(array($key, $raw_data, numcoder_dump_simple($raw_data),  $pk), true)."\n", true);

  $aparams=@$pk['data'];
  if (!is_array($aparams)) return true;
    
  if (!($conn=&conn_get_settings($key, @$aparams['reader_type_name'], true))) return true;

  if (session_is_alive(@$conn['reader_locked'])) {
    $pk=eproto_packet(eproto_cmd_Interactive);
    $pk['flags']=(int)@$aparams['reader_type'];
    $text=from_utf8("Ожидайте...");
    $pk['payload']=pocket_interactive($text, 0, 0, true);
//    $pk['payload']=pocket_interactive_text($text);
    $pool->send($key, $pk);
    return true;
  }

  $rtr=(bool)($pk['cmd']==eproto_cmd_ReadTag);
  $fr=(bool)@$pk['fast_react'];
  if ((bool)@$conn['rtreact']!=$rtr) return true;
  
  if (@$conn['memreg_dev']) {
    memreg_dev_rth($pool, $key, $raw_data, $pk);
    return true;
  }

//  $pool->send($key, eproto_packet(eproto_cmd_Signal, 0, chr(EPROTO_SIGNAL_NFC_LOCK)));
  
//  print("\n\nauto_lock:\n");
  if (dev_session_auto_lock($pool, $key, $raw_data, $pk)) return true;
//  $salck=dev_session_auto_lock1($pool, @$aparams['uid'], $key, @$aparams['reader_type_name']);
//  print('9');
//  print("======\n\n");
//  if ($salck) return true;

    
  $gpkey=cgate_get_op_conn($conn);
  
  if (!($sobj=&dev_session_auto_renew($pool, @$aparams['uid'], $key, @$aparams['reader_type_name']))) return true;
  
  $sobj['uid_raw']=@$aparams['uid_raw'];
  
//  logp($glob['log_file'], eproto_cmd_name($pk['cmd'])." conn [".$key."]:\n".var_d($conn, true)."\n", true);

/*  
  $fplocks=@$glob['free_pass_locks'];
  if (!is_array($fplocks)) $fplocks=array();

  if (!$fr && !$rtr && is_array(@$aparams['lockers_data']) && count($aparams['lockers_data'])>0) {
    if (handler_exec('transform_lockers_data', array($aparams['lockers_data']), $lda)) {
    } else {
      $lda=array();
      foreach ($aparams['lockers_data'] as $ld) {
        if (is_array($ld) && (int)@$ld['auth_err']==0 && (int)@$ld['read_err']==0 &&
            @$ld['locked'] && (int)@$ld['cab_no']>0) {
            $ldi=array((@$ld['is_passtech'])?(string)@$ld['litera']:(int)@$ld['block_no'], (int)@$ld['cab_no']); // array($lit, $num);
            if (!in_array(implode(':', $ldi), $fplocks)) { // wegym fix
              $lda[]=$ldi;
            }              
        }
      }
      unset($aparams['lockers_data']);
      $aparams['lockers_data']=$lda;
      $lda=array();
      foreach ($aparams['lockers_data'] as $ld) {
        $lda[]=(!is_string($ld[0]))?(string)$ld[1]:(string)$ld[0].(string)$ld[1];
      }
      $aparams['lockers_data_f']=$lda;
    }
  }
*/ 
 
  if (!$fr && !$rtr) dev_process_lockers_data($aparams);
  
  $os='Terminal used: ['.$key."]\n";
  $os.='Terminal id: '.@$conn['id']."\n";
  $os.='Terminal address: ['.@$conn['ip'].':'.@$conn['port']."]\n";
  $os.="Terminal type: POCKET\n";
//  $os.='UID: '.@$aparams['uid']."\n";
  foreach ($aparams as $k=>$v) $os.=$k.': '.var_d($v, true)."\n";
  plogs($os);

  
//  session_set_kpo_result($sobj, NULL);
  session_set_rfid_data($sobj, $aparams);

  session_check_done($sobj['id']);
  return true;
}

function pocket_handle_resp_RelayControlEx(&$pool, $key, $raw_data, $pk) {
  global $glob;
  
//  logp($glob['log_file'], "eproto_resp_RelayControlEx [".$key."]:\n".var_d(array($key, $raw_data, numcoder_dump_simple($raw_data),  $pk), true)."\n", true);




  $aparams=@$pk['data'];
  if (!is_array($aparams)) return true;
  
  if (agov($glob, 'term_session_lock') && !@$aparams['passed']) return true;
  if (agov($glob, 'term_pulse_mode') && !@$aparams['passed']) return true;
  
  
  $aparams['key']=$key;
  $aparams['time']=get_mtf();
  $_uid=hexutil_hex2buf($aparams['uid_raw']);
  if ($_uid) {
    $aparams['uid']=$aparams['uid_raw'];
    $aparams['uid_raw']=$_uid;
  }
  
  
  if (!($conn=&conn_get_settings($key, @$aparams['reader_type_name'], true))) return true;
  $gpkey=cgate_get_op_conn($conn);
//  logp($glob['log_file'], "eproto_resp_RelayControlEx conn [".$key."]:\n".var_d($conn, true)."\n", true);

  $os='Terminal used: ['.$key."]\n";
  $os.='Terminal id: '.@$conn['id']."\n";
  $os.='Terminal address: ['.@$conn['ip'].':'.@$conn['port']."]\n";
  $os.="Terminal type: POCKET\n";
  foreach ($aparams as $k=>$v) $os.=$k.': '.var_d($v, true)."\n";
  plogs($os);

//  if (!($sobj=&session_obj_get(@$aparams['uid'], $key, @$aparams['reader_type_name']))) return true;
  if (!($sobj=&session_obj_get(@$aparams['uid_raw']))) return true;
  if (agov($glob, 'term_pulse_mode') && session_passed2val(@$sobj['passed'])) return true;
  logp($glob['log_file'], "eproto_resp_RelayControlEx session [".$key."]:\n".var_d(array($sobj, $aparams), true)."\n", true);
  session_set_passed_data($sobj, $aparams);
  session_check_done($sobj['id']);
  logp($glob['log_file'], "eproto_resp_RelayControlEx session [".$key."]:\n".var_d(array($sobj, $aparams), true)."\n", true);
  return true;
}

function pocket_handle_cmd_InputChanged(&$pool, $key, $raw_data, $pk) {
  global $glob;

  $aparams=@$pk['data'];
  if (!is_array($aparams)) return true;
  if (!((int)@$aparams['inputs_changed'] && 0x01)) return true;
  if (!agov($glob, 'term_pulse_mode')) return true;
  if (!($conn=&conn_get_settings($key, @$aparams['reader_type_name'], true))) return true;
  if (!($cobj=&conn_obj_get($key))) return true;
  if (!($sobj=&session_obj_get(@$cobj['vars']['last_started_session']))) return true;
  if (session_passed2val(@$sobj['passed'])) return true;
  
  $aparams['uid_raw']=$sobj['s_id'];
  $aparams['uid']=hexutil_buf2hex($aparams['uid_raw']);
  $aparams['key']=$key;
  $aparams['time']=get_mtf();
  $aparams['passed']=true;

  plogs("Input changed:\n".var_d($aparams)."\n");
  
  session_set_passed_data($sobj, $aparams);
  session_check_done($sobj['id']);
  
  return true;
}
  
function pocket_on_packet(&$pool, $key, $raw_data, $seq_no, $pk) {
  global $glob;

  if (is_array(@$pk['data']) && array_key_exists('uid', $pk['data'])) {
    if (array_key_exists(@$pk['data']['uid'], $glob['rfid_links'])) {
      $pk['data']['uid']=$glob['rfid_links'][$pk['data']['uid']];
      $pk['data']['uid_raw']=hexutil_hex2buf($pk['data']['uid']);
    } else if (array_key_exists('*', $glob['rfid_links'])) {
      $pk['data']['uid']=$glob['rfid_links']['*'];
      $pk['data']['uid_raw']=hexutil_hex2buf($pk['data']['uid']);
    }
  }

  $aparams=@$pk['data'];
  if (!is_array($aparams)) return true;
  
  if (!($conn=&conn_get_settings($key, @$aparams['reader_type_name'], true))) return true;

   $pkey=proxy_get_child_key($pool, $key);
  
   if ($pk['cmd']==eproto_cmd_Enquire) {
      $conn['inputs']=$pk['code'];
      $rpk=eproto_packet(eproto_resp_Enquire);
      $pool->send($key, $rpk);
   } else if ($pk['cmd']==eproto_cmd_USARTRaw) {
//     usart_process_stream($key, $pk['payload']);
      if (strlen(@$pk['payload'])>0) {
        if (ord($pk['payload']{0})==0x2A && ord($pk['payload']{1})==0x03) {
          send_slave_USART_packet($key, eproto_cmd_Interactive, 0, pocket_interactive(from_utf8("OK"), 1500, 4, true));
        } else {
         $apk=eproto_packet(eproto_cmd_Interactive);
         $apk['flags']=(int)@$aparams['reader_type'];
         $text=from_utf8("Ожидайте...");
         $apk['payload']=pocket_interactive($text, 0, 0, true);
//         $pool->send($key, $apk);
//         plogs("USART received [".$key."]:\n".var_d($pk['payload'], true)."\n");
         $apk=eproto_packet(eproto_cmd_USARTRaw);
         $apk['flags']=(int)@$aparams['reader_type'];
         $apk['payload']="\x7E\x00\x07\x01\x00\x0A\x01\xEE\x8A";
//         $pool->send($key, $apk);
          if (@$conn['fm3056']) fm3056_process_stream($pool, $key, $pk);
          if (@$conn['ds9208']) ds9208_process_stream($pool, $key, $pk);
        }
      }  
   } else if ($pk['cmd']==eproto_cmd_ReadTagExtended || $pk['cmd']==eproto_cmd_ReadTag) {     
     if (@$pk['data']) return pocket_handle_cmd_ReadTagExtended($pool, $key, $raw_data, $pk);
   } else if ($pk['cmd']==eproto_resp_RelayControlEx) {
     if (@$pk['data']) return pocket_handle_resp_RelayControlEx($pool, $key, $raw_data, $pk);
   } else if ($pk['cmd']==eproto_cmd_InputChanged) {
      $conn['inputs']=$pk['code'];
      plogs("inputs changed [".$key."]:\n".var_d($pk['data'], true)."\n");
      if ($pkey) $pool->send($pkey, $pk);
      return pocket_handle_cmd_InputChanged($pool, $key, $raw_data, $pk);
   } else if ($pkey) {
      $pool->send($pkey, $pk);
   }
   return true;
}

  
  
} // end incl_h
?>
