<?php
if (!defined("INC_PROXY_INL_H")){
   define("INC_PROXY_INL_H", TRUE);


function proxy_rtag_pk($uid, $code=0, $flags=0) {
  if (strlen($uid)>POCKET_RELAY_UID_MAX_LEN) $uid=substr($uid, 0, POCKET_RELAY_UID_MAX_LEN);
  $pk=eproto_packet(eproto_cmd_ReadTagExtended);
  $pk['code']=$code;
  $pk['flags']=$flags;
  $pk['payload']='';
  $pk['payload'].=numcoder_encode_r(strlen($uid), 1).$uid; // uid_len + uid
  $dblzero=numcoder_encode_r(0x0000, 2);
  $pk['payload'].=$dblzero; // finger result
  $pk['payload'].=$dblzero.$dblzero; // locker #1
  $pk['payload'].=$dblzero.$dblzero; // locker #2
  $pk['payload_hex']='';
  return $pk;
}

function proxy_rcer_pk($uid, $code=0, $flags=0x10) {
  if (strlen($uid)>POCKET_RELAY_UID_MAX_LEN) $uid=substr($uid, 0, POCKET_RELAY_UID_MAX_LEN);
  $pk=eproto_packet(eproto_resp_RelayControlEx);
  $pk['code']=$code;
  $pk['flags']=$flags;
  $pk['payload']=$uid;
  $pk['payload_hex']='';
  return $pk;
}
   
function proxy_get_term_connected_key(&$pool, $key) {
  global $glob;
  $ckey=false;
  $srv_key=$pool->list[$key]['srv_key'];
  if (array_key_exists($srv_key, $glob[GLOB_KEY_PROXY_SERVERS])) {
    $ckey=$glob[GLOB_KEY_PROXY_SERVERS][$srv_key]['ckey'];
    if (!array_key_exists($ckey, $glob[GLOB_KEY_CONNECTIONS])) $ckey=false;
    if ($ckey && !@$pool->list[$ckey]['connected']) $ckey=false;
  }
  return $ckey;
}

function proxy_get_child_key(&$pool, $key) {
  global $glob;
  $srv_key=@$glob[GLOB_KEY_CONNECTIONS][$key]['vars']['proxy_key'];
//  print("srv_key:".$srv_key."\n");
  if (array_key_exists($srv_key, $glob[GLOB_KEY_PROXY_SERVERS])) {
    $child_key=$glob[GLOB_KEY_PROXY_SERVERS][$srv_key]['child_key'];
    if ($child_key && @$pool->list[$child_key]['connected']) {
      return $child_key;
    }
  }
  return false;
}

function proxy_get_session_key(&$pool, $key) {
  global $glob;
  $srv_key=$pool->list[$key]['srv_key'];
  if (array_key_exists($srv_key, $glob[GLOB_KEY_PROXY_SERVERS])) {
    $skey=@$glob[GLOB_KEY_PROXY_SERVERS][$srv_key]['session_key'];
    if ($skey && array_key_exists($skey, $glob[GLOB_KEY_SESSIONS])) return $skey;
  }
  return false;
}

function proxy_set_session_key_by_conkey(&$pool, $key, $skey) {
  global $glob;
  $srv_key=@$glob[GLOB_KEY_CONNECTIONS][$key]['vars']['proxy_key'];
//  print("srv_key:".$srv_key."\n");
  if (array_key_exists($srv_key, $glob[GLOB_KEY_PROXY_SERVERS])) {
    $child_key=$glob[GLOB_KEY_PROXY_SERVERS][$srv_key]['child_key'];
    if ($skey==false || ($child_key && @$pool->list[$child_key]['connected'])) {
      $glob[GLOB_KEY_PROXY_SERVERS][$srv_key]['session_key']=$skey;
      return true;
    }    
  }
  return false;
}

function proxy_set_autoping(&$pool, $key, $interval, $timeout) {
  global $glob;
  $ckey=false;
  $srv_key=$pool->list[$key]['srv_key'];
  if (array_key_exists($srv_key, $glob[GLOB_KEY_PROXY_SERVERS])) {
    $ckey=$glob[GLOB_KEY_PROXY_SERVERS][$srv_key]['child_key'];
    if ($ckey) { // && @$pool->list[$ckey]['connected']) {
      $glob[GLOB_KEY_PROXY_SERVERS][$srv_key]['child_vars']['ping_interval']=$interval;
      $glob[GLOB_KEY_PROXY_SERVERS][$srv_key]['child_vars']['ping_timeout']=$timeout;
      $glob[GLOB_KEY_PROXY_SERVERS][$srv_key]['child_vars']['last_sent_time']=get_mtf();
      proxy_upd_autoping($pool, $key, 2);
    }
  }
  return $ckey;
}

function proxy_get_tick() {
  return (int)(get_mtf()*1000);
}

function proxy_upd_autoping(&$pool, $key, $reset=0) {
  global $glob;
  $srv_key=$pool->list[$key]['srv_key'];
  
  if (array_key_exists($srv_key, $glob[GLOB_KEY_PROXY_SERVERS])) {
    $vars=&$glob[GLOB_KEY_PROXY_SERVERS][$srv_key]['child_vars'];
    
    $ts=proxy_get_tick();
    
    if ($reset!=0) {
      $vars['ping_sent']=0;
      $vars['ping_timer']=0;
      if ($reset>1) $vars['ping_since_last']=0;
      $vars['ping_timer_']=proxy_get_tick();
    }
  
    $e_ms=$ts-$vars['ping_timer_'];
    $e_s=(int)($e_ms/1000);
  
    if ($e_s) {
      $vars['ping_timer']+=$e_s;
      $vars['ping_since_last']+=$e_s;
    
      $e_ms-=$e_s*1000;
      $vars['ping_timer_']=$ts-$e_ms;
      return 1;
    }
  }
  return 0;
}

function proxy_check_autoping(&$pool, $key) {
  global $glob;
  $srv_key=$pool->list[$key]['srv_key'];
  
  if (array_key_exists($srv_key, $glob[GLOB_KEY_PROXY_SERVERS])) {
    if (!proxy_upd_autoping($pool, $key, 0)) return;
    if (!@$pool->list[$key]['connected']) return;
    $vars=&$glob[GLOB_KEY_PROXY_SERVERS][$srv_key]['child_vars'];
    if ($vars['ping_sent'] && $vars['ping_timeout']>0 && $vars['ping_since_last']>=$vars['ping_timeout']) {
      $vars['ping_interval']=0;
      $vars['ping_timeout']=0;
      $pool->drop_connection($key, 'ping timeout.');
    } else if (!$vars['ping_sent'] && $vars['ping_interval']>0 && $vars['ping_timer']>=$vars['ping_interval']) {
      $pk=eproto_packet(eproto_cmd_Enquire);
      $pool->send($key, $pk);
      proxy_upd_autoping($pool, $key, 2);
      $vars['ping_sent']=1;
//      print("autoping:[".$srv_key.":".$key."]\n");
    }
  }
}

function proxy_on_connect(&$pool, $key) {
  global $glob;
  $srv_key=$pool->list[$key]['srv_key'];
  
  if (array_key_exists($srv_key, $glob[GLOB_KEY_PROXY_SERVERS])) {
    $addr=$pool->list[$key]['addr'];
    $port=$pool->list[$key]['port'];
    plogs("proxy connected [".$key.":".$srv_key."]: [".$addr.":".$port."]\n");
    $pool->set_socket_handlers($key, 'proxy_on_recv', 'proxy_on_send', 'proxy_on_data', 'proxy_on_disconnect');
    $pool->set_socket_low_handlers($key, 'conn_on_low_recv', 'conn_on_low_send');        

    $ckey=@$glob[GLOB_KEY_PROXY_SERVERS][$srv_key]['child_key'];
    if ($ckey && @$pool->list[$ckey]['connected'] && $ckey!=$key) {
      $pk=eproto_packet(eproto_cmd_Busy);
      $pool->drop_after_send($key);
      $pool->send($key, $pk);
      return;
    }
    $glob[GLOB_KEY_PROXY_SERVERS][$srv_key]['child_key']=$key;
    $glob[GLOB_KEY_PROXY_SERVERS][$srv_key]['child_vars']['con_evt_time']=get_mtf();    
    $glob[GLOB_KEY_PROXY_SERVERS][$srv_key]['child_vars']['ping_interval']=0;
    $glob[GLOB_KEY_PROXY_SERVERS][$srv_key]['child_vars']['ping_timeout']=0;
    $glob[GLOB_KEY_PROXY_SERVERS][$srv_key]['child_vars']['ping_timer']=0;
    $glob[GLOB_KEY_PROXY_SERVERS][$srv_key]['child_vars']['ping_since_last']=0;
    $glob[GLOB_KEY_PROXY_SERVERS][$srv_key]['child_vars']['ping_timer_']=0;
    $glob[GLOB_KEY_PROXY_SERVERS][$srv_key]['child_vars']['ping_sent']=0;
    proxy_upd_autoping($pool, $key, 2);
  
  }
  
}

function proxy_on_disconnect(&$pool, $key, $err_code=0) {
  global $glob;
  $srv_key=$pool->list[$key]['srv_key'];
  if (array_key_exists($srv_key, $glob[GLOB_KEY_PROXY_SERVERS])) {
    plogs("proxy disconnected [".$key.":".$srv_key."]\n");
    $ckey=@$glob[GLOB_KEY_PROXY_SERVERS][$srv_key]['child_key'];
    if ($ckey && $ckey==$key) {
      $glob[GLOB_KEY_PROXY_SERVERS][$srv_key]['child_key']=false;
      $glob[GLOB_KEY_PROXY_SERVERS][$srv_key]['child_vars']=array();
      $glob[GLOB_KEY_PROXY_SERVERS][$srv_key]['child_vars']['con_evt_time']=get_mtf();
      $glob[GLOB_KEY_PROXY_SERVERS][$srv_key]['child_vars']['ping_interval']=0;
      $glob[GLOB_KEY_PROXY_SERVERS][$srv_key]['child_vars']['ping_timeout']=0;
      $glob[GLOB_KEY_PROXY_SERVERS][$srv_key]['child_vars']['ping_timer']=0;
      $glob[GLOB_KEY_PROXY_SERVERS][$srv_key]['child_vars']['ping_since_last']=0;
      $glob[GLOB_KEY_PROXY_SERVERS][$srv_key]['child_vars']['ping_timer_']=0;
      $glob[GLOB_KEY_PROXY_SERVERS][$srv_key]['child_vars']['ping_sent']=0;
    }
  }
}

function proxy_on_recv(&$pool, $key, $buffer, &$readed=0, &$wait_len=0, &$seq_no=0) {
   global $dmn_main_conn, $glob;
      
   $offset=0;
   $prlog=!@$glob['llock'];
     
   $ret=eproto_packet_decode($buffer, $offset, $pk);
   if (is_int($ret) && $ret<0) {
     plogs("proxy pde:".var_d($ret, true)."\n");
     $ret=false;
   }
   if (@$pk['cmd']) pocket_parse_packet($pk);
   if (@$pk['cmd'] && @$glob['log_exclude_pings'] && ($pk['cmd'] & 0x7F)==eproto_cmd_Enquire) $prlog=false;

   if ($ret===false) {
     plogs("proxy packet decode error. halting.\n");
     $pool->drop_connection($key, 'packet decode error. stream broken.');
     return false;
   }
   if (!is_array($ret)) return $ret;

   proxy_upd_autoping($pool, $key, 2);

   $readed=$offset;
   $buf=substr($buffer, 0, $readed);

   if ($prlog) logp($glob['log_file'].'.p',
                    "received [".$key.':'.$seq_no."]:".NL.   
                    $pool->dump_packet($buf).
                    NL.NL."Data:".NL.
                    var_d($pk, true).NL,
                    true);
                                       
   return $pk;
}

function proxy_on_send(&$pool, $key, $data, $seq_no) {
  global $dmn_main_conn, $glob;

    $prlog=!@$glob['llock'];
    if (@$data['cmd']==eproto_cmd_ReadTagExtended) {
      if (strlen(@$data['payload'])>0) {
        $uid_len=ord($data['payload']{0});
        $data['payload']=str_pad($data['payload'], 1+$uid_len+2+(4*2) , chr(0x00));
      }
    }
    pocket_parse_packet($data);
    $buf=eproto_packet_encode($data);
    if (@$glob['log_exclude_pings'] && ($data['cmd'] & 0x7F)==eproto_cmd_Enquire) $prlog=false;
      
    if ($prlog) logp($glob['log_file'].'.p',
                     "sended [".$key.':'.$seq_no."]:".NL.
                     $pool->dump_packet($buf).
                     NL.NL."Data:".NL.
                     var_d($data, true).NL, 
                     true);
//   plogs("sended:\n".var_d($data, true));
    return $buf;
}

function proxy_kpo_res_from_text(&$text, $def_val=KPO_RES_UNDEF) {
  if ($text==from_utf8("Доступ\nзапрещен")) {
    return KPO_RES_NO;
  } else if ($text==from_utf8('Please go; to reception; ')) {
	  $text=from_utf8("Please go\nto reception");
    return KPO_RES_NO;
  } else if ($text==from_utf8('Welcome; to club; ') || $text==from_utf8('Welcome; to clu')) {
	  $text=from_utf8("Welcome to club");
  } else if ($text==from_utf8('Verification;Error; ')) {
	  $text=from_utf8("Приложите\nбраслет\nповторно");
    return KPO_RES_NO;
  } else if ($text==from_utf8('Доступ в ВИП разрешен')) {
	  $text=from_utf8('Доступ\nв VIP\nразрешен');
  } else if (preg_match('/[\;\n]/', $text)) {
    return KPO_RES_NO;
  } else if (preg_match('/\\\n/', $text)) {
    return KPO_RES_NO;
  }
  return $def_val;
}

function proxy_on_data(&$pool, $key) {
   global $glob;
   
   $data=$pool->get_data($key);
   if ($data===false) return false;
   $raw_data=$data[2];
   $seq_no=$data[1];
   $data=$data[0];
//   plogs("proxy raw_data:\n".var_d($raw_data, true));
//   logp($glob['log_file'].'.p', "answer [".$key."]:\n".var_d($data[2], true)."\n", true);

   if (!@$data['cmd']) return true;
   
   $cint=(@$glob['proxy_catch_interaction'])?true:false;
   $crelay=(@$glob['proxy_catch_relay'])?true:false;
   
   $tkey=proxy_get_term_connected_key($pool, $key);
   $skey=proxy_get_session_key($pool, $key);   
   $sobj=false; if ($skey) $sobj=&session_obj_get($skey);
   
   
   if ($data['cmd']==eproto_cmd_Enquire) {
     $pool->send($key, eproto_packet(eproto_resp_Enquire));
     if (@$data['data']['ping_interval'] && @$data['data']['ping_timeout']) {
       proxy_set_autoping($pool, $key, $data['data']['ping_interval'], $data['data']['ping_timeout']);
     }
     return true;
   } else if ($data['cmd']==eproto_resp_Enquire) {
     return true;
   }
   
   
   if ($data['cmd']==eproto_cmd_Beep) {
     if ($sobj && !@$glob['cam_service_resolve_uid']) {
/*       
       session_set_kpo_result($sobj, KPO_RES_YES, NULL, array('kpo_answer_data'=>$data));
       session_check_done($sobj);
       return true;
*/       
     } else if ($cint) {
       $pool->send($key, eproto_packet($data['cmd']|0x80));
       return true;
     }
   } else if ($data['cmd']==eproto_cmd_Quack || $data['cmd']==eproto_cmd_QuackQuack) {
     if ($sobj) {
/*	   
       session_set_kpo_result($sobj, KPO_RES_NO, NULL, array('kpo_answer_data'=>$data));
       session_check_done($sobj);
       return true;
*/	 
     } else if ($cint) {
       $pool->send($key, eproto_packet($data['cmd']|0x80));
       return true;
     }
   } else if ($data['cmd']==eproto_cmd_DisplayText) {
     if ($sobj && !@$glob['cam_service_resolve_uid']) {
/*	   
       session_set_kpo_result($sobj, proxy_kpo_res_from_text(@$data['data']['caption'], @$sobj['data']['kpo']['result']), @$data['data']['caption'], array('kpo_answer_data'=>$data));
       session_check_done($sobj);
       return true;
*/	 
     } else if ($cint) {
       $pool->send($key, eproto_packet($data['cmd']|0x80));
       return true;
     }
   } else if ($data['cmd']==eproto_cmd_Interactive) {
     if ($sobj) {
       $tlvs=@$data['data']['tlvs'];
       if (is_array($tlvs)) foreach ($tlvs as $tlv) {
         if ($tlv['tag']==EPROTO_INTERACTIVE_TAG_TEXT) {
           session_set_kpo_result($sobj, proxy_kpo_res_from_text(@$tlv['val'], @$sobj['data']['kpo']['result']), @$tlv['val'], array('kpo_answer_data'=>$data));
           
/*		   
         } else if ($tlv['tag']==EPROTO_INTERACTIVE_TAG_SOUND) {
           if (@$tlv['param_sound_freq']==4000) {
             if (@$tlv['param_sound_type']==EPROTO_INTERACTIVE_SOUND_BEEP && !@$glob['cam_service_resolve_uid']) {
               session_set_kpo_result($sobj, KPO_RES_YES, NULL, array('kpo_answer_data'=>$data));
             } else if (@$tlv['param_sound_type']==EPROTO_INTERACTIVE_SOUND_QUACK) {
               session_set_kpo_result($sobj, KPO_RES_NO, NULL, array('kpo_answer_data'=>$data));
             }
           }
*/		   
         }
       }
       session_check_done($sobj);
       return true;
     } else if ($cint) {
       $pool->send($key, eproto_packet($data['cmd']|0x80));
       return true;
     }
   } else if ($data['cmd']==eproto_cmd_RelayControl) {
     if ($sobj && !@$glob['cam_service_resolve_uid']) {
/*	   
       session_set_kpo_result($sobj, KPO_RES_YES, NULL, array('kpo_answer_data'=>$data));
       session_check_done($sobj);
       return true;
*/	 
     } else if ($crelay) {
       $pool->send($key, eproto_packet($data['cmd']|0x80));
       return true;
     }
   } else if ($data['cmd']==eproto_cmd_RelayControlEx && (int)$data['data']['rce_tmo']>0) {
     if ($sobj) {
         $capt=@$data['data']['caption'];
         proxy_kpo_res_from_text($capt);
         session_set_kpo_result($sobj, KPO_RES_YES, $capt, array('kpo_answer_data'=>$data));
         if (array_key_exists('rce_uid', $data['data'])) {
           $sobj['cid']=trim($data['data']['rce_uid']);
           $sobj['rce_uid']=$data['data']['rce_uid'];
         }
         session_check_done($sobj);
       return true;
     } else if ($crelay) return true;
   }
   
   if ($tkey && $glob[GLOB_KEY_CONNECTIONS][$tkey]['settings']['type']==TTYPE_POCKET) {
     $pool->send($tkey, $data);
   } else {
     $pk=eproto_packet(eproto_cmd_Busy);
     $pool->send($key, $pk);
   }
   
   return true;
}

function proxy_idle_proc(&$pool, $mtf) {
  global $dmn_main_conn, $glob;
  
  foreach (array_keys($glob[GLOB_KEY_PROXY_SERVERS]) as $srv_key) {
    $ckey=$glob[GLOB_KEY_PROXY_SERVERS][$srv_key]['child_key'];
    if ($ckey && !@$pool->list[$ckey]['connected']) $ckey=false;
    $tkey=$glob[GLOB_KEY_PROXY_SERVERS][$srv_key]['ckey'];
    if ($tkey && !@$pool->list[$tkey]['connected']) $tkey=false;
    
    if ($ckey) {
      proxy_check_autoping($pool, $ckey);
    }      
    
    
    
  }
//    $glob[GLOB_KEY_PROXY_SERVERS][$srv_key]['child_vars']=array();
  
  
}

} // end incl_h
?>
